/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import java.io.File;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.drools.repository.JackrabbitRepositoryConfigurator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryAdministrator;
import org.drools.repository.RulesRepositoryException;

public class RepositorySessionUtil {
    private static ThreadLocal<RulesRepository> repo = new ThreadLocal();
    private static Repository multiThreadedRepository;

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                if (!RepositorySessionUtil.deleteDir(new File(dir, children[i]))) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static RulesRepository getRepository() throws RulesRepositoryException {
        RulesRepository repoInstance = repo.get();
        if (repoInstance == null) {
            File dir = new File("repository");
            System.out.println("DELETING test repo: " + dir.getAbsolutePath());
            RepositorySessionUtil.deleteDir(dir);
            System.out.println("TEST repo was deleted.");
            JackrabbitRepositoryConfigurator config = new JackrabbitRepositoryConfigurator();
            multiThreadedRepository = config.getJCRRepository(null);
            try {
                Session session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(session);
                if (admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                config.setupRulesRepository(session);
                repoInstance = new RulesRepository(session);
                multiThreadedRepository.login((Credentials)new SimpleCredentials("ADMINISTRATOR", "password".toCharArray()));
                repo.set(repoInstance);
            }
            catch (Exception e) {
                throw new RulesRepositoryException(e);
            }
        }
        return repoInstance;
    }

    public static synchronized RulesRepository getMultiThreadedRepository() throws RulesRepositoryException {
        if (multiThreadedRepository == null) {
            File dir = new File("repository");
            System.out.println("DELETING test repo: " + dir.getAbsolutePath());
            RepositorySessionUtil.deleteDir(dir);
            System.out.println("TEST repo was deleted.");
            JackrabbitRepositoryConfigurator config = new JackrabbitRepositoryConfigurator();
            multiThreadedRepository = config.getJCRRepository(null);
            try {
                Session session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
                RulesRepositoryAdministrator admin = new RulesRepositoryAdministrator(session);
                if (admin.isRepositoryInitialized()) {
                    admin.clearRulesRepository();
                }
                config.setupRulesRepository(session);
            }
            catch (Exception e) {
                throw new RulesRepositoryException(e);
            }
        }
        try {
            Session session = multiThreadedRepository.login((Credentials)new SimpleCredentials("alan_parsons", "password".toCharArray()));
            RulesRepository threadLocalRepo = new RulesRepository(session);
            return threadLocalRepo;
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return null;
    }
}

