/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository.remoteapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public abstract class Response {
    public Calendar lastModified;

    public abstract void writeData(OutputStream var1) throws IOException;

    public static class Binary
    extends Response {
        InputStream stream;

        public void writeData(OutputStream out) throws IOException {
            try {
                InputStream in = this.stream;
                if (!(out instanceof BufferedOutputStream)) {
                    out = new BufferedOutputStream(out);
                }
                if (!(in instanceof BufferedInputStream)) {
                    in = new BufferedInputStream(in);
                }
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                out.flush();
                out.close();
                this.stream.close();
            }
        }
    }

    public static class Text
    extends Response {
        String data;

        public Text() {
        }

        public Text(String s) {
            this.data = s;
        }

        public void writeData(OutputStream out) throws IOException {
            out.write(this.data.getBytes());
        }
    }
}

