/*
 * Decompiled with CFR 0.152.
 */
package org.drools.resource.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.drools.resource.RepositoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SvnUtil {
    private static final Logger logger = LoggerFactory.getLogger(SvnUtil.class);

    public static ByteArrayOutputStream getFileContentsFromSvn(String url, String svnUsername, String svnPassword, long version) throws SVNException {
        String username = svnUsername;
        String password = svnPassword;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SvnUtil.setupLibrary();
        try {
            SVNRepository repository = null;
            repository = SVNRepositoryFactoryImpl.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            repository.setAuthenticationManager(authManager);
            HashMap fileProperties = new HashMap();
            SVNNodeKind nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                logger.error("There is no entry at '" + url + "'.");
            } else if (nodeKind == SVNNodeKind.DIR) {
                logger.error("The entry at '" + url + "' is a directory while a file was expected.");
            }
            repository.getFile("", version, fileProperties, (OutputStream)baos);
        }
        catch (SVNException e) {
            e.printStackTrace();
            logger.error("The SVN file cannot be found. " + url);
            throw e;
        }
        return baos;
    }

    public static List getRepositoryBeanList(RepositoryBean criteriaBean, String username, String password, String repositoryUrl) throws RuntimeException {
        String url = repositoryUrl;
        ArrayList resourceList = new ArrayList();
        logger.debug("URL is: " + url);
        SvnUtil.setupLibrary();
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            Collection entries = repository.getDir(url, -1L, null, null);
            Collections.sort(resourceList);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                String string = ((SVNDirEntry)i.next()).toString();
            }
        }
        catch (SVNException e) {
            logger.error("Repository does not exist or is unavailable");
            throw new RuntimeException(e);
        }
        return resourceList;
    }

    public static String writeFile(ByteArrayOutputStream baos) {
        String fileText = null;
        try {
            fileText = baos.toString("text/html");
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
        }
        return fileText;
    }

    public static ByteArrayOutputStream getByteArrayOutputFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(bytes);
        return baos;
    }

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static boolean authenticate(String username, String password, String repositoryUrl) throws RuntimeException {
        try {
            logger.debug("Subversion authentication for : username=" + username + ", password=" + password + ", repositoryURL=" + repositoryUrl);
            SvnUtil.setupLibrary();
            SVNRepository repository = null;
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)repositoryUrl));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            repository.setAuthenticationManager(authManager);
            repository.testConnection();
        }
        catch (SVNException e) {
            logger.error(e.getErrorMessage().getFullMessage());
            return false;
        }
        return true;
    }
}

