/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import org.drools.core.marshalling.impl.InputMarshaller;
import org.drools.core.marshalling.impl.MarshallerProviderImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ObjectMarshallingStrategyStoreImpl;
import org.drools.core.marshalling.impl.OutputMarshaller;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.reteoo.integrationtests.marshalling.util.OldOutputMarshallerMethods;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.internal.marshalling.MarshallerFactory;

public class WorkItemMarshallingTest {
    private char[] bandName = new char[]{'a', 'c', 'd', 'c'};
    private Object[] input = new Object[]{23L, "WorkItem", "para1", "meter", "para2", 141015, "para3", this.bandName, 501L, 1};

    private WorkItem createWorkItem(Object[] input) {
        int i = 0;
        WorkItemImpl impl = new WorkItemImpl();
        impl.setId(((Long)input[i++]).longValue());
        impl.setName((String)input[i++]);
        impl.setParameter((String)input[i++], input[i++]);
        impl.setParameter((String)input[i++], input[i++]);
        impl.setParameter((String)input[i++], input[i++]);
        impl.setProcessInstanceId(((Long)input[i++]).longValue());
        impl.setState(((Integer)input[i++]).intValue());
        return impl;
    }

    private void checkWorkItem(WorkItem workItem, Object[] input) {
        int i = 0;
        Assert.assertTrue((String)"id incorrect", (boolean)input[i++].equals(workItem.getId()));
        Assert.assertTrue((String)"name incorrect", (boolean)input[i++].equals(workItem.getName()));
        String paraName = (String)input[i++];
        Assert.assertTrue((String)("parameter " + paraName + " incorrect"), (boolean)input[i++].equals(workItem.getParameter(paraName)));
        paraName = (String)input[i++];
        Assert.assertTrue((String)("parameter " + paraName + " incorrect"), (boolean)input[i++].equals(workItem.getParameter(paraName)));
        paraName = (String)input[i++];
        Object paraVal = input[i++];
        Assert.assertTrue((String)("parameter " + paraName + " incorrect"), (boolean)Arrays.equals((char[])paraVal, (char[])workItem.getParameter(paraName)));
        Assert.assertTrue((String)"processInstanceId incorrect", (boolean)input[i++].equals(workItem.getProcessInstanceId()));
        Assert.assertTrue((String)"state incorrect", (boolean)input[i++].equals(workItem.getState()));
    }

    @Test
    public void basicMarshallingTest() throws IOException {
        WorkItem workItem = this.createWorkItem(this.input);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext outContext = new MarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OutputMarshaller.writeWorkItem((MarshallerWriteContext)outContext, (WorkItem)workItem);
        byte[] byteArray = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        MarshallerReaderContext inContext = new MarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), Collections.EMPTY_MAP, true, true, null);
        workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)inContext);
        this.checkWorkItem(workItem, this.input);
    }

    @Test
    public void multipleStrategyDifferentOrderMarshallingTest() throws IOException {
        WorkItem workItem = this.createWorkItem(this.input);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext outContext = new MarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OutputMarshaller.writeWorkItem((MarshallerWriteContext)outContext, (WorkItem)workItem);
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{new MarshallerProviderImpl().newIdentityMarshallingStrategy(), MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        MarshallerReaderContext inContext = new MarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)inContext);
        this.checkWorkItem(workItem, this.input);
    }

    @Test
    public void multipleStrategyOneLessMarshallingTest() throws IOException {
        WorkItem workItem = this.createWorkItem(this.input);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext outContext = new MarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OutputMarshaller.writeWorkItem((MarshallerWriteContext)outContext, (WorkItem)workItem);
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        MarshallerReaderContext inContext = new MarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)inContext);
        this.checkWorkItem(workItem, this.input);
    }

    @Test
    public void multipleStrategyNoneLeftMarshallingTest() throws IOException {
        WorkItem workItem = this.createWorkItem(this.input);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext outContext = new MarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OutputMarshaller.writeWorkItem((MarshallerWriteContext)outContext, (WorkItem)workItem);
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        MarshallerReaderContext inContext = new MarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        try {
            workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)inContext);
            Assert.fail((String)"An exception was expected here.");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((e.getMessage() != null && e.getMessage().startsWith("No strategy of type") ? 1 : 0) != 0);
        }
    }

    @Test
    public void backwardsCompatibleWorkItemMarshalling() throws IOException {
        WorkItem workItem = this.createWorkItem(this.input);
        ObjectMarshallingStrategy[] strats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy(), new MarshallerProviderImpl().newIdentityMarshallingStrategy()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshallerWriteContext outContext = new MarshallerWriteContext((OutputStream)baos, null, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(strats), true, true, null);
        OldOutputMarshallerMethods.writeWorkItem_v1(outContext, workItem);
        byte[] byteArray = baos.toByteArray();
        ObjectMarshallingStrategy[] newStrats = new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()};
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        MarshallerReaderContext inContext = new MarshallerReaderContext((InputStream)bais, null, null, (ObjectMarshallingStrategyStore)new ObjectMarshallingStrategyStoreImpl(newStrats), Collections.EMPTY_MAP, true, true, null);
        workItem = InputMarshaller.readWorkItem((MarshallerReaderContext)inContext);
        this.checkWorkItem(workItem, this.input);
    }
}

