/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.Agenda;
import org.drools.core.RuleBaseFactory;
import org.drools.core.WorkingMemory;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.Timer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SchedulerTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.pctxFactory = this.ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    public void testScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)this.ruleBase.newStatefulSession();
        Rule rule = new Rule("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(100L));
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        Assert.assertEquals((long)0L, (long)data.size());
        node.assertLeftTuple((LeftTuple)tuple, context, workingMemory);
        workingMemory.fireAllRules();
        Thread.sleep(300L);
        Assert.assertEquals((long)1L, (long)data.size());
    }

    @Test
    public void testDoLoopScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        final Rule rule = new Rule("test-rule");
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 3) {
                    PropagationContext context2 = SchedulerTest.this.pctxFactory.createPropagationContext(0L, 0, rule, (LeftTuple)((RuleTerminalNodeLeftTuple)knowledgeHelper.getTuple()), null);
                    RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (LeftTupleSink)node, true);
                    node.assertLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)((AbstractWorkingMemory)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        rule.setTimer((Timer)new DurationTimer(50L));
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)data.size());
        workingMemory.fireAllRules();
        Thread.sleep(2000L);
        Assert.assertEquals((long)4L, (long)data.size());
    }

    @Test
    public void testNoLoopScheduledActivation() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ReteooBuilder.IdGenerator idGenerator = ruleBase.getReteooBuilder().getIdGenerator();
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        final Rule rule = new Rule("test-rule");
        final ArrayList data = new ArrayList();
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        rule.setTimer((Timer)new DurationTimer(100L));
        rule.setNoLoop(true);
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 5) {
                    PropagationContext context2 = SchedulerTest.this.pctxFactory.createPropagationContext(0L, 0, rule, (LeftTuple)((RuleTerminalNodeLeftTuple)knowledgeHelper.getTuple()), null);
                    RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (LeftTupleSink)node, true);
                    node.assertLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)((AbstractWorkingMemory)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)data.size());
        workingMemory.fireAllRules();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)data.size());
    }
}

