/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.util.List;
import org.drools.compiler.Cat;
import org.drools.compiler.Cheese;
import org.drools.compiler.CommonTestMethodBase;
import org.drools.compiler.Person;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.junit.Test;
import org.kie.internal.KnowledgeBase;

public class AlphaNetworkModifyTest
extends CommonTestMethodBase {
    public ObjectTypeNode getObjectTypeNode(KnowledgeBase kbase, String nodeName) {
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        for (ObjectTypeNode n : nodes) {
            if (!((ClassObjectType)n.getObjectType()).getClassType().getSimpleName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    @Test
    public void testModifyWithLiaToEval() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + Person.class.getCanonicalName() + "\n";
        str = str + "import " + Cheese.class.getCanonicalName() + "\n";
        str = str + "import " + Cat.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $pe : Person() \n";
        str = str + "    $ch : Cheese() \n";
        str = str + "    $ca : Cat() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() \n";
        str = str + "    $ca : Cat() \n";
        str = str + "    $pe : Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x3 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x4 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() \n";
        str = str + "    eval( $ch != null ) \n";
        str = str + "then \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        ReteooWorkingMemoryInterface wm = ((StatefulKnowledgeSessionImpl)kbase.newStatefulKnowledgeSession()).session;
        ObjectTypeNode otnPerson = this.getObjectTypeNode(kbase, "Person");
        ObjectTypeNode otnCheese = this.getObjectTypeNode(kbase, "Cheese");
        ObjectTypeNode otnCat = this.getObjectTypeNode(kbase, "Cat");
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)otnPerson.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)otnCheese.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)otnCat.getOtnIdCounter());
        wm.insert((Object)new Person());
        wm.insert((Object)new Cat("yyy"));
        wm.insert((Object)new Cheese());
        AlphaNetworkModifyTest.assertEquals((long)2L, (long)otnPerson.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)4L, (long)otnCheese.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)2L, (long)otnCat.getOtnIdCounter());
    }

    @Test
    public void testModifyWithLiaToFrom() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + Person.class.getCanonicalName() + "\n";
        str = str + "import " + Cheese.class.getCanonicalName() + "\n";
        str = str + "import " + Cat.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $pe : Person() from list\n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() from list\n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x3 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() from list\n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x4 \n";
        str = str + "when \n";
        str = str + "    $ch : Cheese() from list\n";
        str = str + "    eval( $ch != null ) \n";
        str = str + "then \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        ReteooWorkingMemoryInterface wm = ((StatefulKnowledgeSessionImpl)kbase.newStatefulKnowledgeSession()).session;
        wm.fireAllRules();
        ObjectTypeNode otnInit = this.getObjectTypeNode(kbase, "InitialFactImpl");
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otnInit.getSinkPropagator().getSinks()[0];
        LeftTupleSink[] sinks = liaNode.getSinkPropagator().getSinks();
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)sinks[0].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)1L, (long)sinks[1].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)2L, (long)sinks[2].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)3L, (long)sinks[3].getLeftInputOtnId().getId());
    }

    @Test
    public void testModifyWithLiaToAcc() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + Person.class.getCanonicalName() + "\n";
        str = str + "import " + Cheese.class.getCanonicalName() + "\n";
        str = str + "import " + Cat.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    Object() from accumulate( $p : Person() and Cheese(), collectList( $p ) )\n";
        str = str + "    Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n";
        str = str + "    Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x3 \n";
        str = str + "when \n";
        str = str + "    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n";
        str = str + "    Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule x4 \n";
        str = str + "when \n";
        str = str + "    Object() from accumulate( $ch : Cheese(), collectList( $ch ) )\n";
        str = str + "    Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        ReteooWorkingMemoryInterface wm = ((StatefulKnowledgeSessionImpl)kbase.newStatefulKnowledgeSession()).session;
        wm.fireAllRules();
        ObjectTypeNode otnInit = this.getObjectTypeNode(kbase, "InitialFactImpl");
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)otnInit.getSinkPropagator().getSinks()[0];
        LeftTupleSink[] sinks = liaNode.getSinkPropagator().getSinks();
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)sinks[0].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)1L, (long)sinks[1].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)2L, (long)sinks[2].getLeftInputOtnId().getId());
        AlphaNetworkModifyTest.assertEquals((long)3L, (long)sinks[3].getLeftInputOtnId().getId());
        ObjectTypeNode otnPerson = this.getObjectTypeNode(kbase, "Person");
        ObjectTypeNode otnCheese = this.getObjectTypeNode(kbase, "Cheese");
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)otnPerson.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)0L, (long)otnCheese.getOtnIdCounter());
        wm.insert((Object)new Person());
        wm.insert((Object)new Cheese());
        AlphaNetworkModifyTest.assertEquals((long)5L, (long)otnPerson.getOtnIdCounter());
        AlphaNetworkModifyTest.assertEquals((long)4L, (long)otnCheese.getOtnIdCounter());
    }
}

