/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.acme.insurance.Driver;
import org.acme.insurance.Policy;
import org.drools.compiler.Address;
import org.drools.compiler.Attribute;
import org.drools.compiler.Bar;
import org.drools.compiler.Cat;
import org.drools.compiler.Cell;
import org.drools.compiler.Cheese;
import org.drools.compiler.CheeseEqual;
import org.drools.compiler.Cheesery;
import org.drools.compiler.Child;
import org.drools.compiler.DomainObjectHolder;
import org.drools.compiler.FactA;
import org.drools.compiler.FactB;
import org.drools.compiler.FactC;
import org.drools.compiler.FirstClass;
import org.drools.compiler.Foo;
import org.drools.compiler.FromTestClass;
import org.drools.compiler.Guess;
import org.drools.compiler.IndexedNumber;
import org.drools.compiler.LongAddress;
import org.drools.compiler.Message;
import org.drools.compiler.MockPersistentSet;
import org.drools.compiler.Move;
import org.drools.compiler.ObjectWithSet;
import org.drools.compiler.Order;
import org.drools.compiler.OrderItem;
import org.drools.compiler.OuterClass;
import org.drools.compiler.PersonFinal;
import org.drools.compiler.PersonInterface;
import org.drools.compiler.PersonWithEquals;
import org.drools.compiler.Pet;
import org.drools.compiler.PolymorphicFact;
import org.drools.compiler.Primitives;
import org.drools.compiler.RandomNumber;
import org.drools.compiler.SecondClass;
import org.drools.compiler.Sensor;
import org.drools.compiler.SpecialString;
import org.drools.compiler.State;
import org.drools.compiler.StockTick;
import org.drools.compiler.Target;
import org.drools.compiler.TestParam;
import org.drools.compiler.Triangle;
import org.drools.compiler.Win;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.ParserError;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.compiler.lang.DrlDumper;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.compiler.test.Man;
import org.drools.compiler.test.Person;
import org.drools.core.ClassObjectFilter;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.MapBackedClassLoader;
import org.drools.core.runtime.rule.impl.AgendaImpl;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.command.Setter;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.ConsequenceException;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.conf.SequentialOption;
import org.kie.internal.conf.ShareAlphaNodesOption;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(MiscTest.class);

    @Test
    public void testImportFunctions() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ImportFunctions.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese cheese = new Cheese("stilton", 15);
        session.insert((Object)cheese);
        List list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        int fired = session.fireAllRules();
        list = (List)session.getGlobal("list");
        MiscTest.assertEquals((long)4L, (long)fired);
        MiscTest.assertEquals((long)4L, (long)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        MiscTest.assertEquals((Object)"rule2", list.get(1));
        MiscTest.assertEquals((Object)"rule3", list.get(2));
        MiscTest.assertEquals((Object)"rule4", list.get(3));
    }

    @Test
    public void testStaticFieldReference() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_StaticField.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheesery cheesery1 = new Cheesery();
        cheesery1.setStatus(1);
        cheesery1.setMaturity(Cheesery.Maturity.OLD);
        session.insert((Object)cheesery1);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        Cheesery cheesery2 = new Cheesery();
        cheesery2.setStatus(0);
        cheesery2.setMaturity(Cheesery.Maturity.YOUNG);
        session.insert((Object)cheesery2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)cheesery1, list.get(0));
        MiscTest.assertEquals((Object)cheesery2, list.get(1));
    }

    @Test
    public void testMetaConsequence() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MetaConsequence.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        session.setGlobal("results", results);
        session.insert((Object)new org.drools.compiler.Person("Michael"));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"bar", results.get(0));
        MiscTest.assertEquals((Object)"bar2", results.get(1));
    }

    @Test
    public void testEnabledExpression() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_enabledExpression.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        session.setGlobal("results", results);
        session.insert((Object)new org.drools.compiler.Person("Michael"));
        results = (List)session.getGlobal("results");
        session.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains("1"));
        MiscTest.assertTrue((boolean)results.contains("2"));
        MiscTest.assertTrue((boolean)results.contains("3"));
    }

    @Test
    public void testGetStatefulKnowledgeSessions() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("empty.drl"));
        StatefulKnowledgeSession ksession_1 = this.createKnowledgeSession(kbase);
        String expected_1 = "expected_1";
        String expected_2 = "expected_2";
        FactHandle handle_1 = ksession_1.insert((Object)expected_1);
        FactHandle handle_2 = ksession_1.insert((Object)expected_2);
        ksession_1.fireAllRules();
        Collection coll_1 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_1.size() == 1 ? 1 : 0) != 0);
        StatefulKnowledgeSession ksession_2 = (StatefulKnowledgeSession)coll_1.iterator().next();
        Object actual_1 = ksession_2.getObject(handle_1);
        Object actual_2 = ksession_2.getObject(handle_2);
        MiscTest.assertEquals((Object)expected_1, (Object)actual_1);
        MiscTest.assertEquals((Object)expected_2, (Object)actual_2);
        ksession_1.dispose();
        Collection coll_2 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_2.size() == 0 ? 1 : 0) != 0);
        ksession_1.dispose();
        Collection coll_3 = kbase.getStatefulKnowledgeSessions();
        MiscTest.assertTrue((coll_3.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFactHandle() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("empty.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 20; ++i) {
            Object object = new Object();
            ksession.insert(object);
            FactHandle factHandle = ksession.getFactHandle(object);
            MiscTest.assertNotNull((Object)factHandle);
            MiscTest.assertEquals((Object)object, (Object)ksession.getObject(factHandle));
        }
        ksession.dispose();
    }

    @Test
    public void testPrimitiveArray() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_primitiveArray.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        List result = new ArrayList();
        session.setGlobal("result", result);
        Primitives p1 = new Primitives();
        p1.setPrimitiveIntArray(new int[]{1, 2, 3});
        p1.setArrayAttribute((Object[])new String[]{"a", "b"});
        session.insert((Object)p1);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        result = (List)session.getGlobal("result");
        session.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)result.size());
        MiscTest.assertEquals((long)3L, (long)((Integer)result.get(0)).intValue());
        MiscTest.assertEquals((long)2L, (long)((Integer)result.get(1)).intValue());
        MiscTest.assertEquals((long)3L, (long)((Integer)result.get(2)).intValue());
    }

    @Test
    public void testMVELSoundex() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("MVEL_soundex.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese c = new Cheese("fubar", 2);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)42L, (long)c.getPrice());
    }

    @Test
    public void testMVELSoundexNoCharParam() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("MVEL_soundexNPE2500.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese foobarCheese = new Cheese("foobar", 2);
        Cheese nullCheese = new Cheese(null, 2);
        Cheese starCheese = new Cheese("*", 2);
        ksession.insert((Object)foobarCheese);
        ksession.insert((Object)nullCheese);
        ksession.insert((Object)starCheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)42L, (long)foobarCheese.getPrice());
        MiscTest.assertEquals((long)2L, (long)nullCheese.getPrice());
        MiscTest.assertEquals((long)2L, (long)starCheese.getPrice());
    }

    @Test
    public void testMVELRewrite() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MVELrewrite.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese brie = new Cheese("brie", 2);
        Cheese stilton = new Cheese("stilton", 2);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(brie);
        cheesery.addCheese(stilton);
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)cheesery, results.get(0));
    }

    @Test
    public void testVariableDeclaration() throws Exception {
        String str = "rule KickOff\ndialect \"mvel\"\nwhen\nthen\nint i;\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testMissingImport() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "import " + org.drools.compiler.Person.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "         MissingClass( fieldName == $i ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testInvalidModify1() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "import " + Cheese.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    no-loop \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "then \n";
        str = str + "    modify( $i ); ";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testInvalidModify2() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "import " + Cheese.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    no-loop \n";
        str = str + "when \n";
        str = str + "    $i : Cheese() \n";
        str = str + "then \n";
        str = str + "    modify( $i ) { setType( \"stilton\" ); setType( \"stilton\" );}; ";
        str = str + "    list.add( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            logger.warn(kbuilder.getErrors().toString());
        }
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testIncrementOperator() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"java\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    int i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)10, list.get(0));
    }

    @Test
    public void testKnowledgeRuntimeAccess() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler.test\n";
        str = str + "import " + Message.class.getName() + "\n";
        str = str + "rule \"Hello World\"\n";
        str = str + "when\n";
        str = str + "    Message( )\n";
        str = str + "then\n";
        str = str + "    System.out.println( drools.getKieRuntime() );\n";
        str = str + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("help"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testEvalWithBigDecimal() throws Exception {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"java\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    @Test
    public void testFieldBiningsAndEvalSharing() throws Exception {
        String drl = "test_FieldBindingsAndEvalSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndEvalSharing.drl");
    }

    @Test
    public void testFieldBiningsAndPredicateSharing() throws Exception {
        String drl = "test_FieldBindingsAndPredicateSharing.drl";
        this.evalSharingTest("test_FieldBindingsAndPredicateSharing.drl");
    }

    private void evalSharingTest(String drl) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        TestParam tp1 = new TestParam();
        tp1.setValue2("boo");
        ksession.insert((Object)tp1);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
    }

    @Test
    public void testGeneratedBeans1() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_GeneratedBeans.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "age", (Object)42);
        Map personMap = personType.getAsMap(ps);
        MiscTest.assertEquals((Object)42, personMap.get("age"));
        personMap.put("age", 43);
        personType.setFromMap(ps, personMap);
        MiscTest.assertEquals((Object)43, (Object)personType.get(ps, "age"));
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.getField("type").get(cheese));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Object cg = cheeseFact.newInstance();
        ksession.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        ksession.setGlobal("list", result);
        ksession.insert(cheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)result.size());
        MiscTest.assertEquals((Object)new Integer(5), result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        ksession.insert(person);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)result.size());
        MiscTest.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testGeneratedBeansMVEL() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_GeneratedBeansMVEL.drl");
        FactType pf = kbase.getFactType("mortgages", "Applicant");
        FactType af = kbase.getFactType("mortgages", "LoanApplication");
        Object person = pf.newInstance();
        pf.set(person, "creditRating", (Object)"OK");
        Object application = af.newInstance();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert(person);
        ksession.insert(application);
        ksession.fireAllRules();
    }

    @Test
    public void testGeneratedBeans2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_GeneratedBeans2.drl");
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)"stilton", (Object)cheeseFact.get(cheese, "type"));
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"stilton");
        MiscTest.assertEquals((Object)cheese, (Object)cheese2);
        FactType personType = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object ps = personType.newInstance();
        personType.set(ps, "name", (Object)"mark");
        personType.set(ps, "last", (Object)"proctor");
        personType.set(ps, "age", (Object)42);
        Object ps2 = personType.newInstance();
        personType.set(ps2, "name", (Object)"mark");
        personType.set(ps2, "last", (Object)"proctor");
        personType.set(ps2, "age", (Object)30);
        MiscTest.assertEquals((Object)ps, (Object)ps2);
        personType.set(ps2, "last", (Object)"little");
        MiscTest.assertFalse((boolean)ps.equals(ps2));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        Object cg = cheeseFact.newInstance();
        wm.setGlobal("cg", cg);
        ArrayList result = new ArrayList();
        wm.setGlobal("list", result);
        wm.insert(cheese);
        wm.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)result.size());
        MiscTest.assertEquals((Object)new Integer(5), result.get(0));
        FactType personFact = kbase.getFactType("org.drools.generatedbeans", "Person");
        Object person = personFact.newInstance();
        personFact.getField("likes").set(person, cheese);
        personFact.getField("age").set(person, (Object)7);
        wm.insert(person);
        wm.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)result.size());
        MiscTest.assertEquals((Object)person, result.get(1));
    }

    @Test
    public void testDeclaredFactAndFunction() throws Exception {
        String rule = "package com.jboss.qa;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "declare Address\n";
        rule = rule + "    street: String\n";
        rule = rule + "end\n";
        rule = rule + "function void myFunction() {\n";
        rule = rule + "}\n";
        rule = rule + "rule \"r1\"\n";
        rule = rule + "    dialect \"mvel\"\n";
        rule = rule + "when\n";
        rule = rule + "    Address()\n";
        rule = rule + "then\n";
        rule = rule + "    list.add(\"r1\");\n";
        rule = rule + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        List list = new ArrayList();
        session.setGlobal("list", list);
        FactType addressFact = kbase.getFactType("com.jboss.qa", "Address");
        Object address = addressFact.newInstance();
        session.insert(address);
        session.fireAllRules();
        list = (List)session.getGlobal("list");
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testTypeDeclarationOnSeparateResource() throws Exception {
        String file1 = "package a.b.c\ndeclare SomePerson\n    weight : double\n    height : double\nend\n";
        String file2 = "package a.b.c\nimport org.drools.compiler.*\ndeclare Holder\n    person : Person\nend\nrule \"create holder\"\n    when\n        person : Person( )\n        not (\n            Holder( person; )\n        )\n    then\n        insert(new Holder(person));\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(file1, file2);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        MiscTest.assertEquals((long)0L, (long)ksession.fireAllRules());
        ksession.insert((Object)new org.drools.compiler.Person("Bob"));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        MiscTest.assertEquals((long)0L, (long)ksession.fireAllRules());
    }

    @Test
    public void testUppercaseField() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "declare Address\n";
        rule = rule + "    Street: String\n";
        rule = rule + "end\n";
        rule = rule + "rule \"r1\"\n";
        rule = rule + "when\n";
        rule = rule + "    Address($street: Street)\n";
        rule = rule + "then\n";
        rule = rule + "    list.add($street);\n";
        rule = rule + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("list", new ArrayList());
        FactType addressType = kbase.getFactType("org.drools.compiler.test", "Address");
        Object address = addressType.newInstance();
        addressType.set(address, "Street", (Object)"5th Avenue");
        ksession.insert(address);
        ksession.fireAllRules();
        List list = (List)ksession.getGlobal("list");
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"5th Avenue", list.get(0));
        ksession.dispose();
    }

    @Test
    public void testUppercaseField2() throws Exception {
        String rule = "package org.drools.compiler\ndeclare SomeFact\n    Field : String\n    aField : String\nend\nrule X\nwhen\n    SomeFact( Field == \"foo\", aField == \"bar\" )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType factType = kbase.getFactType("org.drools.compiler", "SomeFact");
        Object fact = factType.newInstance();
        factType.set(fact, "Field", (Object)"foo");
        factType.set(fact, "aField", (Object)"bar");
        ksession.insert(fact);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
        ksession.dispose();
    }

    @Test
    public void testNullHandling() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_NullHandling.drl");
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese nullCheese = new Cheese(null, 2);
        session.insert((Object)nullCheese);
        org.drools.compiler.Person notNullPerson = new org.drools.compiler.Person("shoes butt back");
        notNullPerson.setBigDecimal(new BigDecimal("42.42"));
        session.insert((Object)notNullPerson);
        org.drools.compiler.Person nullPerson = new org.drools.compiler.Person("whee");
        nullPerson.setBigDecimal(null);
        session.insert((Object)nullPerson);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        nullPerson = new org.drools.compiler.Person(null);
        session.insert((Object)nullPerson);
        session.fireAllRules();
        MiscTest.assertEquals((long)4L, (long)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testNullFieldOnCompositeSink() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_NullFieldOnCompositeSink.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Attribute());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"X", ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testEmptyPattern() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EmptyPattern.drl");
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((Object)5, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testExplicitAnd() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_ExplicitAnd.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message("hola"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)new Cheese("brie", 33));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
    }

    @Test
    public void testHelloWorld() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("HelloWorld.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Message message = new Message("hola");
        message.addToList("hello");
        message.setNumber(42);
        ksession.insert((Object)message);
        ksession.insert((Object)"boo");
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)message.isFired());
        MiscTest.assertEquals((Object)message, ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testExtends() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("extend_rule_test.drl");
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese mycheese = new Cheese("cheddar", 4);
        FactHandle handle = session.insert((Object)mycheese);
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains("rule 4"));
        MiscTest.assertTrue((boolean)list.contains("rule 2b"));
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract(handle);
        Cheese mycheese2 = new Cheese("notcheddar", 4);
        FactHandle handle2 = session.insert((Object)mycheese2);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"rule 4", list.get(0));
        MiscTest.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract(handle2);
        Cheese mycheese3 = new Cheese("stilton", 6);
        FactHandle handle3 = session.insert((Object)mycheese3);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"rule 3", list.get(0));
        MiscTest.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract(handle3);
        Cheese mycheese4 = new Cheese("notstilton", 6);
        FactHandle handle4 = session.insert((Object)mycheese4);
        session.fireAllRules();
        MiscTest.assertTrue((((List)session.getGlobal("list")).size() == 0 ? 1 : 0) != 0);
        list = new ArrayList();
        session.setGlobal("list", list);
        session.retract(handle4);
        Cheese mycheese5 = new Cheese("stilton", 7);
        FactHandle handle5 = session.insert((Object)mycheese5);
        session.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testExtends2() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_RuleExtend.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"stilton", results.get(0));
        MiscTest.assertEquals((Object)"brie", results.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatinLocale() throws Exception {
        Locale defaultLoc = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("pt", "BR"));
            KnowledgeBase kbase = this.loadKnowledgeBase("test_LatinLocale.drl");
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Cheese mycheese = new Cheese("cheddar", 4);
            FactHandle handle = ksession.insert((Object)mycheese);
            ksession.fireAllRules();
            MiscTest.assertEquals((long)1L, (long)results.size());
            MiscTest.assertEquals((Object)"1", results.get(0));
            mycheese.setPrice(8);
            mycheese.setDoublePrice(8.5);
            ksession.update(handle, (Object)mycheese);
            ksession.fireAllRules();
            MiscTest.assertEquals((long)2L, (long)results.size());
            MiscTest.assertEquals((Object)"3", results.get(1));
        }
        finally {
            Locale.setDefault(defaultLoc);
        }
    }

    @Test
    public void testLiteral() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("literal_rule_test.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"stilton", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testLiteralWithEscapes() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_literal_with_escapes.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        String expected = "s\tti\"lto\nn";
        Cheese stilton = new Cheese(expected, 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        int fired = session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)fired);
        MiscTest.assertEquals((Object)expected, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testLiteralWithBoolean() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("literal_with_boolean.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        org.drools.compiler.Person bill = new org.drools.compiler.Person("bill", null, 12);
        bill.setAlive(true);
        session.insert((Object)bill);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((Object)bill, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testFactBindings() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_FactBindings.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wmel = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        ksession.addEventListener(wmel);
        org.drools.compiler.Person bigCheese = new org.drools.compiler.Person("big cheese");
        Cheese cheddar = new Cheese("cheddar", 15);
        bigCheese.setCheese(cheddar);
        FactHandle bigCheeseHandle = ksession.insert((Object)bigCheese);
        FactHandle cheddarHandle = ksession.insert((Object)cheddar);
        ksession.fireAllRules();
        ArgumentCaptor arg = ArgumentCaptor.forClass(ObjectUpdatedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)2))).objectUpdated((ObjectUpdatedEvent)arg.capture());
        ObjectUpdatedEvent event = (ObjectUpdatedEvent)arg.getAllValues().get(0);
        MiscTest.assertSame((Object)cheddarHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)cheddar, (Object)event.getOldObject());
        MiscTest.assertSame((Object)cheddar, (Object)event.getObject());
        event = (ObjectUpdatedEvent)arg.getAllValues().get(1);
        MiscTest.assertSame((Object)bigCheeseHandle, (Object)event.getFactHandle());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getOldObject());
        MiscTest.assertSame((Object)bigCheese, (Object)event.getObject());
    }

    @Test
    public void testPropertyChangeSupportNewAPI() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_PropertyChangeTypeDecl.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        State state = new State("initial");
        session.insert((Object)state);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        state.setFlag(true);
        MiscTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
        state.setState("finished");
        session.dispose();
        MiscTest.assertEquals((long)0L, (long)state.getPropertyChangeListeners().length);
    }

    @Test
    public void testDisconnectedFactHandle() {
        KnowledgeBase kbase = this.getKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        DefaultFactHandle helloHandle = (DefaultFactHandle)ksession.insert((Object)"hello");
        DefaultFactHandle goodbyeHandle = (DefaultFactHandle)ksession.insert((Object)"goodbye");
        DefaultFactHandle key = new DefaultFactHandle(helloHandle.toExternalForm());
        MiscTest.assertEquals((Object)"hello", (Object)ksession.getObject((FactHandle)key));
        key = new DefaultFactHandle(goodbyeHandle.toExternalForm());
        MiscTest.assertEquals((Object)"goodbye", (Object)ksession.getObject((FactHandle)key));
    }

    @Test
    public void testBigDecimal() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("big_decimal_and_comparable.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        org.drools.compiler.Person bill = new org.drools.compiler.Person("bill", null, 42);
        bill.setBigDecimal(new BigDecimal("42"));
        org.drools.compiler.Person ben = new org.drools.compiler.Person("ben", null, 43);
        ben.setBigDecimal(new BigDecimal("43"));
        session.insert((Object)bill);
        session.insert((Object)new Cheese("gorgonzola", 43));
        session.insert((Object)ben);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testBigDecimalIntegerLiteral() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("big_decimal_and_literal.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        org.drools.compiler.Person bill = new org.drools.compiler.Person("bill", null, 12);
        bill.setBigDecimal(new BigDecimal("42"));
        bill.setBigInteger(new BigInteger("42"));
        session.insert((Object)bill);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testBigDecimalWithFromAndEval() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $dec : java.math.BigDecimal() from java.math.BigDecimal.TEN;\n";
        rule = rule + "    eval( $dec.compareTo(java.math.BigDecimal.ONE) > 0 )\n";
        rule = rule + "then\n";
        rule = rule + "    System.out.println(\"OK!\");\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.fireAllRules();
    }

    @Test
    public void testImport() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler.integrationtests;\n";
        rule = rule + "import java.lang.Math;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  dialect \"mvel\"\n";
        rule = rule + "  when\n";
        rule = rule + "  then\n";
        rule = rule + "    new TestFact(TestFact.TEST);\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.fireAllRules();
    }

    @Test
    public void testMVELConsequenceWithMapsAndArrays() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import java.util.ArrayList\n";
        rule = rule + "import java.util.HashMap\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "    dialect \"mvel\"";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    m = new HashMap();\n";
        rule = rule + "    l = new ArrayList();\n";
        rule = rule + "    l.add(\"first\");\n";
        rule = rule + "    m.put(\"content\", l);\n";
        rule = rule + "    System.out.println(((ArrayList)m[\"content\"])[0]);\n";
        rule = rule + "    list.add(((ArrayList)m[\"content\"])[0]);\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"first", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testCell() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("evalmodify.drl"));
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase, null, env);
        Cell cell1 = new Cell(9);
        Cell cell = new Cell(0);
        session.insert((Object)cell1);
        FactHandle cellHandle = session.insert((Object)cell);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)9L, (long)cell.getValue());
    }

    @Test
    public void testNesting() throws Exception {
        org.drools.compiler.Person p = new org.drools.compiler.Person();
        p.setName("Michael");
        Address add1 = new Address();
        add1.setStreet("High");
        Address add2 = new Address();
        add2.setStreet("Low");
        ArrayList<Address> l = new ArrayList<Address>();
        l.add(add1);
        l.add(add2);
        p.setAddresses(l);
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr desc = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("nested_fields.drl")));
        List packageAttrs = desc.getAttributes();
        MiscTest.assertEquals((long)1L, (long)desc.getRules().size());
        MiscTest.assertEquals((long)1L, (long)packageAttrs.size());
        RuleDescr rule = (RuleDescr)desc.getRules().get(0);
        Map ruleAttrs = rule.getAttributes();
        MiscTest.assertEquals((long)1L, (long)ruleAttrs.size());
        MiscTest.assertEquals((Object)"mvel", (Object)((AttributeDescr)ruleAttrs.get("dialect")).getValue());
        MiscTest.assertEquals((Object)"dialect", (Object)((AttributeDescr)ruleAttrs.get("dialect")).getName());
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(desc));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
    }

    @Test
    public void testOr() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("or_test.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle h = session.insert((Object)cheddar);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"got cheese", list.get(0));
        MiscTest.assertEquals((long)1L, (long)list.size());
        session.retract(h);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        session.insert((Object)new Cheese("stilton", 5));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testEval() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("eval_rule_test.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testJaninoEval() throws Exception {
        KnowledgeBuilderConfiguration kbconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbconf.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBase kbase = this.loadKnowledgeBase(kbconf, "eval_rule_test.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("five", (Object)new Integer(5));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testEvalMore() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("eval_rule_test_more.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        org.drools.compiler.Person foo = new org.drools.compiler.Person("foo");
        session.insert((Object)foo);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((Object)foo, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testReturnValue() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("returnvalue_rule_test.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person peter = new org.drools.compiler.Person("peter", null, 12);
        ksession.insert((Object)peter);
        org.drools.compiler.Person jane = new org.drools.compiler.Person("jane", null, 10);
        ksession.insert((Object)jane);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)jane, ((List)ksession.getGlobal("list")).get(0));
        MiscTest.assertEquals((Object)peter, ((List)ksession.getGlobal("list")).get(1));
    }

    @Test
    public void testPredicate() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("predicate_rule_test.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("two", (Object)new Integer(2));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person peter = new org.drools.compiler.Person("peter", null, 12);
        ksession.insert((Object)peter);
        org.drools.compiler.Person jane = new org.drools.compiler.Person("jane", null, 10);
        ksession.insert((Object)jane);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)jane, ((List)ksession.getGlobal("list")).get(0));
        MiscTest.assertEquals((Object)peter, ((List)ksession.getGlobal("list")).get(1));
    }

    @Test
    public void testNullBehaviour() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("null_behaviour.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("michael", "food", 40);
        org.drools.compiler.Person p2 = new org.drools.compiler.Person(null, "drink", 30);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
    }

    @Test
    public void testNullConstraint() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("null_constraint.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList foo = new ArrayList();
        session.setGlobal("messages", foo);
        org.drools.compiler.Person p1 = new org.drools.compiler.Person(null, "food", 40);
        Primitives p2 = new Primitives();
        p2.setArrayAttribute(null);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)((List)session.getGlobal("messages")).size());
    }

    @Test
    public void testBasicFrom() throws Exception {
        if (CommonTestMethodBase.phreak == RuleEngineOption.RETEOO) {
            return;
        }
        KnowledgeBase kbase = this.loadKnowledgeBase("test_From.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        ksession.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        ksession.setGlobal("list3", list3);
        Cheesery cheesery = new Cheesery();
        Cheese stilton = new Cheese("stilton", 12);
        Cheese cheddar = new Cheese("cheddar", 15);
        cheesery.addCheese(stilton);
        cheesery.addCheese(cheddar);
        ksession.setGlobal("cheesery", (Object)cheesery);
        ksession.insert((Object)cheesery);
        org.drools.compiler.Person p = new org.drools.compiler.Person("stilton");
        ksession.insert((Object)p);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)((List)ksession.getGlobal("list1")).size());
        MiscTest.assertEquals((Object)cheddar, ((List)ksession.getGlobal("list1")).get(0));
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list1")).get(1));
        MiscTest.assertEquals((long)2L, (long)((List)ksession.getGlobal("list2")).size());
        MiscTest.assertEquals((Object)cheddar, ((List)ksession.getGlobal("list2")).get(0));
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list2")).get(1));
        MiscTest.assertEquals((long)1L, (long)((List)ksession.getGlobal("list3")).size());
        MiscTest.assertEquals((Object)stilton, ((List)ksession.getGlobal("list3")).get(0));
    }

    @Test
    public void testFromWithParams() throws Exception {
        if (CommonTestMethodBase.phreak == RuleEngineOption.RETEOO) {
            return;
        }
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FromWithParams.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        Object globalObject = new Object();
        ksession.setGlobal("list", list);
        ksession.setGlobal("testObject", (Object)new FromTestClass());
        ksession.setGlobal("globalObject", globalObject);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob");
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)((List)ksession.getGlobal("list")).size());
        List array = (List)((List)ksession.getGlobal("list")).get(0);
        MiscTest.assertEquals((long)3L, (long)array.size());
        org.drools.compiler.Person p = (org.drools.compiler.Person)array.get(0);
        MiscTest.assertEquals((Object)p, (Object)bob);
        MiscTest.assertEquals((Object)new Integer(42), array.get(1));
        List nested = (List)array.get(2);
        MiscTest.assertEquals((Object)"x", nested.get(0));
        MiscTest.assertEquals((Object)"y", nested.get(1));
        Map map = (Map)((List)ksession.getGlobal("list")).get(1);
        MiscTest.assertEquals((long)2L, (long)map.keySet().size());
        MiscTest.assertTrue((boolean)map.keySet().contains(bob));
        MiscTest.assertEquals((Object)globalObject, map.get(bob));
        MiscTest.assertTrue((boolean)map.keySet().contains("key1"));
        Map nestedMap = (Map)map.get("key1");
        MiscTest.assertEquals((long)1L, (long)nestedMap.keySet().size());
        MiscTest.assertTrue((boolean)nestedMap.keySet().contains("key2"));
        MiscTest.assertEquals((Object)"value2", nestedMap.get("key2"));
        MiscTest.assertEquals((Object)new Integer(42), ((List)ksession.getGlobal("list")).get(2));
        MiscTest.assertEquals((Object)"literal", ((List)ksession.getGlobal("list")).get(3));
        MiscTest.assertEquals((Object)bob, ((List)ksession.getGlobal("list")).get(4));
        MiscTest.assertEquals((Object)globalObject, ((List)ksession.getGlobal("list")).get(5));
    }

    @Test
    public void testFromWithNewConstructor() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr descr = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromWithNewConstructor.drl")));
        Collection pkgs = this.loadKnowledgePackages(descr);
        pkgs = (Collection)SerializationHelper.serializeObject(pkgs);
    }

    @Test
    public void testFromDeclarationWithWorkingMemoryLogger() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import org.drools.compiler.Cheesery\n";
        rule = rule + "import org.drools.compiler.Cheese\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $cheesery : Cheesery()\n";
        rule = rule + "    Cheese( $type : type) from $cheesery.cheeses\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $type );\n";
        rule = rule + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 22));
        session.insert((Object)cheesery);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        MiscTest.assertEquals((Object)"stilton", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testWithInvalidRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"invalid_rule.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        String pretty = kbuilder.getErrors().toString();
        MiscTest.assertFalse((boolean)pretty.equals(""));
    }

    @Test
    public void testWithInvalidRule2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"invalid_rule2.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testErrorLineNumbers() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"errors_in_rule.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        KnowledgeBuilderError[] errors = (KnowledgeBuilderError[])kbuilder.getErrors().toArray((Object[])new KnowledgeBuilderError[0]);
        MiscTest.assertEquals((long)3L, (long)errors.length);
        DescrBuildError stiltonError = (DescrBuildError)errors[0];
        MiscTest.assertTrue((boolean)stiltonError.getMessage().contains("Stilton"));
        MiscTest.assertNotNull((Object)stiltonError.getDescr());
        MiscTest.assertTrue((stiltonError.getLine() != -1 ? 1 : 0) != 0);
        MiscTest.assertEquals((long)stiltonError.getLine(), (long)stiltonError.getDescr().getLine());
        MiscTest.assertEquals((long)11L, (long)stiltonError.getLine());
        DescrBuildError poisonError = (DescrBuildError)errors[1];
        MiscTest.assertTrue((boolean)poisonError.getMessage().contains("Poison"));
        MiscTest.assertEquals((long)13L, (long)poisonError.getLine());
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        switch (javaConf.getCompiler()) {
            case 2: {
                MiscTest.assertTrue((boolean)errors[2].getMessage().contains("illegal"));
                break;
            }
            case 0: {
                MiscTest.assertTrue((boolean)errors[2].getMessage().contains("add"));
                break;
            }
            case 1: {
                MiscTest.assertTrue((boolean)errors[2].getMessage().contains("Unexpected"));
                break;
            }
            default: {
                MiscTest.fail((String)"Unknown compiler used");
            }
        }
        DescrBuildError rhsError = (DescrBuildError)errors[2];
        MiscTest.assertTrue((rhsError.getLine() >= 8 && rhsError.getLine() <= 17 ? 1 : 0) != 0);
    }

    @Test
    public void testErrorsParser() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        MiscTest.assertEquals((long)0L, (long)parser.getErrors().size());
        parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("errors_parser_multiple.drl")));
        MiscTest.assertTrue((boolean)parser.hasErrors());
        MiscTest.assertTrue((parser.getErrors().size() > 0 ? 1 : 0) != 0);
        MiscTest.assertTrue((boolean)(parser.getErrors().get(0) instanceof ParserError));
        ParserError first = (ParserError)parser.getErrors().get(0);
        MiscTest.assertTrue((first.getMessage() != null ? 1 : 0) != 0);
        MiscTest.assertFalse((boolean)first.getMessage().equals(""));
    }

    @Test
    public void testAssertRetract() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("assert_retract.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person person = new org.drools.compiler.Person("michael", "cheese");
        person.setStatus("start");
        ksession.insert((Object)person);
        ksession.fireAllRules();
        List results = (List)ksession.getGlobal("list");
        for (String result : results) {
            logger.info(result);
        }
        MiscTest.assertEquals((long)5L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains("first"));
        MiscTest.assertTrue((boolean)results.contains("second"));
        MiscTest.assertTrue((boolean)results.contains("third"));
        MiscTest.assertTrue((boolean)results.contains("fourth"));
        MiscTest.assertTrue((boolean)results.contains("fifth"));
    }

    @Test
    public void testPredicateAsFirstPattern() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("predicate_as_first_pattern.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese mussarela = new Cheese("Mussarela", 35);
        ksession.insert((Object)mussarela);
        Cheese provolone = new Cheese("Provolone", 20);
        ksession.insert((Object)provolone);
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"The rule is being incorrectly fired", (long)35L, (long)mussarela.getPrice());
        MiscTest.assertEquals((String)"Rule is incorrectly being fired", (long)20L, (long)provolone.getPrice());
    }

    @Test
    public void testConsequenceException() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_ConsequenceException.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        try {
            ksession.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Consequence");
        }
        catch (ConsequenceException e) {
            MiscTest.assertEquals((Object)"Throw Consequence Exception", (Object)e.getMatch().getRule().getName());
            MiscTest.assertEquals((Object)"this should throw an exception", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testEvalException() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EvalException.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Eval");
        }
        catch (Exception e) {
            MiscTest.assertEquals((Object)"this should throw an exception", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testPredicateException() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_PredicateException.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the Predicate");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            MiscTest.assertTrue((boolean)cause.getMessage().contains("this should throw an exception"));
        }
    }

    @Test
    public void testReturnValueException() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ReturnValueException.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese brie = new Cheese("brie", 12);
        try {
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            MiscTest.fail((String)"Should throw an Exception from the ReturnValue");
        }
        catch (Exception e) {
            Throwable root = e;
            while (root.getCause() != null) {
                root = root.getCause();
            }
            root.getMessage().contains("this should throw an exception");
        }
    }

    @Test
    public void testMultiRestrictionFieldConstraint() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MultiRestrictionFieldConstraint.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list1 = new ArrayList();
        ksession.setGlobal("list1", list1);
        ArrayList list2 = new ArrayList();
        ksession.setGlobal("list2", list2);
        ArrayList list3 = new ArrayList();
        ksession.setGlobal("list3", list3);
        ArrayList list4 = new ArrayList();
        ksession.setGlobal("list4", list4);
        org.drools.compiler.Person youngChili1 = new org.drools.compiler.Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        org.drools.compiler.Person youngChili2 = new org.drools.compiler.Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        org.drools.compiler.Person chili1 = new org.drools.compiler.Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        org.drools.compiler.Person chili2 = new org.drools.compiler.Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        org.drools.compiler.Person oldChili1 = new org.drools.compiler.Person("old chili1");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        org.drools.compiler.Person oldChili2 = new org.drools.compiler.Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        ksession.insert((Object)youngChili1);
        ksession.insert((Object)youngChili2);
        ksession.insert((Object)chili1);
        ksession.insert((Object)chili2);
        ksession.insert((Object)oldChili1);
        ksession.insert((Object)oldChili2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list1.size());
        MiscTest.assertTrue((boolean)list1.contains(chili1));
        MiscTest.assertEquals((long)2L, (long)list2.size());
        MiscTest.assertTrue((boolean)list2.contains(chili1));
        MiscTest.assertTrue((boolean)list2.contains(chili2));
        MiscTest.assertEquals((long)2L, (long)list3.size());
        MiscTest.assertTrue((boolean)list3.contains(youngChili1));
        MiscTest.assertTrue((boolean)list3.contains(youngChili2));
        MiscTest.assertEquals((long)2L, (long)list4.size());
        MiscTest.assertTrue((boolean)list4.contains(youngChili1));
        MiscTest.assertTrue((boolean)list4.contains(chili1));
    }

    @Test
    public void testDumpers() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        PackageDescr pkg = parser.parse((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dumpers.drl")));
        if (parser.hasErrors()) {
            for (DroolsError error : parser.getErrors()) {
                logger.warn(error.toString());
            }
            MiscTest.fail((String)parser.getErrors().toString());
        }
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(pkg));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
        DrlDumper drlDumper = new DrlDumper();
        String drlResult = drlDumper.dump(pkg);
        System.out.println(drlResult);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(drlResult));
        ksession = kbase.newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
        MiscTest.assertEquals((Object)"3 1", list.get(0));
        MiscTest.assertEquals((Object)"MAIN", list.get(1));
        MiscTest.assertEquals((Object)"1 1", list.get(2));
    }

    @Test
    public void testContainsCheese() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ContainsCheese.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        ksession.insert((Object)stilton);
        Cheese brie = new Cheese("brie", 10);
        ksession.insert((Object)brie);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton);
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
    }

    @Test
    public void testDuplicateRuleNames() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_DuplicateRuleName1.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_DuplicateRuleName2.drl");
        kbase.addKnowledgePackages(kpkgs);
    }

    @Test
    public void testNullValuesIndexing() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NullValuesIndexing.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person bob = new org.drools.compiler.Person(null, null);
        bob.setStatus("P1");
        org.drools.compiler.Person pete = new org.drools.compiler.Person(null, null);
        bob.setStatus("P2");
        ksession.insert((Object)bob);
        ksession.insert((Object)pete);
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"Indexing with null values is not working correctly.", (Object)"OK", (Object)bob.getStatus());
        MiscTest.assertEquals((String)"Indexing with null values is not working correctly.", (Object)"OK", (Object)pete.getStatus());
    }

    @Test
    public void testEmptyRule() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EmptyRule.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired2"));
    }

    @Test
    public void testjustEval() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NoPatterns.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("fired1"));
        MiscTest.assertTrue((boolean)list.contains("fired3"));
    }

    @Test
    public void testOrWithBinding() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_OrWithBindings.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person hola = new org.drools.compiler.Person("hola");
        ksession.insert((Object)hola);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        Cheese brie = new Cheese("brie");
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(hola));
        MiscTest.assertTrue((boolean)list.contains(brie));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinNodeModifyObject() throws Exception {
        IndexedNumber n;
        int i;
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_JoinNodeModifyObject.drl"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList orderedFacts = new ArrayList();
        ArrayList errors = new ArrayList();
        ksession.setGlobal("orderedNumbers", orderedFacts);
        ksession.setGlobal("errors", errors);
        int MAX = 2;
        for (i = 1; i <= 2; ++i) {
            n = new IndexedNumber(i, 2 - i + 1);
            ksession.insert((Object)n);
        }
        ksession.fireAllRules();
        MiscTest.assertTrue((String)("Processing generated errors: " + ((Object)errors).toString()), (boolean)errors.isEmpty());
        for (i = 1; i <= 2; ++i) {
            n = (IndexedNumber)orderedFacts.get(i - 1);
            MiscTest.assertEquals((String)"Fact is out of order", (long)i, (long)n.getIndex());
        }
    }

    @Test
    public void testInsurancePricingExample() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("insurance_pricing_example.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Driver driver = new Driver();
        Policy policy = new Policy();
        ksession.insert((Object)driver);
        ksession.insert((Object)policy);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)120L, (long)policy.getBasePrice());
    }

    @Test
    public void testLLR() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_JoinNodeModifyTuple.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Target tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26544f));
        tgt.setLon(new Float(28.952137f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.8666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236874f));
        tgt.setLon(new Float(28.992579f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.8666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265343f));
        tgt.setLon(new Float(28.952267f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236935f));
        tgt.setLon(new Float(28.992493f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.26525f));
        tgt.setLon(new Float(28.952396f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9333333f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.236996f));
        tgt.setLon(new Float(28.992405f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9333333f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
        tgt = new Target();
        tgt.setLabel("Santa-Anna");
        tgt.setLat(new Float(60.265163f));
        tgt.setLon(new Float(28.952526f));
        tgt.setCourse(new Float(145.0f));
        tgt.setSpeed(new Float(12.0f));
        tgt.setTime(new Float(1.9666667f));
        ksession.insert((Object)tgt);
        tgt = new Target();
        tgt.setLabel("Santa-Maria");
        tgt.setLat(new Float(60.237057f));
        tgt.setLon(new Float(28.99232f));
        tgt.setCourse(new Float(325.0f));
        tgt.setSpeed(new Float(8.0f));
        tgt.setTime(new Float(1.9666667f));
        ksession.insert((Object)tgt);
        ksession.fireAllRules();
    }

    @Test
    public void testReturnValueAndGlobal() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ReturnValueAndGlobal.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList matchlist = new ArrayList();
        ksession.setGlobal("matchingList", matchlist);
        ArrayList nonmatchlist = new ArrayList();
        ksession.setGlobal("nonMatchingList", nonmatchlist);
        ksession.setGlobal("cheeseType", (Object)"stilton");
        Cheese stilton1 = new Cheese("stilton", 5);
        Cheese stilton2 = new Cheese("stilton", 7);
        Cheese brie = new Cheese("brie", 4);
        ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)matchlist.size());
        MiscTest.assertEquals((long)1L, (long)nonmatchlist.size());
    }

    @Test
    public void testDeclaringAndUsingBindsInSamePattern() throws Exception {
        KieBaseConfiguration kbc = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbc.setOption((KieBaseOption)RemoveIdentitiesOption.YES);
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(kbc, "test_DeclaringAndUsingBindsInSamePattern.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList sensors = new ArrayList();
        ksession.setGlobal("sensors", sensors);
        Sensor sensor1 = new Sensor(100, 150);
        ksession.insert((Object)sensor1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)sensors.size());
        Sensor sensor2 = new Sensor(200, 150);
        ksession.insert((Object)sensor2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)sensors.size());
    }

    @Test
    public void testMissingImports() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_missing_import.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testNestedConditionalElements() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NestedConditionalElements.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        State state = new State("SP");
        ksession.insert((Object)state);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)new Cheese(bob.getLikes(), 10));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testDeclarationUsage() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_DeclarationUsage.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testDeclareAndFrom() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_DeclareWithFrom.drl");
        FactType profileType = kbase.getFactType("org.drools.compiler", "Profile");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Object profile = profileType.newInstance();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("internet", 2);
        profileType.set(profile, "pageFreq", map);
        ksession.insert(profile);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testDeclarationNonExistingField() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_DeclarationOfNonExistingField.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testUnbalancedTrees() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_UnbalancedTrees.drl"));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        wm.insert((Object)new Cheese("a", 10));
        wm.insert((Object)new Cheese("b", 10));
        wm.insert((Object)new Cheese("c", 10));
        wm.insert((Object)new Cheese("d", 10));
        Cheese e = new Cheese("e", 10);
        wm.insert((Object)e);
        wm.fireAllRules();
        MiscTest.assertEquals((String)"Rule should have fired twice, seting the price to 30", (long)30L, (long)e.getPrice());
    }

    @Test
    public void testImportConflict() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ImportConflict.drl"));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
    }

    @Test
    public void testEmptyIdentifier() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_emptyIdentifier.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList result = new ArrayList();
        ksession.setGlobal("results", result);
        org.drools.compiler.Person person = new org.drools.compiler.Person("bob");
        Cheese cheese = new Cheese("brie", 10);
        ksession.insert((Object)person);
        ksession.insert((Object)cheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)4L, (long)result.size());
    }

    @Test
    public void testDuplicateVariableBinding() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_duplicateVariableBinding.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap result = new HashMap();
        ksession.setGlobal("results", result);
        Cheese stilton = new Cheese("stilton", 20);
        Cheese brie = new Cheese("brie", 10);
        ksession.insert((Object)stilton);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)5L, (long)result.size());
        MiscTest.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get(stilton.getType())).intValue());
        MiscTest.assertEquals((long)brie.getPrice(), (long)((Integer)result.get(brie.getType())).intValue());
        MiscTest.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get(stilton)).intValue());
        MiscTest.assertEquals((long)brie.getPrice(), (long)((Integer)result.get(brie)).intValue());
        MiscTest.assertEquals((long)stilton.getPrice(), (long)((Integer)result.get("test3" + stilton.getType())).intValue());
        ksession.insert((Object)new org.drools.compiler.Person("bob", brie.getType()));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)result.size());
        MiscTest.assertEquals((long)brie.getPrice(), (long)((Integer)result.get("test3" + brie.getType())).intValue());
    }

    @Test
    public void testShadowProxyInHirarchies() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ShadowProxyInHirarchies.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Child("gp"));
        ksession.fireAllRules();
    }

    @Test
    public void testSelfReference() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_SelfReference.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Order order = new Order(10, "Bob");
        OrderItem item1 = new OrderItem(order, 1);
        OrderItem item2 = new OrderItem(order, 2);
        OrderItem anotherItem1 = new OrderItem(null, 3);
        OrderItem anotherItem2 = new OrderItem(null, 4);
        ksession.insert((Object)order);
        ksession.insert((Object)item1);
        ksession.insert((Object)item2);
        ksession.insert((Object)anotherItem1);
        ksession.insert((Object)anotherItem2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains(item1));
        MiscTest.assertTrue((boolean)results.contains(item2));
    }

    @Test
    public void testNumberComparisons() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NumberComparisons.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        RandomNumber rn = new RandomNumber();
        rn.setValue(10);
        ksession.insert((Object)rn);
        Guess guess = new Guess();
        guess.setValue(new Integer(5));
        FactHandle handle = ksession.insert((Object)guess);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"HIGHER", list.get(0));
        guess.setValue(new Integer(15));
        ksession.update(handle, (Object)guess);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)"LOWER", list.get(1));
        guess.setValue(new Integer(10));
        ksession.update(handle, (Object)guess);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
        MiscTest.assertEquals((Object)"CORRECT", list.get(2));
    }

    @Test
    public void testEventModel() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EventModel.drl"));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wmel = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        wm.addEventListener(wmel);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        ArgumentCaptor oic = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectInserted((ObjectInsertedEvent)oic.capture());
        MiscTest.assertSame((Object)stiltonHandle, (Object)((ObjectInsertedEvent)oic.getValue()).getFactHandle());
        wm.update(stiltonHandle, (Object)stilton);
        ArgumentCaptor ouc = ArgumentCaptor.forClass(ObjectUpdatedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectUpdated((ObjectUpdatedEvent)ouc.capture());
        MiscTest.assertSame((Object)stiltonHandle, (Object)((ObjectUpdatedEvent)ouc.getValue()).getFactHandle());
        wm.retract(stiltonHandle);
        ArgumentCaptor orc = ArgumentCaptor.forClass(ObjectDeletedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmel)).objectDeleted((ObjectDeletedEvent)orc.capture());
        MiscTest.assertSame((Object)stiltonHandle, (Object)((ObjectDeletedEvent)orc.getValue()).getFactHandle());
    }

    @Test
    public void testImplicitDeclarations() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_implicitDeclarations.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.setGlobal("factor", (Object)new Double(1.2));
        Cheese cheese = new Cheese("stilton", 10);
        ksession.insert((Object)cheese);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testMVELImplicitWithFrom() throws IOException, ClassNotFoundException {
        String str = "package org.drools.compiler.test \nimport java.util.List \nglobal java.util.List list \nglobal java.util.List list2 \nrule \"show\" dialect \"mvel\" \nwhen  \n    $m : List( eval( size == 0 ) ) from [list] \nthen \n    list2.add('r1'); \nend \n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testJavaImplicitWithFrom() throws IOException, ClassNotFoundException {
        String str = "package org.drools.compiler.test \nimport java.util.List \nglobal java.util.List list \nglobal java.util.List list2 \nrule \"show\" dialect \"java\" \nwhen  \n    $m : List( eval( size == 0 )  ) from [list] \nthen \n    list2.add('r1'); \nend \n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("list2", list);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testCastingInsideEvals() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_castsInsideEval.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("value", (Object)new Integer(20));
        ksession.fireAllRules();
    }

    @Test
    public void testMemberOfAndNotMemberOf() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_memberOf.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese muzzarela = new Cheese("muzzarela", 10);
        Cheese brie = new Cheese("brie", 15);
        ksession.insert((Object)stilton);
        ksession.insert((Object)muzzarela);
        Cheesery cheesery = new Cheesery();
        cheesery.getCheeses().add(stilton.getType());
        cheesery.getCheeses().add(brie.getType());
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)muzzarela, list.get(1));
    }

    @Test
    public void testContainsInArray() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_contains_in_array.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Primitives p = new Primitives();
        p.setStringArray(new String[]{"test1", "test3"});
        ksession.insert((Object)p);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)"ok1", list.get(0));
        MiscTest.assertEquals((Object)"ok2", list.get(1));
    }

    @Test
    public void testNodeSharingNotExists() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_nodeSharingNotExists.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"rule1", list.get(0));
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)"rule2", list.get(1));
    }

    @Test
    public void testNullBinding() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_nullBindings.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new org.drools.compiler.Person("bob"));
        ksession.insert((Object)new org.drools.compiler.Person(null));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    public void testModifyRetractWithFunction() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_RetractModifyWithFunction.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cheese stilton = new Cheese("stilton", 7);
        Cheese muzzarella = new Cheese("muzzarella", 9);
        int sum = stilton.getPrice() + muzzarella.getPrice();
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        FactHandle muzzarellaHandle = ksession.insert((Object)muzzarella);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)sum, (long)stilton.getPrice());
        MiscTest.assertEquals((long)1L, (long)ksession.getFactCount());
        MiscTest.assertNotNull((Object)ksession.getObject(stiltonHandle));
        MiscTest.assertNotNull((Object)ksession.getFactHandle((Object)stilton));
        MiscTest.assertNull((Object)ksession.getObject(muzzarellaHandle));
        MiscTest.assertNull((Object)ksession.getFactHandle((Object)muzzarella));
    }

    @Test
    public void testConstraintConnectors() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ConstraintConnectors.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        org.drools.compiler.Person youngChili1 = new org.drools.compiler.Person("young chili1");
        youngChili1.setAge(12);
        youngChili1.setHair("blue");
        org.drools.compiler.Person youngChili2 = new org.drools.compiler.Person("young chili2");
        youngChili2.setAge(25);
        youngChili2.setHair("purple");
        org.drools.compiler.Person chili1 = new org.drools.compiler.Person("chili1");
        chili1.setAge(35);
        chili1.setHair("red");
        org.drools.compiler.Person chili2 = new org.drools.compiler.Person("chili2");
        chili2.setAge(38);
        chili2.setHair("indigigo");
        org.drools.compiler.Person oldChili1 = new org.drools.compiler.Person("old chili1");
        oldChili1.setAge(45);
        oldChili1.setHair("green");
        org.drools.compiler.Person oldChili2 = new org.drools.compiler.Person("old chili2");
        oldChili2.setAge(48);
        oldChili2.setHair("blue");
        org.drools.compiler.Person veryold = new org.drools.compiler.Person("very old");
        veryold.setAge(99);
        veryold.setHair("gray");
        ksession.insert((Object)youngChili1);
        ksession.insert((Object)youngChili2);
        ksession.insert((Object)chili1);
        ksession.insert((Object)chili2);
        ksession.insert((Object)oldChili1);
        ksession.insert((Object)oldChili2);
        ksession.insert((Object)veryold);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)4L, (long)results.size());
        MiscTest.assertEquals((Object)chili1, results.get(0));
        MiscTest.assertEquals((Object)oldChili1, results.get(1));
        MiscTest.assertEquals((Object)youngChili1, results.get(2));
        MiscTest.assertEquals((Object)veryold, results.get(3));
    }

    @Test
    public void testConnectorsAndOperators() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ConstraintConnectorsAndOperators.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
        ksession.insert((Object)new StockTick(2L, "IBM", 10.0, 1100L));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)fired);
    }

    @Test
    public void testConstraintConnectorOr() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ConstraintConnectorOr.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        org.drools.compiler.Person mark = new org.drools.compiler.Person("Mark");
        mark.setAlive(true);
        mark.setHappy(true);
        org.drools.compiler.Person bush = new org.drools.compiler.Person("Bush");
        bush.setAlive(true);
        bush.setHappy(false);
        org.drools.compiler.Person conan = new org.drools.compiler.Person("Conan");
        conan.setAlive(false);
        conan.setHappy(true);
        org.drools.compiler.Person nero = new org.drools.compiler.Person("Nero");
        nero.setAlive(false);
        nero.setHappy(false);
        ksession.insert((Object)mark);
        ksession.insert((Object)bush);
        ksession.insert((Object)conan);
        ksession.insert((Object)nero);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains(mark));
        MiscTest.assertTrue((boolean)results.contains(bush));
        MiscTest.assertTrue((boolean)results.contains(conan));
    }

    @Test
    public void testMatchesNotMatchesCheese() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MatchesNotMatches.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 12);
        Cheese stilton2 = new Cheese("stilton2", 12);
        Cheese agedStilton = new Cheese("aged stilton", 12);
        Cheese brie = new Cheese("brie", 10);
        Cheese brie2 = new Cheese("brie2", 10);
        Cheese muzzarella = new Cheese("muzzarella", 10);
        Cheese muzzarella2 = new Cheese("muzzarella2", 10);
        Cheese provolone = new Cheese("provolone", 10);
        Cheese provolone2 = new Cheese("another cheese (provolone)", 10);
        ksession.insert((Object)stilton);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)agedStilton);
        ksession.insert((Object)brie);
        ksession.insert((Object)brie2);
        ksession.insert((Object)muzzarella);
        ksession.insert((Object)muzzarella2);
        ksession.insert((Object)provolone);
        ksession.insert((Object)provolone2);
        ksession.fireAllRules();
        logger.info(((Object)list).toString());
        MiscTest.assertEquals((long)4L, (long)list.size());
        MiscTest.assertEquals((Object)stilton, list.get(0));
        MiscTest.assertEquals((Object)brie, list.get(1));
        MiscTest.assertEquals((Object)agedStilton, list.get(2));
        MiscTest.assertEquals((Object)provolone, list.get(3));
    }

    @Test
    public void testAutomaticBindings() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_AutoBindings.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        ksession.insert((Object)bob);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    @Test
    public void testMatchesMVEL() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MatchesMVEL.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "hello ;=");
        session.insert(map);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testMatchesMVEL2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_MatchesMVEL2.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "String with . and (routine)");
        ksession.insert(map);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)fired);
    }

    @Test
    public void testMatchesMVEL3() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_MatchesMVEL2.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", "String with . and ()");
        ksession.insert(map);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)fired);
    }

    @Test
    public void testQualifiedFieldReference() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_QualifiedFieldReference.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob", "stilton");
        Cheese stilton = new Cheese("stilton", 12);
        ksession.insert((Object)bob);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)bob, list.get(0));
    }

    @Test
    public void testEvalInline() throws Exception {
        String text = "package org.drools.compiler\nrule \"inline eval\"\nwhen\n    $str : String()\n    Person( eval( name.startsWith($str) && age == 18) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nrule \"inline eval\"\nwhen\n    $str : String()\n    Person( eval( name.startsWith($str) && age == 18) )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"b");
        ksession.insert((Object)new org.drools.compiler.Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)rules);
        ksession.insert((Object)new org.drools.compiler.Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testMethodCalls() throws Exception {
        String text = "package org.drools.compiler\nrule \"method calls\"\nwhen\n    Person( getName().substring(2) == 'b' )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nrule \"method calls\"\nwhen\n    Person( getName().substring(2) == 'b' )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new org.drools.compiler.Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)rules);
        ksession.insert((Object)new org.drools.compiler.Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testAlphaExpression() throws Exception {
        String text = "package org.drools.compiler\nrule \"alpha\"\nwhen\n    Person( 5 < 6 )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nrule \"alpha\"\nwhen\n    Person( 5 < 6 )\nthen\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new org.drools.compiler.Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testEvalCE() throws Exception {
        String text = "package org.drools.compiler\nrule \"inline eval\"\nwhen\n    $str : String()\n    $p   : Person()\n    eval( $p.getName().startsWith($str) && $p.getName().endsWith($str) )then\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nrule \"inline eval\"\nwhen\n    $str : String()\n    $p   : Person()\n    eval( $p.getName().startsWith($str) && $p.getName().endsWith($str) )then\nend");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"b");
        ksession.insert((Object)new org.drools.compiler.Person("mark", 50));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)rules);
        ksession.insert((Object)new org.drools.compiler.Person("bob", 18));
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testEvalRewrite() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EvalRewrite.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        order3.addItem(item31);
        order3.addItem(item32);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.insert((Object)order2);
        ksession.insert((Object)item21);
        ksession.insert((Object)item22);
        ksession.insert((Object)order3);
        ksession.insert((Object)item31);
        ksession.insert((Object)item32);
        ksession.insert((Object)order4);
        ksession.insert((Object)item41);
        ksession.insert((Object)item42);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)5L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
        MiscTest.assertTrue((boolean)list.contains(item22));
        MiscTest.assertTrue((boolean)list.contains(order3));
        MiscTest.assertTrue((boolean)list.contains(order4));
    }

    @Test
    public void testMapAccess() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MapAccess.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        ksession.insert(map);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapNullConstraint() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_mapNullConstraints.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        new WorkingMemoryConsoleLogger((KnowledgeRuntimeEventManager)ksession);
        HashMap<String, Address> addresses = new HashMap<String, Address>();
        addresses.put("home", new Address("home street"));
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob");
        bob.setNamedAddresses(addresses);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        AfterMatchFiredEvent aaf = (AfterMatchFiredEvent)arg.getAllValues().get(0);
        MiscTest.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"1. home != null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(1);
        MiscTest.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"2. not home == null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(2);
        MiscTest.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"7. work == null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(3);
        MiscTest.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"8. not work != null"));
    }

    @Test
    public void testNoneTypeSafeDeclarations() {
        String str = "package org.drools.compiler\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.test\nimport org.drools.compiler.Person\nglobal java.util.List list\ndeclare Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.test\nglobal java.util.List list\ndeclare org.drools.compiler.Person\n    @typesafe(false)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : org.drools.compiler.Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, true);
        str = "package org.drools.compiler.test\nglobal java.util.List list\ndeclare org.drools.compiler.Person\n    @typesafe(true)\nend\nrule testTypeSafe\n dialect \"mvel\" when\n   $p : org.drools.compiler.Person( object.street == 's1' )\nthen\n   list.add( $p );\nend\n";
        this.executeTypeSafeDeclarations(str, false);
    }

    private void executeTypeSafeDeclarations(String str, boolean mustSucceed) {
        KnowledgeBase kbase = null;
        try {
            kbase = this.loadKnowledgeBaseFromString(str);
            if (!mustSucceed) {
                MiscTest.fail((String)"Compilation Should fail");
            }
        }
        catch (Throwable e) {
            if (mustSucceed) {
                MiscTest.fail((String)"Compilation Should succeed");
            }
            return;
        }
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Address a = new Address("s1");
        org.drools.compiler.Person p = new org.drools.compiler.Person("yoda");
        p.setObject((Object)a);
        ksession.insert((Object)p);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)p, list.get(0));
    }

    @Test
    public void testMapAccessWithVariable() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MapAccessWithVariable.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        ksession.insert(map);
        ksession.insert((Object)"name");
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapAccessWithVariable2() {
        String str = "package org.drools.compiler;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testHalt() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_halt.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Integer(0));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
    }

    @Test
    public void testFireLimit() throws Exception {
        int i;
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_fireLimit.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Integer(0));
        int count = ksession.fireAllRules();
        MiscTest.assertEquals((long)21L, (long)count);
        MiscTest.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        ksession.insert((Object)new Integer(0));
        count = ksession.fireAllRules(10);
        MiscTest.assertEquals((long)10L, (long)count);
        MiscTest.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        count = ksession.fireAllRules();
        MiscTest.assertEquals((long)11L, (long)count);
        MiscTest.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
        ksession.insert((Object)new Integer(0));
        count = ksession.fireAllRules();
        MiscTest.assertEquals((long)21L, (long)count);
        MiscTest.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            MiscTest.assertEquals((Object)new Integer(i), results.get(i));
        }
        results.clear();
    }

    @Test
    public void testEqualitySupport() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_equalitySupport.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        PersonWithEquals person = new PersonWithEquals("bob", 30);
        ksession.insert((Object)person);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)"mark", results.get(0));
    }

    @Test
    public void testCharComparisons() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_charComparisons.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Primitives p1 = new Primitives();
        p1.setCharPrimitive('a');
        p1.setStringAttribute("b");
        Primitives p2 = new Primitives();
        p2.setCharPrimitive('b');
        p2.setStringAttribute("a");
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
        MiscTest.assertEquals((Object)"3", results.get(2));
    }

    @Test
    public void testAlphaNodeSharing() throws Exception {
        KieBaseConfiguration kbc = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbc.setOption((KieBaseOption)ShareAlphaNodesOption.YES);
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(kbc, "test_alphaNodeSharing.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("bob", 5);
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"1", results.get(0));
        MiscTest.assertEquals((Object)"2", results.get(1));
    }

    @Test
    public void testSelfReference2() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_SelfReference2.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese());
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testSelfJoinWithIndex() throws IOException, ClassNotFoundException {
        String drl = "";
        drl = drl + "package org.drools.compiler.test\n";
        drl = drl + "import org.drools.compiler.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( $name : name, $age : age )\n";
        drl = drl + "   $p2 : Person( name == $name, age < $age)\n";
        drl = drl + "then\n";
        drl = drl + "    list.add( $p1 );\n";
        drl = drl + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(drl));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("darth", 30);
        FactHandle fh1 = ksession.insert((Object)p1);
        org.drools.compiler.Person p2 = new org.drools.compiler.Person("darth", 25);
        FactHandle fh2 = ksession.insert((Object)p2);
        p1.setName("yoda");
        ksession.update(fh1, (Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testMergingDifferentPackages() throws Exception {
        try {
            Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_RuleNameClashes1.drl", "test_RuleNameClashes2.drl");
            MiscTest.assertEquals((long)3L, (long)kpkgs.size());
            for (KnowledgePackage kpkg : kpkgs) {
                if (!kpkg.getName().equals("org.drools.package1")) continue;
                MiscTest.assertEquals((Object)"rule 1", (Object)((Rule)kpkg.getRules().iterator().next()).getName());
            }
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testSelfJoinAndNotWithIndex() throws IOException, ClassNotFoundException {
        String drl = "";
        drl = drl + "package org.drools.compiler.test\n";
        drl = drl + "import org.drools.compiler.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( )\n";
        drl = drl + "     not Person( name == $p1.name, age < $p1.age )\n";
        drl = drl + "   $p2 : Person( name == $p1.name, likes != $p1.likes, age > $p1.age)\n";
        drl = drl + "     not Person( name == $p1.name, likes == $p2.likes, age < $p2.age )\n";
        drl = drl + "then\n";
        drl = drl + "    System.out.println( $p1 + \":\" + $p2 );\n";
        drl = drl + "    list.add( $p1 );\n";
        drl = drl + "    list.add( $p2 );\n";
        drl = drl + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(drl));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p0 = new org.drools.compiler.Person("yoda", 0);
        p0.setLikes("cheddar");
        FactHandle fh0 = ksession.insert((Object)p0);
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("darth", 15);
        p1.setLikes("cheddar");
        FactHandle fh1 = ksession.insert((Object)p1);
        org.drools.compiler.Person p2 = new org.drools.compiler.Person("darth", 25);
        p2.setLikes("cheddar");
        FactHandle fh2 = ksession.insert((Object)p2);
        org.drools.compiler.Person p3 = new org.drools.compiler.Person("darth", 30);
        p3.setLikes("brie");
        FactHandle fh3 = ksession.insert((Object)p3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertSame((Object)p1, list.get(0));
        MiscTest.assertSame((Object)p3, list.get(1));
        p1.setName("yoda");
        ksession.update(fh1, (Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)4L, (long)list.size());
        MiscTest.assertSame((Object)p2, list.get(2));
        MiscTest.assertSame((Object)p3, list.get(3));
    }

    @Test
    public void testMergingDifferentPackages2() throws Exception {
        try {
            Collection<KnowledgePackage> kpkgs1 = this.loadKnowledgePackages("test_RuleNameClashes1.drl");
            MiscTest.assertEquals((long)1L, (long)kpkgs1.iterator().next().getRules().size());
            Collection<KnowledgePackage> kpkgs2 = this.loadKnowledgePackages("test_RuleNameClashes2.drl");
            MiscTest.assertEquals((long)1L, (long)kpkgs2.iterator().next().getRules().size());
            KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
            kbase.addKnowledgePackages(kpkgs1);
            kbase.addKnowledgePackages(kpkgs2);
            kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.insert((Object)new Cheese("brie", 5));
            ksession.fireAllRules();
            MiscTest.assertEquals((String)((Object)results).toString(), (long)2L, (long)results.size());
            MiscTest.assertTrue((boolean)results.contains("p1.r1"));
            MiscTest.assertTrue((boolean)results.contains("p2.r1"));
        }
        catch (PackageBuilder.PackageMergeException e) {
            MiscTest.fail((String)("Should not raise exception when merging different packages into the same rulebase: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMergePackageWithSameRuleNames() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_MergePackageWithSameRuleNames1.drl"));
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_MergePackageWithSameRuleNames2.drl");
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)"rule1 for the package2", results.get(0));
    }

    @Test
    public void testRuleRemovalWithJoinedRootPattern() {
        String str = "";
        str = str + "package org.drools.compiler \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "  String() \n";
        str = str + "  Person() \n";
        str = str + "then \n";
        str = str + "end  \n";
        str = str + "rule rule2 \n";
        str = str + "when \n";
        str = str + "  String() \n";
        str = str + "  Cheese() \n";
        str = str + "then \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(RuleEngineOption.PHREAK, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        DefaultFactHandle handle = (DefaultFactHandle)ksession.insert((Object)"hello");
        ksession.fireAllRules();
        LeftTuple leftTuple = handle.getFirstLeftTuple();
        MiscTest.assertNotNull((Object)leftTuple);
        MiscTest.assertNotNull((Object)leftTuple.getPeer());
        kbase.removeRule("org.drools.compiler", "rule2");
        leftTuple = handle.getFirstLeftTuple();
        MiscTest.assertNotNull((Object)leftTuple);
        MiscTest.assertNull((Object)leftTuple.getLeftParentNext());
    }

    @Test
    public void testKnowledgeHelperFixerInStrings() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  no-loop true ";
        str = str + "when \n";
        str = str + "  $fact : String() \n";
        str = str + "then \n";
        str = str + "  list.add(\"This is an update()\"); \n";
        str = str + "  list.add(\"This is an update($fact)\"); \n";
        str = str + "  update($fact); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"hello");
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)"This is an update()", list.get(0));
        MiscTest.assertEquals((Object)"This is an update($fact)", list.get(1));
    }

    @Test
    public void testEmptyAfterRetractInIndexedMemory() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import org.drools.compiler.Person\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx dialect 'mvel' \n";
        str = str + "when \n";
        str = str + "  Person( $name : name ) \n";
        str = str + "  $s : String( this == $name) \n";
        str = str + "then \n";
        str = str + "  list.add($s); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p = new org.drools.compiler.Person("ackbar");
        FactHandle ph = ksession.insert((Object)p);
        FactHandle sh = ksession.insert((Object)"ackbar");
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"ackbar", list.get(0));
    }

    @Test
    public void testRuleReplacement() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_RuleNameClashes3.drl", "test_RuleNameClashes3.drl");
        for (KnowledgePackage kpkg : kpkgs) {
            if (!kpkg.getName().equals("org.drools.package1")) continue;
            MiscTest.assertEquals((long)1L, (long)kpkg.getRules().size());
            break;
        }
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.insert((Object)new Cheese("brie", 5));
        ksession.fireAllRules();
        MiscTest.assertEquals((String)((Object)results).toString(), (long)0L, (long)results.size());
        ksession.insert((Object)new Cheese("muzzarella", 7));
        ksession.fireAllRules();
        MiscTest.assertEquals((String)((Object)results).toString(), (long)1L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains("p1.r3"));
    }

    @Test
    public void testBindingsOnConnectiveExpressions() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_bindings.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 15));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"stilton", results.get(0));
        MiscTest.assertEquals((Object)new Integer(15), results.get(1));
    }

    @Test
    public void testMultipleFroms() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_multipleFroms.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 15));
        cheesery.addCheese(new Cheese("brie", 10));
        ksession.setGlobal("cheesery", (Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((long)2L, (long)((List)results.get(0)).size());
        MiscTest.assertEquals((long)2L, (long)((List)results.get(1)).size());
    }

    @Test
    public void testNullHashing() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NullHashing.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 15));
        ksession.insert((Object)new Cheese("", 10));
        ksession.insert((Object)new Cheese(null, 8));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void testDefaultBetaConstrains() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_DefaultBetaConstraint.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        FirstClass first = new FirstClass("1", "2", "3", "4", "5");
        FactHandle handle = ksession.insert((Object)first);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(0));
        ksession.insert((Object)new SecondClass());
        ksession.update(handle, (Object)first);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(1));
        ksession.update(handle, (Object)first);
        ksession.insert((Object)new SecondClass(null, "2", "3", "4", "5"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(2));
        ksession.update(handle, (Object)first);
        ksession.insert((Object)new SecondClass("1", null, "3", "4", "5"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)4L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(3));
        ksession.update(handle, (Object)first);
        ksession.insert((Object)new SecondClass("1", "2", null, "4", "5"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)5L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(4));
        ksession.update(handle, (Object)first);
        ksession.insert((Object)new SecondClass("1", "2", "3", null, "5"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(5));
        ksession.update(handle, (Object)first);
        ksession.insert((Object)new SecondClass("1", "2", "3", "4", null));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)7L, (long)results.size());
        MiscTest.assertEquals((Object)"NOT", results.get(6));
        ksession.insert((Object)new SecondClass("1", "2", "3", "4", "5"));
        ksession.update(handle, (Object)first);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)8L, (long)results.size());
        MiscTest.assertEquals((Object)"EQUALS", results.get(7));
    }

    @Test
    public void testBooleanWrapper() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_BooleanWrapper.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Primitives p1 = new Primitives();
        ksession.insert((Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)results.size());
        Primitives p2 = new Primitives();
        p2.setBooleanWrapper(Boolean.FALSE);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)results.size());
        Primitives p3 = new Primitives();
        p3.setBooleanWrapper(Boolean.TRUE);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testCrossProductRemovingIdentityEquals() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_CrossProductRemovingIdentityEquals.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        List<Object> list2 = new ArrayList();
        session.setGlobal("list1", list1);
        SpecialString first42 = new SpecialString("42");
        SpecialString second43 = new SpecialString("43");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second43);
        session.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)list1.size());
        list2 = Arrays.asList("42:43", "43:42", "World:42", "42:World", "World:43", "43:World");
        Collections.sort(list1);
        Collections.sort(list2);
        MiscTest.assertEquals(list2, list1);
    }

    @Test
    public void testIterateObjects() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_IterateObjects.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.fireAllRules();
        Iterator events = ksession.getObjects((ObjectFilter)new ClassObjectFilter(PersonInterface.class)).iterator();
        MiscTest.assertTrue((boolean)events.hasNext());
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals(results.get(0), events.next());
    }

    @Test
    public void testNotInStatelessSession() throws Exception {
        KieBaseConfiguration kbc = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbc.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        kbc.setOption((KieBaseOption)SequentialOption.YES);
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(kbc, "test_NotInStatelessSession.drl"));
        StatelessKnowledgeSession session = this.createStatelessKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)"not integer");
        MiscTest.assertEquals((Object)"not integer", list.get(0));
    }

    @Test
    public void testDynamicallyAddInitialFactRule() throws Exception {
        String rule = "package org.drools.compiler.test\nglobal java.util.List list\nrule xxx when\n   i:Integer()\nthen\n   list.add(i);\nend";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new Integer(5));
        session.fireAllRules();
        MiscTest.assertEquals((Object)new Integer(5), list.get(0));
        rule = "package org.drools.compiler.test\nglobal java.util.List list\nrule xxx when\nthen\n   list.add(\"x\");\nend";
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackagesFromString(rule);
        kbase.addKnowledgePackages(kpkgs);
        session.fireAllRules();
        MiscTest.assertEquals((Object)"x", list.get(1));
    }

    @Test
    public void testEvalRewriteWithSpecialOperators() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EvalRewriteWithSpecialOperators.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(10, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        Order order2 = new Order(11, "Bob");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order2.addItem(item21);
        order2.addItem(item22);
        Order order3 = new Order(12, "Bob");
        OrderItem item31 = new OrderItem(order3, 1);
        OrderItem item32 = new OrderItem(order3, 2);
        OrderItem item33 = new OrderItem(order3, 3);
        order3.addItem(item31);
        order3.addItem(item32);
        order3.addItem(item33);
        Order order4 = new Order(13, "Bob");
        OrderItem item41 = new OrderItem(order4, 1);
        OrderItem item42 = new OrderItem(order4, 2);
        order4.addItem(item41);
        order4.addItem(item42);
        Order order5 = new Order(14, "Mark");
        OrderItem item51 = new OrderItem(order5, 1);
        OrderItem item52 = new OrderItem(order5, 2);
        order5.addItem(item51);
        order5.addItem(item52);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.insert((Object)order2);
        ksession.insert((Object)item21);
        ksession.insert((Object)item22);
        ksession.insert((Object)order3);
        ksession.insert((Object)item31);
        ksession.insert((Object)item32);
        ksession.insert((Object)item33);
        ksession.insert((Object)order4);
        ksession.insert((Object)item41);
        ksession.insert((Object)item42);
        ksession.insert((Object)order5);
        ksession.insert((Object)item51);
        ksession.insert((Object)item52);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)9L, (long)list.size());
        int index = 0;
        MiscTest.assertEquals((Object)item11, list.get(index++));
        MiscTest.assertEquals((Object)item12, list.get(index++));
        MiscTest.assertEquals((Object)item21, list.get(index++));
        MiscTest.assertEquals((Object)item22, list.get(index++));
        MiscTest.assertEquals((Object)item31, list.get(index++));
        MiscTest.assertEquals((Object)item33, list.get(index++));
        MiscTest.assertEquals((Object)item41, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
        MiscTest.assertEquals((Object)order5, list.get(index++));
    }

    @Test
    public void testImportColision() throws Exception {
        Collection<KnowledgePackage> kpkgs1 = this.loadKnowledgePackages("nested1.drl");
        Collection<KnowledgePackage> kpkgs2 = this.loadKnowledgePackages("nested2.drl");
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(kpkgs1);
        kbase.addKnowledgePackages(kpkgs2);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        ksession.insert((Object)new FirstClass());
        ksession.insert((Object)new SecondClass());
        ksession.insert((Object)new FirstClass.AlternativeKey());
        ksession.insert((Object)new SecondClass.AlternativeKey());
        ksession.fireAllRules();
    }

    @Test
    public void testAutovivificationOfVariableRestrictions() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_AutoVivificationVR.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10, 8));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testShadowProxyOnCollections() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ShadowProxyOnCollections.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheesery cheesery = new Cheesery();
        ksession.insert((Object)cheesery);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((long)1L, (long)cheesery.getCheeses().size());
        MiscTest.assertEquals(results.get(0), cheesery.getCheeses().get(0));
    }

    @Test
    public void testShadowProxyOnCollections2() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ShadowProxyOnCollections2.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ArrayList<String> list = new ArrayList<String>();
        list.add("example1");
        list.add("example2");
        MockPersistentSet mockPersistentSet = new MockPersistentSet(false);
        mockPersistentSet.addAll(list);
        ObjectWithSet objectWithSet = new ObjectWithSet();
        objectWithSet.setSet((Set)mockPersistentSet);
        ksession.insert((Object)objectWithSet);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)"show", (Object)objectWithSet.getMessage());
    }

    @Test
    public void testNestedAccessors() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NestedAccessors.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        Order order2 = new Order(12, "Mark");
        Order.OrderStatus status = new Order.OrderStatus();
        status.setActive(true);
        order2.setStatus(status);
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order1.addItem(item21);
        order1.addItem(item22);
        ksession.insert((Object)order2);
        ksession.insert((Object)item21);
        ksession.insert((Object)item22);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertSame((Object)item21, list.get(0));
        MiscTest.assertSame((Object)item22, list.get(1));
    }

    @Test
    public void testWorkingMemoryLoggerWithUnbalancedBranches() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Logger.drl"));
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        try {
            wm.fireAllRules();
            wm.insert((Object)new Cheese("a", 10));
            wm.insert((Object)new Cheese("b", 11));
            wm.fireAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"No exception should be raised ");
        }
    }

    @Test
    public void testFromNestedAccessors() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_FromNestedAccessors.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertSame((Object)order1.getStatus(), list.get(0));
    }

    @Test
    public void testFromArrayIteration() throws Exception {
        if (CommonTestMethodBase.phreak == RuleEngineOption.RETEOO) {
            return;
        }
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_FromArrayIteration.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new DomainObjectHolder());
        session.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
        MiscTest.assertEquals((Object)"Message3", list.get(0));
        MiscTest.assertEquals((Object)"Message2", list.get(1));
        MiscTest.assertEquals((Object)"Message1", list.get(2));
    }

    @Test
    public void testSubNetworks() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_SubNetworks.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
    }

    @Test
    public void testFinalClass() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_FinalClass.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PersonFinal bob = new PersonFinal();
        bob.setName("bob");
        bob.setStatus(null);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testEvalRewriteMatches() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_EvalRewriteMatches.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(14, "Mark");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(item11));
        MiscTest.assertTrue((boolean)list.contains(item12));
    }

    @Test
    public void testConsequenceBuilderException() throws Exception {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newClassPathResource((String)"test_ConsequenceBuilderException.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testRuntimeTypeCoercion() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_RuntimeTypeCoercion.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PolymorphicFact fact = new PolymorphicFact((Object)new Integer(10));
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)fact.getData(), list.get(0));
        fact.setData((Object)"10");
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)fact.getData(), list.get(1));
        try {
            fact.setData((Object)new Boolean(true));
            ksession.update(handle, (Object)fact);
            MiscTest.assertEquals((long)2L, (long)list.size());
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
    }

    @Test
    public void testRuntimeTypeCoercion2() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_RuntimeTypeCoercion2.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Primitives fact = new Primitives();
        fact.setBooleanPrimitive(true);
        fact.setBooleanWrapper(new Boolean(true));
        fact.setObject((Object)new Boolean(true));
        fact.setCharPrimitive('X');
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        int index = 0;
        MiscTest.assertEquals((String)((Object)list).toString(), (long)4L, (long)list.size());
        MiscTest.assertEquals((Object)"boolean", list.get(index++));
        MiscTest.assertEquals((Object)"boolean wrapper", list.get(index++));
        MiscTest.assertEquals((Object)"boolean object", list.get(index++));
        MiscTest.assertEquals((Object)"char", list.get(index++));
        fact.setBooleanPrimitive(false);
        fact.setBooleanWrapper(null);
        fact.setCharPrimitive('\u0000');
        fact.setObject((Object)new Character('X'));
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)5L, (long)list.size());
        MiscTest.assertEquals((Object)"char object", list.get(index++));
        fact.setObject(null);
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)6L, (long)list.size());
        MiscTest.assertEquals((Object)"null object", list.get(index++));
    }

    @Test
    public void testAlphaEvalWithOrCE() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_AlphaEvalWithOrCE.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        FactA a = new FactA();
        a.setField1("a value");
        ksession.insert((Object)a);
        ksession.insert((Object)new FactB());
        ksession.insert((Object)new FactC());
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"should not have fired", (long)0L, (long)list.size());
    }

    @Test
    public void testModifyRetractAndModifyInsert() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ModifyRetractInsert.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob");
        bob.setStatus("hungry");
        ksession.insert((Object)bob);
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new Cheese());
        ksession.fireAllRules(2);
        MiscTest.assertEquals((String)"should have fired only once", (long)1L, (long)list.size());
    }

    @Test
    public void testAlphaCompositeConstraints() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_AlphaCompositeConstraints.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob", 30);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testModifyBlock() throws Exception {
        this.doModifyTest("test_ModifyBlock.drl");
    }

    @Test
    public void testModifyBlockWithPolymorphism() throws Exception {
        this.doModifyTest("test_ModifyBlockWithPolymorphism.drl");
    }

    private void doModifyTest(String drlResource) throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(drlResource));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob");
        bob.setStatus("hungry");
        Cheese c = new Cheese();
        ksession.insert((Object)bob);
        ksession.insert((Object)c);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)10L, (long)c.getPrice());
        MiscTest.assertEquals((Object)"fine", (Object)bob.getStatus());
    }

    @Test
    public void testModifyBlockWithFrom() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ModifyBlockWithFrom.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob");
        Address addr = new Address("abc");
        bob.addAddress(addr);
        ksession.insert((Object)bob);
        ksession.insert((Object)addr);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"12345", (Object)addr.getZipCode());
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)addr, results.get(0));
    }

    @Test
    public void testJavaModifyBlock() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_JavaModifyBlock.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob", 30);
        bob.setStatus("hungry");
        ksession.insert((Object)bob);
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new Cheese());
        ksession.insert((Object)new OuterClass.InnerClass(1));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        MiscTest.assertEquals((Object)"full", (Object)bob.getStatus());
        MiscTest.assertEquals((long)31L, (long)bob.getAge());
        MiscTest.assertEquals((long)2L, (long)((OuterClass.InnerClass)list.get(1)).getIntAttr());
    }

    @Test
    public void testOrCE() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_OrCE.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new org.drools.compiler.Person("bob"));
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"should have fired once", (long)1L, (long)list.size());
    }

    @Test
    public void testOrWithAndUsingNestedBindings() throws IOException, ClassNotFoundException {
        String str = "";
        str = str + "package org.drools.compiler\n";
        str = str + "import org.drools.compiler.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "global java.util.List jlist\n";
        str = str + "rule rule1 dialect \"mvel\" \n";
        str = str + "when\n";
        str = str + "$a : Person( name == \"a\" )\n";
        str = str + "  (or $b : Person( name == \"b1\" )\n";
        str = str + "      (and $p : Person( name == \"p2\" )\n";
        str = str + "           $b : Person( name == \"b2\" ) )\n";
        str = str + "      (and $p : Person( name == \"p3\" )\n";
        str = str + "           $b : Person( name == \"b3\" ) )\n";
        str = str + "   )\n ";
        str = str + "then\n";
        str = str + "   mlist.add( $b );\n";
        str = str + "end\n";
        str = str + "rule rule2 dialect \"java\" \n";
        str = str + "when\n";
        str = str + "$a : Person( name == \"a\" )\n";
        str = str + "  (or $b : Person( name == \"b1\" )\n";
        str = str + "      (and $p : Person( name == \"p2\" )\n";
        str = str + "           $b : Person( name == \"b2\" ) )\n";
        str = str + "      (and $p : Person( name == \"p3\" )\n";
        str = str + "           $b : Person( name == \"b3\" ) )\n";
        str = str + "   )\n ";
        str = str + "then\n";
        str = str + "   jlist.add( $b );\n";
        str = str + "end\n";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(str));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person a = new org.drools.compiler.Person("a");
        org.drools.compiler.Person b1 = new org.drools.compiler.Person("b1");
        org.drools.compiler.Person p2 = new org.drools.compiler.Person("p2");
        org.drools.compiler.Person b2 = new org.drools.compiler.Person("b2");
        org.drools.compiler.Person p3 = new org.drools.compiler.Person("p3");
        org.drools.compiler.Person b3 = new org.drools.compiler.Person("b3");
        ArrayList mlist = new ArrayList();
        ArrayList jlist = new ArrayList();
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b1);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b1, mlist.get(0));
        MiscTest.assertEquals((Object)b1, jlist.get(0));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b2);
        ksession.insert((Object)p2);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b2, mlist.get(1));
        MiscTest.assertEquals((Object)b2, jlist.get(1));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("mlist", mlist);
        ksession.setGlobal("jlist", jlist);
        ksession.insert((Object)a);
        ksession.insert((Object)b3);
        ksession.insert((Object)p3);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)b3, mlist.get(2));
        MiscTest.assertEquals((Object)b3, jlist.get(2));
    }

    @Test
    public void testFieldBindingOnWrongFieldName() {
        KnowledgeBuilder kbuilder;
        String str = "";
        str = str + "package org.drools.compiler\n";
        str = str + "import org.drools.compiler.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "rule rule1 \n";
        str = str + "when\n";
        str = str + "   Person( $f : invalidFieldName, eval( $f != null ) )\n";
        str = str + "then\n";
        str = str + "end\n";
        try {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
            if (!kbuilder.hasErrors()) {
                MiscTest.fail((String)"KnowledgeBuilder should have errors");
            }
        }
        catch (Exception e) {
            MiscTest.fail((String)"Exception should not be thrown ");
        }
        str = "";
        str = str + "package org.drools.compiler\n";
        str = str + "import org.drools.compiler.Person\n";
        str = str + "global java.util.List mlist\n";
        str = str + "rule rule1 \n";
        str = str + "when\n";
        str = str + "   Person( $f : invalidFieldName, name == ( $f ) )\n";
        str = str + "then\n";
        str = str + "end\n";
        try {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
            if (!kbuilder.hasErrors()) {
                MiscTest.fail((String)"KnowledgeBuilder should have errors");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MiscTest.fail((String)"Exception should not be thrown ");
        }
    }

    @Test
    public void testDeepNestedConstraints() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_DeepNestedConstraints.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new org.drools.compiler.Person("bob", "muzzarela"));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("muzzarela", 80));
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"should have fired twice", (long)2L, (long)list.size());
    }

    @Test
    public void testGetFactHandleEqualityBehavior() throws Exception {
        KieBaseConfiguration kbc = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbc.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase(kbc, new String[0]));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        ksession.insert((Object)cheese);
        FactHandle fh = ksession.getFactHandle((Object)new CheeseEqual("stilton", 10));
        MiscTest.assertNotNull((Object)fh);
    }

    @Test
    public void testGetFactHandleIdentityBehavior() throws Exception {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.IDENTITY);
        RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        ruleBase = (RuleBase)SerializationHelper.serializeObject((Object)ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        CheeseEqual cheese = new CheeseEqual("stilton", 10);
        session.insert((Object)cheese);
        org.drools.core.FactHandle fh1 = session.getFactHandle((Object)new Cheese("stilton", 10));
        MiscTest.assertNull((Object)fh1);
        org.drools.core.FactHandle fh2 = session.getFactHandle((Object)cheese);
        MiscTest.assertNotNull((Object)fh2);
    }

    @Test
    public void testOrCEFollowedByEval() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_OrCEFollowedByEval.drl"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new FactA("X"));
        InternalFactHandle b = (InternalFactHandle)ksession.insert((Object)new FactB("X"));
        ksession.fireAllRules();
        MiscTest.assertEquals((String)"should have fired", (long)2L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains(b.getObject()));
    }

    @Test
    public void testNPEOnMVELAlphaPredicates() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_NPEOnMVELPredicate.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Cheese cheese = new Cheese("stilton", 10);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(cheese);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob", "stilton");
        Cheese cheese2 = new Cheese();
        bob.setCheese(cheese2);
        FactHandle p = session.insert((Object)bob);
        FactHandle c = session.insert((Object)cheesery);
        session.fireAllRules();
        MiscTest.assertEquals((String)"should not have fired", (long)0L, (long)list.size());
        cheese2.setType("stilton");
        session.update(p, (Object)bob);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testModifyWithLockOnActive() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_ModifyWithLockOnActive.drl"));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob", 15);
        org.drools.compiler.Person mark = new org.drools.compiler.Person("Mark", 16);
        org.drools.compiler.Person michael = new org.drools.compiler.Person("Michael", 14);
        session.insert((Object)bob);
        session.insert((Object)mark);
        session.insert((Object)michael);
        session.getAgenda().getAgendaGroup("feeding").setFocus();
        session.fireAllRules(5);
        MiscTest.assertEquals((long)2L, (long)((List)session.getGlobal("results")).size());
    }

    @Test
    public void testNPEOnParenthesis() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_ParenthesisUsage.drl");
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.setGlobal("results", results);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("Bob", 20);
        bob.setAlive(true);
        org.drools.compiler.Person foo = new org.drools.compiler.Person("Foo", 0);
        foo.setAlive(false);
        session.insert((Object)bob);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)bob, results.get(0));
        session.insert((Object)foo);
        session.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)foo, results.get(1));
    }

    @Test
    public void testEvalWithLineBreaks() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EvalWithLineBreaks.drl");
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.setGlobal("results", results);
        session.insert((Object)10);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)10, results.get(0));
    }

    @Test
    public void testDRLWithoutPackageDeclaration() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_NoPackageDeclaration.drl");
        FactType factType = kbase.getFactType("defaultpkg", "Person");
        MiscTest.assertNotNull((Object)factType);
        Object bob = factType.newInstance();
        factType.set(bob, "name", (Object)"Bob");
        factType.set(bob, "age", (Object)30);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        session.insert(bob);
        session.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((Object)bob, results.get(0));
    }

    @Test
    public void testKnowledgeContextJava() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_KnowledgeContextJava.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"Hello World", list.get(0));
    }

    @Test
    public void testListOfMaps() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_TestMapVariableRef.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        HashMap<String, String> mapOne = new HashMap<String, String>();
        HashMap<String, String> mapTwo = new HashMap<String, String>();
        mapOne.put("MSG", "testMessage");
        mapTwo.put("MSGTWO", "testMessage");
        list.add(mapOne);
        list.add(mapTwo);
        ksession.insert(list);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testKnowledgeContextMVEL() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_KnowledgeContextMVEL.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertEquals((Object)"Hello World", list.get(0));
    }

    @Test
    public void testJBRules2055() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_JBRules2055.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)new Cheese("brie"));
        ksession.insert((Object)new Cheese("muzzarella"));
        ksession.insert((Object)new org.drools.compiler.Person("bob", "stilton"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertEquals((Object)"stilton", results.get(0));
        MiscTest.assertEquals((Object)"brie", results.get(1));
    }

    @Test
    public void testJBRules2369() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_JBRules2369.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        FactA a = new FactA();
        FactB b = new FactB(Integer.valueOf(0));
        FactHandle aHandle = ksession.insert((Object)a);
        FactHandle bHandle = ksession.insert((Object)b);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        ksession.update(aHandle, (Object)a);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testInsertionOrder() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_InsertionOrder.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(1, 2));
        ksession.insert((Object)new Move(2, 3));
        Win win2 = new Win(2);
        Win win3 = new Win(3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains(win2));
        MiscTest.assertTrue((boolean)results.contains(win3));
        ksession.dispose();
        ksession = this.createKnowledgeSession(kbase);
        results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Move(2, 3));
        ksession.insert((Object)new Move(1, 2));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains(win2));
        MiscTest.assertTrue((boolean)results.contains(win3));
    }

    @Test
    public void testFireAllWhenFiringUntilHalt() {
        KnowledgeBase kbase = this.getKnowledgeBase();
        final StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Runnable fireUntilHalt = new Runnable(){

            @Override
            public void run() {
                ksession.fireUntilHalt();
            }
        };
        Runnable fireAllRules = new Runnable(){

            @Override
            public void run() {
                ksession.fireAllRules();
            }
        };
        Thread t1 = new Thread(fireUntilHalt);
        Thread t2 = new Thread(fireAllRules);
        t1.start();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        t2.start();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean aliveT2 = t2.isAlive();
        ksession.halt();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        boolean aliveT1 = t1.isAlive();
        if (t2.isAlive()) {
            t2.interrupt();
        }
        if (t1.isAlive()) {
            t1.interrupt();
        }
        MiscTest.assertFalse((String)"T2 should have finished", (boolean)aliveT2);
        MiscTest.assertFalse((String)"T1 should have finished", (boolean)aliveT1);
    }

    @Test
    public void testFireUntilHaltFailingAcrossEntryPoints() throws Exception {
        String rule1 = "package org.drools.compiler\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule testFireUntilHalt\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "       Cheese()\n";
        rule1 = rule1 + "  $p : Person() from entry-point \"testep2\"\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( $p ) ;\n";
        rule1 = rule1 + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule1);
        final StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        EntryPoint ep = ksession.getEntryPoint("testep2");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Cheese("cheddar"));
        ksession.fireAllRules();
        Runnable fireUntilHalt = new Runnable(){

            @Override
            public void run() {
                ksession.fireUntilHalt();
            }
        };
        Thread t1 = new Thread(fireUntilHalt);
        t1.start();
        Thread.currentThread();
        Thread.sleep(500L);
        ep.insert((Object)new org.drools.compiler.Person("darth"));
        Thread.currentThread();
        Thread.sleep(500L);
        ksession.halt();
        t1.join(5000L);
        boolean alive = t1.isAlive();
        if (alive) {
            t1.interrupt();
        }
        MiscTest.assertFalse((String)"Thread should have died!", (boolean)alive);
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNetworkBuildErrorAcrossEntryPointsAndFroms() throws Exception {
        String rule1 = "package org.drools.compiler\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "         Cheese() from entry-point \"testep\"\n";
        rule1 = rule1 + "    $p : Person() from list\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( \"rule1\" ) ;\n";
        rule1 = rule1 + "  insert( $p );\n";
        rule1 = rule1 + "end\n";
        rule1 = rule1 + "rule rule2\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "  $p : Person() \n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "  list.add( \"rule2\" ) ;\n";
        rule1 = rule1 + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule1);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        EntryPoint ep = ksession.getEntryPoint("testep");
        ArrayList<org.drools.compiler.Person> list = new ArrayList<org.drools.compiler.Person>();
        ksession.setGlobal("list", list);
        list.add(new org.drools.compiler.Person("darth"));
        ep.insert((Object)new Cheese("cheddar"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testBindingToMissingField() throws Exception {
        String rule1 = "package org.drools.compiler\n";
        rule1 = rule1 + "rule rule1\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Integer( $i : noSuchField ) \n";
        rule1 = rule1 + "    eval( $i > 0 )\n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        if (!kbuilder.hasErrors()) {
            MiscTest.fail((String)"this should have errors");
        }
    }

    @Test
    public void testJBRules2140() {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_JBRules2140.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)results.size());
        MiscTest.assertTrue((boolean)results.contains("java"));
        MiscTest.assertTrue((boolean)results.contains("mvel"));
    }

    @Test
    public void testGeneratedBeansSerializable() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_GeneratedBeansSerializable.drl");
        FactType cheeseFact = kbase.getFactType("org.drools.generatedbeans", "Cheese");
        MiscTest.assertTrue((String)"Generated beans must be serializable", (boolean)Serializable.class.isAssignableFrom(cheeseFact.getFactClass()));
        Object cheese = cheeseFact.newInstance();
        cheeseFact.set(cheese, "type", (Object)"stilton");
        Object cheese2 = cheeseFact.newInstance();
        cheeseFact.set(cheese2, "type", (Object)"brie");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert(cheese);
        ksession.insert(cheese2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)results.size());
        MiscTest.assertEquals((long)2L, (long)((Number)results.get(0)).intValue());
    }

    @Test
    public void testAddRemoveListeners() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AddRemoveListeners.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wmeListener = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        ksession.addEventListener(wmeListener);
        ksession.insert((Object)new Cheese("stilton"));
        ksession.insert((Object)wmeListener);
        ksession.fireAllRules();
        ksession.insert((Object)new Cheese("brie"));
        ((RuleRuntimeEventListener)Mockito.verify((Object)wmeListener, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
    }

    @Test
    public void testInsert() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.compiler.Person\n";
        drl = drl + "import org.drools.compiler.Pet\n";
        drl = drl + "import java.util.ArrayList\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pets : ArrayList()\n";
        drl = drl + "   from collect( \n";
        drl = drl + "      Pet(\n";
        drl = drl + "         ownerName == $person.name\n";
        drl = drl + "      )\n";
        drl = drl + "   )\n";
        drl = drl + "then\n";
        drl = drl + "  list.add( $person );\n";
        drl = drl + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p = new org.drools.compiler.Person("Toni");
        ksession.insert((Object)p);
        ksession.insert((Object)new Pet("Toni"));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertSame((Object)p, list.get(0));
    }

    @Test
    public void testMemberOfNotWorkingWithOr() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import java.util.ArrayList;\n";
        rule = rule + "import org.drools.compiler.Person;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $list: ArrayList()                                   \n";
        rule = rule + "    ArrayList()                                          \n";
        rule = rule + "            from collect(                                \n";
        rule = rule + "                  Person(                                \n";
        rule = rule + "                      (                                  \n";
        rule = rule + "                          pet memberOf $list             \n";
        rule = rule + "                      ) || (                             \n";
        rule = rule + "                          pet == null                    \n";
        rule = rule + "                      )                                  \n";
        rule = rule + "                  )                                      \n";
        rule = rule + "            )\n";
        rule = rule + "then\n";
        rule = rule + "  System.out.println(\"hello person\");\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person toni = new org.drools.compiler.Person("Toni", 12);
        toni.setPet(new Pet("Mittens"));
        session.insert(new ArrayList());
        session.insert((Object)toni);
        session.fireAllRules();
    }

    @Test
    public void testUnNamed() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import java.util.ArrayList;\n";
        rule = rule + "import org.drools.compiler.Person;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    $list: ArrayList()                                   \n";
        rule = rule + "    ArrayList()                                          \n";
        rule = rule + "            from collect(                                \n";
        rule = rule + "                  Person(                                \n";
        rule = rule + "                      (                                  \n";
        rule = rule + "                          pet memberOf $list             \n";
        rule = rule + "                      ) || (                             \n";
        rule = rule + "                          pet == null                    \n";
        rule = rule + "                      )                                  \n";
        rule = rule + "                  )                                      \n";
        rule = rule + "            )\n";
        rule = rule + "then\n";
        rule = rule + "  System.out.println(\"hello person\");\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person toni = new org.drools.compiler.Person("Toni", 12);
        toni.setPet(new Pet("Mittens"));
        session.insert(new ArrayList());
        session.insert((Object)toni);
        session.fireAllRules();
    }

    @Test
    public void testAccessFieldsFromSubClass() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import org.drools.compiler.Person;\n";
        rule = rule + "import org.drools.compiler.Pet;\n";
        rule = rule + "import org.drools.compiler.Cat;\n";
        rule = rule + "declare Person @typesafe(false) end\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    Person(\n";
        rule = rule + "      pet.breed == \"Siamise\"\n";
        rule = rule + "    )\n";
        rule = rule + "then\n";
        rule = rule + "System.out.println(\"hello person\");\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person person = new org.drools.compiler.Person();
        person.setPet((Pet)new Cat("Mittens"));
        session.insert((Object)person);
        session.fireAllRules();
    }

    @Test
    public void testGenericsInRHS() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import java.util.Map;\n";
        rule = rule + "import java.util.HashMap;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "  then\n";
        rule = rule + "    Map<String,String> map = new HashMap<String,String>();\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        MiscTest.assertNotNull((Object)session);
    }

    @Test
    public void testAccessingMapValues() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import org.drools.compiler.Pet;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "    $pet: Pet()\n";
        rule = rule + "    Pet( \n";
        rule = rule + "      ownerName == $pet.attributes[\"key\"] \n";
        rule = rule + "    )\n";
        rule = rule + "  then\n";
        rule = rule + "    System.out.println(\"hi pet\");\n";
        rule = rule + "end";
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBaseFromString(rule));
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        MiscTest.assertNotNull((Object)session);
        Pet pet1 = new Pet("Toni");
        pet1.getAttributes().put("key", "value");
        Pet pet2 = new Pet("Toni");
        session.insert((Object)pet1);
        session.insert((Object)pet2);
        session.fireAllRules();
    }

    @Test
    public void testClassLoaderHits() throws Exception {
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeansMVEL.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_GeneratedBeans.drl")), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test_NullFieldOnCompositeSink.drl")), ResourceType.DRL);
        MiscTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    public void testMVELConsequenceWithoutSemiColon1() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.compiler.Person\n";
        drl = drl + "import org.drools.compiler.Pet\n";
        drl = drl + "rule test dialect 'mvel'\n";
        drl = drl + "when\n";
        drl = drl + "$person:Person()\n";
        drl = drl + "$pet:Pet()\n";
        drl = drl + "then\n";
        drl = drl + "    retract($person) // some comment\n";
        drl = drl + "    retract($pet) // another comment\n";
        drl = drl + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        ksession.addEventListener(wml);
        FactHandle personFH = ksession.insert((Object)new org.drools.compiler.Person("Toni"));
        FactHandle petFH = ksession.insert((Object)new Pet("Toni"));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)fired);
        ArgumentCaptor retracts = ArgumentCaptor.forClass(ObjectDeletedEvent.class);
        ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectDeleted((ObjectDeletedEvent)retracts.capture());
        List values = retracts.getAllValues();
        MiscTest.assertThat((Object)((ObjectDeletedEvent)values.get(0)).getFactHandle(), (Matcher)CoreMatchers.is((Object)personFH));
        MiscTest.assertThat((Object)((ObjectDeletedEvent)values.get(1)).getFactHandle(), (Matcher)CoreMatchers.is((Object)petFH));
    }

    @Test
    public void testRuleMetaAttributes() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "rule \"test meta attributes\"\n";
        drl = drl + "    @id(1234 ) @author(  john_doe  ) @text(\"It's an escaped\\\" string\"  )\n";
        drl = drl + "when\n";
        drl = drl + "then\n";
        drl = drl + "    // some comment\n";
        drl = drl + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        Rule rule = kbase.getRule("test", "test meta attributes");
        MiscTest.assertNotNull((Object)rule);
        MiscTest.assertThat((Object)((Integer)rule.getMetaData().get("id")), (Matcher)CoreMatchers.is((Object)1234));
        MiscTest.assertThat((Object)((String)rule.getMetaData().get("author")), (Matcher)CoreMatchers.is((Object)"john_doe"));
        MiscTest.assertThat((Object)((String)rule.getMetaData().get("text")), (Matcher)CoreMatchers.is((Object)"It's an escaped\" string"));
    }

    @Test
    public void testMVELConsequenceUsingFactConstructors() throws Exception {
        String drl = "";
        drl = drl + "package test\n";
        drl = drl + "import org.drools.compiler.Person\n";
        drl = drl + "global org.drools.core.runtime.StatefulKnowledgeSession ksession\n";
        drl = drl + "rule test dialect 'mvel'\n";
        drl = drl + "when\n";
        drl = drl + "    $person:Person( name == 'mark' )\n";
        drl = drl + "then\n";
        drl = drl + "    // below constructor for Person does not exist\n";
        drl = drl + "    Person p = new Person( 'bob', 30, 555 )\n";
        drl = drl + "    ksession.update(ksession.getFactHandle($person), new Person('bob', 30, 999, 453, 534, 534, 32))\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testRuleChainingWithLogicalInserts() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_RuleChaining.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        RuleRuntimeEventListener wml = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(wml);
        ksession.addEventListener(ael);
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)3L, (long)fired);
        ArgumentCaptor actvs = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterMatchFired((AfterMatchFiredEvent)actvs.capture());
        List values = actvs.getAllValues();
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)values.get(0)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"init"));
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)values.get(1)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r1"));
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)values.get(2)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r2"));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)Matchers.any(MatchCancelledEvent.class));
        ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
        ((RuleRuntimeEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.never())).objectDeleted((ObjectDeletedEvent)Matchers.any(ObjectDeletedEvent.class));
    }

    @Test
    public void testOrWithReturnValueRestriction() throws Exception {
        String fileName = "test_OrWithReturnValue.drl";
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Cheese("brie", 18));
        ksession.insert((Object)new Cheese("stilton", 8));
        ksession.insert((Object)new Cheese("brie", 28));
        int fired = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)fired);
    }

    @Test
    public void testFromExprFollowedByNot() {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "global java.util.List list;\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "    when\n";
        rule = rule + "        p : Person ($var: pet )\n";
        rule = rule + "        Pet () from $var\n";
        rule = rule + "        not Pet ()\n";
        rule = rule + "    then\n";
        rule = rule + "       list.add( p );\n";
        rule = rule + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p = new org.drools.compiler.Person();
        p.setPet(new Pet());
        ksession.insert((Object)p);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertSame((Object)p, list.get(0));
    }

    @Test
    public void testLastMemoryEntryNotBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x1' ) \n";
        str = str + "    not A( this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x1\"); \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x2' ) \n";
        str = str + "    not A( field1 == $s, this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x2\"); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"x1");
        ksession.insert((Object)"x2");
        A a1 = new A("x1", null);
        A a2 = new A("x2", null);
        org.drools.core.FactHandle fa1 = (org.drools.core.FactHandle)ksession.insert((Object)a1);
        org.drools.core.FactHandle fa2 = (org.drools.core.FactHandle)ksession.insert((Object)a2);
        ksession.update((FactHandle)fa1, (Object)a1);
        ksession.update((FactHandle)fa2, (Object)a2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testLastMemoryEntryExistsBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule x1 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x1' ) \n";
        str = str + "    exists A( this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x1\"); \n";
        str = str + "end  \n";
        str = str + "rule x2 \n";
        str = str + "when \n";
        str = str + "    $s : String( this == 'x2' ) \n";
        str = str + "    exists A( field1 == $s, this != null ) \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired x2\"); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"x1");
        ksession.insert((Object)"x2");
        A a1 = new A("x1", null);
        A a2 = new A("x2", null);
        org.drools.core.FactHandle fa1 = (org.drools.core.FactHandle)ksession.insert((Object)a1);
        org.drools.core.FactHandle fa2 = (org.drools.core.FactHandle)ksession.insert((Object)a2);
        ksession.update((FactHandle)fa1, (Object)a1);
        ksession.update((FactHandle)fa2, (Object)a2);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testNotIterativeModifyBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "when \n";
        str = str + "  $f1 : A() \n";
        str = str + "    not A(this != $f1,  eval(field2 == $f1.getField2())) \n";
        str = str + "    eval( !$f1.getField1().equals(\"1\") ) \n";
        str = str + "then \n";
        str = str + "  list.add($f1); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        A a1 = new A("2", "2");
        A a2 = new A("1", "2");
        A a3 = new A("1", "2");
        org.drools.core.FactHandle fa1 = (org.drools.core.FactHandle)ksession.insert((Object)a1);
        org.drools.core.FactHandle fa2 = (org.drools.core.FactHandle)ksession.insert((Object)a2);
        org.drools.core.FactHandle fa3 = (org.drools.core.FactHandle)ksession.insert((Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        a2.setField2("1");
        ksession.update((FactHandle)fa2, (Object)a2);
        a2.setField2("2");
        ksession.update((FactHandle)fa2, (Object)a2);
        ksession.update((FactHandle)fa3, (Object)a3);
        a3.setField2("1");
        ksession.update((FactHandle)fa3, (Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testModifyWithLiaToEval() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + org.drools.compiler.Person.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "when \n";
        str = str + "    $p : Person() \n";
        str = str + "    eval( $p.getAge() > 30 ) \n";
        str = str + "then \n";
        str = str + "  list.add($p); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("darth", 25);
        FactHandle fh = ksession.insert((Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)list.size());
        p1.setAge(35);
        ksession.update(fh, (Object)p1);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testExistsIterativeModifyBug() {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "import " + A.class.getCanonicalName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "when \n";
        str = str + "  $f1 : A() \n";
        str = str + "    exists A(this != $f1, eval(field2 == $f1.getField2())) \n";
        str = str + "    eval( !$f1.getField1().equals(\"1\") ) \n";
        str = str + "then \n";
        str = str + "  list.add($f1); \n";
        str = str + "end  \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        A a1 = new A("2", "2");
        A a2 = new A("1", "2");
        A a3 = new A("1", "2");
        org.drools.core.FactHandle fa1 = (org.drools.core.FactHandle)ksession.insert((Object)a1);
        org.drools.core.FactHandle fa2 = (org.drools.core.FactHandle)ksession.insert((Object)a2);
        org.drools.core.FactHandle fa3 = (org.drools.core.FactHandle)ksession.insert((Object)a3);
        a1.setField2("1");
        ksession.update((FactHandle)fa1, (Object)a1);
        a1.setField2("2");
        ksession.update((FactHandle)fa1, (Object)a1);
        a2.setField2("1");
        ksession.update((FactHandle)fa2, (Object)a2);
        a2.setField2("2");
        ksession.update((FactHandle)fa2, (Object)a2);
        ksession.update((FactHandle)fa3, (Object)a3);
        a3.setField2("1");
        ksession.update((FactHandle)fa3, (Object)a3);
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testBindingsWithOr() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools.compiler\ndeclare Assignment\n    source : int\n    target : int\nend\nrule ValueIsTheSame1\nwhen\n    Assignment( $t: target == 10 || target == source )\nthen\nend\nrule ValueIsTheSame2\nwhen\n    Assignment( $t: target == source || target == 10 )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType asgType = kbase.getFactType("org.drools.compiler", "Assignment");
        Object asg = asgType.newInstance();
        asgType.set(asg, "source", (Object)10);
        asgType.set(asg, "target", (Object)10);
        ksession.insert(asg);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testMVELClassReferences() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools.compiler\ndeclare Assignment\n    source : Class\n    target : Class\nend\nrule ObjectIsAssignable1\nwhen\n    Assignment( $t: target == java.lang.Object.class || target == source )\nthen\nend\nrule ObjectIsAssignable2\nwhen\n    Assignment( $t: target == source || target == java.lang.Object.class )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        FactType asgType = kbase.getFactType("org.drools.compiler", "Assignment");
        Object asg = asgType.newInstance();
        asgType.set(asg, "source", Object.class);
        asgType.set(asg, "target", Object.class);
        ksession.insert(asg);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testNotMatchesSucceeds() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools.compiler\nrule NotMatches\nwhen\n    Person( name == null || (name != null && name not matches \"-.{2}x.*\" ) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person p = new org.drools.compiler.Person("-..x..xrwx");
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)0L, (long)rules);
    }

    @Test
    public void testNotMatchesFails() throws InstantiationException, IllegalAccessException {
        String str = "package org.drools.compiler\nrule NotMatches\nwhen\n    Person( name == null || (name != null && name not matches \"-.{2}x.*\" ) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person p = new org.drools.compiler.Person("d..x..xrwx");
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testNotEqualsOperator() {
        String str = "package org.drools.compiler\nrule NotEquals\nwhen\n    Primitives( booleanPrimitive != booleanWrapper )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives p = new Primitives();
        p.setBooleanPrimitive(true);
        p.setBooleanWrapper(Boolean.FALSE);
        ksession.insert((Object)p);
        int rules = ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testNotContainsOperator() {
        String str = "package org.drools.compiler\nrule NotContains\nwhen\n    $oi : OrderItem( )\n    $o  : Order( items.values() not contains $oi )then\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Order order1 = new Order(1, "XYZ");
        Order order2 = new Order(2, "ABC");
        OrderItem item11 = new OrderItem(order1, 1);
        order1.addItem(item11);
        OrderItem item21 = new OrderItem(order2, 1);
        order2.addItem(item21);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)rules);
        ksession.insert((Object)item21);
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testOrWithFrom() {
        String str = "package org.drools.compiler\nrule NotContains\nwhen\n    $oi1 : OrderItem( )\n    $o1  : Order(number == 1) from $oi1.order; \n    ( eval(true) or eval(true) )\n    $oi2 : OrderItem( )\n    $o2  : Order(number == 2) from $oi2.order; \nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Order order1 = new Order(1, "XYZ");
        Order order2 = new Order(2, "ABC");
        OrderItem item11 = new OrderItem(order1, 1);
        order1.addItem(item11);
        OrderItem item21 = new OrderItem(order2, 1);
        order2.addItem(item21);
        ksession.insert((Object)order1);
        ksession.insert((Object)order2);
        ksession.insert((Object)item11);
        ksession.insert((Object)item21);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testSoundsLike() {
        String str = "package org.drools.compiler\nrule SoundsLike\nwhen\n    Person( name soundslike \"Bob\" )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new org.drools.compiler.Person("Bob"));
        ksession.insert((Object)new org.drools.compiler.Person("Mark"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testAgendaFilter1() {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameStartsWithAgendaFilter af = new RuleNameStartsWithAgendaFilter("B");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((long)1L, (long)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Bbb"));
    }

    @Test
    public void testAgendaFilter2() {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameEndsWithAgendaFilter af = new RuleNameEndsWithAgendaFilter("a");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((long)1L, (long)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Aaa"));
    }

    @Test
    public void testAgendaFilter3() {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameMatchesAgendaFilter af = new RuleNameMatchesAgendaFilter(".*b.");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((long)1L, (long)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Bbb"));
    }

    @Test
    public void testAgendaFilter4() {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        RuleNameEqualsAgendaFilter af = new RuleNameEqualsAgendaFilter("Aaa");
        int rules = ksession.fireAllRules((AgendaFilter)af);
        MiscTest.assertEquals((long)1L, (long)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        MiscTest.assertThat((Object)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"Aaa"));
    }

    @Test
    public void testRestrictionsWithOr() {
        String str = "package org.drools.compiler\nrule \"test\"\nwhen\n    Cheese( price == (1 + 1) );\n    (or eval(true);\n        eval(true);\n    )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Cheese("Stilton", 2));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testMapModel() {
        String str = "package org.drools.compiler\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> mark = new HashMap<String, String>();
        mark.put("type", "Person");
        mark.put("name", "Mark");
        ksession.insert(mark);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)0L, (long)rules);
        HashMap<String, String> bob = new HashMap<String, String>();
        bob.put("type", "Person");
        bob.put("name", "Bob");
        ksession.insert(bob);
        rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testConstraintExpression() {
        String str = "package org.drools.compiler\nrule \"test\"\nwhen\n    Person( 5*2 > 3 );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new org.drools.compiler.Person("Bob"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testMethodConstraint() {
        String str = "package org.drools.compiler\nrule \"test\"\nwhen\n    Person( isAlive() );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person person = new org.drools.compiler.Person("Bob");
        person.setAlive(true);
        ksession.insert((Object)person);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testComplexOperator() {
        String str = "package org.drools.compiler\nrule \"test in\"\nwhen\n    Person( $name : name in (\"bob\", \"mark\") )\nthen\n    boolean test = $name != null;end\nrule \"test not in\"\nwhen\n    Person( $name : name not in (\"joe\", \"doe\") )\nthen\n    boolean test = $name != null;end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person person = new org.drools.compiler.Person("bob");
        ksession.insert((Object)person);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testEventsInDifferentPackages() {
        String str = "package org.drools.compiler.test\nimport org.drools.compiler.*\ndeclare StockTick\n    @role( event )\nend\nrule r1\nwhen\nthen\n    StockTick st = new StockTick();\n    st.setCompany(\"RHT\");\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testClassTypeAttributes() {
        String str = "package org.drools.compiler\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Primitives());
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    public void testFreeFormExpressions() {
        String str = "package org.drools.compiler\nrule r1\nwhen\n    $p1 : Person( age > 2*10, 10 < age )\n    $p2 : Person( age > 2*$p1.age )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        org.drools.compiler.Person bob = new org.drools.compiler.Person("bob", 30);
        org.drools.compiler.Person mark = new org.drools.compiler.Person("mark", 61);
        ksession.insert((Object)bob);
        ksession.insert((Object)mark);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testFreeFormExpressions2() {
        String str = "package org.drools.compiler\nrule r1\nwhen\n    $p1 : Cell( row == 2 )\n    $p2 : Cell( row == $p1.row + 1, row == ($p1.row + 1), row == 1 + $p1.row, row == (1 + $p1.row) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Cell c1 = new Cell(1, 2, 0);
        Cell c2 = new Cell(1, 3, 0);
        ksession.insert((Object)c1);
        ksession.insert((Object)c2);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testAddMissingResourceToPackageBuilder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        try {
            kbuilder.add(ResourceFactory.newClassPathResource((String)"some.rf"), ResourceType.DRL);
            MiscTest.fail((String)"adding a missing resource should fail");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            kbuilder.add(ResourceFactory.newClassPathResource((String)"some.rf"), ResourceType.DRF);
            MiscTest.fail((String)"adding a missing resource should fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testJBRULES_2995() {
        String str = "package org.drools.compiler\nrule r1\nwhen\n    Primitives( classAttr == java.lang.String.class, \n                eval(classAttr.equals( java.lang.String.class ) ),\n                classAttr == String.class )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives primitives = new Primitives();
        primitives.setClassAttr(String.class);
        ksession.insert((Object)primitives);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testJBRULES2872() {
        String str = "package org.drools.compiler.test\nimport org.drools.compiler.FactA\nrule X\nwhen\n    FactA( enumVal == TestEnum.ONE || == TestEnum.TWO )\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        logger.info(errors.toString());
        MiscTest.assertEquals((long)1L, (long)errors.size());
        KnowledgeBuilderError error = (KnowledgeBuilderError)errors.iterator().next();
        MiscTest.assertEquals((long)5L, (long)error.getLines()[0]);
    }

    @Test
    public void testJBRULES3030() {
        String str = "package org.drools.compiler\nrule X\nwhen\n    $gp : GrandParent()    $ch : ChildHolder( child == $gp )\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertFalse((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testJBRULES3111() {
        String str = "package org.drools.compiler\ndeclare Bool123\n    bool1 : boolean\n    bool2 : boolean\n    bool3 : boolean\nend\ndeclare Thing\n    name : String\n    bool123 : Bool123\nend\nrule kickOff\nwhen\nthen\n    insert( new Thing( \"one\", new Bool123( true, false, false ) ) );\n    insert( new Thing( \"two\", new Bool123( false, false, false ) ) );\n    insert( new Thing( \"three\", new Bool123( false, false, false ) ) );\nend\nrule r1\nwhen\n    $t: Thing( bool123.bool1 == true )\nthen\nend\nrule r2\nwhen\n    $t: Thing( bool123.bool2 == true )\nthen\nend\nrule r3\nwhen\n    $t: Thing( bool123.bool3 == true )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        int rulesFired = ksession.fireAllRules();
        MiscTest.assertEquals((long)2L, (long)rulesFired);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
        List aafe = captor.getAllValues();
        Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(0)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"kickOff"));
        Assert.assertThat((Object)((AfterMatchFiredEvent)aafe.get(1)).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"r1"));
        Object value = ((AfterMatchFiredEvent)aafe.get(1)).getMatch().getDeclarationValue("$t");
        String name = (String)MVEL.eval((String)"$t.name", Collections.singletonMap("$t", value));
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.is((Object)"one"));
    }

    @Test
    public void testBigLiterals() {
        String str = "package org.drools.compiler\nrule X\nwhen\n    Primitives( bigInteger == 10I, bigInteger < (50I), bigDecimal == 10B, bigDecimal < (50B) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Primitives p = new Primitives();
        p.setBigDecimal(BigDecimal.valueOf(10L));
        p.setBigInteger(BigInteger.valueOf(10L));
        ksession.insert((Object)p);
        int rulesFired = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rulesFired);
    }

    @Test
    public void testNonBooleanConstraint() {
        String str = "package org.drools.compiler\nimport java.util.List\nrule \"test\"\nwhen\n    $p1: Person( name + name )\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        logger.info(kbuilder.getErrors().toString());
    }

    @Test
    public void testModifyJava() {
        String str = "package org.drools.compiler\nimport java.util.List\nrule \"test\"\nwhen\n    $l : List() from collect ( Person( alive == false ) );\nthen\n    for(Object p : $l ) {\n        Person p2 = (Person) p;\n        modify(p2) { setAlive(true) }\n    }\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    public void testModifyMVEL() {
        String str = "package org.drools.compiler\nimport java.util.List\nrule \"test\"\n    dialect \"mvel\"\nwhen\n    $l : List() from collect ( Person( alive == false ) );\nthen\n    for(Object p : $l ) {\n        Person p2 = (Person) p;\n        modify(p2) { setAlive(true) }\n    }\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
    }

    @Test
    public void testPackageNameOfTheBeast() throws Exception {
        String ruleFileContent1 = "package org.drools.integrationtests;\nfunction void myFunction() {\n}\ndeclare MyDeclaredType\n  someProperty: boolean\nend";
        String ruleFileContent2 = "package de.something;\nimport org.drools.integrationtests.*;\nrule \"CheckMyDeclaredType\"\n  when\n    MyDeclaredType()\n  then\n    insertLogical(\"THIS-IS-MY-MARKER-STRING\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(ruleFileContent1, ruleFileContent2);
        StatefulKnowledgeSession knowledgeSession = this.createKnowledgeSession(kbase);
        FactType myDeclaredFactType = kbase.getFactType("org.drools.integrationtests", "MyDeclaredType");
        Object myDeclaredFactInstance = myDeclaredFactType.newInstance();
        knowledgeSession.insert(myDeclaredFactInstance);
        int rulesFired = knowledgeSession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rulesFired);
        knowledgeSession.dispose();
    }

    @Test
    public void testGUVNOR578_2() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/primespoc.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        ArrayList<JarInputStream> jarInputStreams = new ArrayList<JarInputStream>();
        jarInputStreams.add(jis);
        Properties properties = new Properties();
        properties.setProperty("drools.defaultPackageName", "foo.bar");
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration(properties, new ClassLoader[]{loader}));
        PackageDescr pc = new PackageDescr("foo.bar");
        builder.addPackage(pc);
        String header = "import fr.gouv.agriculture.dag.agorha.business.primes.SousPeriodePrimeAgent\n";
        builder.addPackageFromDrl((Reader)new StringReader(header));
        MiscTest.assertFalse((boolean)builder.hasErrors());
        String passingRule = "rule \"rule1\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( echelle == \"abc\" )then\nend\n";
        String failingRule = "rule \"rule2\"\ndialect \"mvel\"\nwhen\nSousPeriodePrimeAgent( quotiteRemuneration == 123 , echelle == \"abc\" )then\nend\n";
        builder.addPackageFromDrl((Reader)new StringReader(passingRule));
        if (builder.hasErrors()) {
            logger.warn(builder.getErrors().getErrors()[0].getMessage());
        }
        MiscTest.assertFalse((boolean)builder.hasErrors());
        builder.addPackageFromDrl((Reader)new StringReader(failingRule));
        if (builder.hasErrors()) {
            logger.warn(builder.getErrors().getErrors()[0].getMessage());
        }
        MiscTest.assertFalse((boolean)builder.hasErrors());
    }

    @Test
    public void testJBRULES3323() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package de.orbitx.accumulatetesettest;\n");
        rule.append("import java.util.Set;\n");
        rule.append("import java.util.HashSet;\n");
        rule.append("import org.drools.compiler.Foo;\n");
        rule.append("import org.drools.compiler.Bar;\n");
        rule.append("rule \"Sub optimal foo parallelism - this rule is causing NPE upon reverse\"\n");
        rule.append("when\n");
        rule.append("$foo : Foo($leftId : id, $leftBar : bar != null)\n");
        rule.append("$fooSet : Set()\n");
        rule.append("from accumulate ( Foo(id > $leftId, bar != null && != $leftBar, $bar : bar),\n");
        rule.append("collectSet( $bar ) )\n");
        rule.append("then\n");
        rule.append("//System.out.println(\"ok\");\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        Bar[] barList = new Bar[3];
        for (int i = 0; i < barList.length; ++i) {
            barList[i] = new Bar(String.valueOf(i));
        }
        Foo[] fooList = new Foo[4];
        for (int i = 0; i < fooList.length; ++i) {
            fooList[i] = new Foo(String.valueOf(i), i == 3 ? barList[2] : barList[i]);
        }
        for (Foo foo : fooList) {
            ksession.insert((Object)foo);
        }
        int[] magicFoos = new int[]{3, 3, 1, 1, 0, 0, 2, 2, 1, 1, 0, 0, 3, 3, 2, 2, 3, 1, 1};
        int[] magicBars = new int[]{1, 2, 0, 1, 1, 0, 1, 2, 2, 1, 2, 0, 0, 2, 0, 2, 0, 0, 1};
        for (int i = 0; i < magicFoos.length; ++i) {
            Foo tehFoo = fooList[magicFoos[i]];
            FactHandle fooFactHandle = ksession.getFactHandle((Object)tehFoo);
            tehFoo.setBar(barList[magicBars[i]]);
            ksession.update(fooFactHandle, (Object)tehFoo);
            ksession.fireAllRules();
        }
        ksession.dispose();
    }

    @Test
    public void testJBRULES3326() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message(!!!false)\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
        ksession.dispose();
    }

    @Test
    public void testDispose() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Message()\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
        ksession.dispose();
        try {
            ksession.fireAllRules();
            MiscTest.fail((String)"An IllegallStateException should have been raised as the session was disposed before the method call.");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
    }

    @Test
    public void testInnerEnum() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Triangle( type == Triangle.Type.UNCLASSIFIED )\n");
        rule.append("then\n");
        rule.append("end\n");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Triangle());
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
        ksession.dispose();
    }

    @Test
    public void testNestedAccessors2() throws Exception {
        String rule = "package org.drools.compiler\nrule 'rule1'    salience 10\nwhen\n    Cheesery( typedCheeses[0].type == 'stilton' );\nthen\nend\nrule 'rule2'\nwhen\n    Cheesery( typedCheeses[0].price == 10 );\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheesery c1 = new Cheesery();
        c1.addCheese(new Cheese("stilton", 20));
        Cheesery c2 = new Cheesery();
        c2.addCheese(new Cheese("brie", 10));
        Cheesery c3 = new Cheesery();
        c3.addCheese(new Cheese("muzzarella", 30));
        ksession.insert((Object)c1);
        ksession.insert((Object)c2);
        ksession.insert((Object)c3);
        ksession.fireAllRules();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
        List values = captor.getAllValues();
        MiscTest.assertThat((Object)((Cheesery)((AfterMatchFiredEvent)values.get(0)).getMatch().getObjects().get(0)), (Matcher)CoreMatchers.is((Object)c1));
        MiscTest.assertThat((Object)((Cheesery)((AfterMatchFiredEvent)values.get(1)).getMatch().getObjects().get(0)), (Matcher)CoreMatchers.is((Object)c2));
        ksession.dispose();
    }

    @Test
    public void testMVELConstraintsWithFloatingPointNumbersInScientificNotation() {
        String rule = "package test; \ndialect \"mvel\"\nglobal java.util.List list;\ndeclare Bean \n field : double \nend \n\nrule \"Init\" \nwhen \nthen \n\t insert( new Bean( 1.0E-2 ) ); \nend \n\nrule \"Check\" \nwhen \n\t Bean( field < 1.0E-1 ) \nthen \n\t list.add( \"OK\" ); \nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession kSession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMvelDoubleInvocation() throws Exception {
        String rule = "package org.drools.compiler\nimport " + MiscTest.class.getName() + ".TestUtility;\n" + "import " + MiscTest.class.getName() + ".TestFact;\n" + "rule \"First Rule\"\n" + "    when\n" + "    $tf : TestFact(TestUtility.utilMethod(s, \"Value1\") == true\n" + "             && i > 0\n" + "    )\n" + "    then\n" + "        System.out.println(\"First Rule Fires\");\n" + "end\n" + "\n" + "rule \"Second Rule\"\n" + "    when\n" + "    $tf : TestFact(TestUtility.utilMethod(s, \"Value2\") == true\n" + "             && i > 0\n" + "    )\n" + "    then\n" + "        System.out.println(\"Second Rule Fires\");\n" + "end\n" + "\n" + "rule \"Third Rule\"\n" + "    when\n" + "    $tf : TestFact(TestUtility.utilMethod(s, \"Value3\") == true\n" + "             && i > 0\n" + "    )\n" + "    then\n" + "        System.out.println(\"Third Rule Fires\");\n" + "end ";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestFact fact = new TestFact();
        fact.setS("asdf");
        fact.setI(10);
        ksession.insert((Object)fact);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testUnwantedCoersion() throws Exception {
        String rule = "package org.drools.compiler\nimport " + MiscTest.class.getName() + ".InnerBean;\n" + "import " + MiscTest.class.getName() + ".OuterBean;\n" + "rule \"Test.Code One\"\n" + "when\n" + "   OuterBean($code : inner.code in (\"1.50\", \"2.50\"))\n" + "then\n" + "   System.out.println(\"Code compared values: 1.50, 2.50 - actual code value: \" + $code);\n" + "end\n" + "rule \"Test.Code Two\"\n" + "when\n" + "   OuterBean($code : inner.code in (\"1.5\", \"2.5\"))\n" + "then\n" + "   System.out.println(\"Code compared values: 1.5, 2.5 - actual code value: \" + $code);\n" + "end\n" + "rule \"Big Test ID One\"\n" + "when\n" + "   OuterBean($id : id in (\"3.5\", \"4.5\"))\n" + "then\n" + "   System.out.println(\"ID compared values: 3.5, 4.5 - actual ID value: \" + $id);\n" + "end\n" + "rule \"Big Test ID Two\"\n" + "when\n" + "   OuterBean($id : id in ( \"3.0\", \"4.0\"))\n" + "then\n" + "   System.out.println(\"ID compared values: 3.0, 4.0 - actual ID value: \" + $id);\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        InnerBean innerTest = new InnerBean();
        innerTest.setCode("1.500");
        ksession.insert((Object)innerTest);
        OuterBean outerTest = new OuterBean();
        outerTest.setId("3");
        outerTest.setInner(innerTest);
        ksession.insert((Object)outerTest);
        OuterBean outerTest2 = new OuterBean();
        outerTest2.setId("3.0");
        outerTest2.setInner(innerTest);
        ksession.insert((Object)outerTest2);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testShiftOperator() throws Exception {
        String rule = "dialect \"mvel\"\nrule kickOff\nwhen\nthen\n   insert( Integer.valueOf( 1 ) );\n   insert( Long.valueOf( 1 ) );\n   insert( Integer.valueOf( 65552 ) ); // 0x10010\n   insert( Long.valueOf( 65552 ) );\n   insert( Integer.valueOf( 65568 ) ); // 0x10020\n   insert( Long.valueOf( 65568 ) );\n   insert( Integer.valueOf( 65536 ) ); // 0x10000\n   insert( Long.valueOf( 65536L ) );\n   insert( Long.valueOf( 4294967296L ) ); // 0x100000000L\nend\nrule test1\n   salience -1\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test1 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test2\n   salience -2\nwhen\n   $a: Integer( $one: intValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test2 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test3\n   salience -3\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Long ( $shift: longValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test3 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend\nrule test4\n   salience -4\nwhen\n   $a: Long ( $one: longValue == 1 )\n   $b: Integer( $shift: intValue )\n   $c: Integer( $i: intValue, intValue == ($one << $shift ) )\nthen\n   System.out.println( \"test4 \" + $a + \" << \" + $b + \" = \" + Integer.toHexString( $c ) );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)13L, (long)rules);
    }

    @Test
    public void testRecursiveDeclaration() throws Exception {
        String rule = "package org.drools.compiler\ndeclare Node\n    value: String\n    parent: Node\nend\nrule R1 when\n   $parent: Node( value == \"parent\" )\n   $child: Node( $value : value, parent == $parent )\nthen\n   System.out.println( $value );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType nodeType = kbase.getFactType("org.drools.compiler", "Node");
        Object parent = nodeType.newInstance();
        nodeType.set(parent, "value", (Object)"parent");
        ksession.insert(parent);
        Object child = nodeType.newInstance();
        nodeType.set(child, "value", (Object)"child");
        nodeType.set(child, "parent", parent);
        ksession.insert(child);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testCircularDeclaration() throws Exception {
        String rule = "package org.drools.compiler.test\ndeclare FactA\n    fieldB: FactB\nend\ndeclare FactB\n    fieldA: FactA\nend\nrule R1 when\n   $fieldA : FactA( $fieldB : fieldB )\n   FactB( this == $fieldB, fieldA == $fieldA )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType aType = kbase.getFactType("org.drools.compiler.test", "FactA");
        Object a = aType.newInstance();
        FactType bType = kbase.getFactType("org.drools.compiler.test", "FactB");
        Object b = bType.newInstance();
        aType.set(a, "fieldB", b);
        bType.set(b, "fieldA", a);
        ksession.insert(a);
        ksession.insert(b);
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testPatternMatchingOnThis() throws Exception {
        String rule = "package org.drools.compiler\nrule R1 when\n    $i1: Integer()\n    $i2: Integer( this > $i1 )\nthen\n   System.out.println( $i2 + \" > \" + $i1 );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Integer(1));
        ksession.insert((Object)new Integer(2));
        int rules = ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testArrayUsage() {
        String str = "import org.drools.compiler.TestParam;\n\nglobal java.util.List list;\n\nrule \"Intercept\"\nwhen\n    TestParam( value1 == \"extract\", $args : elements )\n    $s : String( this == $args[$s.length() - $s.length()] )\n    $s1 : String( this == $args[0] )\n    $s2 : String( this == $args[1] )\n    Integer( this == 2 ) from $args.length\n    $s3 : String( this == $args[$args.length - $args.length  + 1] )\nthen\n    retract( $s1 );  \n    retract( $s2 );  \n    list.add( $s1 ); \n    list.add( $s2 ); \nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        int N = 2;
        for (int j = 0; j < N; ++j) {
            TestParam o = new TestParam();
            o.setValue1("extract");
            o.setElements(new Object[]{"x1_" + j, "x2_" + j});
            ksession.insert((Object)("x1_" + j));
            ksession.insert((Object)("x2_" + j));
            ksession.insert((Object)o);
            ksession.fireAllRules();
        }
        MiscTest.assertEquals((long)4L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains("x1_0"));
        MiscTest.assertTrue((boolean)list.contains("x1_1"));
        MiscTest.assertTrue((boolean)list.contains("x2_0"));
        MiscTest.assertTrue((boolean)list.contains("x2_1"));
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testEfficientBetaNodeNetworkUpdate() {
        String str = "declare SimpleMembership\n    listId : String\n    patientId : String\nend\ndeclare SimplePatientFact\n    value : int\n    patientId : String\nend\nrule \"A\"\nwhen\n$slm : SimpleMembership($pid : patientId, listId == \"5072\" )\nand not (\n    (\n        (\n            SimplePatientFact(value == 1, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 2, patientId == $pid)\n        )\n    ) and (\n        (\n            SimplePatientFact(value == 6, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 7, patientId == $pid)\n        ) or (\n            SimplePatientFact(value == 8, patientId == $pid)\n        )\n    ) and (\n       (\n           SimplePatientFact(value == 9, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 10, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 11, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 12, patientId == $pid)\n       ) or (\n           SimplePatientFact(value == 13, patientId == $pid)\n       )\n   )\n)\nthen\n   System.out.println(\"activated\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
    }

    @Test
    public void testModifyCommand() {
        String str = "rule \"sample rule\"\n   when\n   then\n       System.out.println(\"\\\"Hello world!\\\"\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p1 = new org.drools.compiler.Person("John", "nobody", 25);
        ksession.execute(CommandFactory.newInsert((Object)p1));
        FactHandle fh = ksession.getFactHandle((Object)p1);
        org.drools.compiler.Person p = new org.drools.compiler.Person("Frank", "nobody", 30);
        ArrayList<Setter> setterList = new ArrayList<Setter>();
        setterList.add(CommandFactory.newSetter((String)"age", (String)String.valueOf(p.getAge())));
        setterList.add(CommandFactory.newSetter((String)"name", (String)p.getName()));
        setterList.add(CommandFactory.newSetter((String)"likes", (String)p.getLikes()));
        ksession.execute(CommandFactory.newModify((FactHandle)fh, setterList));
    }

    @Test
    public void testMVELTypeCoercion() {
        String str = "package org.drools.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  field : java.util.ArrayList\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( new java.util.ArrayList( java.util.Arrays.asList( \"x\" ) ) ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field == [\"x\"] )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MiscTest.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbConf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("OK"));
        ksession.dispose();
    }

    @Test
    public void testPatternOnClass() throws Exception {
        String rule = "import org.drools.core.reteoo.InitialFactImpl\nimport org.drools.compiler.FactB\nrule \"Clear\" when\n   $f: Object(class != FactB.class)\nthen\n   if( ! ($f instanceof InitialFactImpl) ){\n     retract( $f );\n   }\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new FactA());
        ksession.insert((Object)new FactA());
        ksession.insert((Object)new FactB());
        ksession.insert((Object)new FactB());
        ksession.insert((Object)new FactC());
        ksession.insert((Object)new FactC());
        ksession.fireAllRules();
        for (FactHandle fact : ksession.getFactHandles()) {
            InternalFactHandle internalFact = (InternalFactHandle)fact;
            MiscTest.assertTrue((boolean)(internalFact.getObject() instanceof FactB));
        }
    }

    @Test
    public void testPatternOffset() throws Exception {
        String str = "package org.drools.compiler.test; \ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) or ( A( ) and B( ) ) ) and (\n   A( ) or ( B( $bField : field ) and C( field != $bField ) )\n)\nthen\n    System.out.println(\"rule fired\");\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType typeA = kbase.getFactType("org.drools.compiler.test", "A");
        FactType typeB = kbase.getFactType("org.drools.compiler.test", "B");
        FactType typeC = kbase.getFactType("org.drools.compiler.test", "C");
        Object a = typeA.newInstance();
        ksession.insert(a);
        Object b = typeB.newInstance();
        typeB.set(b, "field", (Object)1);
        ksession.insert(b);
        Object c = typeC.newInstance();
        typeC.set(c, "field", (Object)1);
        ksession.insert(c);
        ksession.fireAllRules();
    }

    @Test
    public void testCommentDelimiterInString() throws Exception {
        String str = "rule x\ndialect \"mvel\"\nwhen\nthen\nSystem.out.println( \"/*\" );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
    }

    @Test
    public void testCovariance() throws Exception {
        String str = "import " + MiscTest.class.getName() + ".*\n" + "rule x\n" + "when\n" + "   $b : ClassB( )\n" + "   $a : ClassA( b.id == $b.id )\n" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ClassA a = new ClassA();
        ClassB b = new ClassB();
        a.setB(b);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testRetractLeftTuple() throws Exception {
        String str = "import " + MiscTest.class.getName() + ".*\n" + "rule R1 salience 3\n" + "when\n" + "   $b : InterfaceB( )\n" + "   $a : ClassA( b == null )\n" + "then\n" + "   $a.setB( $b );\n" + "   update( $a );\n" + "end\n" + "rule R2 salience 2\n" + "when\n" + "   $b : ClassB( id == \"123\" )\n" + "   $a : ClassA( b != null && b.id == $b.id )\n" + "then\n" + "   $b.setId( \"456\" );\n" + "   update( $b );\n" + "end\n" + "rule R3 salience 1\n" + "when\n" + "   InterfaceA( $b : b )\n" + "then\n" + "   retract( $b );\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new ClassA());
        ksession.insert((Object)new ClassB());
        MiscTest.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testVariableBindingWithOR() throws Exception {
        String str1 = "package org.drools.compiler.test; \ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $bField : field ) or C( $cField : field ) ) )\nthen\n    System.out.println($bField);\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str1.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        String str2 = "package org.drools.compiler.test; \ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $field : field ) or C( $field : field ) ) )\nthen\n    System.out.println($field);\nend\n";
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add(ResourceFactory.newByteArrayResource((byte[])str2.getBytes()), ResourceType.DRL);
        MiscTest.assertFalse((boolean)kbuilder2.hasErrors());
    }

    @Test
    public void testModifySimple() {
        String str = "package org.drools.compiler;\n\nrule \"test modify block\"\nwhen\n    $p: Person( name == \"hungry\" )\nthen\n    modify( $p ) { setName(\"fine\") }\nend\n\nrule \"Log\"\nwhen\n    $o: Object()\nthen\n    System.out.println( $o );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person();
        p.setName("hungry");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testDeclaresWithArrayFields() throws Exception {
        String rule = "package org.drools.compiler.test; \nimport " + Person.class.getName() + ";\n" + "import " + Man.class.getName() + ";\n" + "\n" + "global java.util.List list;" + "\n" + "declare Cheese\n" + "   name : String = \"ched\" \n" + "end \n" + "" + "declare X\n" + "    fld \t: String   = \"xx\"                                      @key \n" + "    achz\t: Cheese[] \n" + "    astr\t: String[] " + " = new String[] {\"x\", \"y11\" } \n" + "    aint\t: int[] \n" + "    sint\t: short[] \n" + "    bint\t: byte[] \n" + "    lint\t: long[] \n" + "    dint\t: double[] \n" + "    fint\t: float[] \n" + "    zint\t: Integer[] " + " = new Integer[] {2,3}                   @key \n" + "    aaaa\t: String[][] \n" + "    bbbb\t: int[][] \n" + "    aprs\t: Person[] " + " = new Person[] { new Man() } \n" + "end\n" + "\n" + "rule \"Init\"\n" + "when\n" + "\n" + "then\n" + "    X x = new X( \"xx\", \n" + "                 new Cheese[0], \n" + "                 new String[] { \"x\", \"y22\" }, \n" + "                 new int[] { 7, 9 }, \n" + "                 new short[] { 3, 4 }, \n" + "                 new byte[] { 1, 2 }, \n" + "                 new long[] { 100L, 200L }, \n" + "                 new double[] { 3.2, 4.4 }, \n" + "                 new float[] { 3.2f, 4.4f }, \n" + "                 new Integer[] { 2, 3 }, \n" + "                 new String[2][3], \n" + "                 new int[5][3], \n" + "                 null \n" + "    ); \n" + "   insert( x );\n" + "   " + "   X x2 = new X(); \n" + "   x2.setAint( new int[2] ); \n " + "   x2.getAint()[0] = 7; \n" + "   insert( x2 );\n" + "   " + "   if ( x.hashCode() == x2.hashCode() ) list.add( \"hash\" );  \n" + "   " + "   if( x.equals( x2 ) ) list.add( \"equals\" );  \n" + "   " + "   list.add( x.getAint(  )[0] );  \n" + "end \n" + "\n" + "rule \"Check\"\n" + "when\n" + "    X( astr.length > 0,            \n" + "       astr[0] == \"x\",           \n" + "       $x : astr[1],               \n" + "       aint[0] == 7  )             \n" + "then\n" + "    list.add( $x );\n" + "end \n" + "";
        System.out.println(rule);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("hash"));
        MiscTest.assertTrue((boolean)list.contains("equals"));
        MiscTest.assertTrue((boolean)list.contains(7));
        MiscTest.assertTrue((boolean)list.contains("y11"));
        MiscTest.assertTrue((boolean)list.contains("y22"));
    }

    @Test
    public void testTypeUnsafe() throws Exception {
        String str = "import " + MiscTest.class.getName() + ".*\n" + "declare\n" + "   Parent @typesafe(false)\n" + "end\n" + "rule R1\n" + "when\n" + "   $a : Parent( x == 1 )\n" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        for (int i = 0; i < 20; ++i) {
            ksession.insert((Object)new ChildA(i % 10));
            ksession.insert((Object)new ChildB(i % 10));
        }
        MiscTest.assertEquals((long)4L, (long)ksession.fireAllRules());
        Thread.sleep(100L);
        ksession.insert((Object)new ChildA(1));
        ksession.insert((Object)new ChildB(1));
        MiscTest.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testConstructorWithOtherDefaults() {
        String str = "\nglobal java.util.List list;\n\ndeclare Bean\n   kField : String     @key\n   sField : String     = \"a\"\n   iField : int        = 10\n   dField : double     = 4.32\n   aField : Long[]     = new Long[] { 100L, 1000L }\nend\nrule \"Trig\"\nwhen\n    Bean( kField == \"key\", sField == \"a\", iField == 10, dField == 4.32, aField[1] == 1000L ) \nthen\n    list.add( \"OK\" );\nend\n\nrule \"Exec\"\nwhen\nthen\n    insert( new Bean( \"key\") ); \nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("OK"));
        ksession.dispose();
    }

    @Test
    public void testBindingToNullFieldWithEquality() {
        String str = "package org.drools.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  id    : String @key\n  field : String\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( \"x\" ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend";
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbConf, str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains("OK"));
        ksession.dispose();
    }

    @Test
    public void testCoercionOfStringValueWithoutQuotes() throws Exception {
        String str = "package org.drools.compiler.test; \ndeclare A\n   field : String\nend\nrule R when\n   A( field == 12 )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactType typeA = kbase.getFactType("org.drools.compiler.test", "A");
        Object a = typeA.newInstance();
        typeA.set(a, "field", (Object)"12");
        ksession.insert(a);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testVarargConstraint() throws Exception {
        String str = "package org.drools.compiler.test;\nimport " + MiscTest.class.getName() + ".VarargBean;\n" + " global java.util.List list;\n" + "\n" + "rule R1 when\n" + "   VarargBean( isOddArgsNr(1, 2, 3) )\n" + "then\n" + "   list.add(\"odd\");\n" + "end\n" + "rule R2 when\n" + "   VarargBean( isOddArgsNr(1, 2, 3, 4) )\n" + "then\n" + "   list.add(\"even\");\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new VarargBean());
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertTrue((boolean)list.contains("odd"));
    }

    @Test
    public void testPackageImportWithMvelDialect() throws Exception {
        String str = "package org.drools.compiler.test;\nimport org.drools.compiler.*\ndialect \"mvel\"\nrule R1 no-loop when\n   $p : Person( )   $c : Cheese( )then\n   modify($p) { setCheese($c) };\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person("Mario", 38);
        ksession.insert((Object)p);
        Cheese c = new Cheese("Gorgonzola");
        ksession.insert((Object)c);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        MiscTest.assertSame((Object)c, (Object)p.getCheese());
    }

    @Test
    public void testNoMvelSyntaxInFunctions() throws Exception {
        String str = "import java.util.*;\ndialect \"mvel\"\nfunction Integer englishToInt(String englishNumber) { \n   Map m = [\"one\":1, \"two\":2, \"three\":3, \"four\":4, \"five\":5]; \n   Object obj = m.get(englishNumber.toLowerCase()); \n   return Integer.parseInt(obj.toString()); \n}\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testMissingClosingBraceOnModify() throws Exception {
        String str = "package org.drools.compiler.test;\nimport org.drools.compiler.*\nrule R1 when\n   $p : Person( )   $c : Cheese( )then\n   modify($p) { setCheese($c) ;\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testPrimitiveToBoxedCoercionInMethodArgument() throws Exception {
        String str = "package org.drools.compiler.test;\nimport " + MiscTest.class.getName() + "\n" + "import org.drools.compiler.*\n" + "rule R1 when\n" + "   Person( $ag1 : age )" + "   $p2 : Person( name == MiscTest.integer2String($ag1) )" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person("42", 42);
        ksession.insert((Object)p);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    public static String integer2String(Integer value) {
        return "" + value;
    }

    @Test
    public void testKeyedInterfaceField() {
        String str = "package org.drools.compiler.integrationtest; \n\nimport " + MiscTest.class.getName() + ".*; \n" + "" + "global java.util.List list;" + "" + "declare Bean\n" + "  id    : InterfaceB @key\n" + "end\n" + "\n" + "\n" + "rule \"Init\"\n" + "when  \n" + "then\n" + "  insert( new Bean( new ClassB() ) );\n" + "end\n" + "\n" + "rule \"Check\"\n" + "when\n" + "  $b : Bean( )\n" + "then\n" + "  list.add( $b.hashCode() ); \n" + "  list.add( $b.equals( new Bean( new ClassB() ) ) ); \n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MiscTest.assertTrue((boolean)list.contains(154));
        MiscTest.assertTrue((boolean)list.contains(true));
        ksession.dispose();
    }

    @Test
    public void testDeclaredTypeAsFieldForAnotherDeclaredType() {
        String str = "package com.sample\n\nimport com.sample.*;\n\ndeclare Item\n        id : int;\nend\n\ndeclare Priority\n        name : String;\n        priority : int;\nend\n\ndeclare Cap\n        item : Item;\n        name : String\nend\n\nrule \"split cart into items\"\nwhen\nthen\n        insert(new Item(1));\n        insert(new Item(2));\n        insert(new Item(3));\nend\n\nrule \"Priorities\"\nwhen\nthen\n        insert(new Priority(\"A\", 3));\n        insert(new Priority(\"B\", 2));\n        insert(new Priority(\"C\", 5));\nend\n\nrule \"Caps\"\nwhen\n        $i : Item()\n        $p : Priority($name : name)\nthen\n        insert(new Cap($i, $name));\nend\n\nrule \"test\"\nwhen\n        $i : Item()\n        Cap(item.id == $i.id)\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        MiscTest.assertEquals((long)20L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testCheckDuplicateVariables() throws Exception {
        String str = "package com.sample\nimport org.drools.compiler.*\nrule R1 when\n   Person( $a: age, $a: name ) // this should cause a compile-time error\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        str = "package com.sample\nrule R1 when\n   accumulate( Object(), $c: count(1), $c: max(1) ) // this should cause a compile-time error\nthen\nend";
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
        str = "package com.sample\nrule R1 when\n   Number($i: intValue) from accumulate( Object(), $i: count(1) ) // this should cause a compile-time error\nthen\nend";
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testDeclaredTypesDefaultHashCode() {
        String str = "package com.sample\n\nglobal java.util.List list; \ndeclare Bean\n id : int \nend\n\ndeclare KeyedBean\n id : int @key \nend\n\n\nrule Create\nwhen\nthen\n list.add( new Bean(1) ); \n list.add( new Bean(2) ); \n list.add( new KeyedBean(1) ); \n list.add( new KeyedBean(1) ); \nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertFalse((list.get(0).hashCode() == 34 ? 1 : 0) != 0);
        MiscTest.assertFalse((list.get(1).hashCode() == 34 ? 1 : 0) != 0);
        MiscTest.assertFalse((list.get(0).hashCode() == list.get(1).hashCode() ? 1 : 0) != 0);
        MiscTest.assertNotSame(list.get(0), list.get(1));
        MiscTest.assertFalse((boolean)list.get(0).equals(list.get(1)));
        MiscTest.assertTrue((list.get(2).hashCode() == 32 ? 1 : 0) != 0);
        MiscTest.assertTrue((list.get(3).hashCode() == 32 ? 1 : 0) != 0);
        MiscTest.assertNotSame(list.get(2), list.get(3));
        MiscTest.assertTrue((boolean)list.get(2).equals(list.get(3)));
    }

    @Test
    public void testJittingConstraintWithInvocationOnLiteral() {
        String str = "package com.sample\nimport org.drools.compiler.Person\nrule XXX when\n  Person( name.toString().toLowerCase().contains( \"mark\".toString().toLowerCase() ) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person("mark", 37));
        ksession.insert((Object)new org.drools.compiler.Person("mario", 38));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testJittingMethodWithCharSequenceArg() {
        String str = "package com.sample\nimport org.drools.compiler.Person\nrule XXX when\n  Person( $n : name, $n.contains( \"mark\" ) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person("mark", 37));
        ksession.insert((Object)new org.drools.compiler.Person("mario", 38));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testMapAccessorWithPrimitiveKey() {
        String str = "package com.sample\nimport " + MiscTest.class.getName() + ".MapContainerBean\n" + "rule R1 when\n" + "  MapContainerBean( map[1] == \"one\" )\n" + "then\n" + "end\n" + "rule R2 when\n" + "  MapContainerBean( map[1+1] == \"two\" )\n" + "then\n" + "end\n" + "rule R3 when\n" + "  MapContainerBean( map[this.get3()] == \"three\" )\n" + "then\n" + "end\n" + "rule R4 when\n" + "  MapContainerBean( map[4] == null )\n" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new MapContainerBean());
        MiscTest.assertEquals((long)4L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testFromWithStrictModeOff() {
        String str = "import java.util.Map;\ndialect \"mvel\"\nrule \"LowerCaseFrom\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\n   $lowerValue : String() from $valOne.toLowerCase()\nthen\n   System.out.println( $valOne.toLowerCase() );\nend\n";
        PackageBuilderConfiguration pkgBuilderCfg = new PackageBuilderConfiguration();
        MVELDialectConfiguration mvelConf = (MVELDialectConfiguration)pkgBuilderCfg.getDialectConfiguration("mvel");
        mvelConf.setStrict(false);
        mvelConf.setLangLevel(5);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString((KnowledgeBuilderConfiguration)pkgBuilderCfg, str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        HashMap<String, String> testMap = new HashMap<String, String>();
        testMap.put("keyOne", "valone");
        testMap.put("valTwo", "valTwo");
        ksession.insert(testMap);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testFromWithStrictModeOn() {
        String str = "import java.util.Map;\ndialect \"mvel\"\nrule \"LowerCaseFrom\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\n   $lowerValue : String() from $valOne.toLowerCase()\nthen\n   System.out.println( $valOne.toLowerCase() );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testEntryPointWithVarIN() {
        String str = "package org.drools.compiler.test;\n\nglobal java.util.List list;\n\nrule \"In\"\nwhen\n   $x : Integer()\n then\n   drools.getEntryPoint(\"inX\").insert( $x );\nend\n\nrule \"Out\"\nwhen\n   $i : Integer() from entry-point \"inX\"\nthen\n   list.add( $i );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)10);
        ArrayList res = new ArrayList();
        ksession.setGlobal("list", res);
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertTrue((boolean)res.contains(10));
    }

    @Test
    public void testArithmeticExpressionWithNull() {
        String str = "import " + MiscTest.class.getName() + ".PrimitiveBean;\n" + "rule R when\n" + "   PrimitiveBean(primitive/typed > 0.7)\n" + "then\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new PrimitiveBean(0.9, 1.1));
        ksession.insert((Object)new PrimitiveBean(0.9, null));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    public void testMvelMatches() {
        String str = "package com.sample\nimport org.drools.compiler.Person\nglobal java.util.List results;rule XXX when\n  Person( $n : name ~= \"\\\\D.*\" )\nthen\n  results.add( $n ); \n end \nrule YY when\n  Person( $a : age, $n : name ~= \"\\\\d\\\\D.*\" )\nthen\n  results.add( $a ); \n end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList res = new ArrayList();
        ksession.setGlobal("results", res);
        ksession.insert((Object)new org.drools.compiler.Person("mark", 37));
        ksession.insert((Object)new org.drools.compiler.Person("mario", 38));
        ksession.insert((Object)new org.drools.compiler.Person("1mike", 44));
        ksession.insert((Object)new org.drools.compiler.Person("52matt", 44));
        ksession.fireAllRules();
        ksession.dispose();
        MiscTest.assertEquals((long)3L, (long)res.size());
        MiscTest.assertTrue((boolean)res.contains("mark"));
        MiscTest.assertTrue((boolean)res.contains("mario"));
        MiscTest.assertTrue((boolean)res.contains(44));
    }

    @Test
    public void testRuleFlowGroupWithLockOnActivate() {
        String str = "import org.drools.compiler.Person;\nimport org.drools.compiler.Cheese;\nrule R1\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person()\nthen\n   $p.setName(\"John\");\n   update ($p);\nend\nrule R2\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person( name == null )\n   forall ( Cheese ( type == \"cheddar\" ))\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person());
        ksession.insert((Object)new Cheese("gorgonzola"));
        ((AgendaImpl)ksession.getAgenda()).activateRuleFlowGroup("group1");
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInstanceof() throws Exception {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   Person( address instanceof LongAddress )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person mark = new org.drools.compiler.Person("mark");
        mark.setAddress((Address)new LongAddress("uk"));
        ksession.insert((Object)mark);
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testFromNodeWithMultipleBetas() throws Exception {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $p : Person( $name : name, $addresses : addresses )\n   $c : Cheese( $type: type == $name )\n   $a : Address( street == $type, suburb == $name ) from $addresses\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person("x");
        p.addAddress(new Address("x", "x", "x"));
        p.addAddress(new Address("y", "y", "y"));
        ksession.insert((Object)p);
        ksession.insert((Object)new Cheese("x"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testMvelFunctionWithDeclaredTypeArg() {
        String rule = "package test; \ndialect \"mvel\"\nglobal java.lang.StringBuilder value;\nfunction String getFieldValue(Bean bean) {   return bean.getField();}declare Bean \n   field : String \nend \n\nrule R1 \nwhen \nthen \n   insert( new Bean( \"mario\" ) ); \nend \n\nrule R2 \nwhen \n   $bean : Bean( ) \nthen \n   value.append( getFieldValue($bean) ); \nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        StringBuilder sb = new StringBuilder();
        ksession.setGlobal("value", (Object)sb);
        ksession.fireAllRules();
        MiscTest.assertEquals((Object)"mario", (Object)sb.toString());
        ksession.dispose();
    }

    @Test
    public void testMvelFunctionWithDeclaredTypeArgForGuvnor() throws Exception {
        String function = "function String getFieldValue(Bean bean) { return bean.getField();}\n";
        String declaredFactType = "declare Bean \n field : String \nend \n";
        String rule = "rule R2 \ndialect 'mvel'\nwhen \n $bean : Bean( ) \nthen \n System.out.println( getFieldValue($bean) ); \nend\n";
        PackageBuilder packageBuilder = new PackageBuilder();
        packageBuilder.addPackageFromDrl((Reader)new StringReader(declaredFactType));
        packageBuilder.addPackageFromDrl((Reader)new StringReader(function));
        packageBuilder.addPackageFromDrl((Reader)new StringReader(rule));
        for (KnowledgeBuilderError error : packageBuilder.getErrors()) {
            System.out.println("ERROR:");
            System.out.println(error.getMessage());
        }
        MiscTest.assertFalse((boolean)packageBuilder.hasErrors());
    }

    public void testGenericsList() throws Exception {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addresses.get(0).street == $type )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person("x");
        p.addAddress(new Address("x", "x", "x"));
        p.addAddress(new Address("y", "y", "y"));
        ksession.insert((Object)p);
        ksession.insert((Object)new Cheese("x"));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testGenericsOption() throws Exception {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addressOption.get.street == $type )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.drools.compiler.Person p = new org.drools.compiler.Person("x");
        p.setAddress(new Address("x", "x", "x"));
        ksession.insert((Object)p);
        ksession.insert((Object)new Cheese("x"));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testRHSClone() {
        String str = "import java.util.Map;\ndialect \"mvel\"\nrule \"RHSClone\"\nwhen\n   Map($valOne : this['keyOne'] !=null)\nthen\n   System.out.println( $valOne.clone() );\nend\n";
        PackageBuilderConfiguration pkgBuilderCfg = new PackageBuilderConfiguration();
        MVELDialectConfiguration mvelConf = (MVELDialectConfiguration)pkgBuilderCfg.getDialectConfiguration("mvel");
        mvelConf.setStrict(false);
        mvelConf.setLangLevel(5);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pkgBuilderCfg);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            MiscTest.fail((String)"Could not parse knowledge");
        }
    }

    @Test
    public void testDeclaredTypeWithHundredsProps() {
        StringBuilder sb = new StringBuilder("declare MyType\n");
        for (int i = 0; i < 300; ++i) {
            sb.append("i" + i + " : int\n");
        }
        sb.append("end");
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(sb.toString());
    }

    @Test
    public void testAddRuleWithFrom() {
        String str1 = "global java.util.List names;\nglobal java.util.List list;\n";
        String str2 = "import org.drools.compiler.*;\nglobal java.util.List names;\nglobal java.util.List list;\nrule R1 when\n   $p : Person( )\n   String( this == $p.name ) from names\nthen\n list.add( $p );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str1);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Mark");
        ksession.setGlobal("names", names);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        org.drools.compiler.Person p = new org.drools.compiler.Person("Mark");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(str2));
        ksession.fireAllRules();
        MiscTest.assertEquals((long)1L, (long)list.size());
        MiscTest.assertSame((Object)p, list.get(0));
        ksession.dispose();
    }

    @Test
    public void testConstantLeft() {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $p : Person( \"Mark\" == name )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person(null));
        ksession.insert((Object)new org.drools.compiler.Person("Mark"));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void noDormantCheckOnModifies() throws Exception {
        String str = "package org.drools.compiler;\n rule R1\n    salience 10\n    when\n        $c : Cheese( price == 10 ) \n        $p : Person( ) \n    then \n        modify($c) { setPrice( 5 ) }\n        modify($p) { setAge( 20 ) }\nend\nrule R2\n    when\n        $p : Person( )    then \n        // noop\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.insert((Object)new org.drools.compiler.Person("Bob", 19));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).matchCancelled((MatchCancelledEvent)Matchers.any(MatchCancelledEvent.class));
    }

    @Test
    public void testNullConstantLeft() {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $p : Person( null == name )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person(null));
        ksession.insert((Object)new org.drools.compiler.Person("Mark"));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testJitConstraintInvokingConstructor() {
        String str = "import org.drools.compiler.Person;\nrule R1 when\n   Person( new Integer( ageAsInteger ) < 40 ) \nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person("Mario", 38));
        MiscTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testRemoveRuleWithFromNode() throws Exception {
        String str = "package org.drools.compiler;\nimport org.drools.compiler.*;\nrule R1 when\n   not( Person( name == \"Mark\" ));\nthen\nend\nrule R2 when\n   $p: Person( name == \"Mark\" );\n   not( Address() from $p.getAddresses() );\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        MiscTest.assertEquals((long)2L, (long)kbase.getKnowledgePackage("org.drools.compiler").getRules().size());
        kbase.removeRule("org.drools.compiler", "R2");
        MiscTest.assertEquals((long)1L, (long)kbase.getKnowledgePackage("org.drools.compiler").getRules().size());
    }

    @Test
    public void testDeterministicOTNOrdering() throws Exception {
        String str = "package indexingproblem.remove.me.anditworks;\ndeclare Criteria\n   processed : boolean\nend\n\ndeclare CheeseCriteria extends Criteria end\n\nrule setUp salience 10000 when\nthen\n   insert(new CheeseCriteria());\nend\n\nrule aaa when\n   CheeseCriteria( )\nthen\nend\n\nrule bbb when\n   CheeseCriteria( )\nthen\nend\n\nrule ccc when\n   CheeseCriteria( )\nthen\nend\n\nrule eeeFalse when\n   Criteria( processed == false )\nthen\nend\n\ndeclare Filter end\n\nrule fffTrue when\n   Criteria( processed == true )\n   Filter( )\nthen\nend\n\nrule ruleThatFails when\n   $criteria : Criteria( processed == false )\nthen\n   modify($criteria) { setProcessed(true) }\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
    }

    @Test
    public void testRemoveBigRule() throws Exception {
        String str = "package org.drools.compiler.test\n\ndeclare SimpleFact\n   patientSpaceId : String\n   block : int\nend\n\ndeclare SimpleMembership\n   patientSpaceId : String\n   listId : String\nend\n\ndeclare SimplePatient\n   spaceId : String\nend\n\nrule \"RTR - 47146 retract\"\nagenda-group \"list membership\"\nwhen\n   $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId, ( listId != null && listId == \"47146\" ) )\n   not ( $patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null && spaceId == $listMembershipPatientSpaceIdRoot ) \n       and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 1 )\n         ) or (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 2 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 3 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 4 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 5 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 6 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 7 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 8 )\n       ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 9 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 10 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 11 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 12 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 13 )\n         ) or ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 14 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 15 )\n         ) ) or ( (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 16 )\n           ) and (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 17 )\n         ) ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 18 )\n           ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 19 )\n         ) ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 20 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 21 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 22 )\n         ) or ( (              SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 23 )\n         ) and (             SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 24 )\n     ) ) ) and ( (            SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 25 )\n         ) or (           SimpleFact( patientSpaceId == $patientSpaceIdRoot, block == 26 )\n     ) ) )\nthen\nend\n";
        Collection<KnowledgePackage> kpgs = this.loadKnowledgePackagesFromString(str);
        Assert.assertEquals((long)1L, (long)kpgs.size());
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kpgs);
        kbase.removeKnowledgePackage(kpgs.iterator().next().getName());
    }

    @Test
    public void testCompilationFailureOnTernaryComparison() {
        String str = "declare Cont\n  val:Integer\nend\nrule makeFacts\nsalience 10\nwhen\nthen\n    insert( new Cont(2) );\nend\nrule R1\nwhen\n    $c: Cont( 3 < val < 10 )\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        MiscTest.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testCommentWithCommaInRHS() {
        String str = "import org.drools.compiler.*;\nrule R1 when\n   $p : Person( age < name.length ) \nthen\n   insertLogical(new Person(\"Mario\",\n       // this is the age,\n       38));end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
    }

    @Test
    public void testAlphaHashingWithConstants() {
        String str = "import " + org.drools.compiler.Person.class.getName() + ";\n" + "import " + MiscTest.class.getName() + ";\n" + "rule R1 when\n" + "   $p : Person( age == 38 )\n" + "then end\n" + "rule R2 when\n" + "   $p : Person( age == 37+1 )\n" + "then end\n" + "rule R3 when\n" + "   $p : Person( age == 36+2 )\n" + "then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new org.drools.compiler.Person("Mario", 38));
        MiscTest.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testMemoriesCCEWhenAddRemoveAddRule() {
        String rule1 = "import " + MiscTest.class.getCanonicalName() + ".*\n" + "import java.util.Date\n" + "rule \"RTR - 28717 retract\"\n" + "when\n" + "        $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId,\n" + "        ( listId != null && listId == \"28717\" ) ) and not ($patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null &&\n" + "        spaceId == $listMembershipPatientSpaceIdRoot ) and\n" + "        (($ruleTime0 : RuleTime( $ruleTimeStartOfDay4_1 : startOfDay, $ruleTimeTime4_1 : time ) and $patient1 :\n" + "        SimplePatient( spaceId != null && spaceId == $patientSpaceIdRoot, birthDate != null && (birthDate after[0s,1d] $ruleTimeStartOfDay4_1) ) ) ) )\n" + "then\n" + "end";
        String rule2 = "import " + MiscTest.class.getCanonicalName() + ".*\n" + "import java.util.Date\n" + "rule \"RTR - 28717 retract\"\n" + "when  $listMembership0 : SimpleMembership( $listMembershipPatientSpaceIdRoot : patientSpaceId, ( listId != null && listId == \"28717\" ) )\n" + "    and not ($patient0 : SimplePatient( $patientSpaceIdRoot : spaceId, spaceId != null && spaceId == $listMembershipPatientSpaceIdRoot )\n" + "    and ( ($ruleTime0 : RuleTime( $ruleTimeStartOfDay4_1 : startOfDay, $ruleTimeTime4_1 : time )\n" + "    and $patient1 : SimplePatient( spaceId != null && spaceId == $patientSpaceIdRoot, birthDate != null && (birthDate not after[0s,1d] $ruleTimeStartOfDay4_1) ) ) ) )\n" + "then\n" + "end";
        KnowledgeBase kbase = this.getKnowledgeBase();
        StatefulKnowledgeSession knowledgeSession = kbase.newStatefulKnowledgeSession();
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(rule1));
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(rule2));
    }

    public class SimplePatient {
        public String getSpaceId() {
            return "";
        }

        public String getFactHandleString() {
            return "";
        }

        public Date getBirthDate() {
            return new Date();
        }
    }

    public static class SimpleMembership {
        public String getListId() {
            return "";
        }

        public String getPatientSpaceId() {
            return "";
        }
    }

    public static class RuleTime {
        public Date getTime() {
            return new Date();
        }

        public Date getStartOfDay() {
            return new Date();
        }
    }

    public static class PrimitiveBean {
        public final double primitive;
        public final Double typed;

        public PrimitiveBean(double primitive, Double typed) {
            this.primitive = primitive;
            this.typed = typed;
        }

        public double getPrimitive() {
            return this.primitive;
        }

        public Double getTyped() {
            return this.typed;
        }
    }

    public static class MapContainerBean {
        private final Map<Integer, String> map = new HashMap<Integer, String>();

        MapContainerBean() {
            this.map.put(1, "one");
            this.map.put(2, "two");
            this.map.put(3, "three");
        }

        public Map<Integer, String> getMap() {
            return this.map;
        }

        public int get3() {
            return 3;
        }
    }

    public static class VarargBean {
        public boolean isOddArgsNr(int ... args) {
            return args.length % 2 == 1;
        }
    }

    public static class ChildB
    extends Parent {
        private final int x;

        public ChildB(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }
    }

    public static class ChildA
    extends Parent {
        private final int x;

        public ChildA(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }
    }

    public static class Parent {
    }

    public static class ClassB
    implements InterfaceB {
        private String id = "123";

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassB classB = (ClassB)o;
            return !(this.id != null ? !this.id.equals(classB.id) : classB.id != null);
        }

        public int hashCode() {
            return Integer.valueOf(this.id);
        }
    }

    public static class ClassA
    implements InterfaceA {
        private ClassB b = null;

        @Override
        public ClassB getB() {
            return this.b;
        }

        public void setB(InterfaceB b) {
            this.b = (ClassB)b;
        }
    }

    public static interface InterfaceB {
    }

    public static interface InterfaceA {
        public InterfaceB getB();
    }

    public static class OuterBean {
        private InnerBean inner;
        private String id;

        public InnerBean getInner() {
            return this.inner;
        }

        public void setInner(InnerBean inner) {
            this.inner = inner;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class InnerBean {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static class TestFact {
        private int i;
        private String s;

        public int getI() {
            return this.i;
        }

        public void setI(int i) {
            this.i = i;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String s) {
            this.s = s;
        }
    }

    public static class TestUtility {
        public static Boolean utilMethod(String s1, String s2) {
            Boolean result = null;
            if (s1 != null) {
                result = s1.equals(s2);
            }
            logger.info("in utilMethod >" + s1 + "<  >" + s2 + "< returns " + result);
            return result;
        }
    }

    public static class A {
        private String field1;
        private String field2;

        public A(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public String getField1() {
            return this.field1;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public String toString() {
            return "A) " + this.field1 + ":" + this.field2;
        }
    }
}

