/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.compiler.Address;
import org.drools.compiler.Cell;
import org.drools.compiler.Cheese;
import org.drools.compiler.FactA;
import org.drools.compiler.FactB;
import org.drools.compiler.FactC;
import org.drools.compiler.Message;
import org.drools.compiler.Person;
import org.drools.compiler.Primitives;
import org.drools.compiler.integrationtests.IteratorToList;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.ClockType;
import org.drools.core.RuleBase;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.definitions.impl.KnowledgePackageImp;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MapBackedClassLoader;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.runtime.rule.impl.AgendaImpl;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.Timer;
import org.drools.reteoo.common.ReteWorkingMemory;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MarshallingTest
extends CommonTestMethodBase {
    @Test
    public void testSerializable() throws Exception {
        Package pkg = this.loadPackage("../test_Serializable.drl");
        KnowledgePackageImp kpkg = new KnowledgePackageImp(pkg);
        kpkg = (KnowledgePackage)SerializationHelper.serializeObject((Object)kpkg);
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(Collections.singleton(kpkg));
        Map map = new HashMap<String, KnowledgeBase>();
        map.put("x", kbase);
        map = (Map)SerializationHelper.serializeObject(map);
        kbase = (KnowledgeBase)map.get("x");
        org.kie.api.definition.rule.Rule[] rules = ((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().toArray(new org.kie.api.definition.rule.Rule[0]);
        MarshallingTest.assertEquals((long)4L, (long)rules.length);
        MarshallingTest.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        MarshallingTest.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        MarshallingTest.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        MarshallingTest.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        MarshallingTest.assertEquals((long)1L, (long)ksession.getFactCount());
        MarshallingTest.assertEquals((Object)bob, ksession.getObjects().iterator().next());
        MarshallingTest.assertEquals((long)2L, (long)((AgendaImpl)ksession.getAgenda()).getAgenda().agendaSize());
        ksession.fireAllRules();
        List list = (List)ksession.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        ArrayList objects = new ArrayList(ksession.getObjects());
        MarshallingTest.assertEquals((long)2L, (long)objects.size());
        MarshallingTest.assertTrue((boolean)objects.contains(bob));
        MarshallingTest.assertTrue((boolean)objects.contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase1() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Serializable.drl");
        KnowledgeBase kBase = this.getKnowledgeBase();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        Map map = new HashMap<String, KnowledgeBase>();
        map.put("x", kBase);
        map = (Map)SerializationHelper.serializeObject(map);
        kBase = (KnowledgeBase)map.get("x");
        kBase.addKnowledgePackages(kpkgs);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        org.kie.api.definition.rule.Rule[] rules = kBase.getKnowledgePackage("org.drools.compiler.test").getRules().toArray(new org.kie.api.definition.rule.Rule[0]);
        MarshallingTest.assertEquals((long)4L, (long)rules.length);
        MarshallingTest.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        MarshallingTest.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        MarshallingTest.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        MarshallingTest.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        Assert.assertEquals((long)1L, (long)session.getObjects().size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        MarshallingTest.assertEquals((long)2L, (long)((AgendaImpl)session.getAgenda()).getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((long)2L, (long)session.getObjects().size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase2() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Serializable.drl");
        KnowledgeBase kBase = this.getKnowledgeBase();
        Map map = new HashMap<String, KnowledgeBase>();
        map.put("x", kBase);
        map = (Map)SerializationHelper.serializeObject(map);
        kBase = (KnowledgeBase)map.get("x");
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kBase.addKnowledgePackages(kpkgs);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        org.kie.api.definition.rule.Rule[] rules = kBase.getKnowledgePackage("org.drools.compiler.test").getRules().toArray(new org.kie.api.definition.rule.Rule[0]);
        MarshallingTest.assertEquals((long)4L, (long)rules.length);
        MarshallingTest.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        MarshallingTest.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        MarshallingTest.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        MarshallingTest.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        MarshallingTest.assertEquals((long)1L, (long)session.getObjects().size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        MarshallingTest.assertEquals((long)2L, (long)((AgendaImpl)session.getAgenda()).getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((long)2L, (long)session.getObjects().size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeWorkingMemoryAndRuleBase3() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Serializable.drl");
        KnowledgeBase kBase = this.getKnowledgeBase();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        kBase.addKnowledgePackages(kpkgs);
        session.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        session.insert((Object)bob);
        Map map = new HashMap<String, KnowledgeBase>();
        map.put("x", kBase);
        map = (Map)SerializationHelper.serializeObject(map);
        kBase = (KnowledgeBase)map.get("x");
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        org.kie.api.definition.rule.Rule[] rules = kBase.getKnowledgePackage("org.drools.compiler.test").getRules().toArray(new org.kie.api.definition.rule.Rule[0]);
        MarshallingTest.assertEquals((long)4L, (long)rules.length);
        MarshallingTest.assertEquals((Object)"match Person 1", (Object)rules[0].getName());
        MarshallingTest.assertEquals((Object)"match Person 2", (Object)rules[1].getName());
        MarshallingTest.assertEquals((Object)"match Person 3", (Object)rules[2].getName());
        MarshallingTest.assertEquals((Object)"match Integer", (Object)rules[3].getName());
        MarshallingTest.assertEquals((long)1L, (long)session.getObjects().size());
        MarshallingTest.assertEquals((Object)bob, IteratorToList.convert(session.getObjects().iterator()).get(0));
        MarshallingTest.assertEquals((long)2L, (long)((AgendaImpl)session.getAgenda()).getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        MarshallingTest.assertEquals((long)2L, (long)session.getObjects().size());
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(bob));
        MarshallingTest.assertTrue((boolean)IteratorToList.convert(session.getObjects().iterator()).contains(new Person("help")));
    }

    @Test
    public void testSerializeAdd() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages("../test_Dynamic1.drl");
        kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages(kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        InternalFactHandle stilton = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)list.size(), (long)1L);
        MarshallingTest.assertEquals((Object)"stilton", list.get(0));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        list = (List)session.getGlobal("list");
        MarshallingTest.assertNotNull(list);
        MarshallingTest.assertEquals((long)list.size(), (long)1L);
        MarshallingTest.assertEquals((Object)"stilton", list.get(0));
        kpkgs = this.loadKnowledgePackages("../test_Dynamic3.drl");
        kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs);
        kBase.addKnowledgePackages(kpkgs);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)list.size(), (long)3L);
        MarshallingTest.assertEquals((Object)bob.getObject(), list.get(1));
        MarshallingTest.assertEquals((Object)"stilton", list.get(2));
        session.dispose();
    }

    @Test
    public void testSerializationOfIndexedWM() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages("../test_Serializable2.drl");
        kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages(kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        Map map = new HashMap<String, KnowledgeBase>();
        map.put("x", kBase);
        map = (Map)SerializationHelper.serializeObject(map);
        kBase = (KnowledgeBase)map.get("x");
        org.kie.api.definition.rule.Rule[] rules = kBase.getKnowledgePackage("org.drools.compiler").getRules().toArray(new org.kie.api.definition.rule.Rule[0]);
        MarshallingTest.assertEquals((long)3L, (long)rules.length);
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session.setGlobal("list", new ArrayList());
        Primitives p = new Primitives();
        p.setBytePrimitive((byte)1);
        p.setShortPrimitive((short)2);
        p.setIntPrimitive(3);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        MarshallingTest.assertEquals((long)1L, (long)session.getObjects().size());
        MarshallingTest.assertEquals((Object)p, IteratorToList.convert(session.getObjects().iterator()).get(0));
        MarshallingTest.assertEquals((long)3L, (long)((AgendaImpl)session.getAgenda()).getAgenda().agendaSize());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        List list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)"1", list.get(0));
        MarshallingTest.assertEquals((Object)"2", list.get(1));
        MarshallingTest.assertEquals((Object)"3", list.get(2));
    }

    @Test
    public void testSerializeAdd2() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
        kpkgs = (Collection<KnowledgePackage>)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages((Collection)kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        List results = new ArrayList();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        InternalFactHandle bob = (InternalFactHandle)session.insert((Object)new Person("bob", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kpkgs = this.loadKnowledgePackages("../test_Dynamic3_0.drl");
        kBase.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle mark = (InternalFactHandle)session.insert((Object)new Person("mark", 20));
        session.fireAllRules();
        results = (List)session.getGlobal("results");
        MarshallingTest.assertEquals((long)4L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)mark.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)bob.getObject(), results.get(3));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd_newRuleNotFiredForNewData() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
        kpkgs = (Collection<KnowledgePackage>)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages((Collection)kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kpkgs = this.loadKnowledgePackages("../test_Dynamic1_1.drl");
        kBase.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)5L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)brie3.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)brie2.getObject(), results.get(3));
        MarshallingTest.assertEquals((Object)brie1.getObject(), results.get(4));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session.dispose();
    }

    @Test
    public void testSerializeAdd3() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
        kpkgs = (Collection<KnowledgePackage>)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages((Collection)kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kpkgs = this.loadKnowledgePackages("../test_Dynamic3_0.drl");
        kBase.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)bob2.getObject(), results.get(2));
        MarshallingTest.assertEquals((Object)bob1.getObject(), results.get(3));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kpkgs = this.loadKnowledgePackages("../test_Dynamic1_2.drl");
        kBase.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 40));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 40));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        InternalFactHandle addr1 = (InternalFactHandle)session.insert((Object)new Address("bangalore"));
        InternalFactHandle addr2 = (InternalFactHandle)session.insert((Object)new Address("India"));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)9L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton3.getObject(), results.get(4));
        MarshallingTest.assertEquals((Object)bob4.getObject(), results.get(5));
        MarshallingTest.assertEquals((Object)bob3.getObject(), results.get(6));
        MarshallingTest.assertEquals((Object)addr2.getObject(), results.get(7));
        MarshallingTest.assertEquals((Object)addr1.getObject(), results.get(8));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 50));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 50));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 50));
        InternalFactHandle addr3 = (InternalFactHandle)session.insert((Object)new Address("Tripura"));
        InternalFactHandle addr4 = (InternalFactHandle)session.insert((Object)new Address("Agartala"));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)14L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton4.getObject(), results.get(9));
        MarshallingTest.assertEquals((Object)bob6.getObject(), results.get(10));
        MarshallingTest.assertEquals((Object)bob5.getObject(), results.get(11));
        MarshallingTest.assertEquals((Object)addr4.getObject(), results.get(12));
        MarshallingTest.assertEquals((Object)addr3.getObject(), results.get(13));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.dispose();
    }

    @Test
    public void testSerializeAddRemove_NoClassDefFoundError() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
        kpkgs = (Collection<KnowledgePackage>)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages((Collection)kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ArrayList results = new ArrayList();
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        session.setGlobal("results", results);
        InternalFactHandle stilton1 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 10));
        InternalFactHandle brie1 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 10));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton1.getObject(), results.get(0));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        kpkgs = this.loadKnowledgePackages("../test_Dynamic3_0.drl");
        kBase.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        results.clear();
        InternalFactHandle stilton2 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie2 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob1 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob2 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)results.size());
        MarshallingTest.assertEquals((Object)stilton2.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob2.getObject(), results.get(1));
        MarshallingTest.assertEquals((Object)bob1.getObject(), results.get(2));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        results.clear();
        kBase.removeRule("org.drools.compiler.test", "like stilton");
        InternalFactHandle stilton3 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie3 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob3 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob4 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)results.size());
        MarshallingTest.assertEquals((Object)bob4.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob3.getObject(), results.get(1));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        results.clear();
        kBase.removeKnowledgePackage("org.drools.compiler.test");
        InternalFactHandle stilton4 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 20));
        InternalFactHandle brie4 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 20));
        InternalFactHandle bob5 = (InternalFactHandle)session.insert((Object)new Person("bob", 20));
        InternalFactHandle bob6 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)results.size());
        MarshallingTest.assertEquals((Object)bob6.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob5.getObject(), results.get(1));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        results.clear();
        session.setGlobal("results", results);
        InternalFactHandle stilton5 = (InternalFactHandle)session.insert((Object)new Cheese("stilton", 30));
        InternalFactHandle brie5 = (InternalFactHandle)session.insert((Object)new Cheese("brie", 30));
        InternalFactHandle bob7 = (InternalFactHandle)session.insert((Object)new Person("bob", 30));
        InternalFactHandle bob8 = (InternalFactHandle)session.insert((Object)new Person("bob", 40));
        session.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)results.size());
        MarshallingTest.assertEquals((Object)bob8.getObject(), results.get(0));
        MarshallingTest.assertEquals((Object)bob7.getObject(), results.get(1));
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization1() throws Exception {
        try {
            this.setPrivateKeyProperties();
            this.setPublicKeyProperties();
            Collection kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
            kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs);
            KnowledgeBase kBase = this.getKnowledgeBase();
            kBase.addKnowledgePackages(kpkgs);
            KnowledgeBase knowledgeBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        }
        finally {
            this.unsetPrivateKeyProperties();
            this.unsetPublicKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization2() throws Exception {
        try {
            this.setPrivateKeyProperties();
            try {
                Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("../test_Dynamic1_0.drl");
                MarshallingTest.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization3() throws Exception {
        try {
            this.setPrivateKeyProperties();
            Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages(null, false, "../test_Dynamic1_0.drl");
            KnowledgeBase kBase = this.getKnowledgeBase();
            kBase.addKnowledgePackages(kpkgs);
            try {
                kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
                MarshallingTest.fail((String)"Deserialisation should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.unsetPrivateKeyProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignedSerialization4() throws Exception {
        Collection kpkgs = this.loadKnowledgePackages(null, false, "../test_Dynamic1_0.drl");
        kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs);
        KnowledgeBase kBase = this.getKnowledgeBase();
        kBase.addKnowledgePackages(kpkgs);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        try {
            this.setPublicKeyProperties();
            kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
            MarshallingTest.fail((String)"Should not deserialize an unsigned rulebase on an environment configured to work with signed rulebases.");
        }
        catch (Exception exception) {
        }
        finally {
            this.unsetPublicKeyProperties();
        }
    }

    private void setPublicKeyProperties() {
        URL clientKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsClient.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.public.keyStoreURL", clientKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.public.keyStorePwd", "clientpwd");
    }

    private void unsetPublicKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.public.keyStoreURL", "");
        System.setProperty("drools.serialization.public.keyStorePwd", "");
    }

    private void setPrivateKeyProperties() {
        URL serverKeyStoreURL = ((Object)((Object)this)).getClass().getResource("droolsServer.keystore");
        System.setProperty("drools.serialization.sign", "true");
        System.setProperty("drools.serialization.private.keyStoreURL", serverKeyStoreURL.toExternalForm());
        System.setProperty("drools.serialization.private.keyStorePwd", "serverpwd");
        System.setProperty("drools.serialization.private.keyAlias", "droolsKey");
        System.setProperty("drools.serialization.private.keyPwd", "keypwd");
    }

    private void unsetPrivateKeyProperties() {
        System.setProperty("drools.serialization.sign", "");
        System.setProperty("drools.serialization.private.keyStoreURL", "");
        System.setProperty("drools.serialization.private.keyStorePwd", "");
        System.setProperty("drools.serialization.private.keyAlias", "");
        System.setProperty("drools.serialization.private.keyPwd", "");
    }

    @Test
    public void testSerializabilityWithJarFacts() throws Exception {
        MapBackedClassLoader loader = new MapBackedClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        JarInputStream jis = new JarInputStream(((Object)((Object)this)).getClass().getResourceAsStream("/billasurf.jar"));
        JarEntry entry = null;
        byte[] buf = new byte[1024];
        int len = 0;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = jis.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            loader.addResource(entry.getName(), out.toByteArray());
        }
        String drl = "package foo.bar \nimport com.billasurf.Board\nrule 'MyGoodRule' \n dialect 'mvel' \n when    Board() then \n System.err.println(42); \nend\n";
        KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader});
        Collection kpkgs = this.loadKnowledgePackagesFromString(kbuilderConf, drl);
        kpkgs = (Collection)SerializationHelper.serializeObject(kpkgs, (ClassLoader)loader);
    }

    @Test
    public void testEmptyRule() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "then\n";
        rule = rule + "    list.add( \"fired\" );\n";
        rule = rule + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)((KnowledgeBaseImpl)kBase).getRuleBase()));
        MarshallingTest.assertEquals((long)2L, (long)nodes.size());
        MarshallingTest.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        MarshallingTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)"fired", ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testDynamicEmptyRule() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"fired1\" );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"fired2\" );\n";
        rule2 = rule2 + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule1);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)((KnowledgeBaseImpl)kBase).getRuleBase()));
        MarshallingTest.assertEquals((long)2L, (long)nodes.size());
        MarshallingTest.assertEquals((Object)"InitialFactImpl", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        StatefulKnowledgeSession session1 = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)false);
        session1.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)((List)session1.getGlobal("list")).size());
        StatefulKnowledgeSession session2 = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session1, (KieBase)kBase, (boolean)false);
        session.dispose();
        session1.dispose();
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackagesFromString(rule2);
        kBase.addKnowledgePackages(kpkgs);
        session2.fireAllRules();
        System.out.println(session2.getGlobal("list"));
        MarshallingTest.assertEquals((long)2L, (long)((List)session2.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)"fired1", ((List)session2.getGlobal("list")).get(0));
        MarshallingTest.assertEquals((Object)"fired2", ((List)session2.getGlobal("list")).get(1));
    }

    @Test
    public void testSinglePattern() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import org.drools.compiler.Person\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $p : Person( ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)((KnowledgeBaseImpl)kBase).getRuleBase()));
        MarshallingTest.assertEquals((long)2L, (long)nodes.size());
        MarshallingTest.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(4)).getRule().getName());
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        session.insert((Object)p);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)p, ((List)session.getGlobal("list")).get(0));
    }

    @Test
    public void testSingleRuleSingleJoinNodePattern() throws Exception {
        String rule = "package org.drools.compiler.test;\n";
        rule = rule + "import org.drools.compiler.Person\n";
        rule = rule + "import org.drools.compiler.Cheese\n";
        rule = rule + "global java.util.List list\n";
        rule = rule + "rule \"Rule 1\"\n";
        rule = rule + "when\n";
        rule = rule + "    $c : Cheese( ) \n";
        rule = rule + "    $p : Person( cheese == $c ) \n";
        rule = rule + "then\n";
        rule = rule + "    list.add( $p );\n";
        rule = rule + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule);
        Map nodes = RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalRuleBase)((KnowledgeBaseImpl)kBase).getRuleBase()));
        MarshallingTest.assertEquals((long)4L, (long)nodes.size());
        MarshallingTest.assertEquals((Object)"Cheese", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(2)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertEquals((Object)"Person", (Object)((ClassObjectType)((ObjectTypeNode)nodes.get(4)).getObjectType()).getClassType().getSimpleName());
        MarshallingTest.assertTrue((String)"Should end with JoinNode", (boolean)((BaseNode)nodes.get(5)).getClass().getSimpleName().endsWith("JoinNode"));
        MarshallingTest.assertEquals((Object)"Rule 1", (Object)((RuleTerminalNode)nodes.get(6)).getRule().getName());
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 32);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 32);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)bobba, ((List)session.getGlobal("list")).get(0));
        Person c3po = new Person("c3p0", 32);
        c3po.setCheese(stilton);
        session.insert((Object)c3po);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)c3po, ((List)session.getGlobal("list")).get(1));
        Person r2d2 = new Person("r2d2", 32);
        r2d2.setCheese(brie);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        MarshallingTest.assertEquals((Object)r2d2, ((List)session.getGlobal("list")).get(2));
    }

    @Test
    public void testMultiRuleMultiJoinNodePatternsWithHalt() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import org.drools.compiler.Person\n";
        rule1 = rule1 + "import org.drools.compiler.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "    $p : Person( cheese == $c ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( $p );\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import org.drools.compiler.Person\n";
        rule2 = rule2 + "import org.drools.compiler.Cheese\n";
        rule2 = rule2 + "import org.drools.compiler.Cell\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "    $p : Person( cheese == $c ) \n";
        rule2 = rule2 + "    $x : Cell( value == $p.age ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( $x );\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import org.drools.compiler.FactA\n";
        rule3 = rule3 + "import org.drools.compiler.FactB\n";
        rule3 = rule3 + "import org.drools.compiler.FactC\n";
        rule3 = rule3 + "import org.drools.compiler.Person\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $a : FactA( field2 > 10 ) \n";
        rule3 = rule3 + "    $b : FactB( f2 >= $a.field2 ) \n";
        rule3 = rule3 + "    $p : Person( name == \"darth vadar\" ) \n";
        rule3 = rule3 + "    $c : FactC( f2 >= $b.f2 ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( $c );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule1, rule2, rule3);
        StatefulKnowledgeSession session = kBase.newStatefulKnowledgeSession();
        List list = new ArrayList();
        session.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 25);
        Cheese brie = new Cheese("brie", 49);
        Person bobba = new Person("bobba fet", 30);
        bobba.setCheese(stilton);
        Person vadar = new Person("darth vadar", 38);
        Person c3po = new Person("c3p0", 17);
        c3po.setCheese(stilton);
        Person r2d2 = new Person("r2d2", 58);
        r2d2.setCheese(brie);
        session.insert((Object)stilton);
        session.insert((Object)bobba);
        session.insert((Object)vadar);
        session.insert((Object)brie);
        session.insert((Object)c3po);
        session.insert((Object)r2d2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        list = (List)session.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertTrue((boolean)list.contains(r2d2));
        MarshallingTest.assertTrue((boolean)list.contains(c3po));
        MarshallingTest.assertTrue((boolean)list.contains(bobba));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        Cell cell30 = new Cell(30);
        session.insert((Object)cell30);
        Cell cell58 = new Cell(58);
        session.insert((Object)cell58);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        MarshallingTest.assertEquals((long)5L, (long)list.size());
        MarshallingTest.assertTrue((boolean)list.contains(cell30));
        MarshallingTest.assertTrue((boolean)list.contains(cell58));
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.insert((Object)new FactA(Integer.valueOf(15)));
        session.insert((Object)new FactB(Integer.valueOf(20)));
        FactC factC27 = new FactC(Integer.valueOf(27));
        session.insert((Object)factC27);
        FactC factC52 = new FactC(Integer.valueOf(52));
        session.insert((Object)factC52);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (KieBase)kBase, (boolean)true);
        session.fireAllRules();
        session.fireAllRules();
        MarshallingTest.assertEquals((long)7L, (long)list.size());
        MarshallingTest.assertTrue((boolean)list.contains(factC52));
        MarshallingTest.assertTrue((boolean)list.contains(factC27));
    }

    @Test
    public void testNot() throws Exception {
        String header = "package org.drools.compiler.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.compiler.Person\n";
        header = header + "import org.drools.compiler.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    not Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(header + rule1);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testExists() throws Exception {
        String header = "package org.drools.compiler.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.compiler.Person\n";
        header = header + "import org.drools.compiler.Cheese\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not rule test\"\n";
        rule1 = rule1 + "salience 10\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    Person()\n";
        rule1 = rule1 + "    exists Cheese( price >= 5 )\n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( new Integer( 5 ) );\n";
        rule1 = rule1 + "end\n";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(header + rule1);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession(null, env);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Person bobba = new Person("bobba fet", 50);
        ksession.insert((Object)bobba);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Person darth = new Person("darth vadar", 200);
        ksession.insert((Object)darth);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)0L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        Cheese brie = new Cheese("brie", 18);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)stilton));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)bobba));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession.retract(ksession.getFactHandle((Object)brie));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)4L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testTruthMaintenance() throws Exception {
        String header = "package org.drools.compiler.test;\n";
        header = header + "import java.util.List;\n";
        header = header + "import org.drools.compiler.Person\n";
        header = header + "import org.drools.compiler.Cheese\n";
        header = header + "global Cheese cheese;\n";
        header = header + "global Person person;\n";
        header = header + "global java.util.List list;\n";
        String rule1 = "rule \"not person then cheese\"\n";
        rule1 = rule1 + "when \n";
        rule1 = rule1 + "    not Person() \n";
        rule1 = rule1 + "then \n";
        rule1 = rule1 + "    if (list.size() < 3) { \n";
        rule1 = rule1 + "        list.add(new Integer(0)); \n";
        rule1 = rule1 + "        insertLogical( cheese ); \n    }\n";
        rule1 = rule1 + "    drools.halt();\nend\n";
        String rule2 = "rule \"if cheese then person\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    Cheese()\n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    if (list.size() < 3) {\n";
        rule2 = rule2 + "        list.add(new Integer(0));\n";
        rule2 = rule2 + "        insertLogical( person );\n";
        rule2 = rule2 + "    }\n    drools.halt();\n";
        rule2 = rule2 + "end\n";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(header + rule1 + rule2);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        ksession.setGlobal("cheese", (Object)cheese);
        ksession.setGlobal("person", (Object)person);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testActivationGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import org.drools.compiler.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    activation-group \"activation-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import org.drools.compiler.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    activation-group \"activation-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import org.drools.compiler.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-1\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import org.drools.compiler.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule1, rule2, rule3, rule4);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)list.size());
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        MarshallingTest.assertEquals((Object)"rule4", list.get(1));
    }

    @Test
    public void testAgendaGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import org.drools.compiler.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    agenda-group \"agenda-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import org.drools.compiler.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    agenda-group \"agenda-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import org.drools.compiler.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    agenda-group \"agenda-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import org.drools.compiler.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    agenda-group \"agenda-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule1, rule2, rule3, rule4);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.getAgenda().getAgendaGroup("agenda-group-1").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.getAgenda().getAgendaGroup("agenda-group-2").setFocus();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule3", list.get(1));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testRuleFlowGroups() throws Exception {
        String rule1 = "package org.drools.compiler.test;\n";
        rule1 = rule1 + "import org.drools.compiler.Cheese\n";
        rule1 = rule1 + "global java.util.List list\n";
        rule1 = rule1 + "rule \"Rule 1\"\n";
        rule1 = rule1 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule1 = rule1 + "when\n";
        rule1 = rule1 + "    $c : Cheese( ) \n";
        rule1 = rule1 + "then\n";
        rule1 = rule1 + "    list.add( \"rule1\" );\n";
        rule1 = rule1 + "    drools.halt();\n";
        rule1 = rule1 + "end";
        String rule2 = "package org.drools.compiler.test;\n";
        rule2 = rule2 + "import org.drools.compiler.Cheese\n";
        rule2 = rule2 + "global java.util.List list\n";
        rule2 = rule2 + "rule \"Rule 2\"\n";
        rule2 = rule2 + "    salience 10\n";
        rule2 = rule2 + "    ruleflow-group \"ruleflow-group-1\"\n";
        rule2 = rule2 + "when\n";
        rule2 = rule2 + "    $c : Cheese( ) \n";
        rule2 = rule2 + "then\n";
        rule2 = rule2 + "    list.add( \"rule2\" );\n";
        rule2 = rule2 + "    drools.halt();\n";
        rule2 = rule2 + "end";
        String rule3 = "package org.drools.compiler.test;\n";
        rule3 = rule3 + "import org.drools.compiler.Cheese\n";
        rule3 = rule3 + "global java.util.List list\n";
        rule3 = rule3 + "rule \"Rule 3\"\n";
        rule3 = rule3 + "    salience 10\n";
        rule3 = rule3 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule3 = rule3 + "    activation-group \"activation-group-2\"\n";
        rule3 = rule3 + "when\n";
        rule3 = rule3 + "    $c : Cheese( ) \n";
        rule3 = rule3 + "then\n";
        rule3 = rule3 + "    list.add( \"rule3\" );\n";
        rule3 = rule3 + "    drools.halt();\n";
        rule3 = rule3 + "end";
        String rule4 = "package org.drools.compiler.test;\n";
        rule4 = rule4 + "import org.drools.compiler.Cheese\n";
        rule4 = rule4 + "global java.util.List list\n";
        rule4 = rule4 + "rule \"Rule 4\"\n";
        rule4 = rule4 + "    ruleflow-group \"ruleflow-group-2\"\n";
        rule4 = rule4 + "    activation-group \"activation-group-2\"\n";
        rule4 = rule4 + "when\n";
        rule4 = rule4 + "    $c : Cheese( ) \n";
        rule4 = rule4 + "then\n";
        rule4 = rule4 + "    list.add( \"rule4\" );\n";
        rule4 = rule4 + "    drools.halt();\n";
        rule4 = rule4 + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule1, rule2, rule3, rule4);
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)kbase.newStatefulKnowledgeSession(), (boolean)true);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ((AgendaImpl)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule2", list.get(0));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ((AgendaImpl)ksession.getAgenda()).activateRuleFlowGroup("ruleflow-group-2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule3", list.get(1));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((Object)"rule1", list.get(2));
    }

    @Test
    public void testAccumulate() throws Exception {
        String rule = "package org.drools\nimport org.drools.compiler.Message\nglobal java.util.List results\nrule MyRule\n  when\n    $n : Number( intValue >= 2 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    results.add($n);\nend";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)kBase.newStatefulKnowledgeSession(), (boolean)true);
        kBase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kBase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.setGlobal("results", new ArrayList());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        List results = (List)ksession.getGlobal("results");
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)((Number)results.get(0)).intValue());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        MarshallingTest.assertEquals((long)1L, (long)((AgendaImpl)ksession.getAgenda()).getAgenda().agendaSize());
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)5L, (long)((Number)results.get(1)).intValue());
    }

    @Test
    public void testAccumulate2() throws Exception {
        String str = "package org.drools\n\nimport org.drools.compiler.Message\n\nrule MyRule\n  when\n    Number( intValue >= 5 ) from accumulate ( m: Message( ), count( m ) )\n  then\n    System.out.println(\"Found messages\");\nend\n";
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ksession.insert((Object)new Message());
        ((ReteWorkingMemory)((StatefulKnowledgeSessionImpl)ksession).session).initInitialFact();
        MarshallingTest.assertEquals((long)1L, (long)((AgendaImpl)ksession.getAgenda()).getAgenda().agendaSize());
    }

    @Test
    public void testAccumulateSessionSerialization() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("../test_AccumulateSerialization.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 10));
        ksession.insert((Object)new Cheese("brie", 5));
        ksession.insert((Object)new Cheese("provolone", 150));
        ksession.insert((Object)new Cheese("brie", 20));
        ksession.insert((Object)new Person("Bob", "brie"));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)1L, (long)results.size());
        MarshallingTest.assertEquals((long)25L, (long)((Number)results.get(0)).intValue());
    }

    @Test
    @Ignore
    public void testDroolsObjectOutputInputStream() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("org/drools/compiler/integrationtests/test_Serializable.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Person bob = new Person();
        session.insert((Object)bob);
        MarshallingTest.assertSame((String)"these two object references should be same", (Object)bob, session.getObjects().iterator().next());
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(bob);
        out.writeObject(kbase);
        marshaller.marshall((OutputStream)out, (KieSession)session);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Person deserializedBob = (Person)in.readObject();
        kbase = (KnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(kbase);
        session = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)in);
        MarshallingTest.assertSame((String)"these two object references should be same", (Object)deserializedBob, session.getObjects().iterator().next());
        in.close();
    }

    @Test
    public void testAccumulateSerialization() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("org/drools/compiler/integrationtests/marshalling/test_SerializableAccumulate.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("results", new ArrayList());
        Cheese t1 = new Cheese("brie", 10);
        Cheese t2 = new Cheese("brie", 15);
        Cheese t3 = new Cheese("stilton", 20);
        Cheese t4 = new Cheese("brie", 30);
        ksession.insert((Object)t1);
        ksession.insert((Object)t2);
        ksession.insert((Object)t3);
        ksession.insert((Object)t4);
        Marshaller marshaller = this.createSerializableMarshaller(kbase);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)baos);
        out.writeObject(kbase);
        marshaller.marshall((OutputStream)out, (KieSession)ksession);
        out.flush();
        out.close();
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        kbase = (KnowledgeBase)in.readObject();
        marshaller = this.createSerializableMarshaller(kbase);
        ksession = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)in);
        in.close();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        MarshallingTest.assertNotNull(results);
        ksession.fireAllRules();
        ksession.dispose();
        MarshallingTest.assertEquals((long)1L, (long)results.size());
        MarshallingTest.assertEquals((long)3L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testMarshallWithNot() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "rule one\n" + "when\n" + "   A()\n" + "   not(B())\n" + "then\n" + "System.out.println(\"a\");\n" + "end\n" + "\n" + "rule two\n" + "when\n" + "   A()\n" + "then\n" + "System.out.println(\"b\");\n" + "end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(config, str);
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession();
        ksession.insert((Object)new A());
        MarshallerFactory.newMarshaller((KieBase)kBase).marshall((OutputStream)new ByteArrayOutputStream(), (KieSession)ksession);
    }

    @Test
    public void testMarshallEvents() throws Exception {
        String str = "import " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "rule one\n" + "when\n" + "   $a : A()\n" + "   B(this after $a)\n" + "then\n" + "insert(new C());" + "end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(config, str);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession(ksconf, null);
        ksession.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        ksession.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)ksession.getObjects().size());
    }

    @Test
    @Ignore(value="This test is suspicious to say the least...")
    public void testScheduledActivation() {
        KnowledgeBaseImpl knowledgeBase = (KnowledgeBaseImpl)KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgePackageImp impl = new KnowledgePackageImp();
        impl.pkg = new Package("test");
        BuildContext buildContext = new BuildContext((InternalRuleBase)knowledgeBase.getRuleBase(), ((ReteooRuleBase)knowledgeBase.getRuleBase()).getReteooBuilder().getIdGenerator());
        Rule rule = new Rule("test-rule");
        new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, buildContext);
        final ArrayList fired = new ArrayList();
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
                fired.add("a");
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(10000L));
        rule.setPackage("test");
        impl.pkg.addRule(rule);
        knowledgeBase.addKnowledgePackages(Collections.singleton(impl));
        SessionConfiguration config = new SessionConfiguration();
        config.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession((KieSessionConfiguration)config, KnowledgeBaseFactory.newEnvironment());
        PseudoClockScheduler scheduler = (PseudoClockScheduler)ksession.getSessionClock();
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
        ksession.insert((Object)"cheese");
        MarshallingTest.assertTrue((boolean)fired.isEmpty());
        this.readWrite((KnowledgeBase)knowledgeBase, (KieSession)ksession, (KieSessionConfiguration)config);
        MarshallingTest.assertTrue((boolean)fired.isEmpty());
        scheduler.advanceTime(12L, TimeUnit.SECONDS);
        MarshallingTest.assertFalse((boolean)fired.isEmpty());
    }

    @Test
    public void testMarshallEntryPointsWithExpires() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "global java.util.List list\n" + "declare A\n" + " @role( event )\n" + " @expires( 10s )\n" + "end\n" + "declare B\n" + "" + " @role( event )\n" + " @expires( 10s )\n" + "end\n" + "" + "declare C\n" + " @role( event )\n" + " @expires( 15s )\n" + "end\n" + "" + "rule a1\n" + "when\n" + "   $a : A() from entry-point 'a-ep'\n" + "then\n" + "list.add( $a );" + "end\n" + "" + "rule b1\n" + "when\n" + "   $b : B() from entry-point 'b-ep'\n" + "then\n" + "list.add( $b );" + "end\n" + "" + "rule c1\n" + "when\n" + "   $c : C() from entry-point 'c-ep'\n" + "then\n" + "list.add( $c );" + "end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(config, str);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        EntryPoint bep = ksession.getEntryPoint("b-ep");
        bep.insert((Object)new B());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        EntryPoint cep = ksession.getEntryPoint("c-ep");
        cep.insert((Object)new C());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        aep = ksession.getEntryPoint("a-ep");
        MarshallingTest.assertEquals((long)1L, (long)aep.getFactHandles().size());
        bep = ksession.getEntryPoint("b-ep");
        MarshallingTest.assertEquals((long)1L, (long)bep.getFactHandles().size());
        cep = ksession.getEntryPoint("c-ep");
        MarshallingTest.assertEquals((long)1L, (long)cep.getFactHandles().size());
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(11L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        MarshallingTest.assertEquals((long)0L, (long)aep.getFactHandles().size());
        bep = ksession.getEntryPoint("b-ep");
        MarshallingTest.assertEquals((long)0L, (long)bep.getFactHandles().size());
        cep = ksession.getEntryPoint("c-ep");
        MarshallingTest.assertEquals((long)1L, (long)cep.getFactHandles().size());
    }

    @Test
    public void testMarshallEntryPointsWithNot() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "global java.util.List list\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + "" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "" + "rule a1\n" + "when\n" + "   $a : A() from entry-point 'a-ep'\n" + "   not B( this after[0s, 10s] $a) from entry-point 'a-ep'\n" + "then\n" + "list.add( $a );" + "end\n";
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        config.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kBase = this.loadKnowledgeBaseFromString(config, str);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        StatefulKnowledgeSession ksession = kBase.newStatefulKnowledgeSession(ksconf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)0L, (long)list.size());
    }

    @Test
    @Ignore(value="beta4 phreak")
    public void testMarshallEntryPointsWithSlidingTimeWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "import java.util.List\n" + "global java.util.List list\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + "" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "" + "rule a1\n" + "when\n" + "   $l : List() from collect( A()  over window:time(30s) from entry-point 'a-ep') \n" + "then\n" + "   list.add( $l );" + "end\n";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(conf, str);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)2L, (long)((List)list.get(0)).size());
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)4L, (long)((List)list.get(0)).size());
        timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        list.clear();
        ksession.fireAllRules();
        MarshallingTest.assertEquals((long)2L, (long)((List)list.get(0)).size());
    }

    @Test
    public void testMarshallEntryPointsWithSlidingLengthWindow() throws Exception {
        String str = "package org.domain.test \nimport " + ((Object)((Object)this)).getClass().getCanonicalName() + ".*\n" + "import java.util.List\n" + "global java.util.List list\n" + "declare A\n" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "declare B\n" + "" + " @role( event )\n" + " @expires( 10m )\n" + "end\n" + "" + "rule a1\n" + "when\n" + "   $l : List() from collect( A()  over window:length(3) from entry-point 'a-ep') \n" + "then\n" + "   list.add( $l );" + "end\n";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(conf, str);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase, ksconf);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        EntryPoint aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)2L, (long)((List)list.get(0)).size());
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        aep = ksession.getEntryPoint("a-ep");
        aep.insert((Object)new A());
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        list.clear();
        ksession.fireAllRules();
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)3L, (long)((List)list.get(0)).size());
    }

    @Test
    public void testMarshalWithProtoBuf() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("../test_Serializable.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", new ArrayList());
        Person bob = new Person("bob");
        ksession.insert((Object)bob);
        ksession = this.marsallStatefulKnowledgeSession((KieSession)ksession);
        MarshallingTest.assertEquals((long)1L, (long)ksession.getFactCount());
        MarshallingTest.assertEquals((Object)bob, ksession.getObjects().iterator().next());
        int fired = ksession.fireAllRules();
        MarshallingTest.assertEquals((long)3L, (long)fired);
        List list = (List)ksession.getGlobal("list");
        MarshallingTest.assertEquals((long)3L, (long)list.size());
        MarshallingTest.assertEquals((Object)new Integer(4), list.get(0));
        Collection facts = ksession.getObjects();
        System.out.println(new ArrayList(facts));
        MarshallingTest.assertEquals((long)2L, (long)facts.size());
    }

    private KieSession marsallStatefulKnowledgeSession(KieSession ksession) throws IOException, ClassNotFoundException {
        Globals globals = ksession.getGlobals();
        KieBase kbase = ksession.getKieBase();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallerFactory.newMarshaller((KieBase)kbase).marshall((OutputStream)out, ksession);
        KieSessionConfiguration ksconf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksconf.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"trackable"));
        ksconf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.Globals", (Object)globals);
        ksession = MarshallerFactory.newMarshaller((KieBase)kbase).unmarshall((InputStream)new ByteArrayInputStream(out.toByteArray()), ksconf, env);
        return ksession;
    }

    private void readWrite(KnowledgeBase knowledgeBase, KieSession ksession, KieSessionConfiguration config) {
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase);
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)o, ksession);
            ksession = marshaller.unmarshall((InputStream)new ByteArrayInputStream(o.toByteArray()), config, KnowledgeBaseFactory.newEnvironment());
            ksession.fireAllRules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Marshaller createSerializableMarshaller(KnowledgeBase knowledgeBase) {
        ObjectMarshallingStrategyAcceptor acceptor = MarshallerFactory.newClassFilterAcceptor((String[])new String[]{"*.*"});
        ObjectMarshallingStrategy strategy = MarshallerFactory.newSerializeMarshallingStrategy((ObjectMarshallingStrategyAcceptor)acceptor);
        Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)knowledgeBase, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{strategy});
        return marshaller;
    }

    protected RuleBase getRuleBase(Package pkg) throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return (RuleBase)SerializationHelper.serializeObject((Object)ruleBase);
    }

    public static class C
    implements Serializable {
        public String toString() {
            return "C[]";
        }
    }

    public static class B
    implements Serializable {
        public String toString() {
            return "B[]";
        }
    }

    public static class A
    implements Serializable {
        public String toString() {
            return "A[]";
        }
    }
}

