/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.drools.core.ClockType;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.time.SessionPseudoClock;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CepEspTest {
    @Test
    public void testEventTimestamp() {
        String drl = "\nimport org.drools.reteoo.integrationtests.CepEspTest.Event; \nglobal java.util.List list; \nglobal org.drools.core.time.SessionPseudoClock clock; \ndeclare Event \n @role( event )\n @timestamp( time ) \n @expires( 10000000 ) \nend \nrule \"inform about E1\"\nwhen\n $event1 : Event( type == 1 )\n //there is an event (T2) with value 0 between 0,2m after doorClosed\n $event2: Event( type == 2, value == 1, this after [0, 1200ms] $event1, $timestamp : time )\n //there is no newer event (T2) within the timeframe\n not Event( type == 2, this after [0, 1200ms] $event1, time > $timestamp ) \nthen\n list.add( clock.getCurrentTime() ); \n end\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        baseConfig.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sessionConfig, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ksession.setGlobal("clock", (Object)clock);
        ksession.insert((Object)new Event(1, -1, clock.getCurrentTime()));
        clock.advanceTime(600L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
        clock.advanceTime(300L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 1, clock.getCurrentTime()));
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
        clock.advanceTime(1000L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        Long time = (Long)list.get(0);
        TestCase.assertTrue((time > 1000L && time < 1500L ? 1 : 0) != 0);
        ksession.dispose();
    }

    @Test
    public void testEventTimestamp2() {
        String drl = "\nimport org.drools.reteoo.integrationtests.CepEspTest.Event; \nglobal java.util.List list; \nglobal org.drools.core.time.SessionPseudoClock clock; \ndeclare Event \n @role( event )\n @timestamp( time ) \n @expires( 10000000 ) \nend \nrule \"inform about E1\"\nwhen\n $event1 : Event( type == 1 )\n $event2: Event( type == 2 )\n not Event( type == 3, this after [0, 1000ms] $event1 ) \nthen\n list.add( clock.getCurrentTime() ); \n end\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        baseConfig.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(sessionConfig, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ksession.setGlobal("clock", (Object)clock);
        ksession.insert((Object)new Event(1, 0, clock.getCurrentTime()));
        clock.advanceTime(600L, TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        ksession.insert((Object)new Event(2, 0, clock.getCurrentTime()));
        clock.advanceTime(600L, TimeUnit.MILLISECONDS);
        ksession.insert((Object)new Event(3, 0, clock.getCurrentTime()));
        ksession.fireAllRules();
        Assert.assertFalse((boolean)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        long time = (Long)list.get(0);
        TestCase.assertTrue((time >= 1000L ? 1 : 0) != 0);
        ksession.dispose();
    }

    @Test
    public void testCollectAfterRetract() {
        String drl = "import org.drools.reteoo.integrationtests.CepEspTest.SimpleFact;\nimport java.util.List;\nglobal List list;\n\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"Retract facts if 2 or more\" salience 1000\nwhen\n    $facts : List( size > 0 ) from collect( SimpleFact() )\nthen\n    for (Object f: new java.util.LinkedList($facts)) {\n        System.out.println(\"Retracting \"+f);\n        retract(f);\n    }\nend\n\nrule \"Still facts in WM\"\nwhen\n    $facts : List( size != 0 ) from collect( SimpleFact() )\nthen\nSystem.out.println( \"bubu\" );\n    list.add( $facts.size() );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        baseConfig.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new SimpleFact("id1"));
        ksession.insert((Object)new SimpleFact("id2"));
        ksession.insert((Object)new SimpleFact("id3"));
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)0L, (long)ksession.getFactCount());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testFromWithEvents() {
        String drl = "\n\npackage org.drools.test\nglobal java.util.List list; \n\ndeclare MyEvent\n@role(event)\n@timestamp( stamp )\nid : int\nstamp : long\nend\n\ndeclare MyBean\nid : int\nevent : MyEvent\nend\n\nrule \"Init\"\nwhen\nthen\nMyEvent ev = new MyEvent( 1, 1000 );\nMyBean bin = new MyBean( 99, ev );\nMyEvent ev2 = new MyEvent( 2, 2000 );\n\ndrools.getWorkingMemory().getWorkingMemoryEntryPoint( \"X\" ).insert( ev2 );\ninsert( bin );\nend\n\nrule \"Check\"\nwhen\n$e2 : MyEvent( id == 2 ) from entry-point \"X\" \n$b1 : MyBean( id == 99, $ev : event )\nMyEvent( this before $e2 ) from $ev\nthen\nSystem.out.println( \"Success\" );\nlist.add( 1 ); \nend\n";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (knowledgeBuilder.hasErrors()) {
            TestCase.fail((String)knowledgeBuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList(1);
        ks.setGlobal("list", list);
        ks.fireAllRules();
        Assert.assertEquals(Arrays.asList(1), list);
    }

    @Test
    public void testNotBefore() {
        String drl = "import org.drools.reteoo.integrationtests.CepEspTest.SimpleFact;\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"TEST1\"\nwhen\n    sf1: SimpleFact(status==\"code0\")\n    not ( SimpleFact(status==\"code1\", this before[1ms, 10s] sf1 ) )\n    then\n        System.out.println(\"test OK\");\n        insert(new SimpleFact(\"OK\", \"OK\"));\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        baseConfig.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession kSession = kbase.newStatefulKnowledgeSession();
        kSession.insert((Object)new SimpleFact("id0", "code0"));
        kSession.fireAllRules();
        Assert.assertEquals((String)"2 facts in session", (long)2L, (long)kSession.getFactCount());
    }

    @Test
    public void testNotAfterOnDeclaration() {
        String drl = "import org.drools.reteoo.integrationtests.CepEspTest.SimpleFact;\ndeclare SimpleFact\n    @role( event )\nend\n\nrule \"TEST2\"\n    when\n        sf1: SimpleFact(status==\"code2\")\n        not ( SimpleFact($a: this, status==\"code3\", $a after[1ms, 2s] sf1 ) )\n    then\n        insert(new SimpleFact(\"OK\", \"OK\"));\n    end";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            TestCase.fail((String)kbuilder.getErrors().toString());
        }
        KieBaseConfiguration baseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        baseConfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        baseConfig.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)baseConfig);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KieSessionConfiguration sessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        sessionConfig.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession kSession = kbase.newStatefulKnowledgeSession(sessionConfig, null);
        SessionPseudoClock clock = (SessionPseudoClock)kSession.getSessionClock();
        kSession.insert((Object)new SimpleFact("id1", "code2"));
        kSession.fireAllRules();
        Assert.assertEquals((String)"1 facts in session", (long)1L, (long)kSession.getFactCount());
        clock.advanceTime(3L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"2 facts in session", (long)2L, (long)kSession.getFactCount());
    }

    public static class SimpleFact {
        private String status = "NOK";
        private final String id;

        public SimpleFact(String id) {
            this.id = id;
        }

        public SimpleFact(String id, String status) {
            this.id = id;
            this.status = status;
        }

        public String getId() {
            return this.id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String s) {
            this.status = s;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " (id=" + this.id + ", status=" + this.status + ")";
        }
    }

    public static class Event {
        private int type;
        private int value;
        private long time;

        public Event(int type, int value, long time) {
            this.type = type;
            this.value = value;
            this.time = time;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public String toString() {
            return "Event{type=" + this.type + ", value=" + this.value + ", time=" + this.time % 10000L + '}';
        }
    }
}

