/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.MockRightTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.ObjectHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.rule.Agenda;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.beliefs.Mode;

@Ignore
public class LogicalAssertionTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.kBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
        this.pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    @Ignore
    public <M extends ModedAssertion<M>> void testSingleLogicalRelationship() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockRightTupleSink sink = new MockRightTupleSink();
        RuleImpl rule1 = new RuleImpl("test-rule1");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        InternalAgenda agenda = (InternalAgenda)ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = (DefaultFactHandle)ksession.insert((Object)"o1");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        String logicalString = new String("logical");
        InternalFactHandle logicalHandle = (InternalFactHandle)ksession.insert((Object)logicalString, null, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        context1.setFactHandle((FactHandle)handle1);
        node.retractLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        ksession.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Object[] values = (Object[])sink.getRetracted().get(0);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        logicalHandle = (InternalFactHandle)ksession.insert((Object)logicalString, null, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        agenda.fireNextItem(null, 0, -1);
        node.retractLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        ksession.executeQueuedActions();
        this.assertLength(2, sink.getRetracted());
        values = (Object[])sink.getRetracted().get(1);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
    }

    @Test
    public <M extends ModedAssertion<M>> void testEqualsMap() throws Exception {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Agenda agenda = ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = ksession.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = ksession.insert((Object)logicalString2, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        logicalHandle1 = ksession.insert((Object)logicalString1);
        logicalHandle2 = ksession.insert((Object)logicalString2);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.kBase.getConfiguration().getAssertBehaviour())) {
            Assert.assertNotSame((Object)logicalHandle1, (Object)logicalHandle2);
        } else {
            Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        }
    }

    @Test
    public <M extends ModedAssertion<M>> void testStatedOverride() throws Exception {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Agenda agenda = ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = ksession.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = ksession.insert((Object)logicalString2);
        node.retractLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        Assert.assertEquals((Object)logicalString1, (Object)ksession.getObject(logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)ksession.getObject(logicalHandle2));
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        logicalString2 = new String("logical");
        logicalHandle2 = ksession.insert((Object)logicalString2);
        logicalString1 = new String("logical");
        logicalHandle1 = ksession.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle1);
        logicalHandle1 = ksession.insert((Object)logicalString2, null, false, false, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        node.retractLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        Assert.assertEquals((Object)logicalString1, (Object)ksession.getObject(logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)ksession.getObject(logicalHandle2));
    }

    @Test
    public <M extends ModedAssertion<M>> void testRetract() throws Exception {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context, (InternalWorkingMemory)ksession);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = ksession.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        RuleImpl rule2 = new RuleImpl("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(3), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle2, (LeftTupleSink)node2, true);
        node.assertLeftTuple((LeftTuple)tuple2, context, (InternalWorkingMemory)ksession);
        node2.assertLeftTuple((LeftTuple)tuple2, context, (InternalWorkingMemory)ksession);
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = ksession.insert((Object)logicalString2, null, false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        ksession.retract(logicalHandle1);
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
    }

    @Test
    public <M extends ModedAssertion<M>> void testMultipleLogicalRelationships() {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockRightTupleSink sink = new MockRightTupleSink();
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Agenda agenda = ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        RuleImpl rule2 = new RuleImpl("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle2, (LeftTupleSink)node2, true);
        PropagationContext context2 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node2.assertLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)ksession);
        String logicalString1 = new String("logical");
        InternalFactHandle logicalHandle1 = (InternalFactHandle)ksession.insert((Object)logicalString1, (Object)"value1", false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle1, (RightTupleSink)sink);
        String logicalString2 = new String("logical");
        InternalFactHandle logicalHandle2 = (InternalFactHandle)ksession.insert((Object)logicalString2, (Object)"value2", false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        BeliefSet bs = logicalHandle2.getEqualityKey().getBeliefSet();
        Assert.assertEquals((Object)"value1", (Object)((LogicalDependency)((LinkedListEntry)bs.getFirst()).getObject()).getMode());
        Assert.assertEquals((Object)"value2", (Object)((LogicalDependency)((LinkedListEntry)bs.getFirst().getNext()).getObject()).getMode());
        node2.retractLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)ksession);
        ksession.executeQueuedActions();
        this.assertLength(0, sink.getRetracted());
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        node.retractLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        ksession.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
    }

    @Test
    public <M extends ModedAssertion<M>> void testMultipleAssert() throws Exception {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Agenda agenda = ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        String statedString1 = new String("logical");
        FactHandle statedHandle1 = ksession.insert((Object)statedString1);
        String statedString2 = new String("logical");
        FactHandle statedHandle2 = ksession.insert((Object)statedString2);
        String logicalString3 = new String("logical");
        FactHandle logicalHandle3 = ksession.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle3);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.kBase.getConfiguration().getAssertBehaviour())) {
            ksession.retract(statedHandle2);
            logicalHandle3 = ksession.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
            Assert.assertNull((Object)logicalHandle3);
        }
        ksession.retract(statedHandle1);
        logicalHandle3 = ksession.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNotNull((Object)logicalHandle3);
    }

    @Test
    public <M extends ModedAssertion<M>> void testMutableObject() {
        RuleImpl rule1 = new RuleImpl("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.kBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Agenda agenda = ksession.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), (Mode)dep.getMode());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)handle1, (LeftTupleSink)node, true);
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        Cheese cheese = new Cheese("brie", 10);
        FactHandle cheeseHandle = ksession.insert((Object)cheese, null, false, true, rule1, (Activation)tuple1.getObject());
        cheese.setType("cheddar");
        cheese.setPrice(20);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)ksession.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        ksession.retract(cheeseHandle);
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
        Assert.assertEquals((long)0L, (long)tms.getEqualityKeyMap().size());
    }

    public int getLogicalCount(TruthMaintenanceSystem tms) {
        ObjectHashMap map = tms.getEqualityKeyMap();
        Iterator it = map.iterator();
        int i = 0;
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            EqualityKey key = (EqualityKey)entry.getKey();
            if (key.getStatus() == 2) {
                ++i;
            }
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
        return i;
    }
}

