/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.test.model.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;

@Ignore
public class ObjectTypeNodeTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.kBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
        this.pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    public void testAttach() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        Rete source = this.kBase.getRete();
        ClassObjectType objectType = new ClassObjectType(String.class);
        int id = idGenerator.getNextId();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(id, this.entryPoint, (ObjectType)objectType, this.buildContext);
        Assert.assertEquals((long)id, (long)objectTypeNode.getId());
        Map map = source.getObjectTypeNodes(EntryPointId.DEFAULT);
        Assert.assertEquals((long)0L, (long)map.size());
        objectTypeNode.attach(this.buildContext);
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertSame((Object)objectTypeNode, map.get(objectType));
    }

    @Test
    public void testAssertObject() throws Exception {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        Rete source = this.kBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)ksession.insert((Object)string1);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)ksession);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)ksession.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)ksession.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectSequentialMode() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)conf);
        this.buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        this.buildContext.setObjectTypeNodeMemoryEnabled(false);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        Rete source = kBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)string1);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)((Object[])asserted.get(0))[0])));
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
    }

    @Test
    public void testMemory() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ReteooBuilder.IdGenerator idGenerator = kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)ksession.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testIsAssignableFrom() {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ReteooBuilder.IdGenerator idGenerator = kBase.getReteooBuilder().getIdGenerator();
        Rete source = new Rete(kBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertFalse((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
        objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(Object.class), this.buildContext);
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Object().getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType(new Integer(5).getClass())));
        Assert.assertTrue((boolean)objectTypeNode.isAssignableFrom((ObjectType)new ClassObjectType("string".getClass())));
    }

    @Test
    public void testRetractObject() throws Exception {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ReteooBuilder.IdGenerator idGenerator = kBase.getReteooBuilder().getIdGenerator();
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        Rete source = new Rete(kBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        String string1 = "cheese";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        objectTypeNode.assertObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)ksession);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)ksession.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        objectTypeNode.retractObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)ksession);
        Assert.assertEquals((long)0L, (long)memory.memory.size());
        List retracted = sink.getRetracted();
        this.assertLength(1, retracted);
        Assert.assertSame((Object)handle1, (Object)((Object[])retracted.get(0))[0]);
    }

    @Test
    public void testUpdateSink() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        Rete source = new Rete(kBase);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string1 = "cheese";
        String string2 = "bread";
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)string1);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)string2);
        objectTypeNode.assertObject((InternalFactHandle)handle1, context, (InternalWorkingMemory)workingMemory);
        objectTypeNode.assertObject((InternalFactHandle)handle2, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink1.getAsserted().size());
        MockObjectSink sink2 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink2);
        Assert.assertEquals((long)0L, (long)sink2.getAsserted().size());
        objectTypeNode.updateSink((ObjectSink)sink2, (PropagationContext)new PhreakPropagationContext(), (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)sink2.getAsserted().size());
        String string3 = "water";
        DefaultFactHandle handle3 = new DefaultFactHandle(3, (Object)string3);
        objectTypeNode.assertObject((InternalFactHandle)handle3, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)sink1.getAsserted().size());
        Assert.assertEquals((long)3L, (long)sink2.getAsserted().size());
    }

    @Test
    public void testAssertObjectWithShadowEnabled() throws Exception {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        Rete source = kBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        entryPoint.addObjectSink((ObjectSink)objectTypeNode);
        Cheese cheese = new Cheese("muzzarela", 5);
        InternalFactHandle handle1 = (InternalFactHandle)workingMemory.insert((Object)cheese);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)cheese, (Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject());
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)workingMemory.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }

    @Test
    public void testAssertObjectWithShadowEnabledNoDefaultConstr() throws Exception {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ReteooBuilder.IdGenerator idGenerator = kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        Rete source = kBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)source, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), entryPoint, (ObjectType)new ClassObjectType(Person.class), this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        Person person = new Person("bob", 25);
        InternalFactHandle handle1 = (InternalFactHandle)ksession.insert((Object)person);
        objectTypeNode.assertObject(handle1, context, (InternalWorkingMemory)ksession);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Assert.assertEquals((Object)((InternalFactHandle)((Object[])asserted.get(0))[0]).getObject(), (Object)person);
        ObjectTypeNode.ObjectTypeNodeMemory memory = (ObjectTypeNode.ObjectTypeNodeMemory)ksession.getNodeMemory((MemoryFactory)objectTypeNode);
        Assert.assertEquals((long)1L, (long)memory.memory.size());
        Assert.assertTrue((boolean)memory.memory.contains((Object)handle1));
    }
}

