/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.drools.compiler.CommonTestMethodBase;
import org.drools.compiler.Person;
import org.drools.core.io.impl.ByteArrayResource;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.io.ResourceFactory;

public class AnnotationsTest
extends CommonTestMethodBase {
    @Test
    public void annotationTest() {
        String drl = "package org.drools.compiler.test;\n import org.kie.api.definition.type.Position; \n import " + AnnotationsTest.class.getCanonicalName() + "; \n" + "import " + Annot.class.getCanonicalName() + "; \n" + "" + "declare AnnotatedBean \n" + " @Deprecated \n" + "" + " @Annot( intProp=7 " + "         ,typeProp=String.class " + "         ,strProp=\"hello world\" " + "         ,enumProp=AnnPropEnum.THREE " + "         ,dblArrProp={1.0,2.0} " + "         ,typeArrProp={String.class, AnnotationsTest.class} " + "         ,strArrProp={\"x1\",\"x2\"} " + "         ,enumArrProp={AnnPropEnum.ONE, AnnPropEnum.THREE} " + "         ) \n " + " \n " + " @role(event) \n " + " " + " age : int \n" + " name : String      @key    @Position(0)    @Deprecated \n" + " end \n " + " " + " \n\n" + " " + "declare SecondBean \n " + " @NonexistingAnnotation" + "  \n" + " field : String @Annot \n" + "end \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{drl});
        Class clazz = kbase.getFactType("org.drools.compiler.test", "AnnotatedBean").getFactClass();
        AnnotationsTest.assertNotNull((Object)clazz);
        try {
            Field fld = clazz.getDeclaredField("name");
            AnnotationsTest.assertEquals((long)3L, (long)fld.getAnnotations().length);
            AnnotationsTest.assertNotNull((Object)fld.getAnnotation(Deprecated.class));
            AnnotationsTest.assertNotNull((Object)fld.getAnnotation(Position.class));
            AnnotationsTest.assertNotNull((Object)fld.getAnnotation(Key.class));
            Position pos = fld.getAnnotation(Position.class);
            AnnotationsTest.assertEquals((long)0L, (long)pos.value());
        }
        catch (NoSuchFieldException nsfe) {
            AnnotationsTest.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Annotation[] anns = clazz.getAnnotations();
        AnnotationsTest.assertEquals((long)3L, (long)anns.length);
        AnnotationsTest.assertNotNull((Object)clazz.getAnnotation(Deprecated.class));
        AnnotationsTest.assertNotNull((Object)clazz.getAnnotation(Annot.class));
        AnnotationsTest.assertNotNull((Object)clazz.getAnnotation(Role.class));
        Annot ann = clazz.getAnnotation(Annot.class);
        AnnotationsTest.assertEquals((long)7L, (long)ann.intProp());
        AnnotationsTest.assertEquals(String.class, (Object)ann.typeProp());
        AnnotationsTest.assertEquals((Object)"hello world", (Object)ann.strProp());
        AnnotationsTest.assertEquals((Object)((Object)AnnPropEnum.THREE), (Object)((Object)ann.enumProp()));
        AnnotationsTest.assertArrayEquals((double[])new double[]{1.0, 2.0}, (double[])ann.dblArrProp(), (double)1.0E-16);
        AnnotationsTest.assertArrayEquals((Object[])new Class[]{String.class, AnnotationsTest.class}, (Object[])ann.typeArrProp());
        AnnotationsTest.assertArrayEquals((Object[])new String[]{"x1", "x2"}, (Object[])ann.strArrProp());
        AnnotationsTest.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.ONE, AnnPropEnum.THREE}, (Object[])ann.enumArrProp());
        Class clazz2 = kbase.getFactType("org.drools.compiler.test", "SecondBean").getFactClass();
        AnnotationsTest.assertNotNull((Object)clazz2);
        Annotation[] anns2 = clazz2.getAnnotations();
        AnnotationsTest.assertEquals((long)0L, (long)anns2.length);
        Annot ann2 = null;
        try {
            Field fld2 = clazz2.getDeclaredField("field");
            AnnotationsTest.assertEquals((long)1L, (long)fld2.getAnnotations().length);
            AnnotationsTest.assertNotNull((Object)fld2.getAnnotation(Annot.class));
            ann2 = fld2.getAnnotation(Annot.class);
        }
        catch (NoSuchFieldException nsfe) {
            AnnotationsTest.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        AnnotationsTest.assertNotNull(ann2);
        AnnotationsTest.assertEquals((long)0L, (long)ann2.intProp());
        AnnotationsTest.assertEquals((Object)"foo", (Object)ann2.strProp());
        AnnotationsTest.assertEquals((Object)((Object)AnnPropEnum.ONE), (Object)((Object)ann2.enumProp()));
        AnnotationsTest.assertArrayEquals((double[])new double[]{0.4, 0.5}, (double[])ann2.dblArrProp(), (double)1.0E-16);
        AnnotationsTest.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ann2.strArrProp());
        AnnotationsTest.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.TWO, AnnPropEnum.THREE}, (Object[])ann2.enumArrProp());
    }

    @Test
    public void annotationErrorTest() {
        String drl = "package org.drools.compiler.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n ";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        AnnotationsTest.assertEquals((long)0L, (long)kbuilder.getErrors().size());
        String drl2 = "package org.drools.compiler.test;\n import " + Annot.class.getCanonicalName() + "; \n" + "" + "" + "declare MissingAnnotationBean \n" + " @Annot( wrongProp1 = 1 ) \n" + "" + " name : String      @Annot( wrongProp2 = 2, wrongProp3 = 3 ) \n" + " end \n ";
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add((Resource)new ByteArrayResource(drl2.getBytes()), ResourceType.DRL);
        AnnotationsTest.assertEquals((long)4L, (long)kbuilder2.getErrors().size());
    }

    @Test
    public void testRuleAnnotation() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Person.class.getCanonicalName() + "; \n" + "rule X\n" + "    @author(\"John Doe\")\n" + "    @output(Hello World!)\n" + "    @value( 10 + 10 )\n" + "    @alt( \"Hello \"+\"World!\" )\n" + "when\n" + "    Person()\n" + "then\n" + "end";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KieBaseOption)MBeansOption.ENABLED);
        conf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        KnowledgeBase kbase = this.loadKnowledgeBase("kb1", drl, conf);
        Rule rule = kbase.getRule("org.drools.compiler.integrationtests", "X");
        Assert.assertEquals((Object)"John Doe", rule.getMetaData().get("author"));
        Assert.assertEquals((Object)"Hello World!", rule.getMetaData().get("output"));
        Assert.assertEquals((long)20L, (long)((Number)rule.getMetaData().get("value")).intValue());
        Assert.assertEquals((Object)"Hello World!", rule.getMetaData().get("alt"));
    }

    @Test
    public void testRuleAnnotation2() {
        String drl = "package org.drools.compiler.integrationtests\nimport " + Person.class.getCanonicalName() + "; \n" + "rule X\n" + "    @alt(\" \\\"<- these are supposed to be the only quotes ->\\\" \")\n" + "when\n" + "    Person()\n" + "then\n" + "end";
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KieBaseOption)MBeansOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBase("kb1", drl, conf);
        Rule rule = kbase.getRule("org.drools.compiler.integrationtests", "X");
        Assert.assertEquals((Object)" \"<- these are supposed to be the only quotes ->\" ", rule.getMetaData().get("alt"));
    }

    private KnowledgeBase loadKnowledgeBase(String id, String drl, KieBaseConfiguration conf) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)id, (KieBaseConfiguration)conf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Annot {
        public int intProp() default 0;

        public Class typeProp();

        public String strProp() default "foo";

        public AnnPropEnum enumProp() default AnnPropEnum.ONE;

        public double[] dblArrProp() default {0.4, 0.5};

        public Class[] typeArrProp();

        public String[] strArrProp() default {"a", "b", "c"};

        public AnnPropEnum[] enumArrProp() default {AnnPropEnum.TWO, AnnPropEnum.THREE};
    }

    public static enum AnnPropEnum {
        ONE("one"),
        TWO("two"),
        THREE("three");

        private String value;

        private AnnPropEnum(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

