/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.StockTick;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MultithreadTest
extends CommonTestMethodBase {
    @Test(timeout=10000L)
    public void testConcurrentInsertions() {
        String str = "import org.drools.compiler.integrationtests.MultithreadTest.Bean\n\nrule \"R\"\nwhen\n    $a : Bean( seed != 1 )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        int OBJECT_NR = 1000;
        int THREAD_NR = 4;
        ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
        for (int i = 0; i < 4; ++i) {
            ecs.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        FactHandle[] facts = new FactHandle[1000];
                        for (int i = 0; i < 1000; ++i) {
                            facts[i] = ksession.insert((Object)new Bean(i));
                        }
                        ksession.fireAllRules();
                        for (FactHandle fact : facts) {
                            ksession.retract(fact);
                        }
                        ksession.fireAllRules();
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        boolean success = true;
        for (int i = 0; i < 4; ++i) {
            try {
                success = (Boolean)ecs.take().get() != false && success;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MultithreadTest.assertTrue((boolean)success);
        ksession.dispose();
    }

    @Test(timeout=60000L)
    public void testSlidingTimeWindows() {
        String str = "package org.drools\nglobal java.util.List list; \nimport org.drools.compiler.StockTick; \ndeclare StockTick @role(event) end\nrule R\nwhen\n accumulate( $st : StockTick() over window:time(400ms)\n             from entry-point X,\n             $c : count(1) )then\n   list.add( $c ); \nend \n";
        final ArrayList<Exception> errors = new ArrayList<Exception>();
        KieBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        kbconf.setOption((KieBaseOption)RuleEngineOption.RETEOO);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbconf, str);
        final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final EntryPoint ep = ksession.getEntryPoint("X");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        int RUN_TIME = 5000;
        int THREAD_NR = 2;
        ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
        ecs.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    ksession.fireUntilHalt();
                    return true;
                }
                catch (Exception e) {
                    errors.add(e);
                    e.printStackTrace();
                    return false;
                }
            }
        });
        for (int i = 0; i < 2; ++i) {
            ecs.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        String s = Thread.currentThread().getName();
                        long endTS = System.currentTimeMillis() + 5000L;
                        int j = 0;
                        long lastTimeInserted = -1L;
                        while (System.currentTimeMillis() < endTS) {
                            long currentTimeInMillis = System.currentTimeMillis();
                            if (currentTimeInMillis <= lastTimeInserted) continue;
                            lastTimeInserted = currentTimeInMillis;
                            ep.insert((Object)new StockTick((long)j++, s, 0.0, 0L));
                        }
                        return true;
                    }
                    catch (Exception e) {
                        errors.add(e);
                        e.printStackTrace();
                        return false;
                    }
                }
            });
        }
        boolean success = true;
        for (int i = 0; i < 2; ++i) {
            try {
                success = (Boolean)ecs.take().get() != false && success;
                continue;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        ksession.halt();
        try {
            success = (Boolean)ecs.take().get() != false && success;
        }
        catch (Exception e) {
            errors.add(e);
        }
        for (Exception e : errors) {
            e.printStackTrace();
        }
        MultithreadTest.assertTrue((boolean)errors.isEmpty());
        MultithreadTest.assertTrue((boolean)success);
        MultithreadTest.assertTrue((!list.isEmpty() && ((Number)list.get(list.size() - 1)).intValue() > 400 ? 1 : 0) != 0);
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testClassLoaderRace() throws InterruptedException {
        String drl = "package org.drools.integrationtests;\nrule \"average temperature\"\nwhen\n $avg := Number( ) from accumulate (       $x : Integer ( );       average ($x) )\nthen\n  System.out.println( $avg );\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        final StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Thread t = new Thread(){

            @Override
            public void run() {
                session.fireUntilHalt();
            }
        };
        t.start();
        session.fireAllRules();
        for (int j = 0; j < 100; ++j) {
            session.insert((Object)j);
        }
        try {
            Thread.sleep(1000L);
            System.out.println("Halting ..");
            session.halt();
        }
        catch (Exception e) {
            MultithreadTest.fail((String)e.getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testRaceOnAccumulateNodeSimple() throws InterruptedException {
        long LIMIT;
        String drl = "package org.drools.integrationtests;\nimport org.drools.compiler.integrationtests.MultithreadTest.IntEvent; \nimport org.drools.compiler.integrationtests.MultithreadTest.Server; \ndeclare IntEvent\n  @role ( event )\n  @expires( 15s )\nend\n\nrule \"average temperature\"\nwhen\n  $s : Server (hostname == \"hiwaesdk\")\n $avg := Number( ) from accumulate (       IntEvent ( $temp : data ) over window:length(10) from entry-point ep01,       average ($temp)\n  )\nthen\n  $s.avgTemp = $avg.intValue();\n  System.out.println( $avg );\nend\n\n";
        KieBaseConfiguration kbconfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbconfig, drl);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        EntryPoint ep01 = session.getEntryPoint("ep01");
        Runner t = new Runner(session);
        t.start();
        Thread.sleep(1000L);
        Server hiwaesdk = new Server("hiwaesdk");
        session.insert((Object)hiwaesdk);
        for (long i = LIMIT = 20L; i > 0L; --i) {
            ep01.insert((Object)new IntEvent((int)i));
            if (i % 1000L != 0L) continue;
            System.out.println(i);
        }
        try {
            Thread.sleep(1000L);
            System.out.println("Halting ..");
            session.halt();
        }
        catch (Exception e) {
            MultithreadTest.fail((String)e.getMessage());
        }
        if (t.getError() != null) {
            MultithreadTest.fail((String)t.getError().getMessage());
        }
    }

    @Test
    @Ignore
    public void testConcurrencyWithChronThreads() throws InterruptedException {
        String drl = "package it.intext.drools.fusion.bug;\n\nimport org.drools.compiler.integrationtests.MultithreadTest.MyFact;\n global java.util.List list; \n\ndeclare MyFact\n\t@role( event )\n\t@expires( 1s )\nend\n\nrule \"Dummy\"\ntimer( cron: 0/1 * * * * ? )\nwhen\n  Number( $count : intValue ) from accumulate( MyFact( ) over window:time(1s), sum(1) )\nthen\n    System.out.println($count+\" myfact(s) seen in the last 1 seconds\");\n    list.add( $count ); \nend";
        KieBaseConfiguration kbconfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbconfig.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbconfig, drl);
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)"REALTIME"));
        final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Runner t = new Runner(ksession);
        t.start();
        int FACTS_PER_POLL = 1000;
        int POLL_INTERVAL = 500;
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (int j = 0; j < 1000; ++j) {
                    ksession.insert((Object)new MyFact());
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
        Thread.sleep(10200L);
        executor.shutdownNow();
        ksession.halt();
        t.join();
        if (t.getError() != null) {
            MultithreadTest.fail((String)t.getError().getMessage());
        }
        System.out.println("Final size " + ksession.getObjects().size());
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testConcurrentQueries() {
        StringBuilder drl = new StringBuilder();
        drl.append("package org.drools.test;\nquery foo( ) \n   Object() from new Object() \nend\nrule XYZ when then end \n");
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.toString().getBytes()), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(knowledgeBuilder.getKnowledgePackages());
        final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        int THREAD_NR = 5;
        ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(executor);
        for (int i = 0; i < 5; ++i) {
            ecs.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean succ = false;
                    try {
                        QueryResults res = ksession.getQueryResults("foo", new Object[]{Variable.v});
                        succ = res.size() == 1;
                        return succ;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return succ;
                    }
                }
            });
        }
        boolean success = true;
        for (int i = 0; i < 5; ++i) {
            try {
                success = (Boolean)ecs.take().get() != false && success;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MultithreadTest.assertTrue((boolean)success);
        ksession.dispose();
    }

    public static class Runner
    extends Thread {
        private final StatefulKnowledgeSession ksession;
        private Throwable error;

        public Runner(StatefulKnowledgeSession ksession) {
            this.ksession = ksession;
        }

        @Override
        public void run() {
            try {
                this.ksession.fireUntilHalt();
            }
            catch (Throwable t) {
                this.error = t;
                throw new RuntimeException(t);
            }
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class MyFact {
        Date timestamp = new Date();
        String id = UUID.randomUUID().toString();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public class Server {
        public int currentTemp;
        public double avgTemp;
        public String hostname;
        public int readingCount;

        public Server(String hiwaesdk) {
            this.hostname = hiwaesdk;
        }

        public String toString() {
            return "Server{currentTemp=" + this.currentTemp + ", avgTemp=" + this.avgTemp + ", hostname='" + this.hostname + '\'' + '}';
        }
    }

    public static class IntEvent {
        private int data;

        public IntEvent(int j) {
            this.data = j;
        }

        public int getData() {
            return this.data;
        }

        public void setData(int data) {
            this.data = data;
        }
    }

    public static class Bean {
        private int seed;

        public Bean(int seed) {
            this.seed = seed;
        }

        public int getSeed() {
            return this.seed;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Bean)) {
                return false;
            }
            return this.seed == ((Bean)other).seed;
        }

        public int hashCode() {
            return this.seed;
        }

        public String toString() {
            return "Bean nr. " + this.seed;
        }
    }
}

