/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockEvalCondition;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.KnowledgeBaseFactory;

@Ignore
public class EvalConditionNodeTest
extends DroolsTestCase {
    private PropagationContext context;
    private StatefulKnowledgeSessionImpl workingMemory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;

    @Before
    public void setUp() {
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        PropagationContextFactory pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = pctxFactory.createPropagationContext(0L, 0, null, null, null);
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
    }

    @Test
    public void testAttach() throws Exception {
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        Assert.assertEquals((long)18L, (long)node.getId());
        Assert.assertEquals((long)0L, (long)source.getAttached());
        node.attach(this.buildContext);
        Assert.assertEquals((long)1L, (long)source.getAttached());
    }

    @Test
    public void testMemory() {
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)workingMemory.getNodeMemory((MemoryFactory)node);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testAssertedAllowed() {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
    }

    @Test
    public void testAssertedAllowedThenRetract() {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
        node.retractLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getRetracted().size());
        node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getRetracted().size());
    }

    @Test
    public void testAssertedNotAllowed() {
        MockEvalCondition eval = new MockEvalCondition(false);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.workingMemory.getNodeMemory((MemoryFactory)node);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        Assert.assertEquals((long)0L, (long)sink.getRetracted().size());
    }

    @Test
    public void testDoRemove() {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode parent = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        EvalConditionNode node = new EvalConditionNode(2, (LeftTupleSource)parent, (EvalCondition)eval, this.buildContext);
        parent.addTupleSink((LeftTupleSink)node);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl parentTuple = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        LeftTuple tuple0 = sink.createLeftTuple((LeftTuple)parentTuple, (LeftTupleSink)sink, null, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
    }
}

