/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.drools.compiler.Address;
import org.drools.compiler.Cheese;
import org.drools.compiler.Person;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.ClassObjectFilter;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.conflict.SalienceConflictResolver;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.util.FileManager;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.event.kiebase.DefaultKieBaseEventListener;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.RuleEngineOption;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Misc2Test
extends CommonTestMethodBase {
    private static final Logger logger = LoggerFactory.getLogger(Misc2Test.class);

    @Test
    public void testUpdateWithNonEffectiveActivations() throws Exception {
        String str = "package inheritance\n\nimport org.drools.compiler.Address\n\nrule \"Parent\"\n    enabled false\n    when \n        $a : Address(suburb == \"xyz\")\n    then \n        System.out.println( $a ); \nend \nrule \"Child\" extends \"Parent\" \n    when \n        $b : Address( this == $a, street == \"123\")\n    then \n        System.out.println( $b ); \nend";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (builder.hasErrors()) {
            throw new RuntimeException(builder.getErrors().toString());
        }
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
        knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        Address address = new Address();
        address.setSuburb("xyz");
        FactHandle addressHandle = ksession.insert((Object)address);
        int rulesFired = ksession.fireAllRules();
        Misc2Test.assertEquals((long)0L, (long)rulesFired);
        address.setStreet("123");
        ksession.update(addressHandle, (Object)address);
        rulesFired = ksession.fireAllRules();
        System.out.println(rulesFired);
        Misc2Test.assertEquals((long)1L, (long)rulesFired);
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassNotFoundAfterDeserialization() throws Exception {
        String drl = "package completely.other.deal;\n\ndeclare Person\n   firstName : String\n   lastName : String\nend\n\nrule \"now use it B\"\n   when\n       Person( $christianName, $surname; )\n   then\n       insert( new Person( $christianName, null ) );\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("" + kbuilder.getErrors());
        }
        FileManager fileManager = new FileManager().setUp();
        try {
            File root = fileManager.getRootDirectory();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(root, "test.drl.compiled")));
            out.writeObject(kbuilder.getKnowledgePackages());
            out.close();
            KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
            kconf.setOption((KieBaseOption)RuleEngineOption.PHREAK);
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kconf);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(root, "test.drl.compiled")));
            kbase.addKnowledgePackages((Collection)in.readObject());
            in.close();
        }
        finally {
            fileManager.tearDown();
        }
    }

    @Test
    public void testAnalyzeConditionWithVariableRegExp() throws Exception {
        String str = "dialect \"mvel\"\n\ndeclare Person\n   name : String\nend\ndeclare Stuff\n   regexp : String\nend\n\nrule \"Test Regex\"\n   salience 100\n    when\n    then\n       insert (new Stuff(\"Test\"));\n       insert (new Person(\"Test\"));\nend\n\nrule \"Test Equality\"\n   salience 10\n    when\n       Stuff( $regexp : regexp )\n        Person( name matches $regexp )\n        //Person( name matches \"Test\" )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testShareAlphaNodesRegardlessDoubleOrSingleQuotes() {
        String str = "declare RecordA\n   id : long\nend\n\ndeclare RecordB\n   id : long\nrole : String\nend\n\nrule \"insert data 1\"\n   salience 10\n   when\n   then\n       insert (new RecordA(100));\n       insert (new RecordB(100, \"1\"));\n       insert (new RecordB(100, \"2\"));\nend\n\nrule \"test 1\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == '1' )\n   then\nend\n\nrule \"test 2\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == \"1\" )\n   then\nend\n\nrule \"test 3\"\n   when\n       a : RecordA( )\n       b : RecordB( id == b.id, role == \"2\" )\n   then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)4L, (long)ksession.fireAllRules());
    }

    @Test
    public void testEvalBeforeNot() throws Exception {
        String str = "package org.drools.compiler.integration; \nimport " + A.class.getCanonicalName() + ";\n" + "global java.util.List list;\n" + "\n" + "rule r1\n" + "   salience 10\n" + "   when\n" + "      eval( list.size() == 0 || list.size() == 1 ) \n" + "      not  A( )" + "   then\n" + "       list.add('xxx');\n" + "end\n" + "\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertEquals((Object)"xxx", list.get(0));
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)true);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertEquals((Object)"xxx", list.get(0));
    }

    @Test
    public void testKnowledgeBaseEventSupportLeak() throws Exception {
        KnowledgeBase kbase = this.getKnowledgeBase();
        DefaultKieBaseEventListener listener = new DefaultKieBaseEventListener();
        kbase.addEventListener((KieBaseEventListener)listener);
        kbase.addEventListener((KieBaseEventListener)listener);
        Misc2Test.assertEquals((long)1L, (long)((InternalKnowledgeBase)kbase).getKieBaseEventListeners().size());
        kbase.removeEventListener((KieBaseEventListener)listener);
        Misc2Test.assertEquals((long)0L, (long)((InternalKnowledgeBase)kbase).getKieBaseEventListeners().size());
    }

    @Test
    public void testReuseAgendaAfterException() throws Exception {
        String str = "import org.drools.compiler.Person;\nglobal java.util.List results;rule R1\nruleflow-group \"test\"\nwhen\n   Person( $age : age ) \nthen\n   if ($age > 40) throw new RuntimeException(\"Too old\");\n   results.add(\"OK\");end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList res = new ArrayList();
        ksession.setGlobal("results", res);
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                ksession.fireAllRules();
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }
        };
        ksession.addEventListener(agendaEventListener);
        FactHandle fact1 = ksession.insert((Object)new Person("Mario", 38));
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)res.size());
        res.clear();
        ksession.retract(fact1);
        FactHandle fact2 = ksession.insert((Object)new Person("Mario", 48));
        try {
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
            ksession.fireAllRules();
            Misc2Test.fail((String)"should throw an Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        ksession.retract(fact2);
        Misc2Test.assertEquals((long)0L, (long)res.size());
        FactHandle fact3 = ksession.insert((Object)new Person("Mario", 38));
        ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("test");
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)res.size());
        ksession.retract(fact3);
        ksession.dispose();
    }

    @Test
    public void testBooleanPropertyStartingWithEmpty() {
        String str = "declare Fact\n   emptyx : boolean\nend\n\nrule \"R1\"\n   when\n   Fact(emptyx == false)   then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
    }

    @Test
    public void testMVELForLoop() throws Exception {
        String str = "rule demo\ndialect \"mvel\"\nwhen\nthen\n   for ( int i = 1; i <= 3; i++ ) {\n       insert( \"foo\" + i );\n   }\nend";
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (builder.hasErrors()) {
            throw new RuntimeException(builder.getErrors().toString());
        }
    }

    @Test
    public void testBigDecimalComparison() throws Exception {
        String str = "import org.drools.compiler.Person;\nrule \"Big Decimal Comparison\"\n    dialect \"mvel\"\nwhen\n    Person( bigDecimal == 0.0B )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p = new Person("Mario", 38);
        p.setBigDecimal(new BigDecimal("0"));
        ksession.insert((Object)p);
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test(timeout=5000L)
    public void testInfiniteLoopCausedByInheritance() throws Exception {
        String str = "declare Parent\n    active : boolean\nend\n \ndeclare Child extends Parent\nend\n \nrule \"Init\"\nwhen\nthen\n    insert( new Child( false ) );\nend\n \nrule \"Print\"\nwhen\n    $g : Child( active == true )\nthen\nend\n \n \nrule \"Switch\"\nwhen\n    $item : Parent( active == false )\nthen\n    modify ( $item ) {\n            setActive( true );\n    }\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
    }

    @Test
    public void testIntSorting() {
        String str = "global java.util.List list\nrule R\ndialect \"mvel\"\nwhen\n   $number : Number()\n   not Number(intValue < $number.intValue)\nthen\n   list.add($number);\n   retract($number);\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.insert((Object)6);
        ksession.insert((Object)4);
        ksession.insert((Object)1);
        ksession.insert((Object)2);
        ksession.fireAllRules();
        Misc2Test.assertEquals(Arrays.asList(1, 2, 4, 5, 6), list);
    }

    @Test
    public void testIntSorting2() {
        String str = "global java.util.List list\nrule R\ndialect \"mvel\"\nwhen\n   $number : Number()\n   not Number(intValue > $number.intValue)\nthen\n   list.add($number);\n   retract($number);\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)3);
        ksession.insert((Object)7);
        ksession.insert((Object)4);
        ksession.insert((Object)5);
        ksession.insert((Object)2);
        ksession.insert((Object)1);
        ksession.insert((Object)6);
        ksession.fireAllRules();
        Misc2Test.assertEquals(Arrays.asList(7, 6, 5, 4, 3, 2, 1), list);
    }

    @Test(timeout=5000L)
    public void testPropertyReactiveOnAlphaNodeFollowedByAccumulate() {
        String str = "package org.drools.pmml.pmml_4_1.test;\n\ndeclare Charge\n    context     : String\n    index       : String = \"-1\"\n    source      : String = \"-1\"\n    value       : double\nend\n\ndeclare Neuron\n@propertyReactive\n    context     : String            @key\n    index       : String            @key\n    layerIndex  : int\n    bias        : double\n    fanIn       : int\n    value       : double\n    dvalue      : double\n    normalized  : boolean\nend\n\nrule \"LinkSynapses\"\nwhen\nthen\n    Charge c = new Charge();\n    c.setContext( \"MockCold\" );\n    c.setSource( \"0\" );\n    c.setIndex( \"1\" );\n    c.setValue( 0.43 );\n    insert(c);\nend\n\nrule \"NeuralFire_MockCold_Layer0\"\nwhen\n    $neur : Neuron( context == \"MockCold\",\n                    layerIndex == 0\n                  )\n    accumulate( $c : Charge( context == \"MockCold\", index == $neur.index, $in : value ),\n                $list : collectList( $c ),\n                $val : sum( $in );\n                $list.size() == $neur.fanIn )\nthen\n    double x = 1.0; // $neur.getBias() + $val.doubleValue();\n    modify ( $neur ) {\n        setValue( x );\n    }\nend\n\nrule \"BuildNeurons_MockCold_Layer0\"\nwhen\nthen\n    insert( new Neuron( \"MockCold\",\n                               \"1\",\n                               0,\n                               1.0,\n                               1,\n                               0.0,\n                               0.0,\n                               true\n                             ) );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPropertyReactiveAccumulateModification() {
        String str = "package org.drools.compiler.test;\n\ndeclare Neuron\n@propertyReactive\n  id : int\n  value : double\nend\n\ndeclare Charge\n  nId : int\n  val : double\nend\n\nrule \"Log 2\"\nsalience 9999\nwhen\n  $n : Object();\nthen\nend\nrule \"Update\"\nsalience -9999\nwhen\n  $c : Charge( val == 1.0 );\nthen\n  modify ( $c ) {     setVal( 2.0 ); \n } \nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new Neuron( 0, 0.0 ) );\n  insert( new Charge( 0, 1.0 ) );\nend\n\nrule \"Modify\"\nsalience -100\nwhen\n  $n : Neuron( )\n  accumulate( Charge( $v : val ), $x : sum( $v ) )\nthen\n  modify ( $n ) {\n    setValue( $x.doubleValue() );\n  }\nend\n\nrule \"Watch\"\nwhen\n   $n : Neuron() @watch( value )then\nend\n\nquery getNeuron\n  Neuron( $value : value )\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        Misc2Test.assertEquals((Object)2.0, (Object)((QueryResultsRow)ksession.getQueryResults("getNeuron", new Object[0]).iterator().next()).get("$value"));
    }

    @Test
    public void testMvelAssignmentToPublicField() {
        String str = "import " + Foo.class.getCanonicalName() + "\n" + "rule R\n" + "dialect \"mvel\"\n" + "when\n" + "   $foo : Foo()\n" + "then\n" + "   $foo.x = 1;\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Foo foo1 = new Foo();
        Foo foo2 = new Foo();
        ksession.insert((Object)foo1);
        ksession.insert((Object)foo2);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)foo1.x);
        Misc2Test.assertEquals((long)1L, (long)foo2.x);
    }

    @Test
    public void testMvelInvokeAsList() {
        String str = "import java.util.List;\nimport java.util.Arrays;\nimport java.util.ArrayList;\n\ndeclare Project\n@typesafe (false)\n        list1 : List\n        list2 : List\nend\n\nrule kickoff\nsalience 999999\nwhen\nthen\n    insert( new Project() );\n    insert( new Project() );   // necessary to trigger the exception\nend\n\nrule \" Config rule \"\ndialect \"mvel\"\nno-loop true\nwhen\n    P : Project()\nthen\n    modify(P) {\n       list1 = Arrays.asList(10, 15, 20, 25),\n       list2 = Arrays.asList(11, 2, 3, 4, 5, 10, 9, 8, 7)\n    };\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
    }

    @Test
    public void testDynamicAddRule() {
        String str = "import " + A.class.getCanonicalName() + "\n" + "rule r1 when\n" + "    $a : A( f1 == 1 )\n" + "then\n" + "end\n" + "\n" + "rule r2 when\n" + "    $a : A( f2 == 1 )\n" + "then\n" + "end\n" + "\n" + "rule r3 when\n" + "    $a : A( f3 == 1 )" + "then\n" + "end";
        String str2 = "import " + A.class.getCanonicalName() + "\n" + "rule r4 when\n" + "    $a : A( f2 == 1, f4 == 1 )" + "then\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactHandle fh = ksession.insert((Object)new A(1, 1, 1, 1));
        ksession.fireAllRules();
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(str2));
        ksession.fireAllRules();
        ksession.insert((Object)new A(2, 2, 2, 2));
        LeftTuple leftTuple = ((DefaultFactHandle)fh).getFirstLeftTuple();
        ObjectTypeNode.Id letTupleOtnId = leftTuple.getLeftTupleSink().getLeftInputOtnId();
        for (leftTuple = leftTuple.getLeftParentNext(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            Misc2Test.assertTrue((boolean)letTupleOtnId.before(leftTuple.getLeftTupleSink().getLeftInputOtnId()));
            letTupleOtnId = leftTuple.getLeftTupleSink().getLeftInputOtnId();
        }
    }

    @Test
    public void testNumberCoercionOnNonGenericMap() {
        String str = "package com.ilesteban.jit;\n\nimport java.util.Map;\nimport java.util.EnumMap;\nimport " + Parameter.class.getCanonicalName() + "\n" + "import " + DataSample.class.getCanonicalName() + "\n" + "import " + DataSample.class.getCanonicalName() + "\n" + "\n" + "declare TestObject\n" + "    data    :   java.util.Map\n" + "end\n" + "\n" + "rule \"Rule 1\"\n" + "when\n" + "    $d: DataSample()\n" + "then\n" + "    //create a new object copying the Map<Parameter, Double> to a Map<Object, Object>\n" + "    insert( new TestObject($d.getValues()));\n" + "end\n" + "\n" + "rule \"Rule 2\"\n" + "when\n" + "    TestObject(data[Parameter.PARAM_A] > 3)\n" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        EnumMap<Parameter, Double> values = new EnumMap<Parameter, Double>(Parameter.class);
        values.put(Parameter.PARAM_A, 4.0);
        DataSample data = new DataSample();
        data.setValues(values);
        ksession.insert((Object)data);
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPropertyReactivityWithNestedAccessorsInModify() {
        String str = "package com.ilesteban.rulenotbeingfired;\n\nimport java.util.Map;\nimport java.util.EnumMap;\nimport " + Parameter.class.getCanonicalName() + "\n" + "import " + DataSample.class.getCanonicalName() + "\n" + "\n" + "declare Recommendation\n" + "    parameter : Parameter\n" + "    value : double\n" + "end\n" + "\n" + "rule \"Init\" salience 100\n" + "when\n" + "then\n" + "    insert(new Recommendation(Parameter.PARAM_A, 1.0));" + "end\n" + "rule \"Rule 1\"\n" + "when\n" + "    $d: DataSample()\n" + "    $re: Recommendation ($p: parameter, $v: value)\n" + "then\n" + "    System.out.println(drools.getRule().getName());\n" + "    modify($d){\n" + "        addValue($re.getParameter(), $re.getValue())\n" + "    }\n" + "end\n" + "\n" + "rule \"Data with messages\"\n" + "salience -100\n" + "when\n" + "    $d: DataSample(notEmpty == true)\n" + "then\n" + "    System.out.println(drools.getRule().getName());\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new DataSample());
        Misc2Test.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testMvelResolvingGenericVariableDeclaredInParentClass() {
        String str = "import " + AbstractBase.class.getCanonicalName() + "\n" + "import " + StringConcrete.class.getCanonicalName() + "\n" + "rule \"test\"\n" + "dialect \"mvel\"\n" + "when\n" + "$S : StringConcrete()\n" + "then\n" + "$S.getFoo().concat(\"this works with java dialect\");\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
    }

    @Test
    public void testMvelParsingParenthesisInString() {
        String str = "rule \"Test Rule\"\ndialect \"mvel\"\nwhen\nthen\nString s = new String(\"write something with ) a paren\");\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
    }

    @Test
    public void testCompilationMustFailComparingAClassLiteral() {
        String str = "import Misc2Test.Answer\nimport Misc2Test.AnswerGiver\nrule \"Test Rule\"\nwhen\n   AnswerGiver(Answer == Answer.YES)\nthen\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testDeclaredTypeExtendingInnerClass() {
        String str = "import " + StaticPerson.class.getCanonicalName() + "\n" + "declare StaticPerson end\n" + "declare Student extends StaticPerson end\n" + "rule Init when\n" + "then\n" + "    Student s = new Student();\n" + "    s.setName( \"Mark\" );\n" + "    insert( s );\n" + "end\n" + "rule Check when\n" + "    StaticPerson( name == \"Mark\")\n" + "then\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAllowEqualityBetweenObjectAndPrimitiveInt() {
        String str = "declare Bean\n  items : int\nend\n\nrule \"O\"\nwhen\nthen\n  insert( new Bean( 2 ) );\nend\n\nrule \"X\"\nwhen\n   Bean( $num : items ) \n   accumulate( $o : Object(),\n     $list : collectList( $o );\n     $list.size == $num   )\nthen\n   System.out.println( \"Success!\" );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testJitConstraintWithOperationOnBigDecimal() {
        String str = "import " + Model.class.getCanonicalName() + "\n" + "import java.math.BigDecimal;\n" + "\n" + "rule \"minCost\" dialect \"mvel\" \n" + "when\n" + "    $product : Model(price < (cost + 0.10B))\n" + "then\n" + "    modify ($product) { price = $product.cost + 0.10B }\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        Model model = new Model();
        model.setCost(new BigDecimal("2.43"));
        model.setPrice(new BigDecimal("2.43"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)model);
        int fired = ksession.fireAllRules(2);
        if (fired > 1) {
            throw new RuntimeException("loop");
        }
    }

    @Test
    public void testJitComparable() {
        String str = "import " + IntegerWrapperImpl.class.getCanonicalName() + "\n" + "\n" + "rule \"minCost\"\n" + "when\n" + "    $a : IntegerWrapperImpl()\n" + "    IntegerWrapperImpl( this < $a )\n" + "then\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new IntegerWrapperImpl(2));
        ksession.insert((Object)new IntegerWrapperImpl(3));
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testEqualityOfDifferentTypes() {
        String str = "declare Person\n  name: String\nend\ndeclare Customer\nextends Person\n  rating: int\nend\ndeclare Employee\nextends Person\n  wage: int\nend\n\nrule initphone\nsalience 100\nwhen\nthen\n    insert( new Customer( \"Joe\", 100 ) );\n    insert( new Employee( \"Paul\", 2100 ) );\nend\n\nrule match\nwhen\n    $c: Customer()\n    $e: Employee( this != $c )\nthen\n    System.out.println( \"c/e \" + $c + \" \" + $e );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
    }

    @Test
    public void testUnificationInRule() {
        String str = "declare A\nend\n\ndeclare B\n inner : A\nend\n\nrule \"Init\"\nwhen\nthen\n  A a = new A();\n  insert( a );\n  insert( new B( a ) );\nend\n\nrule \"Check\"\nwhen\n  B( $in := inner )\n  $in := A()\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( null ) );\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo(\"B\") < 0 )\n        )\n    )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR2() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( \"B\" ) );\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        B( $b1 : b1 != null )\n        B( $b1 : b1 == null )\n    )\n    eval( $a1.compareTo( $b1 ) < 0 )\nthen\n    System.out.println( $b1 );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR3() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"A\" ) );\n    insert( new B( null ) );\nend\n\nrule R when \n    (or \n        A ( $a1 : a1 != null )\n        A ( $a1 : a1 != null ) ) \n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo(\"B\") < 0 )\n        )\n    )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)3L, (long)ksession.fireAllRules());
    }

    @Test
    public void testDeclarationsScopeUsingOR4() {
        String str = "declare A\n    a1 : String\nend\n\ndeclare B\n    b1 : String\nend\n\nrule R when \n    A ( $a1 : a1 != null )\n    (or\n        (and\n            B( $b1 : b1 != null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n        (and\n            B( b1 == null )\n            eval( $a1.compareTo( $b1 ) < 0 )\n        )\n    )\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testQueryAfterEvalInsideOR() {
        String str = "package pakko\n\ndeclare Holder\n  str : String\nend\n\ndeclare Bean\n  val : String\nend\n\ndeclare Mock end \n\nrule \"Init\"\nwhen\nthen\n  insert( new Bean( \"xyz\" ) );\n  insert( new Holder( \"xyz\" ) );\n  insert( new Mock() );\nend\n\nquery mock( Mock $m ) $m := Mock() end\n\nrule \"Check\"\nwhen\n  $b : Bean( $t : val )\n  ( Holder( $t ; ) or eval( $t.startsWith( \"abc\" ) ) )\n  mock( $m ; ) \nthen\n  System.out.println( $m );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPackageVisibility() {
        String str = "package org.drools.integrationtests;\nrule \"getX\"\nwhen\n    $x: PackageProtected( )\nthen\n    System.out.println( $x );\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testNullValueInFrom() {
        String str = "global java.util.List list\n\nrule R\nwhen\n    $i : Integer( ) from list\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        list.add(1);
        list.add(null);
        list.add(2);
        ksession.fireAllRules();
    }

    @Test
    public void testNumberInQuotes() throws Exception {
        String str = "declare A\n    a1 : String\nend\ndeclare B\n    b1 : String\nend\n\nrule Init salience 10 when \nthen\n    insert( new A( \"40\" ) );\n    insert( new A( \"2abc\" ) );\n    insert( new B( \"300\" ) );\nend\n\nrule R1 when\n   A( $a1 : a1 ) \n   B( b1 > $a1 ) \nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testStringCoercionComparison() {
        String str = "import " + Person.class.getName() + ";\n" + "rule R1 when\n" + " $p : Person( name < \"90201304122000000000000017\" )\n" + "then end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Person("90201304122000000000000015", 38));
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAvoidUnwantedSemicolonWhenDelimitingExpression() {
        String str = "global java.util.List l\nrule rule1 \n    dialect \"mvel\" \nwhen \nthen \n    String s = \"http://onefineday.123\";\n    l.add(s);\nend \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList l = new ArrayList();
        ksession.setGlobal("l", l);
        ksession.fireAllRules();
        Misc2Test.assertEquals((Object)"http://onefineday.123", l.get(0));
    }

    @Test
    public void testJitCastOfPrimitiveType() {
        String str = "rule R when\n Number(longValue < (Long)7)\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Long(6L));
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testSelfChangingRuleSet() {
        String str = "package org.drools.compiler.integrationtests;\nimport org.drools.compiler.integrationtests.Misc2Test.Foo2; \nglobal java.util.List list; \n\nrule \"Prep\" \nwhen \n  $packs : java.util.Collection() \nthen \n   ((org.drools.core.impl.InternalKnowledgeBase)drools.getKieRuntime().getKieBase()).addKnowledgePackages( $packs );end \nrule \"Self-change\"\nwhen\n  String( this == \"go\" )\nthen\n   ((org.drools.core.impl.InternalKnowledgeBase)drools.getKieRuntime().getKieBase()).removeRule( \"org.drools.compiler.integrationtests\", \"React\" ); \nend\n\n\nrule \"Insert\"\nwhen\n  $i : Integer()\nthen\n  Foo2 foo = new Foo2();\n   foo.setX( $i ); \n  insert( foo );\nend\n";
        String str2 = "package org.drools.compiler.integrationtests;\nimport org.drools.compiler.integrationtests.Misc2Test.Foo2; \nglobal java.util.List list;\n rule \"React\"\nwhen\n  $b : Foo2( x < 10 )\nthen\n  System.out.println( \" Foo2 is in \" + $b.getX() );  list.add( $b ); \nend\n";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(str2.getBytes()), ResourceType.DRL);
        System.out.println(knowledgeBuilder.getErrors());
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)knowledgeBuilder.getKnowledgePackages());
        ksession.insert((Object)new Integer(1));
        ksession.fireAllRules();
        ksession.insert((Object)"go");
        ksession.fireAllRules();
        ksession.insert((Object)new Integer(2));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testMatchIntegers() {
        String str = "global java.util.List list; \nrule R when\n $i : Integer( this == 1 )\nthen\n list.add( $i );\nend\nrule S when\n $i : Integer( this == 2 )\nthen\n list.add( $i );\nend\nrule T when\n $i : Integer( this == 3 )\nthen\n list.add( $i );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Integer(1));
        ksession.fireAllRules();
    }

    @Test
    public void testDurationAnnotation() {
        String str = "package org.drools.compiler.integrationtests;\nimport org.drools.compiler.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duration)\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
    }

    @Test
    public void testDurationAnnotationOnKie() {
        String str = "package org.drools.compiler.integrationtests;\nimport org.drools.compiler.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duration)\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        ks.newKieBuilder(kfs).buildAll();
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testDurationAnnotationWithError() {
        String str = "package org.drools.compiler.integrationtests;\nimport org.drools.compiler.integrationtests.Misc2Test.SimpleEvent\ndeclare SimpleEvent\n    @role(event)\n    @duration(duratio)\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testPhreakWithConcurrentUpdates() {
        String str = "import org.drools.compiler.Person\nrule R when\n  $s : String()\n  $i : Integer()\n  not Person( age == $i, name.startsWith($s) )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)30);
        ksession.insert((Object)31);
        ksession.insert((Object)"B");
        ksession.insert((Object)"D");
        Person pA = new Person("AAA", 30);
        Person pB = new Person("BBB", 30);
        Person pC = new Person("CCC", 31);
        Person pD = new Person("DDD", 31);
        FactHandle fhB = ksession.insert((Object)pB);
        FactHandle fhD = ksession.insert((Object)pD);
        FactHandle fhA = ksession.insert((Object)pA);
        FactHandle fhC = ksession.insert((Object)pC);
        ksession.fireAllRules();
        pB.setAge(31);
        pB.setName("DBB");
        ksession.update(fhB, (Object)pB);
        pD.setAge(30);
        pD.setName("BDD");
        ksession.update(fhD, (Object)pD);
        Misc2Test.assertEquals((long)0L, (long)ksession.fireAllRules());
        pB.setAge(30);
        pB.setName("BBB");
        ksession.update(fhB, (Object)pB);
        pD.setAge(31);
        pD.setName("DDD");
        ksession.update(fhD, (Object)pD);
        Misc2Test.assertEquals((long)0L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPhreakWith2Nots() {
        String str = "import org.drools.compiler.Person\nglobal java.util.List list;\nrule R when\n  Person( $age : age, $name : name )\n  not Person( name == $name, age == $age + 1 )\n  not Person( name == $name, age == $age - 1 )\nthen\n  list.add($age);\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("AAA", 31);
        Person p2 = new Person("AAA", 34);
        Person p3 = new Person("AAA", 33);
        FactHandle fh1 = ksession.insert((Object)p1);
        FactHandle fh3 = ksession.insert((Object)p3);
        FactHandle fh2 = ksession.insert((Object)p2);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertEquals((long)31L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        p1.setAge(35);
        ksession.update(fh1, (Object)p1);
        p3.setAge(31);
        ksession.update(fh3, (Object)p3);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertEquals((long)31L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testPhreakTMS() {
        String str = "import org.drools.compiler.Person\nimport org.drools.compiler.Cheese\nrule R when\n  Person( $age : age, $name : name == \"A\" )\n  not Person( age == $age + 1 )\nthen\n  insertLogical(new Cheese(\"gorgonzola\", 10));\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("A", 31);
        FactHandle fh1 = ksession.insert((Object)p1);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)).size());
        Person p2 = new Person("A", 32);
        FactHandle fh2 = ksession.insert((Object)p2);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)).size());
    }

    @Test
    public void testHelloWorld() throws Exception {
        String drl = "package org.drools.test\ndeclare Message\n   message : String\nend\nrule R1 when\n   $m : Message( message == \"Hello World\" )\nthen\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Misc2Test.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
        ks.getRepository().addKieModule(builder.getKieModule());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        FactType messageType = ksession.getKieBase().getFactType("org.drools.test", "Message");
        Object message = messageType.newInstance();
        messageType.set(message, "message", (Object)"Hello World");
        ksession.insert(message);
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
        KieSession ksession2 = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
        FactType messageType2 = ksession2.getKieBase().getFactType("org.drools.test", "Message");
        Object message2 = messageType2.newInstance();
        messageType2.set(message2, "message", (Object)"Hello World");
        ksession2.insert(message2);
        Misc2Test.assertEquals((long)1L, (long)ksession2.fireAllRules());
    }

    @Test
    @Ignore(value="AUG")
    public void testPhreakInnerJoinNot() {
        String str = "import org.drools.compiler.integrationtests.Misc2Test.Lecture\nglobal java.util.List list;\nrule \"curriculumCompactness\"\n    when\n        $lecture : Lecture(\n            $day : day, $index : index\n        )\n        not Lecture(\n            day == $day, index == ($index + 1)\n        )\n    then\n        list.add($lecture.getId());\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Lecture lA = new Lecture("A", 0, 4);
        Lecture lB = new Lecture("B", 2, 2);
        Lecture lC = new Lecture("C", 2, 1);
        FactHandle fhA = ksession.insert((Object)lA);
        FactHandle fhB = ksession.insert((Object)lB);
        FactHandle fhC = ksession.insert((Object)lC);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)2L, (long)list.size());
        Misc2Test.assertTrue((boolean)list.containsAll(Arrays.asList("A", "B")));
        list.clear();
        ksession.update(fhB, (Object)lB.setDay(0).setIndex(4));
        ksession.update(fhC, (Object)lC.setDay(0).setIndex(3));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertTrue((boolean)list.contains("B"));
        list.clear();
        ksession.update(fhB, (Object)lB.setDay(2).setIndex(2));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        Misc2Test.assertTrue((boolean)list.contains("B"));
    }

    @Test
    @Ignore(value="AUG")
    public void testPhreakAccumulate() {
        String str = "import org.drools.compiler.integrationtests.Misc2Test.Lecture\nglobal java.util.List list;\nrule \"R1\"\n    when\n        $lecture : Lecture(\n            $day : day, $index : index\n        )\n        not Lecture(\n            day == $day, index == ($index + 1)\n        )\n    then\n        list.add($lecture.getId());\nend\nrule \"R2\"\n    when\n        $availableLectures : Number(intValue > 0) from accumulate(\n            $lecture : Lecture(\n                available == true\n            ),\n            count($lecture)\n        )\n\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Lecture lA = new Lecture("A", 0, 4, true);
        Lecture lB = new Lecture("B", 2, 2, true);
        Lecture lC = new Lecture("C", 2, 1, true);
        FactHandle fhA = ksession.insert((Object)lA);
        FactHandle fhB = ksession.insert((Object)lB);
        FactHandle fhC = ksession.insert((Object)lC);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)2L, (long)list.size());
        Misc2Test.assertTrue((boolean)list.containsAll(Arrays.asList("A", "B")));
        list.clear();
        ksession.update(fhB, (Object)lB.setAvailable(false));
        ksession.fireAllRules();
        ksession.update(fhB, (Object)lB.setDay(0).setIndex(3));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)2L, (long)list.size());
        Misc2Test.assertTrue((boolean)list.containsAll(Arrays.asList("B", "C")));
        list.clear();
    }

    @Test
    public void testQueryAndRetract() {
        String str = "global java.util.List list\n\nquery q (String $s)\n    String( this == $s )\nend\nrule R1 when\n    $x : String( this == \"x\" )\n    ?q( \"x\"; )\nthen\n    final java.util.List l = list;    org.drools.core.common.AgendaItem item = ( org.drools.core.common.AgendaItem ) drools.getMatch();\n    item.setActivationUnMatchListener( new org.kie.internal.event.rule.ActivationUnMatchListener() {\n        public void unMatch(org.kie.api.runtime.rule.RuleRuntime wm, org.kie.api.runtime.rule.Match activation) {\n            l.add(\"pippo\");\n        }\n    } );    retract( \"x\" );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"x");
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=5000L)
    public void testPhreakNoLoop() {
        String str = "declare Person \n    name : String\n    age : int\nend\n\nrule Init when \nthen\n    insert( new Person( \"Mario\", 39 ) );\nend\n\nrule R no-loop when\n    $p: Person( name == \"Mario\" )\n    not String( this == \"go\" )\nthen\n    modify( $p ) { setAge( 40 ) };\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Misc2Test.assertEquals((long)2L, (long)ksession.fireAllRules());
    }

    @Test
    public void testAddSameResourceTwice() {
        String str = "rule R when\n  $s : String()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kbuilder.hasResults(new ResultSeverity[]{ResultSeverity.INFO, ResultSeverity.WARNING, ResultSeverity.ERROR}));
    }

    @Test
    public void testTwoTimers() {
        String str = "import java.util.Date\nimport java.util.List\n\nglobal List dates\n\nrule \"intervalRule\"\n  timer(int: 200ms 100ms)\nwhen\n  String(this == \"intervalRule\")\nthen\n  Date date = new Date();\n  dates.add(date);\nend\n\n\n// this rule stops timer\nrule \"stopIntervalRule\"\n  timer(int: 320ms)\nwhen\n  $s : String(this == \"intervalRule\")\nthen\n  retract($s);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem().write("src/main/resources/r1.drl", str);
        Misc2Test.assertEquals((long)0L, (long)ks.newKieBuilder(kfs).buildAll().getResults().getMessages().size());
        KieSession ksession = ks.newKieContainer(ks.getRepository().getDefaultReleaseId()).newKieSession();
    }

    @Test
    public void testUnsupportedPolymorphicDeclaration() {
        String drl = "package org.drools.test; \ndeclare Foo end \ndeclare Bar end \nrule X when\n $x : Foo()  or  $x : Bar() \nthen\n System.out.println( $x ); \nend\nrule Init\nwhen\nthen\n insert( new Foo() ); \n insert( new Bar() ); \nend";
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        System.err.println(kb.getErrors().toString());
        Misc2Test.assertTrue((boolean)kb.hasErrors());
    }

    @Test
    public void testLegacySalienceResolver() {
        String drl = "package org.drools.test; \nglobal java.util.List list; \n rule X salience 10 \nthen\n list.add( 1 ); \nend\nrule Y salience 5 \nthen\n list.add( 2 ); \nend\n";
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        Misc2Test.assertFalse((boolean)kb.hasErrors());
        KieBaseConfiguration kbconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        ((RuleBaseConfiguration)kbconf).setConflictResolver(SalienceConflictResolver.getInstance());
        KnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbconf);
        knowledgeBase.addKnowledgePackages(kb.getKnowledgePackages());
        StatefulKnowledgeSession knowledgeSession = knowledgeBase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        knowledgeSession.setGlobal("list", list);
        knowledgeSession.fireAllRules();
        Misc2Test.assertEquals(Arrays.asList(1, 2), list);
    }

    @Test
    public void testUnaryNegation() {
        String str = "rule R when\n    Integer( $a: intValue )\n    Integer( intValue > $a, intValue == -$a )\nthen\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)3);
        ksession.insert((Object)-3);
        Misc2Test.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    @Ignore(value="AUG")
    public void testNotNodeUpdateBlocker() {
        String str = "import org.drools.compiler.integrationtests.Misc2Test.Conversation;\nglobal java.util.List list;\nrule \"familyEnd\" when\n   $conversation : Conversation(\n       family != null, $family: family, \n       $timeslot: timeslot)\n\n   not Conversation(\n       family == $family, \n       timeslot > $timeslot);\nthen\n   list.add($conversation);\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList conversations = new ArrayList();
        ksession.setGlobal("list", conversations);
        Conversation c0 = new Conversation(0, "Fusco", 2);
        Conversation c1 = new Conversation(1, "Fusco", 3);
        Conversation c2 = new Conversation(2, "Fusco", 4);
        FactHandle fh0 = ksession.insert((Object)c0);
        FactHandle fh1 = ksession.insert((Object)c1);
        FactHandle fh2 = ksession.insert((Object)c2);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)conversations.size());
        conversations.clear();
        c2.setTimeslot(0);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        c2.setTimeslot(4);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        conversations.clear();
        c0.setTimeslot(3);
        ksession.update(fh0, (Object)c0);
        ksession.fireAllRules();
        c0.setTimeslot(2);
        ksession.update(fh0, (Object)c0);
        ksession.fireAllRules();
        conversations.clear();
        c2.setTimeslot(1);
        ksession.update(fh2, (Object)c2);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)conversations.size());
    }

    @Test
    public void testFailedStaticImport() {
        String drl = "package org.drools.test; \nimport function org.does.not.exist.Foo; \nrule X when\nthen\nend";
        KnowledgeBuilder kb = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kb.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        Misc2Test.assertTrue((boolean)kb.hasErrors());
    }

    @Test
    public void testNamedConsequence() {
        ArrayList firedRules = new ArrayList();
        String str = "import " + Foo.class.getCanonicalName() + "\n" + "import " + Foo2.class.getCanonicalName() + "\n" + "global java.util.List fired;\n" + "rule \"weird foo\"\n" + "    when\n" + "        \n" + "        $foo: Foo($x: x)\n" + "        if( $foo.getX() != 1 )  break[needThis]\n" + "        $foo2: Foo2(x == $x);\n" + "    then\n" + "        fired.add(\"We made it!\");\n" + "    then[needThis]\n" + "        modify($foo){\n" + "            setX(1)\n" + "        };\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("fired", firedRules);
        ksession.insert((Object)new Foo());
        ksession.insert((Object)new Foo2(1));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)firedRules.size());
    }

    @Test
    public void testNamedConsequenceWithNot() {
        ArrayList firedRules = new ArrayList();
        String str = "import " + Foo.class.getCanonicalName() + "\n" + "import " + Foo2.class.getCanonicalName() + "\n" + "global java.util.List fired;\n" + "rule \"weird foo\"\n" + "    when\n" + "        $foo: Foo($x: x)\n" + "        if( $foo.getX() != 1 ) break[needThis] \n" + "        not( Foo(x == 2) ) \n" + "        $foo2: Foo2(x == $x)\n" + "    then\n" + "        fired.add(\"We made it!\");\n" + "    then[needThis]\n" + "        modify($foo){\n" + "            setX(1)\n" + "        };\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("fired", firedRules);
        ksession.insert((Object)new Foo());
        ksession.insert((Object)new Foo2(1));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)firedRules.size());
    }

    @Test
    public void testBetaNodeInSubnetworkInStreamMode() {
        String str = "import " + Foo.class.getCanonicalName() + "\n" + "\n" + "global java.util.List context;\n" + "\n" + "declare Foo\n" + "    @role( event )\n" + "end\n" + "\n" + "rule \"Rule A\"\n" + "when\n" + "    $f : Foo( )\n" + "    not ( Integer() from context )\n" + "then\n" + "    $f.setX( 2 );\n" + "end";
        KieBaseConfiguration kBaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kBaseConf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kBaseConf, str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("context", (Object)new ArrayList(){
            {
                this.add(new Long(0L));
            }
        });
        Foo foo = new Foo();
        foo.setX(1);
        ksession.insert((Object)foo);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)2L, (long)foo.getX());
    }

    @Test
    public void testIsAWith2KContainers() {
        String str = "import org.drools.compiler.Person\n\nglobal java.util.List students\n\ndeclare trait Student\n    school : String\nend\n\nrule \"create student\" \n    when\n        $student : Person( age < 26, this not isA Student )\n    then\n        Student s = don( $student, Student.class );\n        s.setSchool(\"Masaryk University\");\n        update( $student );\nend\n\nrule \"found student\"\n    salience 10\n    when\n        student : Person( this isA Student )\n    then\n        students.add(student);\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/isA.drl", str);
        KieBuilder kbuilder = ks.newKieBuilder(kfs);
        kbuilder.buildAll();
        Misc2Test.assertEquals((long)0L, (long)kbuilder.getResults().getMessages().size());
        ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).getKieBase();
        KieSession ksession = ks.newKieContainer(kbuilder.getKieModule().getReleaseId()).newKieSession();
        Misc2Test.assertNotNull((Object)ksession);
        ArrayList students = new ArrayList();
        ksession.setGlobal("students", students);
        ksession.insert((Object)new Person("tom", 20));
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)students.size());
    }

    @Test
    public void testFactLeak() throws InterruptedException {
        String drl = "package org.drools.test; \nglobal java.util.List list; \nrule Intx when\n  $x : Integer() from entry-point \"x\" \nthen\n  list.add( $x ); \nend";
        int N = 1100;
        KnowledgeBase kb = this.loadKnowledgeBaseFromString(drl);
        final StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ks.setGlobal("list", list);
        new Thread(){

            @Override
            public void run() {
                ks.fireUntilHalt();
            }
        }.start();
        for (int j = 0; j < N; ++j) {
            ks.getEntryPoint("x").insert((Object)new Integer(j));
        }
        Thread.sleep(1000L);
        ks.halt();
        Misc2Test.assertEquals((long)N, (long)list.size());
    }

    @Test
    public void testKsessionSerializationWithInsertLogical() {
        ArrayList firedRules = new ArrayList();
        String str = "import java.util.Date;\nimport org.drools.reteoo.integrationtests.Misc2Test.Promotion;\n\ndeclare Person\n name : String\n dateOfBirth : Date\nend\n\ndeclare Employee extends Person\n job : String\nend\n\nrule \"Insert Alice\"\n when\n then\n Employee alice = new Employee(\"Alice\", new Date(1973, 7, 2), \"Vet\");\n insert(alice);\n System.out.println(\"Insert Alice\");\nend\n\nrule \"Insert Bob\"\n when\n Person(name == \"Alice\")\n then\n Person bob = new Person(\"Bob\", new Date(1973, 7, 2));\n insertLogical(bob);\n System.out.println(\"InsertLogical Bob\");\nend\n\nrule \"Insert Claire\"\n when\n Person(name == \"Bob\")\n then\n Employee claire = new Employee(\"Claire\", new Date(1973, 7, 2), \"Student\");\n insert(claire);\n System.out.println(\"Insert Claire\");\nend\n\nrule \"Promote\"\n when\n p : Promotion(n : name, j : job)\n e : Employee(name == n)\n then\n modify(e) {\n setJob(j)\n }\n retract(p);\n System.out.printf(\"Promoted %s to %s%n\", n, j);\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        try {
            Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshall((OutputStream)baos, (KieSession)ksession);
            marshaller = MarshallerFactory.newMarshaller((KieBase)kbase);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            ksession = (StatefulKnowledgeSession)marshaller.unmarshall((InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Misc2Test.fail((String)("unexpected exception :" + e.getMessage()));
        }
        ksession.insert((Object)new Promotion("Claire", "Scientist"));
        int result = ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testEventWithSQLTimestamp() throws InterruptedException {
        String str = "import org.drools.reteoo.integrationtests.Misc2Test.SQLTimestamped;\nglobal java.util.List list;\ndeclare SQLTimestamped @role(event) @timestamp(start) end \nrule \"Init\" when\n   $s1 : SQLTimestamped() \n   $s2 : SQLTimestamped( this != $s1, this after $s1 ) \nthen\n   list.add( \"ok\" ); \nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new SQLTimestamped());
        Thread.sleep(100L);
        ksession.insert((Object)new SQLTimestamped());
        ksession.fireAllRules();
        Misc2Test.assertEquals(Arrays.asList("ok"), list);
    }

    @Test
    public void testLockOnActive() {
        String drl = "package org.drools.test; \nimport org.drools.reteoo.integrationtests.Misc2Test.TradeBooking;\nimport org.drools.reteoo.integrationtests.Misc2Test.TradeHeader;\nrule \"Rule1\" \nsalience 1 \nwhen\n  $booking: TradeBooking()\n  $trade: TradeHeader() from $booking.getTrade()\n  not String()\nthen\n  System.out.println( \"Rule1\" ); \n  $trade.setAction(\"New\");\n  modify($booking) {}\n  insert (\"run\");\nend;\n\nrule \"Rule2\"\nlock-on-active true\nwhen\n  $booking: TradeBooking( )\n  $trade: Object( ) from $booking.getTrade()\nthen\n  System.out.println( \"Rule2\" ); \nend";
        KnowledgeBase kb = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ks.addEventListener(new AgendaEventListener(){
            int step = 0;

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
                switch (this.step) {
                    case 0: {
                        Assert.assertEquals((Object)"Rule2", (Object)event.getMatch().getRule().getName());
                        ++this.step;
                        break;
                    }
                    case 1: {
                        Assert.assertEquals((Object)"Rule1", (Object)event.getMatch().getRule().getName());
                        ++this.step;
                        break;
                    }
                    default: {
                        Assert.fail((String)"More cancelled activations than expected");
                    }
                }
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                Assert.assertEquals((Object)"Rule1", (Object)event.getMatch().getRule().getName());
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }
        });
        ks.fireAllRules();
        TradeBookingImpl tb = new TradeBookingImpl(new TradeHeaderImpl());
        ks.insert((Object)tb);
        Misc2Test.assertEquals((long)1L, (long)ks.fireAllRules());
    }

    @Test
    public void testLockOnActiveWithModify() {
        String drl = "package org.drools.test; \nimport org.drools.compiler.Person; \nrule \"Rule1\" \nsalience 1 \nlock-on-active true\nno-loop \nwhen\n  $p: Person()\nthen\n  System.out.println( \"Rule1\" ); \n  modify( $p ) { setAge( 44 ); }\nend;\n\nrule \"Rule2\"\nlock-on-active true\nwhen\n  $p: Person() \n  String() from $p.getName() \nthen\n  System.out.println( \"Rule2\" + $p );   modify ( $p ) { setName( \"john\" ); } \nend";
        KnowledgeBase kb = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ks.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        ks.fireAllRules();
        Person p = new Person("mark", 76);
        ks.insert((Object)p);
        ks.fireAllRules();
        Misc2Test.assertEquals((long)44L, (long)p.getAge());
        Misc2Test.assertEquals((Object)"john", (Object)p.getName());
    }

    @Test
    public void testInitialFactLeaking() {
        String drl = "global java.util.List list;\nrule R when\n    $o : Object()\nthen\n    list.add(1);\nend\n";
        KnowledgeBuilderConfiguration kbConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbConf, drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)"1");
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)1L, (long)list.size());
        ksession.insert((Object)1);
        ksession.fireAllRules();
        Misc2Test.assertEquals((long)2L, (long)list.size());
        ksession.dispose();
    }

    @Test
    public void testDeclarativeAgenda() {
        String drl = "package org.drools.compiler.integrationtests\n\nimport org.kie.api.runtime.rule.Match\nimport java.util.List\n\nglobal List list\n\nrule startAgenda\nsalience 100\nwhen\n    String( this == 'startAgenda' )\nthen\n    drools.getKnowledgeRuntime().getAgenda().getAgendaGroup(\"agenda\").setFocus();\n    list.add(kcontext.getRule().getName());\nend\n\nrule sales @department('sales') salience 10\nagenda-group \"agenda\"\nwhen\n    $s : String( this == 'fireRules' )\nthen\n    list.add(kcontext.getRule().getName());\nend\n\nrule salesBlocker\nwhen\n    $s : String( this == 'fireBlockerRule' )\n    $i : Match( department == 'sales' )\nthen\n    kcontext.blockMatch( $i );\n    list.add(kcontext.getRule().getName());\nend\n";
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kbConf, drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"startAgenda");
        ksession.insert((Object)"fireRules");
        FactHandle fireBlockerRule = ksession.insert((Object)"fireBlockerRule");
        ksession.fireAllRules();
        String[] expected = new String[]{"startAgenda", "sales", "salesBlocker"};
        Misc2Test.assertEquals((long)expected.length, (long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Misc2Test.assertEquals((Object)expected[i], list.get(i));
        }
        ksession.delete(fireBlockerRule);
        list.clear();
        ksession.fireAllRules();
        System.out.println(list);
        Misc2Test.assertEquals((long)0L, (long)list.size());
    }

    public static class TradeBookingImpl
    implements TradeBooking {
        private TradeHeader header;

        public TradeBookingImpl(TradeHeader h) {
            this.header = h;
        }

        @Override
        public TradeHeader getTrade() {
            return this.header;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TradeBookingImpl that = (TradeBookingImpl)o;
            return !(this.header != null ? !this.header.equals(that.header) : that.header != null);
        }

        public int hashCode() {
            return this.header != null ? this.header.hashCode() : 0;
        }
    }

    public static class TradeHeaderImpl
    implements TradeHeader {
        private String action;

        @Override
        public String getAction() {
            return this.action;
        }

        @Override
        public void setAction(String action) {
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TradeHeaderImpl that = (TradeHeaderImpl)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }
    }

    public static interface TradeHeader {
        public void setAction(String var1);

        public String getAction();
    }

    public static interface TradeBooking {
        public TradeHeader getTrade();
    }

    public static class SQLTimestamped {
        private Timestamp start = new Timestamp(new Date().getTime());

        public Timestamp getStart() {
            return this.start;
        }

        public void setStart(Timestamp start) {
            this.start = start;
        }
    }

    public static class Promotion {
        private String name;
        private String job;

        public Promotion(String name, String job) {
            this.setName(name);
            this.setJob(job);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getJob() {
            return this.job;
        }

        public void setJob(String job) {
            this.job = job;
        }
    }

    public static class Foo2 {
        @Position(value=0)
        public int x;

        public Foo2() {
        }

        public Foo2(int x) {
            this.x = x;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class Foo {
        public int x;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }
    }

    public static class Conversation {
        private final int id;
        private String family;
        private int timeslot;

        public Conversation(int id) {
            this.id = id;
        }

        public Conversation(int id, String family, int timeslot) {
            this.id = id;
            this.family = family;
            this.timeslot = timeslot;
        }

        public int getId() {
            return this.id;
        }

        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        public int getTimeslot() {
            return this.timeslot;
        }

        public void setTimeslot(int timeslot) {
            this.timeslot = timeslot;
        }

        public String toString() {
            return "Conversation #" + this.getId() + " with " + this.getFamily() + " @ " + this.getTimeslot();
        }
    }

    public static class Lecture {
        private final String id;
        private int day;
        private int index;
        private boolean available;

        public Lecture(String id, int day, int index) {
            this(id, day, index, true);
        }

        public Lecture(String id, int day, int index, boolean available) {
            this.id = id;
            this.day = day;
            this.index = index;
            this.available = available;
        }

        public String getId() {
            return this.id;
        }

        public int getDay() {
            return this.day;
        }

        public Lecture setDay(int day) {
            this.day = day;
            return this;
        }

        public int getIndex() {
            return this.index;
        }

        public Lecture setIndex(int index) {
            this.index = index;
            return this;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public Lecture setAvailable(boolean available) {
            this.available = available;
            return this;
        }

        public String toString() {
            return this.id + " - " + "day = " + this.getDay() + "; index = " + this.getIndex();
        }
    }

    public static class SimpleEvent {
        private long duration;

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }
    }

    public static class IntegerWrapperImpl
    extends AbstractIntegerWrapper {
        private final int i;

        public IntegerWrapperImpl(int i) {
            this.i = i;
        }

        @Override
        public int compareTo(IntegerWraper o) {
            return this.getInt() - o.getInt();
        }

        @Override
        public int getInt() {
            return this.i;
        }
    }

    public static abstract class AbstractIntegerWrapper
    implements IntegerWraper,
    Comparable<IntegerWraper> {
    }

    static interface IntegerWraper {
        public int getInt();
    }

    public static class Model {
        private BigDecimal cost;
        private BigDecimal price;

        public BigDecimal getCost() {
            return this.cost;
        }

        public void setCost(BigDecimal cost) {
            this.cost = cost;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }
    }

    public static class StaticPerson {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class AnswerGiver {
        public Answer getAnswer() {
            return Answer.YES;
        }
    }

    public static enum Answer {
        YES,
        NO;

    }

    public static class StringConcrete
    extends AbstractBase<String> {
        public StringConcrete() {
            this.foo = new String();
        }
    }

    public static abstract class AbstractBase<T> {
        protected T foo;

        public T getFoo() {
            return this.foo;
        }
    }

    @PropertyReactive
    public static class DataSample {
        private Map<Parameter, Double> values = new EnumMap<Parameter, Double>(Parameter.class);

        public Map<Parameter, Double> getValues() {
            return this.values;
        }

        public void setValues(Map<Parameter, Double> values) {
            this.values = values;
        }

        @Modifies(value={"values", "notEmpty"})
        public void addValue(Parameter p, double value) {
            this.values.put(p, value);
        }

        public boolean isNotEmpty() {
            return !this.values.isEmpty();
        }
    }

    public static enum Parameter {
        PARAM_A,
        PARAM_B;

    }

    @PropertyReactive
    public static class A {
        private int f1;
        private int f2;
        private int f3;
        private int f4;

        public A() {
        }

        public A(int f1, int f2, int f3, int f4) {
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
        }

        public int getF1() {
            return this.f1;
        }

        public void setF1(int f1) {
            this.f1 = f1;
        }

        public int getF2() {
            return this.f2;
        }

        public void setF2(int f2) {
            this.f2 = f2;
        }

        public int getF3() {
            return this.f3;
        }

        public void setF3(int f3) {
            this.f3 = f3;
        }

        public int getF4() {
            return this.f4;
        }

        public void setF4(int f4) {
            this.f4 = f4;
        }

        public String toString() {
            return "A[f1=" + this.f1 + ", f2=" + this.f2 + ", f3=" + this.f3 + ", f4=" + this.f4 + "]";
        }
    }
}

