/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.compiler.Cheese;
import org.drools.compiler.Cheesery;
import org.drools.compiler.Order;
import org.drools.compiler.OrderItem;
import org.drools.compiler.OuterClass;
import org.drools.compiler.Person;
import org.drools.compiler.integrationtests.LinkingTest;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.time.SessionPseudoClock;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.command.Command;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AccumulateTest
extends CommonTestMethodBase {
    @Test(timeout=10000L)
    public void testAccumulateModify() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateModify.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulate() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_Accumulate.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        System.out.println(results);
        AccumulateTest.assertEquals((long)5L, (long)results.size());
        AccumulateTest.assertEquals((Object)165, results.get(0));
        AccumulateTest.assertEquals((Object)10, results.get(1));
        AccumulateTest.assertEquals((Object)150, results.get(2));
        AccumulateTest.assertEquals((Object)10, results.get(3));
        AccumulateTest.assertEquals((Object)210, results.get(4));
    }

    @Test(timeout=10000L)
    public void testMVELAccumulate() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateMVEL.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        AccumulateTest.assertEquals((Object)165, results.get(0));
        AccumulateTest.assertEquals((Object)10, results.get(1));
        AccumulateTest.assertEquals((Object)150, results.get(2));
        AccumulateTest.assertEquals((Object)10, results.get(3));
        AccumulateTest.assertEquals((Object)210, results.get(4));
    }

    @Test(timeout=10000L)
    public void testAccumulateModifyMVEL() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateModifyMVEL.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateReverseModify() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReverseModify.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update(cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)36L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateReverseModify2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReverseModify2.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update(cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)36L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateReverseModifyInsertLogical2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReverseModifyInsertLogical2.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person alice = new Person("Alice", "brie");
        Person bob = new Person("Bob", "stilton");
        Person carol = new Person("Carol", "cheddar");
        Person doug = new Person("Doug", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle aliceHandle = wm.insert((Object)alice);
        FactHandle bobHandle = wm.insert((Object)bob);
        FactHandle dougHandle = wm.insert((Object)doug);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)31L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)30L, (long)((Number)results.get(results.size() - 1)).intValue());
    }

    @Test(timeout=10000L)
    public void testAccumulateReverseModifyMVEL() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReverseModifyMVEL.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateReverseModifyMVEL2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReverseModifyMVEL2.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)31L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateWithFromChaining() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateWithFromChaining.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Cheesery cheesery = new Cheesery();
        for (int i = 0; i < cheese.length; ++i) {
            cheesery.addCheese(cheese[i]);
        }
        FactHandle cheeseryHandle = wm.insert((Object)cheesery);
        Person bob = new Person("Bob", "stilton");
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update(cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        System.out.println(results);
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
        cheesery.getCheeses().remove(cheese[3]);
        wm.update(cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testMVELAccumulate2WM() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateMVEL.drl");
        StatefulKnowledgeSession wm1 = this.createKnowledgeSession(kbase);
        ArrayList results1 = new ArrayList();
        wm1.setGlobal("results", results1);
        StatefulKnowledgeSession wm2 = this.createKnowledgeSession(kbase);
        ArrayList results2 = new ArrayList();
        wm2.setGlobal("results", results2);
        wm1.insert((Object)new Person("Bob", "stilton", 20));
        wm1.insert((Object)new Person("Mark", "provolone"));
        wm2.insert((Object)new Person("Bob", "stilton", 20));
        wm2.insert((Object)new Person("Mark", "provolone"));
        wm1.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("provolone", 150));
        wm2.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("provolone", 150));
        wm1.fireAllRules();
        wm2.fireAllRules();
        AccumulateTest.assertEquals((Object)165, results1.get(0));
        AccumulateTest.assertEquals((Object)10, results1.get(1));
        AccumulateTest.assertEquals((Object)150, results1.get(2));
        AccumulateTest.assertEquals((Object)10, results1.get(3));
        AccumulateTest.assertEquals((Object)210, results1.get(4));
        AccumulateTest.assertEquals((Object)165, results2.get(0));
        AccumulateTest.assertEquals((Object)10, results2.get(1));
        AccumulateTest.assertEquals((Object)150, results2.get(2));
        AccumulateTest.assertEquals((Object)10, results2.get(3));
        AccumulateTest.assertEquals((Object)210, results2.get(4));
    }

    @Test(timeout=10000L)
    public void testAccumulateInnerClass() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateInnerClass.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new OuterClass.InnerClass(10));
        wm.insert((Object)new OuterClass.InnerClass(5));
        wm.fireAllRules();
        AccumulateTest.assertEquals((Object)15, results.get(0));
    }

    @Test(timeout=10000L)
    public void testAccumulateReturningNull() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateReturningNull.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
    }

    @Test(timeout=10000L)
    public void testAccumulateSumJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSum.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateSumMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSumMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternWithFunctionJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionJava.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternWithFunctionMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCountJava() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCount.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCountMVEL() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCountMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateAverageJava() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverage.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateAverageMVEL() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverageMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMinJava() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMin.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMinMVEL() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMinMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMaxJava() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMax.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMaxMVEL() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMaxMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternJava() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPattern.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultiPatternMVEL() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPatternMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectListJava() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectList.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectListMVEL() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectListMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectSetJava() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSet.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateCollectSetMVEL() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSetMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsJava() throws Exception {
        this.execTestAccumulateMultipleFunctions("test_AccumulateMultipleFunctions.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsMVEL() throws Exception {
        this.execTestAccumulateMultipleFunctions("test_AccumulateMultipleFunctionsMVEL.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateMultipleFunctionsConstraint() throws Exception {
        this.execTestAccumulateMultipleFunctionsConstraint("test_AccumulateMultipleFunctionsConstraint.drl");
    }

    @Test(timeout=10000L)
    public void testAccumulateWithAndOrCombinations() throws Exception {
        String rule = "package org.drools.compiler.test;\nimport org.drools.compiler.Cheese;\nimport org.drools.compiler.Person;\nrule \"Class cast causer\"\n    when\n        $person      : Person( $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                min($c.getPrice()) )\n        ($p2 : Person(name == 'nobody') or $p2 : Person(name == 'Doug'))\n    then\n        System.out.println($p2.getName());\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Person("Alice", "brie"));
        wm.insert((Object)new Person("Bob", "stilton"));
    }

    @Test(timeout=10000L)
    public void testAccumulateWithSameSubnetwork() throws Exception {
        String rule = "package org.drools.compiler.test;\nimport org.drools.compiler.Cheese;\nimport org.drools.compiler.Person;\nglobal java.util.List list; \nrule r1 salience 100 \n    when\n        $person      : Person( name == 'Alice', $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                min($c.getPrice()) )\n    then\n        list.add( 'r1' + ':' + $total);\nend\nrule r2 \n    when\n        $person      : Person( name == 'Alice', $likes : likes )\n        $total       : Number() from accumulate( $p : Person(likes != $likes, $l : likes) and $c : Cheese( type == $l ),\n                                                max($c.getPrice()) )\n    then\n        list.add( 'r2' + ':' + $total);\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        ObjectTypeNode cheeseOtn = LinkingTest.getObjectTypeNode((KnowledgeBase)kbase, Cheese.class);
        ObjectSink[] oSinks = cheeseOtn.getObjectSinkPropagator().getSinks();
        AccumulateTest.assertEquals((long)1L, (long)oSinks.length);
        JoinNode cheeseJoin = (JoinNode)oSinks[0];
        LeftTupleSink[] ltSinks = cheeseJoin.getSinkPropagator().getSinks();
        AccumulateTest.assertEquals((long)1L, (long)ltSinks.length);
        RightInputAdapterNode rian = (RightInputAdapterNode)ltSinks[0];
        AccumulateTest.assertEquals((long)2L, (long)rian.getObjectSinkPropagator().size());
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Person("Alice", "brie"));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)list.size());
        AccumulateTest.assertEquals((Object)"r1:10.0", list.get(0));
        AccumulateTest.assertEquals((Object)"r2:10.0", list.get(1));
    }

    public void execTestAccumulateSum(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        DataSet data = new DataSet();
        data.results = new ArrayList();
        session.setGlobal("results", data.results);
        data.cheese = new Cheese[]{new Cheese("stilton", 8, 0), new Cheese("stilton", 10, 1), new Cheese("stilton", 9, 2), new Cheese("brie", 11, 3), new Cheese("brie", 4, 4), new Cheese("provolone", 8, 5)};
        data.bob = new Person("Bob", "stilton");
        data.cheeseHandles = new FactHandle[data.cheese.length];
        for (int i = 0; i < data.cheese.length; ++i) {
            data.cheeseHandles[i] = session.insert((Object)data.cheese[i]);
        }
        data.bobHandle = session.insert((Object)data.bob);
        session.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)data.results.size());
        AccumulateTest.assertEquals((long)27L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        this.updateReferences(session, data);
        boolean index = true;
        data.cheese[1].setPrice(3);
        session.update(data.cheeseHandles[1], (Object)data.cheese[1]);
        int count = session.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)count);
        AccumulateTest.assertEquals((long)2L, (long)data.results.size());
        AccumulateTest.assertEquals((long)20L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        data.bob.setLikes("brie");
        session.update(data.bobHandle, (Object)data.bob);
        session.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)data.results.size());
        AccumulateTest.assertEquals((long)15L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        session.retract(data.cheeseHandles[3]);
        session.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)data.results.size());
    }

    private void updateReferences(StatefulKnowledgeSession session, DataSet data) {
        data.results = (List)session.getGlobal("results");
        for (Object next : session.getObjects()) {
            if (next instanceof Cheese) {
                Cheese c;
                data.cheese[c.getOldPrice()] = c = (Cheese)next;
                data.cheeseHandles[c.getOldPrice()] = session.getFactHandle((Object)c);
                AccumulateTest.assertNotNull((Object)data.cheeseHandles[c.getOldPrice()]);
                continue;
            }
            if (!(next instanceof Person)) continue;
            data.bob = (Person)next;
            data.bobHandle = session.getFactHandle((Object)data.bob);
        }
    }

    public void execTestAccumulateCount(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)results.size());
        AccumulateTest.assertEquals((long)2L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)results.size());
    }

    public void execTestAccumulateAverage(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 11), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)10L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)16L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.retract(cheeseHandles[4]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateMin(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)1L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.retract(cheeseHandles[4]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateMax(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)9L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)17L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract(cheeseHandles[3]);
        wm.retract(cheeseHandles[4]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateCollectList(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
        wm.retract(cheeseHandles[3]);
        wm.retract(cheeseHandles[4]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateCollectSet(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)results.size());
        AccumulateTest.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        wm.retract(cheeseHandles[4]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)3L, (long)results.size());
    }

    public void execTestAccumulateReverseModifyMultiPattern(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        Person mark = new Person("Mark", "provolone");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        FactHandle markHandle = wm.insert((Object)mark);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)32L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)39L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testAccumulateWithPreviouslyBoundVariables() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulatePreviousBinds.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((Object)45, results.get(0));
    }

    @Test(timeout=10000L)
    public void testAccumulateMVELWithModify() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateMVELwithModify.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Order order = new Order(1, "Bob");
        OrderItem item1 = new OrderItem(order, 1, "maquilage", 1, 10);
        OrderItem item2 = new OrderItem(order, 2, "perfume", 1, 5);
        order.addItem(item1);
        order.addItem(item2);
        wm.insert((Object)order);
        wm.insert((Object)item1);
        wm.insert((Object)item2);
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((long)15L, (long)((Number)results.get(0)).intValue());
        AccumulateTest.assertEquals((double)15.0, (double)order.getTotal(), (double)0.0);
    }

    @Test(timeout=10000L)
    public void testAccumulateGlobals() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_AccumulateGlobals.drl");
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.setGlobal("globalValue", (Object)50);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((Object)100, results.get(0));
    }

    @Test(timeout=10000L)
    public void testAccumulateNonExistingFunction() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_NonExistingAccumulateFunction.drl", ((Object)((Object)this)).getClass()), ResourceType.DRL);
        AccumulateTest.assertTrue((String)"It must report a proper error when trying to use a non-registered funcion", (boolean)kbuilder.hasErrors());
        AccumulateTest.assertTrue((boolean)kbuilder.getErrors().toString().contains("Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - Java'."));
        AccumulateTest.assertTrue((boolean)kbuilder.getErrors().toString().contains("Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - MVEL'."));
    }

    @Test(timeout=10000L)
    public void testAccumulateZeroParams() {
        String rule = "global java.util.List list;\nrule fromIt\nwhen\n    Number( $c: intValue ) from accumulate( Integer(), count( ) )\nthen\n    list.add( $c );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(rule);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Integer(1));
        ksession.insert((Object)new Integer(2));
        ksession.insert((Object)new Integer(3));
        ksession.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)list.size());
        AccumulateTest.assertEquals((Object)3, list.get(0));
    }

    public void execTestAccumulateMultipleFunctions(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 3), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = ksession.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        Match activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)18));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)6));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        boolean index = true;
        cheese[1].setPrice(9);
        ksession.update(cheeseHandles[1], (Object)cheese[1]);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)24));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)5));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)8));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        bob.setLikes("brie");
        ksession.update(bobHandle, (Object)bob);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)32));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)15));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)16));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        ksession.retract(cheeseHandles[3]);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)17));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)17));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)17));
    }

    public void execTestAccumulateMultipleFunctionsConstraint(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 3), new Cheese("stilton", 5), new Cheese("brie", 3), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = ksession.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        Match activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)18));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)6));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        boolean index = true;
        cheese[1].setPrice(9);
        ksession.update(cheeseHandles[1], (Object)cheese[1]);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).afterMatchFired((AfterMatchFiredEvent)Mockito.any(AfterMatchFiredEvent.class));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        bob.setLikes("brie");
        ksession.update(bobHandle, (Object)bob);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)cap.capture());
        activation = ((AfterMatchFiredEvent)cap.getValue()).getMatch();
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)20));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        AccumulateTest.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)10));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testAccumulateMinMax() throws Exception {
        Cheese[] cheese;
        String drl = "package org.drools.compiler.test \nimport org.drools.compiler.Cheese \nglobal java.util.List results \n rule minMax \nwhen \n    accumulate( Cheese( $p: price ), $min: min($p), $max: max($p) ) \nthen \n    results.add($min); results.add($max); \nend \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        for (Cheese aCheese : cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)}) {
            ksession.insert((Object)aCheese);
        }
        ksession.fireAllRules();
        AccumulateTest.assertEquals((long)2L, (long)results.size());
        AccumulateTest.assertEquals((long)((Number)results.get(0)).intValue(), (long)2L);
        AccumulateTest.assertEquals((long)((Number)results.get(1)).intValue(), (long)17L);
    }

    @Test(timeout=10000L)
    public void testAccumulateCE() throws Exception {
        Cheese[] cheese;
        String drl = "package org.drools.compiler\nglobal java.util.List results\nrule \"ocount\"\nwhen\n    accumulate( Cheese(), $c: count(1) )\nthen\n    results.add( $c + \" facts\" );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        for (Cheese aCheese : cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)}) {
            ksession.insert((Object)aCheese);
        }
        ksession.fireAllRules();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((Object)"7 facts", results.get(0));
    }

    @Test(timeout=10000L)
    public void testAccumulateAndRetract() {
        String drl = "package org.drools.compiler;\n\nimport java.util.ArrayList;\n\nglobal ArrayList list;\n\ndeclare Holder\n    list : ArrayList\nend\n\nrule \"Init\"\nwhen\n    $l : ArrayList()\nthen\n    insert( new Holder($l) );\nend\n\nrule \"axx\"\nwhen\n    $h : Holder( $l : list )\n    $n : Long() from accumulate (\n                    $b : String( ) from $l;\n                    count($b))\nthen\n    System.out.println($n);\n    list.add($n);\nend\n\nrule \"clean\"\nsalience -10\nwhen\n    $h : Holder()\nthen\n    retract($h);\nend\n";
        KnowledgeBase kb = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ks = this.createKnowledgeSession(kb);
        ArrayList resList = new ArrayList();
        ks.setGlobal("list", resList);
        ArrayList<String> list = new ArrayList<String>();
        list.add("x");
        list.add("y");
        list.add("z");
        ks.insert(list);
        ks.fireAllRules();
        AccumulateTest.assertEquals((Object)3L, resList.get(0));
    }

    @Test(timeout=10000L)
    public void testAccumulateWithNull() {
        String drl = "rule foo\nwhen\nObject() from accumulate( Object(),\ninit( Object res = null; )\naction( res = null; )\nresult( res ) )\nthen\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testAccumulateWithBoundExpression() {
        String drl = "package org.drools.compiler;\nimport " + MyObj.class.getCanonicalName() + ";\n" + "global java.util.List results\n" + "rule init\n" + "   when\n" + "   then\n" + "       insert( new MyObj(5) );\n" + "       insert( new MyObj(4) );\n" + "end\n" + "rule foo\n" + "   salience -10\n" + "   when\n" + "       $n : Number() from accumulate( MyObj( $val : nestedObj.value ),\n" + "                                      sum( $val ) )\n" + "   then\n" + "       System.out.println($n);\n" + "       results.add($n);\n" + "end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        ksession.dispose();
        AccumulateTest.assertEquals((long)1L, (long)results.size());
        AccumulateTest.assertEquals((Object)9.0, results.get(0));
    }

    @Test(timeout=10000L)
    public void testInfiniteLoopAddingPkgAfterSession() throws Exception {
        String rule = "package org.drools.compiler.test;\nimport " + Triple.class.getCanonicalName() + ";\n" + "rule \"accumulate 2 times\"\n" + "when\n" + "  $LIST : java.util.List( )" + "  from accumulate( $Triple_1 : Triple( $CN : subject," + "    predicate == \"<http://deductions.sf.net/samples/princing.n3p.n3#number>\", $N : object )," + "      collectList( $N ) )\n" + "  $NUMBER : Number() from accumulate(" + "    $NUMBER_STRING_ : String() from $LIST , sum( Double.parseDouble( $NUMBER_STRING_)) )\n" + "then\n" + "  System.out.println(\"ok\");\n" + "end\n";
        KnowledgeBase kbase = this.getKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN1>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "200"));
        ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN2>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "100"));
        ksession.insert((Object)new Triple("<http://deductions.sf.net/samples/princing.n3p.n3#CN3>", "<http://deductions.sf.net/samples/princing.n3p.n3#number>", "100"));
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(rule));
        ksession.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testAccumulateWithVarsOutOfHashOrder() throws Exception {
        String rule = "package com.sample;\n\nimport java.util.List;\n\ndeclare MessageHolder\n  id : String\n  msg: String\nend\n\nquery getResults( String $mId, List $holders )\n  accumulate(  \n    $holder  : MessageHolder( id == $mId, $ans : msg ),\n    $holders := collectList( $holder )\n  ) \nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new MessageHolder( \"1\", \"x\" ) );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            AccumulateTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = this.getKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(rule));
        ksession.fireAllRules();
        QueryResults res = ksession.getQueryResults("getResults", new Object[]{"1", Variable.v});
        AccumulateTest.assertEquals((long)1L, (long)res.size());
        Object o = ((QueryResultsRow)res.iterator().next()).get("$holders");
        AccumulateTest.assertTrue((boolean)(o instanceof List));
        AccumulateTest.assertEquals((long)1L, (long)((List)o).size());
    }

    @Test(timeout=10000L)
    public void testAccumulateWithWindow() {
        String str = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 )\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        HashMap res = new HashMap();
        ksession.setGlobal("map", res);
        ksession.fireAllRules();
        for (int j = 0; j < 33; ++j) {
            ksession.insert((Object)(1.0 * (double)j));
            ksession.fireAllRules();
        }
    }

    @Test(timeout=10000L)
    public void testAccumulateWithEntryPoint() {
        String str = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from entry-point data,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        HashMap res = new HashMap();
        ksession.setGlobal("map", res);
        ksession.fireAllRules();
        for (int j = 0; j < 33; ++j) {
            ksession.getEntryPoint("data").insert((Object)(1.0 * (double)j));
            ksession.fireAllRules();
        }
    }

    @Test(timeout=10000L)
    public void testAccumulateWithWindowAndEntryPoint() {
        String str = "global java.util.Map map;\n \ndeclare Double\n@role(event)\nend\n \ndeclare window Streem\n    Double() over window:length( 10 ) from entry-point data\nend\n \nrule \"See\"\nwhen\n    $a : Double() from accumulate (\n        $d: Double()\n            from window Streem,\n        sum( $d )\n    )\nthen\n    System.out.println( \"We have a sum \" + $a );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        HashMap res = new HashMap();
        ksession.setGlobal("map", res);
        ksession.fireAllRules();
        for (int j = 0; j < 33; ++j) {
            ksession.getEntryPoint("data").insert((Object)(1.0 * (double)j));
            ksession.fireAllRules();
        }
    }

    @Test(timeout=10000L)
    public void test2AccumulatesWithOr() throws Exception {
        String str = "import java.util.*;\nimport " + MyPerson.class.getName() + ";\n" + "global java.util.Map map;\n" + "dialect \"mvel\"\n" + "\n" + "rule \"Test\"\n" + "    when\n" + "        $total : Number()\n" + "             from accumulate( MyPerson( $age: age ),\n" + "                              sum( $age ) )\n" + "\n" + "        $p: MyPerson();\n" + "        $k: List( size > 0 ) from accumulate( MyPerson($kids: kids) from $p.kids,\n" + "            init( ArrayList myList = new ArrayList(); ),\n" + "            action( myList.addAll($kids); ),\n" + "            reverse( myList.removeAll($kids); ),\n" + "            result( myList )\n" + "        )\n" + "\n" + "        $r : MyPerson(name == \"Jos Jr Jr\")\n" + "        or\n" + "        $r : MyPerson(name == \"Jos\")\n" + "    then\n" + "        Map pMap = map.get( $r.getName() );\n" + "        pMap.put( 'total', $total );\n" + "        pMap.put( 'p', $p );\n" + "        pMap.put( 'k', $k );\n" + "        pMap.put( 'r', $r );\n" + "        map.put('count', ((Integer)map.get('count')) + 1 );\n " + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ksession.setGlobal("map", map);
        map.put("Jos Jr Jr", new HashMap());
        map.put("Jos", new HashMap());
        map.put("count", Integer.valueOf(0));
        MyPerson josJr = new MyPerson("Jos Jr Jr", 20, Arrays.asList(new MyPerson("John Jr 1st", 10, Arrays.asList(new MyPerson("John Jr Jrx", 4, Collections.<MyPerson>emptyList()))), new MyPerson("John Jr 2nd", 8, Collections.<MyPerson>emptyList())));
        MyPerson jos = new MyPerson("Jos", 30, Arrays.asList(new MyPerson("Jeff Jr 1st", 10, Collections.<MyPerson>emptyList()), new MyPerson("Jeff Jr 2nd", 8, Collections.<MyPerson>emptyList())));
        ksession.execute((Command)new InsertElementsCommand(Arrays.asList(josJr, jos)));
        ksession.fireAllRules();
        System.out.println(map);
        AccumulateTest.assertEquals((Object)2, map.get("count"));
        Map pMap = (Map)map.get("Jos Jr Jr");
        AccumulateTest.assertEquals((Object)50.0, pMap.get("total"));
        List kids = (List)pMap.get("k");
        AccumulateTest.assertEquals((long)1L, (long)kids.size());
        AccumulateTest.assertEquals((Object)"John Jr Jrx", (Object)((MyPerson)kids.get(0)).getName());
        AccumulateTest.assertEquals((Object)josJr, pMap.get("p"));
        AccumulateTest.assertEquals((Object)josJr, pMap.get("r"));
        pMap = (Map)map.get("Jos");
        AccumulateTest.assertEquals((Object)50.0, pMap.get("total"));
        kids = (List)pMap.get("k");
        AccumulateTest.assertEquals((long)1L, (long)kids.size());
        AccumulateTest.assertEquals((Object)"John Jr Jrx", (Object)((MyPerson)kids.get(0)).getName());
        AccumulateTest.assertEquals((Object)josJr, pMap.get("p"));
        AccumulateTest.assertEquals((Object)jos, pMap.get("r"));
    }

    @Test
    public void testAccumulateWithExists() {
        String str = "import " + Course.class.getCanonicalName() + "\n" + "import " + Lecture.class.getCanonicalName() + "\n" + "global java.util.List list; \n" + "rule \"minimumWorkingDays\"\n" + "    when\n" + "        $course : Course($minWorkingDaySize : minWorkingDaySize)\n" + "        $dayCount : Number(intValue <= $minWorkingDaySize) from accumulate(\n" + "            $day : Integer()\n" + "            and exists Lecture(course == $course, day == $day),\n" + "            count($day)\n" + "        )\n" + "        // An uninitialized schedule should have no constraints broken\n" + "        exists Lecture(course == $course)\n" + "    then\n" + "       list.add( $course );\n" + "       list.add( $dayCount );\n" + "end\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Integer day1 = 1;
        Integer day2 = 2;
        Integer day3 = 3;
        Course c = new Course(2);
        Lecture l1 = new Lecture(c, day1);
        Lecture l2 = new Lecture(c, day2);
        ksession.insert((Object)day1);
        ksession.insert((Object)day2);
        ksession.insert((Object)day3);
        ksession.insert((Object)c);
        ksession.insert((Object)l1);
        ksession.insert((Object)l2);
        AccumulateTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        AccumulateTest.assertEquals((long)2L, (long)list.size());
        AccumulateTest.assertEquals((Object)c, list.get(0));
        AccumulateTest.assertEquals((Object)2L, list.get(1));
    }

    @Test
    public void testAccumulatesExpireVsCancel() throws Exception {
        String drl = "package com.sample;\n\nglobal java.util.List list; \ndeclare FactTest\n @role( event ) \nend\n \nrule \"A500 test\"\nwhen\n accumulate (\n $d : FactTest() over window:time(1m), $tot : count($d); $tot > 0 )\nthen\n System.out.println( $tot ); \n list.add( $tot.intValue() ); \n end\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        AccumulateTest.assertFalse((boolean)kbuilder.hasErrors());
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KieBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)kbConf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksConf, null);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactType ft = kbase.getFactType("com.sample", "FactTest");
        ksession.insert(ft.newInstance());
        ksession.fireAllRules();
        ksession.insert(ft.newInstance());
        ksession.fireAllRules();
        ksession.insert(ft.newInstance());
        ksession.fireAllRules();
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        clock.advanceTime(1L, TimeUnit.MINUTES);
        ksession.fireAllRules();
        AccumulateTest.assertFalse((boolean)list.contains(0));
    }

    @Test
    public void testManySlidingWindows() throws Exception {
        String drl = "package com.sample;\n\nglobal java.util.List list; \ndeclare Fakt\n  @role( event ) \n  id : int \nend\n \nrule Init \nwhen \n  $i : Integer() \nthen \n  insert( new Fakt( $i ) ); \nend\nrule \"Test\"\nwhen\n   accumulate ( $d : Fakt( id > 10 ) over window:length(2), $tot1 : count( $d ) ) \n   accumulate ( $d : Fakt( id < 50 ) over window:length(5), $tot2 : count( $d ) ) \nthen\n  System.out.println( \"Fire!\" ); \n  list.clear();\n   list.add( $tot1.intValue() ); \n  list.add( $tot2.intValue() ); \nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        System.out.println(kbuilder.getErrors());
        AccumulateTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Integer(20));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(1, 1));
        ksession.insert((Object)new Integer(20));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(2, 2));
        ksession.insert((Object)new Integer(20));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(2, 3));
        ksession.insert((Object)new Integer(2));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(2, 4));
        ksession.insert((Object)new Integer(2));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(2, 5));
        ksession.insert((Object)new Integer(2));
        ksession.fireAllRules();
        AccumulateTest.assertEquals(list, Arrays.asList(2, 5));
    }

    public static class Lecture {
        private Course course;
        private int day;

        public Lecture(Course course, int day) {
            this.course = course;
            this.day = day;
        }

        public Course getCourse() {
            return this.course;
        }

        public void setCourse(Course course) {
            this.course = course;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }
    }

    public static class Course {
        private int minWorkingDaySize;

        public Course(int minWorkingDaySize) {
            this.minWorkingDaySize = minWorkingDaySize;
        }

        public int getMinWorkingDaySize() {
            return this.minWorkingDaySize;
        }

        public void setMinWorkingDaySize(int minWorkingDaySize) {
            this.minWorkingDaySize = minWorkingDaySize;
        }
    }

    public static class MyPerson {
        private String name;
        private Integer age;
        private Collection<MyPerson> kids;

        public MyPerson(String name, Integer age, Collection<MyPerson> kids) {
            this.name = name;
            this.age = age;
            this.kids = kids;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public Collection<MyPerson> getKids() {
            return this.kids;
        }

        public void setKids(Collection<MyPerson> kids) {
            this.kids = kids;
        }

        public String toString() {
            return "MyPerson{name='" + this.name + '\'' + ", age=" + this.age + ", kids=" + this.kids + '}';
        }
    }

    public static class Triple {
        private String subject;
        private String predicate;
        private String object;

        public Triple() {
        }

        public Triple(String subject, String predicate, String object) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public String getObject() {
            return this.object;
        }
    }

    public static class MyObj {
        private final NestedObj nestedObj;

        public MyObj(long value) {
            this.nestedObj = new NestedObj(value);
        }

        public NestedObj getNestedObj() {
            return this.nestedObj;
        }

        public static class NestedObj {
            public long value;

            public NestedObj(long value) {
                this.value = value;
            }
        }
    }

    public static class DataSet {
        public Cheese[] cheese;
        public FactHandle[] cheeseHandles;
        public Person bob;
        public FactHandle bobHandle;
        public List<?> results;
    }
}

