/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.WorkingMemory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.Timer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.internal.KnowledgeBaseFactory;

@Ignore
public class SchedulerTest
extends DroolsTestCase {
    private PropagationContextFactory pctxFactory;
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, this.kBase.getReteooBuilder().getIdGenerator());
        this.pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    public void testScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        RuleImpl rule = new RuleImpl("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule.setTimer((Timer)new DurationTimer(100L));
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (Sink)node, true);
        Assert.assertEquals((long)0L, (long)data.size());
        node.assertLeftTuple((LeftTuple)tuple, context, (InternalWorkingMemory)ksession);
        ksession.fireAllRules();
        Thread.sleep(300L);
        Assert.assertEquals((long)1L, (long)data.size());
    }

    @Test
    public void testDoLoopScheduledActivation() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)this.kBase.newStatefulKnowledgeSession();
        InternalAgenda agenda = ksession.getAgenda();
        final RuleImpl rule = new RuleImpl("test-rule");
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        final ArrayList data = new ArrayList();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 3) {
                    PropagationContext context2 = SchedulerTest.this.pctxFactory.createPropagationContext(0L, 0, rule, (Tuple)((RuleTerminalNodeLeftTuple)knowledgeHelper.getTuple()), null);
                    RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (Sink)node, true);
                    node.assertLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)((StatefulKnowledgeSessionImpl)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (Sink)node, true);
        rule.setTimer((Timer)new DurationTimer(50L));
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        Assert.assertEquals((long)0L, (long)data.size());
        ksession.fireAllRules();
        Thread.sleep(2000L);
        Assert.assertEquals((long)4L, (long)data.size());
    }

    @Test
    public void testNoLoopScheduledActivation() throws Exception {
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        ReteooBuilder.IdGenerator idGenerator = kBase.getReteooBuilder().getIdGenerator();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newStatefulKnowledgeSession();
        InternalAgenda agenda = ksession.getAgenda();
        final RuleImpl rule = new RuleImpl("test-rule");
        final ArrayList data = new ArrayList();
        final RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule, rule.getLhs(), 0, this.buildContext);
        rule.setTimer((Timer)new DurationTimer(100L));
        rule.setNoLoop(true);
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                if (data.size() < 5) {
                    PropagationContext context2 = SchedulerTest.this.pctxFactory.createPropagationContext(0L, 0, rule, (Tuple)((RuleTerminalNodeLeftTuple)knowledgeHelper.getTuple()), null);
                    RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (Sink)node, true);
                    node.assertLeftTuple((LeftTuple)tuple2, context2, (InternalWorkingMemory)((StatefulKnowledgeSessionImpl)workingMemory));
                }
                data.add("tested");
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        PropagationContext context1 = this.pctxFactory.createPropagationContext(0L, 0, null, null, null);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (Sink)node, true);
        node.assertLeftTuple((LeftTuple)tuple1, context1, (InternalWorkingMemory)ksession);
        Assert.assertEquals((long)0L, (long)data.size());
        ksession.fireAllRules();
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)data.size());
    }
}

