/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.util.ArrayList;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class DeclarativeAgendaTest
extends CommonTestMethodBase {
    @Test(timeout=10000L)
    public void testSimpleBlockingUsingForall() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) salience -100 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 salience 200\n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     exists  Match( department == 'sales' ) \n";
        str = str + "     forall ( $a : Match( department == 'sales' ) Match( this == $a, active == false ) ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)2L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2:go1"));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testBasicBlockOnAnnotation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2:go2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule3:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule3:go1"));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testApplyBlockerFirst() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test(timeout=10000L)
    public void testApplyBlockerFirstWithFireAllRulesInbetween() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)0L, (long)list.size());
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test
    public void testApplyBlockerSecond() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test(timeout=10000L)
    public void testApplyBlockerSecondWithUpdate() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.update(go2, (Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test(timeout=10000L)
    public void testApplyBlockerSecondAfterUpdate() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
        list.clear();
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.update(go1, (Object)"go1");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1:go1"));
    }

    public StatefulKnowledgeSession getStatefulKnowledgeSession() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        return ksession;
    }

    @Test(timeout=10000L)
    public void testMultipleBlockers() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0:go2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0:go3"));
        list.clear();
        ksession.retract(go3);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)0L, (long)list.size());
        ksession.retract(go2);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)0L, (long)list.size());
        ksession.retract(go1);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0:go0"));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testMultipleBlockersWithUnblockAll() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @Propagation(EAGER) @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        str = str + "rule unblockAll @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go4' ) \n";
        str = str + "     $i : Match( department == 'sales', active == true ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.unblockAllMatches( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        System.out.println(list);
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules1:rule0:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules2:rule0:go2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules3:rule0:go3"));
        list.clear();
        FactHandle go4 = ksession.insert((Object)"go4");
        ksession.fireAllRules();
        System.out.println(list);
        DeclarativeAgendaTest.assertEquals((long)5L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("unblockAll:rule0:go4"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0:go0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules1:rule0:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules2:rule0:go2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("blockerAllSalesRules3:rule0:go3"));
    }

    @Test(timeout=10000L)
    public void testIterativeUpdate() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule2 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule2' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $l : List( ) \n";
        str = str + "     $i : Match( rule.name == $l[0] ) \n";
        str = str + "then \n";
        str = str + "    list.add( 'block:' + $i.rule.name  ); \n";
        str = str + "    kcontext.blockMatch( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle rule0 = ksession.insert((Object)"rule0");
        FactHandle rule1 = ksession.insert((Object)"rule1");
        FactHandle rule2 = ksession.insert((Object)"rule2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        ArrayList<String> l = new ArrayList<String>();
        l.add("rule0");
        FactHandle lh = ksession.insert(l);
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)4L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("block:rule0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2"));
        DeclarativeAgendaTest.assertFalse((boolean)list.contains("rule0"));
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("block:rule0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2"));
        DeclarativeAgendaTest.assertFalse((boolean)list.contains("rule0"));
        list.clear();
        l.set(0, "rule1");
        ksession.update(lh, l);
        ksession.fireAllRules();
        System.out.println(list);
        DeclarativeAgendaTest.assertEquals((long)2L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("block:rule1"));
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("block:rule1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule0"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2"));
        DeclarativeAgendaTest.assertFalse((boolean)list.contains("rule1"));
        list.clear();
        l.set(0, "rule2");
        ksession.update(lh, l);
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)2L, (long)list.size());
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("block:rule2"));
    }

    @Test(timeout=10000L)
    public void testCancelActivation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Match( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    kcontext.cancelMatch( $i ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        final ArrayList cancelled = new ArrayList();
        ksession.addEventListener(new AgendaEventListener(){

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
                cancelled.add(event);
            }
        });
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)0L, (long)list.size());
        DeclarativeAgendaTest.assertEquals((long)1L, (long)cancelled.size());
        DeclarativeAgendaTest.assertEquals((Object)"rule1", (Object)((MatchCancelledEvent)cancelled.get(0)).getMatch().getRule().getName());
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testActiveInActiveChanges() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Match.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule countActivateInActive @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $active : Number( this == 1 ) from accumulate( $a : Match( department == 'sales', active == true ), count( $a ) )\n";
        str = str + "     $inActive : Number( this == 2 ) from  accumulate( $a : Match( department == 'sales', active == false ), count( $a ) )\n";
        str = str + "then \n";
        str = str + "    list.add( $active + ':' + $inActive  ); \n";
        str = str + "    kcontext.halt( ); \n";
        str = str + "end \n";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)3L, (long)list.size());
        System.out.println(list);
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("1:2"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule2:go1"));
        DeclarativeAgendaTest.assertTrue((boolean)list.contains("rule3:go1"));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testCancelMultipleActivations() {
        String str = "package org.domain.test\nimport " + Match.class.getName() + "\nglobal java.util.List list\nrule sales1 @department('sales')\nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales1\");\nend\n\nrule sales2 @department('sales') \nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales2\");\nend\n\nrule salesCancel @activationListener('direct')\nwhen\n    $i : Match( department == 'sales' )\nthen\n    kcontext.cancelMatch($i);\nend";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"fireRules");
        ksession.fireAllRules();
        System.out.println(list);
        DeclarativeAgendaTest.assertEquals((long)0L, (long)list.size());
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testCancelActivationOnInsertAndUpdate() {
        String str = "package org.domain.test\nimport " + Match.class.getName() + "\nglobal java.util.List list\nrule sales1 @department('sales') @category('special')\nsalience 10\nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales1\");\nend\n\nrule sales2 @department('sales') \nwhen\n    String( this == 'fireRules' )\nthen\n    list.add(\"sales2\");\nend\n\nrule salesCancel @activationListener('direct')\nwhen\n    String(this == 'fireCancelRule')\n    $i : Match( department == 'sales', category == 'special' )\nthen\n    kcontext.cancelMatch($i);\nend";
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(kconf, str);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle fireRules = ksession.insert((Object)"fireRules");
        FactHandle fireCancelRule = ksession.insert((Object)"fireCancelRule");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)1L, (long)list.size());
        ksession.update(fireRules, (Object)"fireRules");
        ksession.update(fireCancelRule, (Object)"fireCancelRule");
        ksession.fireAllRules();
        DeclarativeAgendaTest.assertEquals((long)2L, (long)list.size());
        ksession.dispose();
    }
}

