/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.Cheese;
import org.drools.compiler.FactA;
import org.drools.compiler.FactB;
import org.drools.compiler.Order;
import org.drools.compiler.OrderItem;
import org.drools.compiler.Person;
import org.drools.compiler.Precondition;
import org.drools.compiler.StockTick;
import org.drools.compiler.integrationtests.SerializationHelper;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.reteoo.integrationtests.CommonTestMethodBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DynamicRulesTest
extends CommonTestMethodBase {
    @Test(timeout=10000L)
    public void testDynamicRuleAdditions() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Dynamic1.drl"));
        StatefulKnowledgeSession workingMemory = this.createKnowledgeSession(kbase);
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic2.drl"));
        kbase.addKnowledgePackages(kpkgs);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((long)5L, (long)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        DynamicRulesTest.assertTrue(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0);
        DynamicRulesTest.assertTrue(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0);
        list.clear();
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic3.drl"));
        kbase.addKnowledgePackages(kpkgs);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((String)"Rule from package 3 should have been fired", (Object)"match Person ok", (Object)bob.getStatus());
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(0));
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic4.drl"));
        kbase.addKnowledgePackages(kpkgs);
        workingMemory.fireAllRules();
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        DynamicRulesTest.assertEquals((String)"Rule from package 4 should have been fired", (Object)"Who likes Stilton ok", (Object)bob.getStatus());
        DynamicRulesTest.assertEquals((long)2L, (long)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(1));
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovals() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Dynamic1.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"));
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic2.drl"));
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        FactHandle fh0 = wm.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        FactHandle fh1 = wm.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        FactHandle fh2 = wm.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        FactHandle fh3 = wm.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle fh4 = wm.insert((Object)cheddar);
        wm.fireAllRules();
        DynamicRulesTest.assertEquals((long)15L, (long)list.size());
        list.clear();
        kbase.removeRule("org.drools.compiler.test", "Who likes Stilton");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        DynamicRulesTest.assertEquals((long)12L, (long)list.size());
        list.clear();
        kbase.removeRule("org.drools.compiler.test", "like cheese");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        DynamicRulesTest.assertEquals((long)8L, (long)list.size());
        list.clear();
        Cheese muzzarela = new Cheese("muzzarela", 5);
        wm.insert((Object)muzzarela);
        wm.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        list.clear();
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        KnowledgeBase kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)this.loadKnowledgeBase("test_Dynamic1.drl", "test_Dynamic2.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"));
        StatefulKnowledgeSession workingMemory = this.createKnowledgeSession(kbase);
        DynamicRulesTest.assertEquals((long)2L, (long)kbase.getKnowledgePackages().size());
        KnowledgePackage knowledgePackage = null;
        for (KnowledgePackage pkg : kbase.getKnowledgePackages()) {
            if (!pkg.getName().equals("org.drools.compiler.test")) continue;
            knowledgePackage = pkg;
            break;
        }
        DynamicRulesTest.assertEquals((long)5L, (long)knowledgePackage.getRules().size());
        kbase.removeRule("org.drools.compiler.test", "Who likes Stilton");
        DynamicRulesTest.assertEquals((long)4L, (long)knowledgePackage.getRules().size());
        kbase.removeRule("org.drools.compiler.test", "like cheese");
        DynamicRulesTest.assertEquals((long)3L, (long)knowledgePackage.getRules().size());
        kbase.removeKnowledgePackage("org.drools.compiler.test");
        DynamicRulesTest.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
    }

    @Test(timeout=10000L)
    public void testDynamicFunction() throws Exception {
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction1.drl"));
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(0));
        kbase.removeFunction("org.drools.compiler.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            DynamicRulesTest.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        Collection kpkgs2 = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction2.drl"));
        kbase.addKnowledgePackages(kpkgs2);
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(6), list.get(1));
        Collection kpkgs3 = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction3.drl"));
        kbase.addKnowledgePackages(kpkgs3);
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(2));
    }

    @Test(timeout=10000L)
    public void testRemovePackage() throws Exception {
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_RemovePackage.drl"));
        String packageName = ((KnowledgePackage)kpkgs.iterator().next()).getName();
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.insert((Object)new Precondition("genericcode", "genericvalue"));
        session.fireAllRules();
        KnowledgeBase ruleBaseWM = session.getKieBase();
        ruleBaseWM.removeKnowledgePackage(packageName);
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_RemovePackage.drl"));
        ruleBaseWM.addKnowledgePackages(kpkgs);
        ruleBaseWM = (KnowledgeBase)SerializationHelper.serializeObject((Object)ruleBaseWM);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
        ruleBaseWM.removeKnowledgePackage(packageName);
        ruleBaseWM.addKnowledgePackages((Collection)SerializationHelper.serializeObject((Object)kpkgs));
        ruleBaseWM.removeKnowledgePackage(packageName);
        ruleBaseWM.addKnowledgePackages((Collection)SerializationHelper.serializeObject((Object)kpkgs));
    }

    @Test(timeout=10000L)
    public void testDynamicRules() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRules.drl"));
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testDynamicRules2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        session.insert((Object)a);
        session.insert((Object)b);
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRules2.drl"));
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)session, (boolean)true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemove() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic1.drl"));
        String pkgName = ((KnowledgePackage)kpkgs.iterator().next()).getName();
        kbase.addKnowledgePackages(kpkgs);
        kbase.removeKnowledgePackage(pkgName);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic1.drl"));
        pkgName = ((KnowledgePackage)kpkgs.iterator().next()).getName();
        kbase.addKnowledgePackages(kpkgs);
        kbase.removeKnowledgePackage(pkgName);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.compiler.Cheese");
            KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBase kbase = this.loadKnowledgeBase(kbuilderConf, "test_Dynamic1.drl");
            StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.compiler.Cheese");
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            kbase = this.loadKnowledgeBase(kbuilderConf, "test_Dynamic1.drl");
            wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.compiler.Cheese");
            KnowledgeBase kbase = this.loadKnowledgeBase("test_Dynamic1.drl");
            StatefulKnowledgeSession wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.compiler.Cheese");
            kbase = this.loadKnowledgeBase("test_Dynamic1.drl");
            wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testCollectDynamicRules() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CollectDynamicRules1.drl");
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("muzzarela", 10));
        kbase.addKnowledgePackages(this.loadKnowledgePackages("test_CollectDynamicRules2.drl"));
        session.fireAllRules();
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        DynamicRulesTest.assertEquals((long)2L, (long)((List)list.get(0)).size());
    }

    @Test(timeout=10000L)
    public void testDynamicNotNode() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_CollectDynamicRules1.drl");
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(null, env);
        List results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicNotNode.drl"));
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        DynamicRulesTest.assertEquals((long)0L, (long)results.size());
        kbase.removeKnowledgePackage("org.drools.compiler");
        ksession.retract(ksession.getFactHandle((Object)b));
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicNotNode.drl"));
        kbase.addKnowledgePackages(kpkgs);
        kbase = (KnowledgeBase)SerializationHelper.serializeObject((Object)kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession((KieSession)ksession, (boolean)false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRulesAddRemove() {
        try {
            KnowledgeBase kbase = this.loadKnowledgeBase("test_DynamicRulesTom.drl");
            StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            InternalFactHandle h1 = (InternalFactHandle)session.insert((Object)new Person("tom", 1));
            InternalFactHandle h2 = (InternalFactHandle)session.insert((Object)new Person("fred", 2));
            InternalFactHandle h3 = (InternalFactHandle)session.insert((Object)new Person("harry", 3));
            InternalFactHandle h4 = (InternalFactHandle)session.insert((Object)new Person("fred", 4));
            InternalFactHandle h5 = (InternalFactHandle)session.insert((Object)new Person("ed", 5));
            InternalFactHandle h6 = (InternalFactHandle)session.insert((Object)new Person("tom", 6));
            InternalFactHandle h7 = (InternalFactHandle)session.insert((Object)new Person("sreeni", 7));
            InternalFactHandle h8 = (InternalFactHandle)session.insert((Object)new Person("jill", 8));
            InternalFactHandle h9 = (InternalFactHandle)session.insert((Object)new Person("ed", 9));
            InternalFactHandle h10 = (InternalFactHandle)session.insert((Object)new Person("tom", 10));
            session.fireAllRules();
            DynamicRulesTest.assertEquals((long)3L, (long)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h1.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h6.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h10.getObject()));
            results.clear();
            kbase.addKnowledgePackages(this.loadKnowledgePackages("test_DynamicRulesFred.drl"));
            session.fireAllRules();
            DynamicRulesTest.assertEquals((long)2L, (long)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h2.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h4.getObject()));
            results.clear();
            kbase.removeKnowledgePackage("tom");
            kbase.addKnowledgePackages(this.loadKnowledgePackages("test_DynamicRulesEd.drl"));
            session.fireAllRules();
            DynamicRulesTest.assertEquals((long)2L, (long)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h5.getObject()));
            DynamicRulesTest.assertTrue((boolean)results.contains(h9.getObject()));
            results.clear();
            ((Person)h3.getObject()).setName("ed");
            session.update((FactHandle)h3, h3.getObject());
            session.fireAllRules();
            DynamicRulesTest.assertEquals((long)1L, (long)results.size());
            DynamicRulesTest.assertTrue((boolean)results.contains(h3.getObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            DynamicRulesTest.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetwork() throws Exception {
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork.drl"));
        KnowledgeBase kbase = this.loadKnowledgeBase(new String[0]);
        kbase.addKnowledgePackages(kpkgs);
        kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork2.drl"));
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        order.addItem(item1);
        FactHandle item1Fh = session.insert((Object)item1);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        order.addItem(item2);
        FactHandle item2Fh = session.insert((Object)item2);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        order.addItem(item3);
        FactHandle item3Fh = session.insert((Object)item3);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        order.addItem(item4);
        FactHandle item4Fh = session.insert((Object)item4);
        session.insert((Object)order);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)11L, (long)list.size());
        kbase.removeRule("org.drools.compiler", "Apply Discount on all books");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)10L, (long)list.size());
        kbase.removeRule("org.drools.compiler", "like book");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)8L, (long)list.size());
        OrderItem item5 = new OrderItem(order, 5, "Sinatra : Vegas", 2, 5);
        FactHandle item5Fh = session.insert((Object)item5);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)10L, (long)list.size());
        kbase.removeKnowledgePackage("org.drools.compiler");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.update(item5Fh, (Object)item5);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)0L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemorySubNetwork() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase("test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork2.drl", "test_DynamicRulesWithSubnetwork.drl");
        DynamicRulesTest.assertEquals((long)2L, (long)kbase.getKnowledgePackages().size());
        DynamicRulesTest.assertEquals((long)4L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.compiler")).getRules().size());
        kbase.removeRule("org.drools.compiler", "Apply Discount on all books");
        DynamicRulesTest.assertEquals((long)3L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.compiler")).getRules().size());
        kbase.removeRule("org.drools.compiler", "like book");
        DynamicRulesTest.assertEquals((long)2L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.compiler")).getRules().size());
        kbase.removeKnowledgePackage("org.drools.compiler");
        DynamicRulesTest.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
    }

    @Test(timeout=10000L)
    @Ignore
    public void testRemovePackageSubNetwork() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_DynamicRulesWithSubnetwork.drl");
        String packageName = ((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getName();
        StatefulKnowledgeSession workingMemory = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        OrderItem item5 = new OrderItem(order, 5, "The Master and Margarita", 1, 29);
        order.addItem(item1);
        order.addItem(item2);
        order.addItem(item3);
        order.addItem(item4);
        order.addItem(item5);
        workingMemory.insert((Object)order);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)results.size());
        DynamicRulesTest.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        KnowledgeBase ruleBaseWM = workingMemory.getKieBase();
        ruleBaseWM.removeKnowledgePackage(packageName);
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
        ruleBaseWM.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        results = (List)workingMemory.getGlobal("results");
        DynamicRulesTest.assertEquals((long)1L, (long)results.size());
        DynamicRulesTest.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removeKnowledgePackage(packageName);
        ruleBaseWM.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)results.size());
        DynamicRulesTest.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removeKnowledgePackage(packageName);
        ruleBaseWM.addKnowledgePackages((Collection)SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)results.size());
        DynamicRulesTest.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemoveSubNetworks() throws Exception {
        try {
            KnowledgeBase kbase = this.getKnowledgeBase();
            Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
            KnowledgePackage kpkg = (KnowledgePackage)kpkgs.toArray()[0];
            kbase.addKnowledgePackages(kpkgs);
            kbase.removeKnowledgePackage(kpkg.getName());
            kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
            kpkg = (KnowledgePackage)kpkgs.toArray()[0];
            kbase.addKnowledgePackages(kpkgs);
            kbase.removeKnowledgePackage(kpkg.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            DynamicRulesTest.fail((String)"Should not raise any exception");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleAdditionsWithEntryPoints() throws Exception {
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_DynamicWithEntryPoint.drl");
        KnowledgeBase kbase = this.getKnowledgeBase();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        kbase.addKnowledgePackages(kpkgs);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EntryPoint ep = ksession.getEntryPoint("in-channel");
        ep.insert((Object)new StockTick(1L, "RHT", 20.0, 10000L));
        ep.insert((Object)new StockTick(2L, "RHT", 21.0, 15000L));
        ep.insert((Object)new StockTick(3L, "RHT", 22.0, 20000L));
        ksession.fireAllRules();
        DynamicRulesTest.assertEquals((long)3L, (long)results.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsPkgBuilder() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/testEnumReteoo.jar")}, ((Object)((Object)this)).getClass().getClassLoader());
            KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages(conf, "test_EnumSerialization.drl");
            byte[] out = DroolsStreamUtils.streamOut(kpkgs);
            KieBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KnowledgeBase kbase = this.getKnowledgeBase(kbaseConf);
            kbase.addKnowledgePackages(kpkgs);
            StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            DynamicRulesTest.assertEquals((long)1L, (long)ksession.fireAllRules());
            DynamicRulesTest.assertEquals((long)1L, (long)list.size());
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/testEnumReteoo.jar")}, ((Object)((Object)this)).getClass().getClassLoader());
            KnowledgeBuilderConfiguration conf2 = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Collection kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader2);
                kpkgs2 = (Collection)DroolsStreamUtils.streamIn((byte[])out);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            KieBaseConfiguration kbaseConf2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            KnowledgeBase kbase2 = this.getKnowledgeBase(kbaseConf2);
            kbase2.addKnowledgePackages(kpkgs2);
            ksession = this.createKnowledgeSession(kbase2);
            list = new ArrayList();
            ksession.setGlobal("list", list);
            DynamicRulesTest.assertEquals((long)1L, (long)ksession.fireAllRules());
            DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsContextClassloader() throws Exception {
        try {
            ArrayList list;
            StatefulKnowledgeSession ksession;
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/testEnumReteoo.jar")}, ((Object)((Object)this)).getClass().getClassLoader());
            loader1.loadClass("org.drools.Primitives");
            loader1.loadClass("org.drools.TestEnum");
            byte[] out = null;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Collection kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader1);
                Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_EnumSerialization.drl");
                out = DroolsStreamUtils.streamOut(kpkgs);
                KnowledgeBase kbase = this.getKnowledgeBase();
                kbase.addKnowledgePackages(kpkgs);
                ksession = this.createKnowledgeSession(kbase);
                list = new ArrayList();
                ksession.setGlobal("list", list);
                DynamicRulesTest.assertEquals((long)1L, (long)ksession.fireAllRules());
                DynamicRulesTest.assertEquals((long)1L, (long)list.size());
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/testEnumReteoo.jar")}, ((Object)((Object)this)).getClass().getClassLoader());
            loader2.loadClass("org.drools.Primitives");
            loader2.loadClass("org.drools.TestEnum");
            ccl = Thread.currentThread().getContextClassLoader();
            kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader2);
                kpkgs2 = (Collection)DroolsStreamUtils.streamIn((byte[])out);
                KnowledgeBase kbase2 = this.getKnowledgeBase();
                kbase2.addKnowledgePackages(kpkgs2);
                ksession = this.createKnowledgeSession(kbase2);
                list = new ArrayList();
                ksession.setGlobal("list", list);
                DynamicRulesTest.assertEquals((long)1L, (long)ksession.fireAllRules());
                DynamicRulesTest.assertEquals((long)1L, (long)list.size());
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetworkAndNot() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_DynamicRulesWithNotSubnetwork.drl");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener alistener = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(alistener);
        ksession.insert((Object)new Person("toni"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.never())).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("bob"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("mark"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
        kbase.removeKnowledgePackage("org.drools.compiler");
        DynamicRulesTest.assertEquals((long)0L, (long)kbase.getKnowledgePackages().size());
        Collection<KnowledgePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithNotSubnetwork.drl");
        kbase.addKnowledgePackages(kpkgs);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
    }

    @Test(timeout=10000L)
    public void testSharedLIANodeRemoval() throws Exception {
        String str = "global java.util.List list;\n";
        str = str + "rule \"test\"\n";
        str = str + "when\n";
        str = str + "  exists(eval(true))\n";
        str = str + "then\n";
        str = str + " list.add(\"fired\");\n";
        str = str + "end\n";
        KnowledgeBase kbase = this.getKnowledgeBase();
        Collection kpkgs = (Collection)SerializationHelper.serializeObject(this.loadKnowledgePackagesFromString(str));
        kbase.addKnowledgePackages(kpkgs);
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        session.setGlobal("list", list);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
        list.clear();
        KnowledgePackage kpkg = (KnowledgePackage)kpkgs.toArray()[0];
        kbase.removeKnowledgePackage(kpkg.getName());
        kbase.addKnowledgePackages(kpkgs);
        session = this.createKnowledgeSession(kbase);
        session.setGlobal("list", list);
        session.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRulesWithTypeDeclarations() {
        String type = "package com.sample\ndeclare type Foo\n  id : int\nend\n";
        String r1 = "package com.sample\nrule R1 when\n  not Foo()\nthen\n  insert( new Foo(1) );\nend\n";
        String r2 = "package com.sample\nrule R2 when\n  $f : Foo()\nthen\n  $f.setId( 2 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])type.getBytes()), ResourceType.DRL);
        DynamicRulesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).afterMatchFired((AfterMatchFiredEvent)Matchers.any(AfterMatchFiredEvent.class));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)kbase);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r1.getBytes()), ResourceType.DRL);
        DynamicRulesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        ksession.fireAllRules();
        ArgumentCaptor capt = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        DynamicRulesTest.assertThat((Object)"R1", (Matcher)CoreMatchers.is((Object)((AfterMatchFiredEvent)capt.getValue()).getMatch().getRule().getName()));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)kbase);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r2.getBytes()), ResourceType.DRL);
        DynamicRulesTest.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        DynamicRulesTest.assertThat((Object)"R2", (Matcher)CoreMatchers.is((Object)((AfterMatchFiredEvent)capt.getAllValues().get(2)).getMatch().getRule().getName()));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    @Ignore
    public void testJBRULES_2206() {
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        ((RuleBaseConfiguration)config).setRuleBaseUpdateHandler(null);
        KnowledgeBase kbase = this.getKnowledgeBase(config);
        StatefulKnowledgeSession session = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        session.addEventListener(ael);
        for (int i = 0; i < 5; ++i) {
            session.insert((Object)new Cheese());
        }
        kbase.addKnowledgePackages(this.loadKnowledgePackages("test_JBRULES_2206_1.drl"));
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
        int fireCount = session.fireAllRules();
        DynamicRulesTest.assertEquals((long)2L, (long)fireCount);
        kbase.addKnowledgePackages(this.loadKnowledgePackages("test_JBRULES_2206_2.drl"));
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).matchCreated((MatchCreatedEvent)Matchers.any(MatchCreatedEvent.class));
        fireCount = session.fireAllRules();
        DynamicRulesTest.assertEquals((long)1L, (long)fireCount);
        session.dispose();
    }

    @Test
    public void testSegmentMerging() {
        String drl1 = "global java.util.List list\nrule R1 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 2 )\nthen\n  list.add( $j );\nend\n";
        String drl2 = "global java.util.List list\nrule R2 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 3 )\nthen\n  list.add( $j );\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(drl1));
        StatefulKnowledgeSession ksession = this.createKnowledgeSession((KnowledgeBase)kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.insert((Object)4);
        ksession.insert((Object)8);
        ksession.insert((Object)12);
        ksession.fireAllRules();
        DynamicRulesTest.assertEquals((long)8L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        kbase.addKnowledgePackages(this.loadKnowledgePackagesFromString(drl2));
        kbase.removeRule("defaultpkg", "R1");
        ksession.fireAllRules();
        DynamicRulesTest.assertEquals((long)12L, (long)((Integer)list.get(0)).intValue());
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 510L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

