/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.drools.compiler.CommonTestMethodBase;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.io.impl.ByteArrayResource;
import org.junit.Test;
import org.kie.api.definition.type.Modifies;
import org.kie.api.definition.type.PropertyReactive;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class PropertyReactivityTest
extends CommonTestMethodBase {
    @Test
    public void testComposedConstraint() {
        String str = "package org.drools.test;\n\nimport " + Klass2.class.getCanonicalName() + ";\n\nrule R when \n $k2 : Klass2(b == 0 || c == 0)\nthen modify($k2) { setD(1) }\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Klass2 k2 = new Klass2(0, 0, 0, 0);
        ksession.insert((Object)k2);
        PropertyReactivityTest.assertEquals((long)1L, (long)ksession.fireAllRules());
        PropertyReactivityTest.assertEquals((long)1L, (long)k2.getD());
    }

    @Test
    public void testScrambleProperties() {
        String str = "package org.drools.test\n global java.util.List list\n declare Parent\n @propertyReactive\n a : int\n k : int\n z : int\n end\n\n declare Child extends Parent\n @propertyReactive\n p : int\n end\n\n\n rule Init\n when\n then\n insert( new Child( 1, 3, 5, 7 ) );\n end\n\n rule Mod\n when\n $p : Parent()\n then\n modify( $p ) { setZ( 99 ); }\n end\n\n rule React2\n when\n Child( p == 7 )\n then\n list.add( \"React2\" );\n end\n\n rule React\n when\n Child( z == 99 )\n then\n list.add( \"React\" );\n end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertTrue((boolean)list.contains("React"));
        PropertyReactivityTest.assertTrue((boolean)list.contains("React2"));
    }

    @Test
    public void testScrambleWithInterfaces() {
        String str = "package org.drools.test;\n\nimport " + Intf1.class.getCanonicalName() + ";\nimport " + Intf2.class.getCanonicalName() + ";\nimport " + Klass.class.getCanonicalName() + ";\nimport " + Klass2.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass( 1, 2, 3, 4, 5, 6 ) );\n  insert( new Klass2( 2, 3, 4, 5 ) );\nend\n\nrule \"On1\"\nwhen\n  $x : Intf1( )\nthen\n  System.out.println( \"Modify by interface \" );\n  modify ( $x ) { setD( 200 ) }\nend\nrule \"On2\"\nwhen\n  $x : Klass2( )\nthen\n  System.out.println( \"Modify by class \" );\n  modify ( $x ) { setD( 200 ) }\nend\n\nrule \"Log1\"\nwhen\n  Klass( d == 200, $id : id ) \nthen\n  System.out.println( \"Log1 - As K1 \" + $id );\n  list.add( $id + \"@K1\" );\nend\n\nrule \"Log2\"\nwhen\n  Klass2( d == 200, $id : id ) \nthen\n  System.out.println( \"Log2 - As K2 \" + $id );\n  list.add( $id + \"@K2\" );\nend\n\nrule \"Log3\"\nwhen\n  Intf1( d == 200, $id : id ) \nthen\n  System.out.println( \"Log3 - As I1 \" + $id );\n  list.add( $id + \"@I1\" );\nend\n\nrule \"Log4\"\nwhen\n  Intf2( d == 200, $id : id ) \nthen\n  System.out.println( \"Log4 - As K2 \" + $id );\n  list.add( $id + \"@I2\" );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        System.out.println(list);
        PropertyReactivityTest.assertTrue((boolean)list.containsAll(Arrays.asList("k1@K1", "k1@I1", "k1@I2")));
        PropertyReactivityTest.assertTrue((boolean)list.containsAll(Arrays.asList("k2@K2", "k2@I2")));
        PropertyReactivityTest.assertEquals((long)5L, (long)list.size());
    }

    @Test
    public void testScrambleWithInterfacesAndObject() {
        String str = "package org.drools.test;\n\nimport " + Intf2.class.getCanonicalName() + ";\nimport " + Klass2.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass2( 2, 3, 4, 5 ) );\nend\nrule \"Mod\"\nwhen\n  $x : Intf2( )\nthen\n  modify ( $x ) { setD( 200 ) }\nend\n\nrule \"Log\"\nwhen\n  Klass2( d == 200, $id : id ) \nthen\n  list.add( \"Klass2\" );\nend\n\nrule \"LogObject\" salience -1\nwhen\n  $o : Object( ) \nthen\n  list.add( $o.getClass().getSimpleName() );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertEquals((Object)"Klass2", list.get(0));
        PropertyReactivityTest.assertEquals((Object)"Klass2", list.get(1));
    }

    @Test
    public void testWithDeclaredTypeAndTraitInDifferentPackages() {
        String str1 = "package org.pkg1;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.pkg2;\ndeclare Bean     @propertyReactive\n    @Traitable\n    a : int\n    b : int\nend";
        String str3 = "package org.pkg3;\nimport org.pkg1.Trait;\nimport org.pkg2.Bean;\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str1, str2, str3});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
    }

    @Test
    public void testWithBeanAndTraitInDifferentPackages() {
        String str1 = "package org.drools.compiler.integrationtests;\ndeclare trait Trait     @propertyReactive\n    a : int\nend";
        String str2 = "package org.drools.test;\nimport org.drools.compiler.integrationtests.Trait;\nimport " + Bean.class.getCanonicalName() + ";\nrule Init\nwhen\nthen\n    insert(new Bean(1, 2));\nend\nrule R\nwhen\n   $b : Bean( b == 2)then\n   Trait t = don( $b, Trait.class, true );\n   modify(t) { setA(2) };\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str1, str2});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
    }

    @Test
    public void testRepeatedPatternWithPR() {
        String str1 = "package org.test;\nglobal java.util.List list; \ndeclare SampleBean \n@propertyReactive \nx : java.math.BigDecimal \ny : java.math.BigDecimal \nid : Long @key\nend \n rule \"calculate y\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n y =5B;\n }\n list.add( $bean.y ); \n end\n\n rule \"calculate x\"\n dialect \"mvel\"\n when\n $bean : SampleBean(id == 1L);\n then\n modify($bean){\n x =10B;\n }\n list.add( $bean.x ); \n end\n rule Init \n when\n then\n insert( new SampleBean( 1L ) ); \n end";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str1});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertTrue((boolean)list.contains(new BigDecimal(10)));
        PropertyReactivityTest.assertTrue((boolean)list.contains(new BigDecimal(5)));
    }

    @Test
    public void testPRWithCollections() {
        String str1 = "package org.test;\nimport java.util.*\n\nglobal List list;\ndeclare java.util.ArrayList end \ndeclare MyList extends java.util.ArrayList \nend\n\ndeclare Bean\n@propertyReactive\n id : int\n num : int\n values : MyList \n checks : Map \n str : String\nend\n\n\nrule Init\nwhen\nthen\n insert( new Bean( 42, 0, new MyList(), new HashMap(), \"\" ) );\nend\n\nrule M1\nwhen\n $b : Bean( id == 42 )\nthen\n System.out.println( 1 ); \n list.add( 1 ); \n modify ( $b ) { setNum( 1 ); }\nend\n\nrule M2\nwhen\n $b : Bean( num == 1 )\nthen\n System.out.println( 2 ); \n list.add( 2 ); \n modify ( $b ) { getValues().add( \"foo\" ); }\nend\n\nrule M3\nwhen\n $b : Bean( values contains \"foo\" )\nthen\n System.out.println( 3 ); \n list.add( 3 ); \n modify ( $b ) { setStr( \"x\" ); }\nend\n \n rule M4\nwhen\n $b : Bean( str == \"x\" )\nthen\n System.out.println( 4 ); \n list.add( 4 ); \n modify ( $b ) { getChecks().put( \"x\", 13 ); }\nend\n\nrule M5\nwhen\n $b : Bean( checks[ \"x\" ] > 10 )\nthen\n System.out.println( 5 ); \n list.add( 5 ); \n modify ( $b ) { getChecks().clear(); }\nend\n\nrule Log\nsalience 1\nwhen\n $b : Bean() @watch( values, checks ) \nthen\n System.out.println( \"Log >> \" + $b );\n list.add( 0 );\nend";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str1});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals(Arrays.asList(0, 1, 2, 0, 3, 4, 0, 5, 0), list);
    }

    @Test
    public void testPRWithPositionalUnification() {
        String str1 = "package org.test;\nglobal java.util.List list; \ndeclare Man \n@propertyReactive \n name : String \nend \ndeclare Animal \n@propertyReactive \n id : int \n owner : String \n age : int \nend \nrule Init \nwhen \nthen \n insert( new Man( \"alan\" ) ); \n insert( new Animal( 1, \"bob\", 7 ) ); \nend \nrule \"Mod Man\" \nwhen \n $m :Man() \nthen \n modify ( $m ) { setName( \"bob\" ); } \nend \nrule \"Mod Per\" \nwhen \n $m :Animal() \nthen \n modify ( $m ) {  setId( 1 ); \n  } \nend \nrule Join_1\nwhen\n Man( $name ; ) \n Animal( $name := owner ) \nthen\n list.add( 1 ); \nend\nrule Join_3\nwhen\n Man( $name ; ) \n Animal( $id, $name; ) \n Integer( this == $id ) \nthen\n list.add( 2 ); \nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str1});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)1);
        ksession.fireAllRules();
        PropertyReactivityTest.assertTrue((boolean)list.contains(1));
        PropertyReactivityTest.assertTrue((boolean)list.contains(2));
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testPRConstraintOnAttributesWithoutSetter() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass3( fullName == 'Walter White' )\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)1L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX -> Walter"), list);
    }

    @Test
    public void testPRConstraintOnAttributesWithoutSetterUsingWatches() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass3( fullName == 'Walter White' ) @watch( name, lastName)\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX -> Walter", "Find Heisenberg"), list);
    }

    @Test
    public void testPRConstraintOnAttributesWithoutSetterUsingModifies() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass4( \"XXX\", \"White\" ) );\nend\nrule \"Find Heisenberg\"\nwhen\n  $x : Klass4( fullName == 'Walter White' )\nthen\n  list.add( drools.getRule().getName() );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass4( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\n  list.add( drools.getRule().getName() );\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX -> Walter", "Find Heisenberg"), list);
    }

    @Test
    public void testPRBindingOnAttributesWithoutSetter() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass3( $fullName: fullName )\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)1L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX White"), list);
    }

    @Test
    public void testPRBindingOnAttributesWithoutSetterUsingWatches() {
        String str = "package org.drools.test;\n\nimport " + Klass3.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass3( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass3( $fullName: fullName ) @watch( name, lastName)\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass3( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX White", "Walter White"), list);
    }

    @Test
    public void testPRBindingOnAttributesWithoutSetterUsingModifies() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Init\"\nwhen\nthen\n  insert( new Klass4( \"XXX\", \"White\" ) );\nend\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( $fullName: fullName )\nthen\n  list.add( $fullName );\nend\nrule \"XXX -> Walter\"\nwhen\n  $x : Klass4( name == 'XXX' )\nthen\n  modify($x){ setName('Walter') };\nend\n\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(new String[]{str});
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        PropertyReactivityTest.assertEquals((long)2L, (long)list.size());
        PropertyReactivityTest.assertEquals(Arrays.asList("XXX White", "Walter White"), list);
    }

    @Test
    public void testPRBindingOnNonexistingAttributes() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( $name: nonexistingName )\nthen\n  list.add( $fullName );\nend\n";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(str.getBytes()), ResourceType.DRL);
        System.out.println(knowledgeBuilder.getErrors());
        PropertyReactivityTest.assertTrue((boolean)knowledgeBuilder.hasErrors());
    }

    @Test
    public void testPRBindingOnNonexistingWatchedAttribute() {
        String str = "package org.drools.test;\n\nimport " + Klass4.class.getCanonicalName() + ";\n\nglobal java.util.List list;\n\nrule \"Get Person name\"\nsalience 1\nwhen\n  $x : Klass4( ) @watch( nmae )\nthen\nend\n";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(str.getBytes()), ResourceType.DRL);
        System.out.println(knowledgeBuilder.getErrors());
        PropertyReactivityTest.assertTrue((boolean)knowledgeBuilder.hasErrors());
    }

    @Test
    public void testModifyAfterInsertWithPropertyReactive() {
        String rule1 = "\npackage com.sample;\nimport " + MyClass.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule r0\nthen insert( new MyClass() );\nend\nrule r1 salience 1\nwhen   MyClass(value == null)\nthen   list.add( 1 );\nend\n\nrule r2 salience 2\nwhen   m : MyClass(value == null)\nthen   modify(m) { setData(\"test\") }\n  list.add( 2 );\nend\n\nrule r3 salience 3\nwhen   MyClass(value == null)\nthen   list.add( 3 );\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            PropertyReactivityTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        PropertyReactivityTest.assertEquals((long)4L, (long)ksession.fireAllRules());
        PropertyReactivityTest.assertEquals((long)3L, (long)list.size());
        PropertyReactivityTest.assertEquals((Object)3, list.get(0));
        PropertyReactivityTest.assertEquals((Object)2, list.get(1));
        PropertyReactivityTest.assertEquals((Object)1, list.get(2));
    }

    @PropertyReactive
    public static class Klass4 {
        private String name;
        private String lastName;

        public Klass4(String name, String lastName) {
            this.name = name;
            this.lastName = lastName;
        }

        public String getName() {
            return this.name;
        }

        @Modifies(value={"fullName"})
        public void setName(String name) {
            this.name = name;
        }

        public String getLastName() {
            return this.lastName;
        }

        @Modifies(value={"fullName"})
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.name + " " + this.lastName;
        }
    }

    @PropertyReactive
    public static class MyClass {
        private String value;
        private String data;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    @PropertyReactive
    public static class Klass3 {
        private String name;
        private String lastName;

        public Klass3(String name, String lastName) {
            this.name = name;
            this.lastName = lastName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getFullName() {
            return this.name + " " + this.lastName;
        }
    }

    @PropertyReactive
    @Traitable
    public static class Bean {
        private int a;
        private int b;

        public Bean() {
        }

        public Bean(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }
    }

    @PropertyReactive
    public static class Klass2
    implements Intf2 {
        private String id = "k2";
        private int b;
        private int c;
        private int d;
        private int e;

        public Klass2(int b, int c, int d, int e) {
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public int getC() {
            return this.c;
        }

        public void setC(int c) {
            this.c = c;
        }

        @Override
        public int getD() {
            return this.d;
        }

        @Override
        public void setD(int d) {
            this.d = d;
        }

        @Override
        public int getE() {
            return this.e;
        }

        @Override
        public void setE(int e) {
            this.e = e;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    @PropertyReactive
    public static class Klass
    implements Intf1,
    Intf2 {
        private String id = "k1";
        private int a;
        private int b;
        private int c;
        private int d;
        private int e;
        private int f;

        public Klass(int a, int b, int c, int d, int e, int f) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.e = e;
            this.f = f;
        }

        public int getA() {
            return this.a;
        }

        public void setA(int a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        @Override
        public int getC() {
            return this.c;
        }

        @Override
        public void setC(int c) {
            this.c = c;
        }

        @Override
        public int getD() {
            return this.d;
        }

        @Override
        public void setD(int d) {
            this.d = d;
        }

        @Override
        public int getE() {
            return this.e;
        }

        @Override
        public void setE(int e) {
            this.e = e;
        }

        @Override
        public int getF() {
            return this.f;
        }

        @Override
        public void setF(int f) {
            this.f = f;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    @PropertyReactive
    public static interface Intf2 {
        public int getD();

        public void setD(int var1);

        public int getE();

        public void setE(int var1);

        public String getId();
    }

    @PropertyReactive
    public static interface Intf1 {
        public int getC();

        public void setC(int var1);

        public int getD();

        public void setD(int var1);

        public int getF();

        public void setF(int var1);

        public String getId();
    }
}

