/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.beliefsystem.simple;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.BeliefSystemLogicalCallback;
import org.drools.core.beliefsystem.simple.SimpleBeliefSet;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class ReteSimpleBeliefSystem
implements BeliefSystem<SimpleMode> {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public ReteSimpleBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    public SimpleMode asMode(Object value) {
        return new SimpleMode();
    }

    public BeliefSet<SimpleMode> insert(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        return this.insert((SimpleMode)node.getMode(), node.getJustifier().getRule(), node.getJustifier(), node.getObject(), beliefSet, context, typeConf);
    }

    public BeliefSet<SimpleMode> insert(SimpleMode mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add((ModedAssertion)mode);
        if (empty) {
            InternalFactHandle handle = beliefSet.getFactHandle();
            this.ep.insert(handle, handle.getObject(), rule, activation, typeConf);
        }
        return beliefSet;
    }

    public void read(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getMode());
    }

    public void stage(PropagationContext context, BeliefSet<SimpleMode> beliefSet) {
    }

    public void unstage(PropagationContext context, BeliefSet<SimpleMode> beliefSet) {
    }

    public void delete(LogicalDependency<SimpleMode> node, BeliefSet<SimpleMode> beliefSet, PropagationContext context) {
        this.delete((SimpleMode)node.getMode(), node.getJustifier().getRule(), node.getJustifier(), node.getObject(), beliefSet, context);
    }

    public void delete(SimpleMode mode, RuleImpl rule, Activation activation, Object payload, BeliefSet<SimpleMode> beliefSet, PropagationContext context) {
        SimpleBeliefSet sBeliefSet = (SimpleBeliefSet)beliefSet;
        beliefSet.remove((ModedAssertion)mode);
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && (context.getType() != PropagationContext.Type.DELETION && context.getType() != PropagationContext.Type.MODIFICATION || context.getFactHandle() != bfh)) {
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                BeliefSystemLogicalCallback action = new BeliefSystemLogicalCallback(bfh, context, activation, false, true);
                this.ep.enQueueWorkingMemoryAction((WorkingMemoryAction)action);
                sBeliefSet.setWorkingMemoryAction((WorkingMemoryAction)action);
            } else {
                BeliefSystemLogicalCallback callback = (BeliefSystemLogicalCallback)sBeliefSet.getWorkingMemoryAction();
                callback.setUpdate(false);
                callback.setFullyRetract(true);
            }
        } else if (!beliefSet.isEmpty() && beliefSet.getFactHandle().getObject() == payload) {
            ((NamedEntryPoint)bfh.getEntryPoint()).getObjectStore().updateHandle(bfh, ((LogicalDependency)((SimpleMode)beliefSet.getFirst()).getObject()).getObject());
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                BeliefSystemLogicalCallback action = new BeliefSystemLogicalCallback(bfh, context, activation, true, false);
                this.ep.enQueueWorkingMemoryAction((WorkingMemoryAction)action);
                sBeliefSet.setWorkingMemoryAction((WorkingMemoryAction)action);
            }
        }
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet((BeliefSystem)this, fh);
    }

    public LogicalDependency newLogicalDependency(Activation<SimpleMode> activation, BeliefSet<SimpleMode> beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, null);
    }
}

