/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.From;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.test.model.Cheese;
import org.drools.reteoo.nodes.ReteFromNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBaseFactory;

public class FromNodeTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private InternalKnowledgeBase kBase;
    private BuildContext buildContext;
    private PropagationContextFactory pctxFactory;

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.buildContext = new BuildContext(this.kBase, new ReteooBuilder.IdGenerator());
        this.pctxFactory = this.kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
    }

    @Test
    public void testAlphaNode() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, this.kBase);
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"stilton\"", FieldFactory.getInstance().getFieldValue((Object)"stilton"), (InternalReadAccessor)extractor);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("cheddar", 20);
        Cheese cheese2 = new Cheese("brie", 20);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        From fromCe = new From((DataProvider)dataProvider);
        fromCe.setResultPattern(pattern);
        ReteFromNode from = new ReteFromNode(3, (DataProvider)dataProvider, (LeftTupleSource)new MockTupleSource(80), new AlphaNodeFieldConstraint[]{constraint}, null, true, this.buildContext, fromCe);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        Person person1 = new Person("xxx1", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person1Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple1, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        cheese1.setType("stilton");
        Person person2 = new Person("xxx2", 30);
        FactHandle person2Handle = workingMemory.insert((Object)person2);
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person2Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple2, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        Assert.assertEquals((long)1L, (long)asserted.size());
        Tuple tuple = (Tuple)((Object[])asserted.get(0))[0];
        Assert.assertSame((Object)person2, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese1, (Object)tuple.getObject(1));
        cheese2.setType("stilton");
        Person person3 = new Person("xxx2", 30);
        FactHandle person3Handle = workingMemory.insert((Object)person3);
        LeftTupleImpl tuple3 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person3Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple3, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)asserted.size());
        tuple = (Tuple)((Object[])asserted.get(1))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese1, (Object)tuple.getObject(1));
        tuple = (Tuple)((Object[])asserted.get(2))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese2, (Object)tuple.getObject(1));
        Assert.assertNotSame((Object)cheese1, (Object)cheese2);
    }

    @Test
    public void testBetaNode() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price");
        ClassFieldReader ageExtractor = this.store.getReader(Person.class, "age");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Person.class));
        Declaration declaration = new Declaration("age", (InternalReadAccessor)ageExtractor, pattern);
        MvelConstraintTestUtil variableConstraint = new MvelConstraintTestUtil("price == age", declaration, (InternalReadAccessor)priceExtractor);
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        configuration.setIndexRightBetaMemory(false);
        configuration.setIndexLeftBetaMemory(false);
        SingleBetaConstraints betaConstraints = new SingleBetaConstraints((BetaNodeFieldConstraint)variableConstraint, configuration);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("cheddar", 18);
        Cheese cheese2 = new Cheese("brie", 12);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        From fromCe = new From((DataProvider)dataProvider);
        fromCe.setResultPattern(new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class)));
        ReteFromNode from = new ReteFromNode(3, (DataProvider)dataProvider, (LeftTupleSource)new MockTupleSource(40), new AlphaNodeFieldConstraint[0], (BetaConstraints)betaConstraints, true, this.buildContext, fromCe);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        Person person1 = new Person("xxx1", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person1Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple1, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        cheese1.setPrice(30);
        Person person2 = new Person("xxx2", 30);
        FactHandle person2Handle = workingMemory.insert((Object)person2);
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person2Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple2, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        Assert.assertEquals((long)1L, (long)asserted.size());
        Tuple tuple = (Tuple)((Object[])asserted.get(0))[0];
        Assert.assertSame((Object)person2, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese1, (Object)tuple.getObject(1));
        cheese2.setPrice(30);
        Person person3 = new Person("xxx2", 30);
        FactHandle person3Handle = workingMemory.insert((Object)person3);
        LeftTupleImpl tuple3 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person3Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple3, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)3L, (long)asserted.size());
        tuple = (Tuple)((Object[])asserted.get(1))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese1, (Object)tuple.getObject(1));
        tuple = (Tuple)((Object[])asserted.get(2))[0];
        Assert.assertSame((Object)person3, (Object)tuple.getObject(0));
        Assert.assertSame((Object)cheese2, (Object)tuple.getObject(1));
        Assert.assertNotSame((Object)cheese1, (Object)cheese2);
    }

    @Test
    public void testRestract() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"stilton\"", FieldFactory.getInstance().getFieldValue((Object)"stilton"), (InternalReadAccessor)extractor);
        ArrayList<Cheese> list = new ArrayList<Cheese>();
        Cheese cheese1 = new Cheese("stilton", 5);
        Cheese cheese2 = new Cheese("stilton", 15);
        list.add(cheese1);
        list.add(cheese2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        From fromCe = new From((DataProvider)dataProvider);
        fromCe.setResultPattern(pattern);
        ReteFromNode from = new ReteFromNode(3, (DataProvider)dataProvider, (LeftTupleSource)new MockTupleSource(30), new AlphaNodeFieldConstraint[]{constraint}, null, true, this.buildContext, fromCe);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        List asserted = sink.getAsserted();
        Person person1 = new Person("xxx2", 30);
        FactHandle person1Handle = workingMemory.insert((Object)person1);
        LeftTupleImpl tuple = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)person1Handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)asserted.size());
        FromNode.FromMemory memory = (FromNode.FromMemory)workingMemory.getNodeMemory((MemoryFactory)from);
        Assert.assertEquals((long)1L, (long)memory.getBetaMemory().getLeftTupleMemory().size());
        Assert.assertNull((Object)memory.getBetaMemory().getRightTupleMemory());
        RightTuple rightTuple2 = tuple.getFirstChild().getRightParent();
        RightTuple rightTuple1 = ((LeftTuple)tuple.getFirstChild().getHandleNext()).getRightParent();
        Assert.assertFalse((boolean)rightTuple1.equals(rightTuple2));
        Assert.assertNull((Object)tuple.getFirstChild().getHandleNext().getHandleNext());
        InternalFactHandle handle2 = rightTuple2.getFactHandle();
        InternalFactHandle handle1 = rightTuple1.getFactHandle();
        Assert.assertEquals((Object)handle1.getObject(), (Object)cheese2);
        Assert.assertEquals((Object)handle2.getObject(), (Object)cheese1);
        from.retractLeftTuple((LeftTuple)tuple, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)memory.getBetaMemory().getLeftTupleMemory().size());
        Assert.assertNull((Object)memory.getBetaMemory().getRightTupleMemory());
    }

    @Test
    public void testAssignable() {
        PropagationContext context = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, this.kBase);
        ArrayList<Human> list = new ArrayList<Human>();
        Human h1 = new Human();
        Human h2 = new Human();
        Person p1 = new Person("darth", 105);
        Person p2 = new Person("yoda", 200);
        Man m1 = new Man("bobba", 95);
        Man m2 = new Man("luke", 40);
        list.add(h1);
        list.add(h2);
        list.add(p1);
        list.add(p1);
        list.add(m1);
        list.add(m2);
        MockDataProvider dataProvider = new MockDataProvider(list);
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Person.class));
        From fromCe = new From((DataProvider)dataProvider);
        fromCe.setResultPattern(pattern);
        ReteFromNode from = new ReteFromNode(3, (DataProvider)dataProvider, (LeftTupleSource)new MockTupleSource(90), new AlphaNodeFieldConstraint[0], null, true, this.buildContext, fromCe);
        MockLeftTupleSink sink = new MockLeftTupleSink(5);
        from.addTupleSink((LeftTupleSink)sink);
        FactHandle handle = workingMemory.insert((Object)"xxx");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)((DefaultFactHandle)handle), (Sink)from, true);
        from.assertLeftTuple((LeftTuple)tuple1, context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        int countHuman = 0;
        int countPerson = 0;
        int countMan = 0;
        for (int i = 0; i < 4; ++i) {
            Object o = ((LeftTuple)((Object[])asserted.get(i))[0]).getFactHandle().getObject();
            if (o.getClass() == Human.class) {
                ++countHuman;
                continue;
            }
            if (o.getClass() == Person.class) {
                ++countPerson;
                continue;
            }
            if (o.getClass() != Man.class) continue;
            ++countMan;
        }
        Assert.assertEquals((long)0L, (long)countHuman);
        Assert.assertEquals((long)2L, (long)countPerson);
        Assert.assertEquals((long)2L, (long)countMan);
    }

    public static class Man
    extends Person {
        public Man(String name, int age) {
            super(name, age);
        }
    }

    public static class Person
    extends Human {
        private String name;
        private int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public int getAge() {
            return this.age;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Human {
    }

    public static class MockDataProvider
    implements DataProvider {
        private static final long serialVersionUID = 510L;
        private Collection collection;

        public Declaration[] getRequiredDeclarations() {
            return null;
        }

        public MockDataProvider(Collection collection) {
            this.collection = collection;
        }

        public Iterator getResults(Tuple tuple, InternalWorkingMemory wm, PropagationContext ctx, Object providerContext) {
            return this.collection.iterator();
        }

        public Object createContext() {
            return null;
        }

        public DataProvider clone() {
            return this;
        }

        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        }
    }
}

