/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DefaultBetaConstraints;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.LongBitMask;
import org.drools.core.util.index.TupleList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBaseConfiguration;
import org.kie.internal.KnowledgeBaseFactory;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Ignore
public class JoinNodeTest
extends DroolsTestCase {
    RuleImpl rule;
    PropagationContext context;
    StatefulKnowledgeSessionImpl workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    BetaNode node;
    BetaMemory memory;
    BetaNodeFieldConstraint constraint;
    private PropagationContextFactory pctxFactory;

    @Before
    public void setUp() {
        this.constraint = (BetaNodeFieldConstraint)Mockito.mock(BetaNodeFieldConstraint.class);
        ContextEntry c = (ContextEntry)Mockito.mock(ContextEntry.class);
        Mockito.when((Object)this.constraint.createContextEntry()).thenReturn((Object)c);
        this.rule = new RuleImpl("test-rule");
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        this.pctxFactory = kBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        this.context = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null);
        this.workingMemory = new StatefulKnowledgeSessionImpl(1L, kBase);
        this.tupleSource = new MockTupleSource(4);
        this.objectSource = new MockObjectSource(4);
        this.sink = new MockLeftTupleSink();
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        InternalKnowledgeBase kBase2 = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase2, kBase2.getReteooBuilder().getIdGenerator());
        this.node = new JoinNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, configuration), buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node);
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
    }

    @Test
    public void testAttach() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        Field objectFfield = ObjectSource.class.getDeclaredField("sink");
        objectFfield.setAccessible(true);
        ObjectSinkPropagator objectSink = (ObjectSinkPropagator)objectFfield.get(this.objectSource);
        Field tupleField = LeftTupleSource.class.getDeclaredField("sink");
        tupleField.setAccessible(true);
        LeftTupleSinkPropagator tupleSink = (LeftTupleSinkPropagator)tupleField.get(this.tupleSource);
        Assert.assertEquals((long)15L, (long)this.node.getId());
        Assert.assertNotNull((Object)objectSink);
        Assert.assertNotNull((Object)tupleSink);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext context = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        this.node.attach(context);
        objectSink = (ObjectSinkPropagator)objectFfield.get(this.objectSource);
        tupleSink = (LeftTupleSinkPropagator)tupleField.get(this.tupleSource);
        Assert.assertEquals((long)1L, (long)objectSink.getSinks().length);
        Assert.assertEquals((long)1L, (long)tupleSink.getSinks().length);
        Assert.assertSame((Object)this.node, (Object)objectSink.getSinks()[0]);
        Assert.assertSame((Object)this.node, (Object)tupleSink.getSinks()[0]);
    }

    @Test
    public void testMemory() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        MockObjectSource objectSource = new MockObjectSource(1);
        MockTupleSource tupleSource = new MockTupleSource(1);
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        JoinNode joinNode = new JoinNode(2, (LeftTupleSource)tupleSource, (ObjectSource)objectSource, EmptyBetaConstraints.getInstance(), buildContext);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)joinNode);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testAssertTuple() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getLeftTupleMemory().size());
        Tuple leftTuple = ((TupleList)this.memory.getLeftTupleMemory()).getFirst();
        Assert.assertEquals((Object)tuple0, (Object)leftTuple);
        Assert.assertEquals((Object)tuple1, (Object)leftTuple.getNext());
    }

    @Test
    public void testAssertTupleSequentialMode() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        this.workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)conf));
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        buildContext.setObjectTypeNodeMemoryEnabled(false);
        this.node = new JoinNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, conf), buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"cheese");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, (InternalFactHandle)f0), (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, (InternalFactHandle)f0), (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.sink.getAsserted().size());
        Assert.assertNull((Object)this.memory.getLeftTupleMemory());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
        Assert.assertEquals((Object)new LeftTupleImpl((LeftTuple)tuple0, f0.getFirstRightTuple(), (Sink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
    }

    @Test
    public void testAssertObject() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)1L, (long)this.memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)"test1");
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getRightTupleMemory().size());
        Tuple rightTuple = this.memory.getRightTupleMemory().getFirst((Tuple)new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true));
        InternalFactHandle rf0 = rightTuple.getFactHandle();
        InternalFactHandle rf1 = ((RightTuple)rightTuple.getNext()).getFactHandle();
        Assert.assertEquals((Object)f0, (Object)rf0);
        Assert.assertEquals((Object)f1, (Object)rf1);
    }

    @Test
    public void testAssertPropagations() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.sink.getAsserted().size());
        Assert.assertEquals((Object)new LeftTupleImpl((LeftTuple)tuple1, f0.getFirstRightTuple(), (Sink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        DefaultFactHandle f2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.sink.getAsserted().size());
        Assert.assertEquals((Object)new LeftTupleImpl((LeftTuple)tuple2, f0.getFirstRightTuple(), (Sink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(1))[0]);
        DefaultFactHandle f3 = (DefaultFactHandle)this.workingMemory.insert((Object)"test2");
        this.node.assertObject((InternalFactHandle)f3, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)4L, (long)this.sink.getAsserted().size());
        ArrayList<Object> tuples = new ArrayList<Object>();
        tuples.add(((Object[])this.sink.getAsserted().get(2))[0]);
        tuples.add(((Object[])this.sink.getAsserted().get(3))[0]);
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple1, f3.getFirstRightTuple(), (Sink)this.sink, true)));
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple2, f3.getFirstRightTuple(), (Sink)this.sink, true)));
    }

    @Test
    public void testRetractTuple() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)"test1");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)"test2");
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)f2, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f3 = (DefaultFactHandle)this.workingMemory.insert((Object)"test3");
        this.node.assertObject((InternalFactHandle)f3, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f4 = (DefaultFactHandle)this.workingMemory.insert((Object)"test4");
        this.node.assertObject((InternalFactHandle)f4, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(6, this.sink.getAsserted());
        BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node);
        Assert.assertTrue((boolean)memory.getRightTupleMemory().contains((Tuple)f0.getFirstRightTuple()));
        this.node.retractRightTuple(f0.getFirstRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(2, this.sink.getRetracted());
        ArrayList<Object> tuples = new ArrayList<Object>();
        tuples.add(((Object[])this.sink.getRetracted().get(0))[0]);
        tuples.add(((Object[])this.sink.getRetracted().get(1))[0]);
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple1, f0.getFirstRightTuple(), (Sink)this.sink, true)));
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple1, f0.getFirstRightTuple(), (Sink)this.sink, true)));
        Assert.assertFalse((boolean)memory.getRightTupleMemory().contains((Tuple)f0.getFirstRightTuple()));
        this.node.retractLeftTuple((LeftTuple)tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)4L, (long)this.sink.getRetracted().size());
        tuples = new ArrayList();
        tuples.add(((Object[])this.sink.getRetracted().get(2))[0]);
        tuples.add(((Object[])this.sink.getRetracted().get(3))[0]);
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple2, f3.getFirstRightTuple(), (Sink)this.sink, true)));
        Assert.assertTrue((boolean)tuples.contains(new LeftTupleImpl((LeftTuple)tuple2, f4.getFirstRightTuple(), (Sink)this.sink, true)));
    }

    @Test
    public void testConstraintPropagations() throws Exception {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)false);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)false);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)"test0");
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (Sink)this.node, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.node.retractRightTuple(f0.getFirstRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getRetracted());
    }

    @Test
    public void testUpdateSink() {
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        JoinNode joinNode = new JoinNode(1, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, EmptyBetaConstraints.getInstance(), buildContext);
        MockLeftTupleSink sink1 = new MockLeftTupleSink(2);
        joinNode.addTupleSink((LeftTupleSink)sink1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"string0");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        joinNode.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)workingMemory);
        String string1 = "string1";
        DefaultFactHandle string1Handle = new DefaultFactHandle(1, (Object)"string1");
        joinNode.assertObject((InternalFactHandle)string1Handle, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        MockLeftTupleSink sink2 = new MockLeftTupleSink(3);
        this.assertLength(0, sink2.getAsserted());
        joinNode.updateSink((LeftTupleSink)sink2, this.context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink2.getAsserted());
    }

    @Test
    public void testSlotSpecific() {
        PropagationContext contextPassAll = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null, 0, 0, EntryPointId.DEFAULT, PropertySpecificUtil.allSetButTraitBitMask());
        PropagationContext contextPassNothing = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null, 0, 0, EntryPointId.DEFAULT, (BitMask)EmptyBitMask.get());
        PropagationContext contextPass2And3 = this.pctxFactory.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, null, 0, 0, EntryPointId.DEFAULT, (BitMask)new LongBitMask(6L));
        Mockito.when((Object)this.constraint.isAllowedCachedLeft((ContextEntry)Matchers.any(ContextEntry.class), (InternalFactHandle)Matchers.any(InternalFactHandle.class))).thenReturn((Object)true);
        Mockito.when((Object)this.constraint.isAllowedCachedRight((Tuple)Matchers.any(LeftTupleImpl.class), (ContextEntry)Matchers.any(ContextEntry.class))).thenReturn((Object)true);
        StatefulKnowledgeSessionImpl workingMemory = new StatefulKnowledgeSessionImpl(1L, (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase());
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase();
        BuildContext buildContext = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
        JoinNode joinNode = new JoinNode(1, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, EmptyBetaConstraints.getInstance(), buildContext);
        MockLeftTupleSink sink1 = new MockLeftTupleSink(2);
        joinNode.addTupleSink((LeftTupleSink)sink1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"string0");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f0, (Sink)this.node, true);
        joinNode.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)workingMemory);
        String string1 = "string1";
        DefaultFactHandle string1Handle = new DefaultFactHandle(1, (Object)"string1");
        ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(null);
        this.assertLength(0, sink1.getAsserted());
        joinNode.modifyObject((InternalFactHandle)string1Handle, modifyPreviousTuples, contextPassNothing, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink1.getAsserted());
        joinNode.setRightDeclaredMask((BitMask)EmptyBitMask.get());
        joinNode.initInferredMask();
        joinNode.modifyObject((InternalFactHandle)string1Handle, modifyPreviousTuples, contextPass2And3, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink1.getAsserted());
        joinNode.setRightDeclaredMask((BitMask)new LongBitMask(9L));
        joinNode.initInferredMask();
        joinNode.modifyObject((InternalFactHandle)string1Handle, modifyPreviousTuples, contextPass2And3, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink1.getAsserted());
        joinNode.setRightDeclaredMask((BitMask)new LongBitMask(3L));
        joinNode.initInferredMask();
        joinNode.modifyObject((InternalFactHandle)string1Handle, modifyPreviousTuples, contextPass2And3, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        joinNode.modifyObject((InternalFactHandle)string1Handle, modifyPreviousTuples, contextPassAll, (InternalWorkingMemory)workingMemory);
        this.assertLength(2, sink1.getAsserted());
    }
}

