/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.SimpleFact;
import org.drools.ruleunit.TestRuleUnit;
import org.drools.ruleunit.executor.RuleUnitSessionImpl;
import org.drools.ruleunit.impl.RuleUnitDescriptionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuleUnitDescriptionTest {
    private RuleUnitDescriptionImpl ruleUnitDescr;

    @Before
    public void prepareRuleUnitDescr() {
        this.ruleUnitDescr = new RuleUnitDescriptionImpl(null, TestRuleUnit.class);
    }

    @Test
    public void getRuleUnitClass() {
        Assertions.assertThat((Class)this.ruleUnitDescr.getRuleUnitClass()).isEqualTo(TestRuleUnit.class);
    }

    @Test
    public void getRuleUnitName() {
        Assertions.assertThat((String)this.ruleUnitDescr.getRuleUnitName()).isEqualTo((Object)TestRuleUnit.class.getName());
    }

    @Test
    public void getEntryPointId() {
        Optional entryPointId = this.ruleUnitDescr.getEntryPointId("nonexisting");
        Assertions.assertThat((Optional)entryPointId).isNotPresent();
        this.assertEntryPointIdExists("numbersArray");
        this.assertEntryPointIdExists("number");
        this.assertEntryPointIdExists("stringList");
        this.assertEntryPointIdExists("simpleFactList");
    }

    @Test
    public void getDatasourceType() {
        Optional dataSourceType = this.ruleUnitDescr.getDatasourceType("nonexisting");
        Assertions.assertThat((Optional)dataSourceType).isNotPresent();
        this.assertDataSourceType("number", BigDecimal.class);
        this.assertDataSourceType("numbersArray", Integer.class);
        this.assertDataSourceType("stringList", String.class);
        this.assertDataSourceType("simpleFactList", SimpleFact.class);
    }

    @Test
    public void getVarType() {
        Optional varType = this.ruleUnitDescr.getVarType("nonexisting");
        Assertions.assertThat((Optional)varType).isNotPresent();
        this.assertVarType("number", BigDecimal.class);
        this.assertVarType("numbersArray", Integer[].class);
        this.assertVarType("stringList", List.class);
        this.assertVarType("simpleFactList", List.class);
    }

    @Test
    public void hasVar() {
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("nonexisting")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("numbers")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("number")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("numbersArray")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("stringList")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasVar("simpleFactList")).isTrue();
    }

    @Test
    public void getUnitVars() {
        Collection unitVars = this.ruleUnitDescr.getUnitVars();
        Assertions.assertThat((Iterable)unitVars).isNotEmpty();
        Assertions.assertThat((Iterable)unitVars).hasSize(5);
        Assertions.assertThat((Iterable)unitVars).containsExactlyInAnyOrder((Object[])new String[]{"bound", "number", "numbersArray", "stringList", "simpleFactList"});
    }

    @Test
    public void getUnitVarAccessors() {
        Collection unitVarAccessors = this.ruleUnitDescr.getUnitVarDeclarations();
        Assertions.assertThat((Iterable)unitVarAccessors).isNotEmpty();
        Assertions.assertThat((Iterable)unitVarAccessors).hasSize(5);
        Assertions.assertThat((Iterable)unitVarAccessors).extracting("name", String.class).containsExactlyInAnyOrder((Object[])new String[]{"bound", "number", "numbersArray", "stringList", "simpleFactList"});
    }

    @Test
    public void hasDataSource() {
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("nonexisting")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("numbers")).isFalse();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("number")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("numbersArray")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("stringList")).isTrue();
        Assertions.assertThat((boolean)this.ruleUnitDescr.hasDataSource("simpleFactList")).isTrue();
    }

    @Test
    public void bindDataSourcesNonexistingEntryPoints() {
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)Mockito.mock(StatefulKnowledgeSessionImpl.class);
        Mockito.when((Object)sessionImpl.getEntryPoint("number")).thenReturn(null);
        Mockito.when((Object)sessionImpl.getEntryPoint("numbersArray")).thenReturn(null);
        Mockito.when((Object)sessionImpl.getEntryPoint("stringList")).thenReturn(null);
        Mockito.when((Object)sessionImpl.getEntryPoint("simpleFactList")).thenReturn(null);
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[]{1, 2, 5}, BigDecimal.TEN);
        SimpleFact simpleFact = new SimpleFact("testValue");
        testRuleUnit.addSimpleFact(simpleFact);
        this.ruleUnitDescr.bindDataSources(new RuleUnitSessionImpl(null, sessionImpl), (RuleUnit)testRuleUnit);
        ((StatefulKnowledgeSessionImpl)Mockito.verify((Object)sessionImpl, (VerificationMode)Mockito.never())).insert(Matchers.anyObject());
        ((StatefulKnowledgeSessionImpl)Mockito.verify((Object)sessionImpl, (VerificationMode)Mockito.never())).insert(Matchers.anyObject(), Matchers.anyBoolean(), (RuleImpl)Matchers.anyObject(), (TerminalNode)Matchers.anyObject());
    }

    @Test
    public void bindDataSources() {
        WorkingMemoryEntryPoint numberEntryPoint = (WorkingMemoryEntryPoint)Mockito.mock(WorkingMemoryEntryPoint.class);
        WorkingMemoryEntryPoint numbersArrayEntryPoint = (WorkingMemoryEntryPoint)Mockito.mock(WorkingMemoryEntryPoint.class);
        WorkingMemoryEntryPoint stringListEntryPoint = (WorkingMemoryEntryPoint)Mockito.mock(WorkingMemoryEntryPoint.class);
        WorkingMemoryEntryPoint simpleFactListEntryPoint = (WorkingMemoryEntryPoint)Mockito.mock(WorkingMemoryEntryPoint.class);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)Mockito.mock(StatefulKnowledgeSessionImpl.class);
        Mockito.when((Object)sessionImpl.getEntryPoint(TestRuleUnit.class.getCanonicalName() + ".number")).thenReturn((Object)numberEntryPoint);
        Mockito.when((Object)sessionImpl.getEntryPoint(TestRuleUnit.class.getCanonicalName() + ".numbersArray")).thenReturn((Object)numbersArrayEntryPoint);
        Mockito.when((Object)sessionImpl.getEntryPoint(TestRuleUnit.class.getCanonicalName() + ".stringList")).thenReturn((Object)stringListEntryPoint);
        Mockito.when((Object)sessionImpl.getEntryPoint(TestRuleUnit.class.getCanonicalName() + ".simpleFactList")).thenReturn((Object)simpleFactListEntryPoint);
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[]{1, 2, 5}, BigDecimal.TEN);
        SimpleFact simpleFact = new SimpleFact("testValue");
        testRuleUnit.addSimpleFact(simpleFact);
        this.ruleUnitDescr.bindDataSources(new RuleUnitSessionImpl(null, sessionImpl), (RuleUnit)testRuleUnit);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)numberEntryPoint)).insert((Object)BigDecimal.TEN);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)numbersArrayEntryPoint)).insert((Object)1);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)numbersArrayEntryPoint)).insert((Object)2);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)numbersArrayEntryPoint)).insert((Object)5);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)simpleFactListEntryPoint)).insert((Object)simpleFact);
    }

    @Test
    public void unbindDataSources() {
        WorkingMemoryEntryPoint boundPropEntryPoint = (WorkingMemoryEntryPoint)Mockito.mock(WorkingMemoryEntryPoint.class);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)Mockito.mock(StatefulKnowledgeSessionImpl.class);
        Mockito.when((Object)sessionImpl.getEntryPoint(TestRuleUnit.class.getCanonicalName() + ".bound")).thenReturn((Object)boundPropEntryPoint);
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[]{1, 2, 5}, BigDecimal.TEN);
        SimpleFact simpleFact = new SimpleFact("testValue");
        testRuleUnit.addSimpleFact(simpleFact);
        Assertions.assertThat((boolean)testRuleUnit.bound).isFalse();
        RuleUnitSessionImpl ruSession = new RuleUnitSessionImpl(null, sessionImpl);
        this.ruleUnitDescr.bindDataSources(ruSession, (RuleUnit)testRuleUnit);
        ((WorkingMemoryEntryPoint)Mockito.verify((Object)boundPropEntryPoint)).insert((Object)true);
        this.ruleUnitDescr.unbindDataSources(ruSession, (RuleUnit)testRuleUnit);
        Assertions.assertThat((boolean)testRuleUnit.bound).isFalse();
    }

    @Test
    public void getValue() {
        TestRuleUnit testRuleUnit = new TestRuleUnit(new Integer[]{1, 2, 5}, BigDecimal.TEN);
        SimpleFact simpleFact = new SimpleFact("testValue");
        testRuleUnit.addSimpleFact(simpleFact);
        Object value = this.ruleUnitDescr.getValue((RuleUnit)testRuleUnit, "nonexisting");
        Assertions.assertThat((Object)value).isNull();
        value = this.ruleUnitDescr.getValue((RuleUnit)testRuleUnit, "number");
        Assertions.assertThat((Object)value).isInstanceOf(BigDecimal.class);
        Assertions.assertThat((Object)value).isEqualTo((Object)BigDecimal.TEN);
        value = this.ruleUnitDescr.getValue((RuleUnit)testRuleUnit, "numbersArray");
        Assertions.assertThat((Object)value).isInstanceOf(Integer[].class);
        Assertions.assertThat((Object)value).isEqualTo((Object)new Integer[]{1, 2, 5});
        value = this.ruleUnitDescr.getValue((RuleUnit)testRuleUnit, "simpleFactList");
        Assertions.assertThat((Object)value).isInstanceOfSatisfying(List.class, list -> Assertions.assertThat((List)list).containsExactly(new Object[]{simpleFact}));
    }

    private void assertEntryPointIdExists(String entryPointIdName) {
        Optional entryPointId = this.ruleUnitDescr.getEntryPointId(entryPointIdName);
        Assert.assertTrue((boolean)entryPointId.isPresent());
        Assert.assertEquals((Object)(TestRuleUnit.class.getName() + "." + entryPointIdName), (Object)((EntryPointId)entryPointId.get()).getEntryPointId());
    }

    private void assertDataSourceType(String dataSourceName, Class<?> expectedType) {
        Optional dataSourceType = this.ruleUnitDescr.getDatasourceType(dataSourceName);
        Assert.assertTrue((boolean)dataSourceType.isPresent());
        Assert.assertEquals(expectedType, dataSourceType.get());
    }

    private void assertVarType(String varName, Class<?> expectedType) {
        Optional variableTable = this.ruleUnitDescr.getVarType(varName);
        Assert.assertTrue((boolean)variableTable.isPresent());
        Assert.assertEquals(expectedType, variableTable.get());
    }
}

