/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit;

import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.ruleunit.RuleUnitDescriptionLoader;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.ruleunit.TestRuleUnit;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.ruleunit.RuleUnitDescription;
import org.mockito.Mockito;

public class RuleUnitDescriptionLoaderTest {
    private RuleUnitDescriptionLoader loader;

    @Before
    public void prepareRuleUnitDescriptionLoader() {
        KnowledgePackageImpl pkg = new KnowledgePackageImpl("org.test");
        pkg.setClassLoader(this.getClass().getClassLoader());
        this.loader = new RuleUnitDescriptionLoader((InternalKnowledgePackage)pkg);
    }

    @Test
    public void getStateUnitExists() {
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.UNKNOWN);
        this.assertDescriptionIsLoaded();
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.UNIT);
    }

    @Test
    public void getStateUnitNotExists() {
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.UNKNOWN);
        Optional description = this.loader.getDescription("nonexisting");
        Assertions.assertThat((Optional)description).isNotPresent();
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.NO_UNIT);
    }

    @Test
    public void getStateMixWithAndWithoutUnit() {
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.UNKNOWN);
        this.assertDescriptionIsLoaded();
        Assertions.assertThat((Comparable)this.loader.getState()).isEqualTo((Object)RuleUnitDescriptionRegistry.State.UNIT);
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> this.loader.getDescription("nonexisting"));
    }

    @Test
    public void getDescriptions() {
        Assertions.assertThat((Map)this.loader.getDescriptions()).isEmpty();
        this.assertDescriptionIsLoaded();
        Assertions.assertThat((Map)this.loader.getDescriptions()).hasSize(1);
    }

    @Test
    public void getDescriptionFromRuleImpl() {
        RuleImpl ruleImpl = (RuleImpl)Mockito.mock(RuleImpl.class);
        Mockito.when((Object)ruleImpl.getRuleUnitClassName()).thenReturn((Object)TestRuleUnit.class.getName());
        Optional description = this.loader.getDescription(ruleImpl);
        Assertions.assertThat((Optional)description).isPresent();
        Optional description2 = this.loader.getDescription(ruleImpl);
        Assertions.assertThat((Optional)description).isPresent();
        Assertions.assertThat(description.get()).isSameAs(description2.get());
        Assertions.assertThat((Class)((RuleUnitDescription)description.get()).getRuleUnitClass()).isEqualTo(TestRuleUnit.class);
    }

    @Test
    public void getDescriptionFromUnitClassName() {
        RuleUnitDescription description = this.assertDescriptionIsLoaded();
        RuleUnitDescription description2 = this.assertDescriptionIsLoaded();
        Assertions.assertThat((Object)description).isSameAs((Object)description2);
        Assertions.assertThat((Class)description.getRuleUnitClass()).isEqualTo(TestRuleUnit.class);
    }

    private RuleUnitDescription assertDescriptionIsLoaded() {
        Optional description = this.loader.getDescription(TestRuleUnit.class.getName());
        Assertions.assertThat((Optional)description).isPresent();
        return (RuleUnitDescription)description.get();
    }
}

