/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit;

import org.assertj.core.api.Assertions;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.spi.Activation;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.TestRuleUnit;
import org.drools.ruleunit.TestRuleUnit2;
import org.drools.ruleunit.executor.RuleUnitExecutorSession;
import org.drools.ruleunit.impl.RuleUnitGuardSystem;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RuleUnitGuardSystemTest {
    private RuleUnitExecutorSession executorSession;
    private RuleUnitGuardSystem guardSystem;

    @Before
    public void prepareGuardSystem() {
        this.executorSession = (RuleUnitExecutorSession)Mockito.mock(RuleUnitExecutorSession.class);
        Mockito.when((Object)this.executorSession.internalExecuteUnit((RuleUnit)Matchers.anyObject())).thenReturn((Object)1);
        this.guardSystem = new RuleUnitGuardSystem(this.executorSession);
    }

    @Test
    public void registerGuard() {
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits()).isEqualTo(0);
        TestRuleUnit testRuleUnit = new TestRuleUnit();
        this.guardSystem.registerGuard((RuleUnit)testRuleUnit, this.prepareActivation());
        Mockito.when((Object)this.executorSession.getCurrentRuleUnit()).thenReturn((Object)testRuleUnit);
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits()).isEqualTo(1);
    }

    @Test
    public void removeActivation() {
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits()).isEqualTo(0);
        Activation activation = this.prepareActivation();
        TestRuleUnit testRuleUnit = new TestRuleUnit();
        this.guardSystem.registerGuard((RuleUnit)testRuleUnit, activation);
        this.guardSystem.removeActivation(activation);
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits()).isEqualTo(0);
    }

    @Test
    public void fireActiveUnitsFromRuleUnit() {
        TestRuleUnit testRuleUnit = new TestRuleUnit();
        Mockito.when((Object)this.executorSession.getCurrentRuleUnit()).thenReturn((Object)testRuleUnit);
        this.guardSystem.registerGuard((RuleUnit)testRuleUnit, this.prepareActivation());
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits((RuleUnit)new TestRuleUnit2())).isEqualTo(0);
        Assertions.assertThat((int)this.guardSystem.fireActiveUnits((RuleUnit)testRuleUnit)).isEqualTo(1);
    }

    private Activation prepareActivation() {
        Activation activation = (Activation)Mockito.mock(Activation.class);
        Mockito.when((Object)activation.getRule()).thenReturn((Object)new RuleImpl());
        return activation;
    }
}

