/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.command.pmml;

import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.runtime.pmml.ApplyPmmlModelCommand;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.Context;

public class ApplyPmmlModelCommandTest {
    @Test(expected=IllegalStateException.class)
    public void testMissingRequestData() {
        ApplyPmmlModelCommand cmd = new ApplyPmmlModelCommand();
        ContextImpl ctx = new ContextImpl();
        cmd.execute((Context)ctx);
    }

    @Test
    public void testHasRequestDataAndKieBase() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)"defaultKieBase");
        ApplyPmmlModelCommand cmd = new ApplyPmmlModelCommand();
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        data.addRequestParam("age", (Object)33.0);
        data.addRequestParam("occupation", (Object)"SKYDIVER");
        data.addRequestParam("residenceState", (Object)"KN");
        data.addRequestParam("validLicense", (Object)true);
        cmd.setRequestData(data);
        cmd.setPackageName("org.drools.scorecards.example");
        ContextImpl ctx = new ContextImpl().register(KieBase.class, (Object)kbase);
        PMML4Result resultHolder = cmd.execute((Context)ctx);
        Assert.assertNotNull((Object)resultHolder);
        String resultCode = resultHolder.getResultCode();
        Assert.assertEquals((Object)"ERROR-2", (Object)resultCode);
    }

    @Test
    public void testHasRequestData() {
        ApplyPmmlModelCommand cmd = new ApplyPmmlModelCommand();
        PMMLRequestData data = new PMMLRequestData("123", "Sample Score");
        data.addRequestParam("age", (Object)33.0);
        data.addRequestParam("occupation", (Object)"SKYDIVER");
        data.addRequestParam("residenceState", (Object)"KN");
        data.addRequestParam("validLicense", (Object)true);
        cmd.setRequestData(data);
        cmd.setPackageName("org.drools.scorecards.example");
        ContextImpl ctx = new ContextImpl();
        PMML4Result resultHolder = cmd.execute((Context)ctx);
        Assert.assertNotNull((Object)resultHolder);
        String resultCode = resultHolder.getResultCode();
        Assert.assertEquals((Object)"ERROR-1", (Object)resultCode);
    }
}

