/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.command.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.util.StringUtils;
import org.drools.ruleunit.DataSource;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.RuleUnitExecutor;
import org.kie.api.KieBase;
import org.kie.api.pmml.OutputFieldFactory;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.ruleunit.ApplyPmmlModelCommandExecutor;
import org.kie.internal.ruleunit.RuleUnitDescription;

public class ApplyPmmlModelCommandExecutorImpl
implements ApplyPmmlModelCommandExecutor {
    private Class<? extends RuleUnit> getStartingRuleUnit(String startingRule, InternalKnowledgeBase ikb, List<String> possiblePackages) {
        RuleUnitDescriptionRegistry unitRegistry = ikb.getRuleUnitDescriptionRegistry();
        Map pkgs = ikb.getPackagesMap();
        RuleImpl ruleImpl = null;
        for (String pkgName : possiblePackages) {
            RuleUnitDescription descr;
            InternalKnowledgePackage pkg;
            if (!pkgs.containsKey(pkgName) || (ruleImpl = (pkg = (InternalKnowledgePackage)pkgs.get(pkgName)).getRule(startingRule)) == null || (descr = (RuleUnitDescription)unitRegistry.getDescription(ruleImpl).orElse(null)) == null) continue;
            return descr.getRuleUnitClass();
        }
        return null;
    }

    private List<String> calculatePossiblePackageNames(String modelId, String ... knownPackageNames) {
        ArrayList<String> packageNames = new ArrayList<String>();
        String javaModelId = modelId.replaceAll("\\s", "");
        String capJavaModelId = StringUtils.ucFirst((String)javaModelId);
        if (knownPackageNames != null && knownPackageNames.length > 0) {
            for (String knownPkgName : knownPackageNames) {
                packageNames.add(knownPkgName + "." + javaModelId);
                if (javaModelId.equals(capJavaModelId)) continue;
                packageNames.add(knownPkgName + "." + capJavaModelId);
            }
        }
        String basePkgName = "org.kie.pmml.pmml_4_2." + javaModelId;
        packageNames.add(basePkgName);
        if (!javaModelId.equals(capJavaModelId)) {
            packageNames.add("org.kie.pmml.pmml_4_2." + capJavaModelId);
        }
        return packageNames;
    }

    private <T> T castObject(Object o, Class<T> clazz) {
        T result = null;
        if (o != null && clazz != null) {
            result = clazz.cast(o);
        }
        return result;
    }

    private <T> DataSource<T> createDataSource(RuleUnitExecutor executor, String dsName, Object o) {
        Object object = this.castObject(o, o.getClass());
        return executor.newDataSource(dsName, object);
    }

    private <T> void insertDataObject(DataSource<T> ds, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot insert null object into a DataSource");
        }
        Object obj = null;
        try {
            obj = object;
        }
        catch (ClassCastException ccx) {
            throw new IllegalArgumentException("Invalid attempt to insert a " + object.getClass().getName() + " object into a DataSource");
        }
        ds.insert(object);
    }

    private KieBase lookupKieBase(RegistryContext ctx) {
        KieSession session;
        if (ctx == null) {
            return null;
        }
        KieBase kbase = (KieBase)ctx.lookup(KieBase.class);
        if (kbase == null && (session = (KieSession)ctx.lookup(KieSession.class)) != null) {
            kbase = session.getKieBase();
        }
        return kbase;
    }

    public PMML4Result execute(Context context, PMMLRequestData requestData, List<Object> complexInputObjects, String packageName, boolean isMining) {
        KieBase kbase;
        if (this.isjPMMLAvailableToClassLoader(this.getClass().getClassLoader())) {
            throw new IllegalStateException("Availability of jPMML module disables ApplyPmmlModelCommand execution. ApplyPmmlModelCommand requires removal of JPMML libs from classpath");
        }
        if (requestData == null) {
            throw new IllegalStateException("ApplyPmmlModelCommand requires request data (PMMLRequestData) to execute");
        }
        PMML4Result resultHolder = new PMML4Result(requestData.getCorrelationId());
        RegistryContext ctx = (RegistryContext)context;
        if (packageName == null) {
            packageName = (String)ctx.get("packageName");
        }
        if ((kbase = this.lookupKieBase(ctx)) == null) {
            resultHolder.setResultCode("ERROR-1");
        } else {
            boolean hasUnits = ((InternalKnowledgeBase)kbase).getRuleUnitDescriptionRegistry().hasUnits();
            if (!hasUnits) {
                resultHolder.setResultCode("ERROR-2");
            } else {
                RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
                DataSource<PMMLRequestData> data = executor.newDataSource("request", requestData);
                DataSource<PMML4Result> resultData = executor.newDataSource("results", resultHolder);
                if (complexInputObjects != null && !complexInputObjects.isEmpty()) {
                    HashMap datasources = new HashMap();
                    for (Object obj : complexInputObjects) {
                        String dsName = "externalBean" + obj.getClass().getSimpleName();
                        if (datasources.containsKey(dsName)) {
                            this.insertDataObject((DataSource)datasources.get(dsName), obj);
                            continue;
                        }
                        datasources.put(dsName, this.createDataSource(executor, dsName, obj));
                    }
                }
                executor.newDataSource("pmmlData", new Object[0]);
                if (isMining) {
                    executor.newDataSource("childModelSegments", new Object[0]);
                    executor.newDataSource("miningModelPojo", new Object[0]);
                }
                Collection parms = requestData.getRequestParams();
                for (ParameterInfo pi : parms) {
                    Class clazz = pi.getType();
                    if (clazz.isAssignableFrom(pi.getValue().getClass())) continue;
                    try {
                        Object o = clazz.getDeclaredConstructor(pi.getValue().getClass()).newInstance(pi.getValue());
                        pi.setValue(o);
                    }
                    catch (Throwable t) {
                        resultHolder.setResultCode("ERROR-3");
                        return resultHolder;
                    }
                }
                data.insert(requestData);
                resultData.insert(resultHolder);
                String startingRule = isMining ? "Start Mining - " + requestData.getModelName() : "RuleUnitIndicator";
                List<String> possibleStartingPackages = this.calculatePossiblePackageNames(requestData.getModelName(), packageName);
                Class<? extends RuleUnit> ruleUnitClass = this.getStartingRuleUnit(startingRule, (InternalKnowledgeBase)kbase, possibleStartingPackages);
                executor.run(ruleUnitClass);
            }
        }
        List outputs = OutputFieldFactory.createOutputsFromResults((PMML4Result)resultHolder);
        Optional<Object> execRes = Optional.ofNullable(ctx.lookup(ExecutionResultImpl.class));
        ctx.register(PMML4Result.class, (Object)resultHolder);
        execRes.ifPresent(result -> result.setResult("results", (Object)resultHolder));
        outputs.forEach(out -> {
            execRes.ifPresent(result -> result.setResult(out.getName(), out));
            resultHolder.updateResultVariable(out.getName(), out);
        });
        return resultHolder;
    }

    private boolean isjPMMLAvailableToClassLoader(ClassLoader classLoader) {
        try {
            classLoader.loadClass("org.kie.dmn.jpmml.DMNjPMMLInvocationEvaluator");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

