/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.integrationtests;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.ClassUtils;
import org.drools.ruleunit.DataSource;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.RuleUnitExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.utils.KieHelper;

public class RuleUnitCoordinationTest {
    @Test
    public void testCoordination() throws Exception {
        String drl1 = "package org.drools.ruleunit.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(MainModelUnit.class) + ";\nimport " + MainModel.class.getCanonicalName() + "\nimport " + ApplicableModel.class.getCanonicalName() + "\nimport " + ApplyMathModel.class.getCanonicalName() + "\nimport " + ApplyStringModel.class.getCanonicalName() + "\nimport " + ScheduledModelApplicationUnit.class.getCanonicalName() + "\n\nrule FindModelToApply \nwhen\n   $mm: MainModel( subModels != null ) from models\n   $am: ApplicableModel( applied == false, $idx: index ) from $mm.subModels\nthen\n   applicableModels.insert($am);\n   drools.run(new ScheduledModelApplicationUnit(models,applicableModels));\nend\n";
        String drl2 = "package org.drools.ruleunit.integrationtests\nunit " + ClassUtils.getCanonicalSimpleName(ScheduledModelApplicationUnit.class) + ";\nimport " + MainModel.class.getCanonicalName() + "\nimport " + ApplicableModel.class.getCanonicalName() + "\nimport " + ApplyMathModel.class.getCanonicalName() + "\nimport " + ApplyStringModel.class.getCanonicalName() + "\n\nrule Apply_ApplyMathModel_Addition \nwhen\n    $amm: ApplyMathModel( applied == false, inputValue1 != null,                           inputValue2 != null, operation == \"add\" ) from applicableModels\n    $v1: Integer() from $amm.inputValue1 \n    $v2: Integer() from $amm.inputValue2 \nthen\n    modify($amm) { \n       setResult($v1.intValue() + $v2.intValue()), \n       setApplied(true) \n    };\n    System.out.println(\"Result = \"+$amm.getResult());\nend\n\nrule Apply_ApplyStringModel_Concat \nwhen\n    $asm: ApplyStringModel( applied == false, inputString1 != null,                             inputString2 != null, operation == \"concat\" ) from applicableModels \n    $v1: String() from $asm.inputString1 \n    $v2: String() from $asm.inputString2 \nthen\n    String result = $v1+\" \"+$v2; \n    modify($asm) {\n       setResult(result),\n       setApplied(true)\n    };\n    System.out.println(\"Result = \"+$asm.getResult());\nend\n";
        MainModel main = new MainModel("TestMain");
        ApplyMathModel mathModel = new ApplyMathModel(1, "Math1", "add", 10, 10);
        ApplyStringModel stringModel = new ApplyStringModel(2, "String1", "concat", "hello", "world");
        main.addSubModel(mathModel);
        main.addSubModel(stringModel);
        KieBase kbase = new KieHelper().addContent(drl1, ResourceType.DRL).addContent(drl2, ResourceType.DRL).build(new KieBaseOption[0]);
        RuleUnitExecutor executor = RuleUnitExecutor.create().bind(kbase);
        DataSource mainModels = executor.newDataSource("models", (Object[])new MainModel[0]);
        DataSource applicableModels = executor.newDataSource("applicableModel", (Object[])new ApplicableModel[0]);
        FactHandle mainFH = mainModels.insert((Object)main);
        MainModelUnit unit = new MainModelUnit((DataSource<MainModel>)mainModels, (DataSource<ApplicableModel>)applicableModels);
        executor.run((RuleUnit)unit);
        Assert.assertEquals((long)20L, (long)mathModel.getResult().intValue());
        Assert.assertEquals((Object)"hello world", (Object)stringModel.getResult());
    }

    public static class ScheduledModelApplicationUnit
    implements RuleUnit {
        private DataSource<MainModel> models;
        private DataSource<ApplicableModel> applicableModels;

        public ScheduledModelApplicationUnit(DataSource<MainModel> models, DataSource<ApplicableModel> applicableModels) {
            this.models = models;
            this.applicableModels = applicableModels;
        }

        public DataSource<MainModel> getModels() {
            return this.models;
        }

        public DataSource<ApplicableModel> getApplicableModels() {
            return this.applicableModels;
        }
    }

    public static class MainModelUnit
    implements RuleUnit {
        private DataSource<MainModel> models;
        private DataSource<ApplicableModel> applicableModels;

        public MainModelUnit(DataSource<MainModel> models, DataSource<ApplicableModel> applicableModels) {
            this.models = models;
            this.applicableModels = applicableModels;
        }

        public DataSource<MainModel> getModels() {
            return this.models;
        }

        public DataSource<ApplicableModel> getApplicableModels() {
            return this.applicableModels;
        }
    }

    public static class ApplyStringModel
    extends ApplicableModel {
        private String inputString1;
        private String inputString2;
        private String result;

        public ApplyStringModel(int index, String name, String operation, String inputString1, String inputString2) {
            super(index, name, operation);
            this.inputString1 = inputString1;
            this.inputString2 = inputString2;
        }

        public String getInputString1() {
            return this.inputString1;
        }

        public void setInputString1(String inputString1) {
            this.inputString1 = inputString1;
        }

        public String getInputString2() {
            return this.inputString2;
        }

        public void setInputString2(String inputString2) {
            this.inputString2 = inputString2;
        }

        @Override
        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }

    public static class ApplyMathModel
    extends ApplicableModel {
        private Integer inputValue1;
        private Integer inputValue2;
        private Integer result;

        public ApplyMathModel(int index, String name, String operation, Integer inputValue1, Integer inputValue2) {
            super(index, name, operation);
            this.inputValue1 = inputValue1;
            this.inputValue2 = inputValue2;
        }

        public Integer getInputValue1() {
            return this.inputValue1;
        }

        public void setInputValue1(Integer inputValue1) {
            this.inputValue1 = inputValue1;
        }

        public Integer getInputValue2() {
            return this.inputValue2;
        }

        public void setInputValue2(Integer inputValue2) {
            this.inputValue2 = inputValue2;
        }

        @Override
        public Integer getResult() {
            return this.result;
        }

        public void setResult(Integer result) {
            this.result = result;
        }
    }

    public static abstract class ApplicableModel
    extends BasicModel {
        private boolean applied;

        public ApplicableModel(int index, String name, String operation) {
            super(index, name, operation);
            this.applied = false;
        }

        public ApplicableModel(int index, String name, String operation, boolean applied) {
            super(index, name, operation);
            this.applied = applied;
        }

        public boolean isApplied() {
            return this.applied;
        }

        public void setApplied(boolean applied) {
            this.applied = applied;
        }

        public abstract Object getResult();
    }

    public static class MainModel
    extends BasicModel {
        private List<ApplicableModel> subModels = new ArrayList<ApplicableModel>();

        public MainModel(String name) {
            super(0, name, "main");
        }

        public List<ApplicableModel> getSubModels() {
            return this.subModels;
        }

        public boolean addSubModel(ApplicableModel subModel) {
            return this.subModels.add(subModel);
        }
    }

    public static class BasicModel {
        private int index;
        private String name;
        private String operation;

        public BasicModel(int index, String name, String operation) {
            this.index = index;
            this.name = name;
            this.operation = operation;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

