/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.dsl.AccumulateUnit;
import org.drools.ruleunits.dsl.ExistentialUnit;
import org.drools.ruleunits.dsl.GroupByUnit;
import org.drools.ruleunits.dsl.HelloWorldUnit;
import org.drools.ruleunits.dsl.InferenceUnit;
import org.drools.ruleunits.dsl.LogicalAddUnit;
import org.drools.ruleunits.dsl.MultiJoinUnit;
import org.drools.ruleunits.dsl.SelfJoinUnit;
import org.drools.ruleunits.dsl.SelfJoinWithInferenceAndNotUnit;
import org.drools.ruleunits.dsl.SumAccumulateUnit;
import org.drools.ruleunits.dsl.UnitOne;
import org.drools.ruleunits.dsl.UnitTwo;
import org.drools.ruleunits.dsl.domain.Cheese;
import org.drools.ruleunits.dsl.domain.Person;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.FactHandle;

public class RuleUnitsTest {
    @Test
    public void testHelloWorld() {
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        Assertions.assertThat(unit.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"it worked!", "it also worked with HELLO WORLD"});
        unit.getResults().clear();
        unit.getInts().add((Object)11);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"String 'Hello World' is 11 characters long"});
        unitInstance.close();
    }

    @Test
    public void testInference() {
        InferenceUnit unit = new InferenceUnit();
        unit.getStrings().add((Object)"test");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        final AtomicBoolean success = new AtomicBoolean(false);
        unit.getStrings().subscribe((DataProcessor)new DataProcessor<String>(){

            public FactHandle insert(DataHandle handle, String object) {
                if (object.equals("ok")) {
                    success.set(true);
                }
                return null;
            }

            public void update(DataHandle handle, String object) {
            }

            public void delete(DataHandle handle) {
            }
        });
        unit.getStrings().add((Object)"Mario");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(3);
        Assertions.assertThat((boolean)success.get()).isTrue();
        unitInstance.close();
    }

    @Test
    public void testSelfJoin() {
        SelfJoinUnit unit = new SelfJoinUnit();
        unit.getStrings().add((Object)"abc");
        unit.getStrings().add((Object)"bcd");
        unit.getStrings().add((Object)"xyz");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"Found 'abc' and 'bcd'"});
        unitInstance.close();
    }

    @Test
    public void testAccumulate() {
        AccumulateUnit unit = new AccumulateUnit();
        unit.getStrings().add((Object)"A1");
        unit.getStrings().add((Object)"A123");
        unit.getStrings().add((Object)"B12");
        unit.getStrings().add((Object)"ABCDEF");
        unit.getStrings().add((Object)"BCDEF");
        unit.getStrings().add((Object)"Cx");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        int fireNr = unitInstance.fire();
        Assertions.assertThat((int)fireNr).isEqualTo(3);
        Assertions.assertThat(unit.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Sum of length of Strings starting with A is 12", "Max length of Strings not starting with A is 5", "Count of Strings above threshold is 0"});
        unit.getResults().clear();
        unit.getThreshold().set((Object)4);
        fireNr = unitInstance.fire();
        Assertions.assertThat((int)fireNr).isEqualTo(2);
        Assertions.assertThat(unit.getResults()).containsExactlyInAnyOrder((Object[])new String[]{"Average length of Strings longer than threshold 4 is 5.5", "Count of Strings above threshold is 2"});
        unitInstance.close();
    }

    @Test
    public void testGroupBy() {
        GroupByUnit unit = new GroupByUnit();
        unit.getPersons().add((Object)new Person("Mario", 48));
        unit.getPersons().add((Object)new Person("Matteo", 10));
        unit.getPersons().add((Object)new Person("Marilena", 17));
        unit.getPersons().add((Object)new Person("Edson", 38));
        unit.getPersons().add((Object)new Person("Edoardo", 33));
        unit.getPersons().add((Object)new Person("Mark", 45));
        unit.getPersons().add((Object)new Person("Daniele", 13));
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        Assertions.assertThat(unit.getResults().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"M", "E"});
        Assertions.assertThat((Object)unit.getResults().get("M")).isEqualTo((Object)93);
        Assertions.assertThat((Object)unit.getResults().get("E")).isEqualTo((Object)71);
        unit.getResults().clear();
        unit.getThreshold().set((Object)12);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(3);
        Assertions.assertThat(unit.getResults().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"M", "E", "D"});
        Assertions.assertThat((List)((List)unit.getResults().get("M"))).containsExactlyInAnyOrder(new Object[]{"Mario", "Marilena", "Mark"});
        Assertions.assertThat((List)((List)unit.getResults().get("E"))).containsExactlyInAnyOrder(new Object[]{"Edson", "Edoardo"});
        Assertions.assertThat((List)((List)unit.getResults().get("D"))).containsExactlyInAnyOrder(new Object[]{"Daniele"});
        unitInstance.close();
    }

    @Test
    public void testExistential() {
        ExistentialUnit unit = new ExistentialUnit();
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).contains((Object[])new String[]{"There's no Hello World"});
        unit.getResults().clear();
        unit.getStrings().add((Object)"test");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        unit.getStrings().add((Object)"Hello World");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).contains((Object[])new String[]{"There is at least one Hello World"});
        unit.getResults().clear();
        unit.getStrings().add((Object)"Hello World");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        unit.getThreshold().set((Object)20);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        unit.getStrings().add((Object)"This is a very long String");
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).contains((Object[])new String[]{"There is at least a String longer than threshold 20"});
        unitInstance.close();
    }

    @Test
    public void testMultiJoin() {
        MultiJoinUnit unit = new MultiJoinUnit();
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        unit.getStrings().add((Object)"Hello World");
        unit.getInts().add((Object)11);
        unit.getPersons().add((Object)new Person("Sofia", 4));
        unit.getCheeses().add((Object)new Cheese("Gorgonzola", 20));
        unit.getCheeses().add((Object)new Cheese("Mozzarella", 12));
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        unit.getPersons().add((Object)new Person("Mark", 47));
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
        unit.getPersons().add((Object)new Person("Mario", 48));
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"Found Mario who eats Mozzarella"});
        unitInstance.close();
    }

    @Test
    public void testUnitsCoordination() {
        UnitOne unitOne = new UnitOne();
        UnitTwo unitTwo = new UnitTwo(unitOne.getInts());
        RuleUnitInstance unitInstanceOne = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unitOne);
        RuleUnitInstance unitInstanceTwo = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unitTwo);
        unitOne.getStrings().add((Object)"Hello World");
        Assertions.assertThat((int)unitInstanceOne.fire()).isEqualTo(1);
        Assertions.assertThat((int)unitInstanceTwo.fire()).isEqualTo(1);
        Assertions.assertThat(unitTwo.getResults()).containsExactly((Object[])new String[]{"Found 11"});
        unitInstanceOne.close();
        unitInstanceTwo.close();
    }

    @Test
    public void testSelfJoinWithInferenceAndNot() {
        SelfJoinWithInferenceAndNotUnit unit = new SelfJoinWithInferenceAndNotUnit();
        unit.getStrings().add((Object)"abc");
        unit.getStrings().add((Object)"axy");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        unitInstance.close();
    }

    @Test
    public void testLogicalAdd() {
        LogicalAddUnit unit = new LogicalAddUnit();
        DataHandle dh = unit.getStrings().add((Object)"abc");
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"exists"});
        unit.getResults().clear();
        unit.getStrings().remove(dh);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"not exists"});
        unitInstance.close();
    }

    @Test
    public void testRuleUnitDefinitionReuse() {
        SumAccumulateUnit unit = new SumAccumulateUnit();
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        int fireNr = unitInstance.fire();
        Assertions.assertThat((int)fireNr).isEqualTo(1);
        Assertions.assertThat(unit.getResults()).containsExactly((Object[])new Integer[]{0});
        SumAccumulateUnit unit2 = new SumAccumulateUnit();
        unit2.getIntegers().add((Object)17);
        RuleUnitInstance unitInstance2 = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit2);
        int fireNr2 = unitInstance2.fire();
        Assertions.assertThat((int)fireNr2).isEqualTo(1);
        Assertions.assertThat(unit2.getResults()).containsExactly((Object[])new Integer[]{17});
        unitInstance.close();
        unitInstance2.close();
    }
}

