/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl.constraints;

import java.io.Serializable;
import java.util.UUID;
import org.drools.model.AlphaIndex;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.ruleunits.dsl.constraints.AbstractConstraint;
import org.drools.ruleunits.dsl.util.ClassIntrospectionCache;

public class AlphaConstraintWithRightValue<L, R>
extends AbstractConstraint<L, R> {
    private final R rightValue;

    public AlphaConstraintWithRightValue(Variable<L> variable, String fieldName, Function1<L, R> extractor, Index.ConstraintType constraintType, R rightValue) {
        super(variable, fieldName, extractor, constraintType);
        this.rightValue = rightValue;
    }

    @Override
    public void addConstraintToPattern(PatternDSL.PatternDef<L> patternDef) {
        Object exprId;
        AlphaIndex alphaIndex = null;
        PatternDSL.ReactOn reactOn = null;
        if (this.leftFieldName != null) {
            exprId = "expr:" + this.leftVariable.getType().getCanonicalName() + ":" + this.leftFieldName + ":" + this.constraintType + ":" + this.rightValue;
            alphaIndex = this.rightValue != null ? PatternDSL.alphaIndexedBy(this.rightValue.getClass(), (Index.ConstraintType)this.constraintType, (int)ClassIntrospectionCache.getFieldIndex(this.leftVariable.getType(), this.leftFieldName), (Function1)this.leftExtractor, this.rightValue) : null;
            reactOn = PatternDSL.reactOn((String[])new String[]{this.leftFieldName});
        } else {
            exprId = UUID.randomUUID().toString();
        }
        patternDef.expr((String)exprId, (Predicate1 & Serializable)p -> this.constraintType.asPredicate().test(this.leftExtractor.apply(p), this.rightValue), alphaIndex, reactOn);
    }
}

