/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl.constraints;

import java.io.Serializable;
import java.util.UUID;
import org.drools.model.BetaIndex2;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Predicate3;
import org.drools.ruleunits.dsl.constraints.AbstractConstraint;
import org.drools.ruleunits.dsl.util.ClassIntrospectionCache;

public class Beta2Constraint<L, R1, R2, V>
extends AbstractConstraint<L, V> {
    private final Variable<R1> rightVariable1;
    private final Variable<R2> rightVariable2;
    private final Function2<R1, R2, V> rightExtractor;

    public Beta2Constraint(Variable<L> leftVariable, String fieldName, Function1<L, V> leftExtractor, Index.ConstraintType constraintType, Variable<R1> rightVariable1, Variable<R2> rightVariable2, Function2<R1, R2, V> rightExtractor) {
        super(leftVariable, fieldName, leftExtractor, constraintType);
        this.rightVariable1 = rightVariable1;
        this.rightVariable2 = rightVariable2;
        this.rightExtractor = rightExtractor;
    }

    @Override
    public void addConstraintToPattern(PatternDSL.PatternDef<L> patternDef) {
        Object exprId;
        BetaIndex2 betaIndex = null;
        PatternDSL.ReactOn reactOn = null;
        if (this.leftFieldName != null) {
            exprId = "expr:" + this.leftVariable.getType().getCanonicalName() + ":" + this.leftFieldName + ":" + this.constraintType + ":" + this.rightVariable1.getType().getCanonicalName() + ":" + this.rightVariable2.getType().getCanonicalName();
            betaIndex = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)this.constraintType, (int)ClassIntrospectionCache.getFieldIndex(this.leftVariable.getType(), this.leftFieldName), (Function1)this.leftExtractor, this.rightExtractor, Object.class);
            reactOn = PatternDSL.reactOn((String[])new String[]{this.leftFieldName});
        } else {
            exprId = UUID.randomUUID().toString();
        }
        patternDef.expr((String)exprId, this.rightVariable1, this.rightVariable2, (Predicate3 & Serializable)(l, r1, r2) -> this.constraintType.asPredicate().test(this.leftExtractor.apply(l), this.rightExtractor.apply(r1, r2)), betaIndex, reactOn);
    }
}

