/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.model.Index;
import org.drools.model.functions.Block1;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.dsl.RuleFactory;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.SyntheticRuleUnit;
import org.drools.ruleunits.dsl.SyntheticRuleUnitBuilder;
import org.junit.jupiter.api.Test;

public class ProgrammaticSyntheticRuleUnitsTest {
    @Test
    public void test() {
        DataStore strings = DataSource.createStore();
        DataStore ints = DataSource.createStore();
        ArrayList<String> results = new ArrayList<String>();
        SyntheticRuleUnitBuilder unitBuilder = SyntheticRuleUnitBuilder.build((String)"ProgTestUnit");
        unitBuilder.registerDataSource("strings", (DataSource)strings, String.class);
        unitBuilder.registerDataSource("ints", (DataSource)ints, Integer.class);
        unitBuilder.registerGlobal("results", results);
        List<RuleDefinition> rules = this.parseRules((DataStore<String>)strings, (DataStore<Integer>)ints);
        Consumer<RulesFactory> rulesDefinition = this.createRulesDefinition(rules, results);
        SyntheticRuleUnit unit = unitBuilder.defineRules(rulesDefinition);
        RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);
        strings.add((Object)"Hi Universe");
        strings.add((Object)"Hello World");
        ints.add((Object)7);
        Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
        Assertions.assertThat(results).containsExactlyInAnyOrder((Object[])new String[]{"R2"});
    }

    private Consumer<RulesFactory> createRulesDefinition(List<RuleDefinition> rules, List<String> results) {
        return rulesFactory -> {
            boolean i = false;
            for (RuleDefinition rule : rules) {
                this.addRule(rulesFactory.rule(rule.ruleName), rule, results);
            }
        };
    }

    private void addRule(RuleFactory ruleFactory, RuleDefinition rule, List<String> results) {
        for (Constraint constraint : rule.constraints) {
            ruleFactory.on(constraint.dataStore).filter(constraint.operator, constraint.value);
        }
        ruleFactory.execute(results, (Block1 & Serializable)r -> r.add(rule.ruleName));
    }

    private List<RuleDefinition> parseRules(DataStore<String> strings, DataStore<Integer> ints) {
        ArrayList<RuleDefinition> rules = new ArrayList<RuleDefinition>();
        Constraint<String> r1c1 = new Constraint<String>(strings, Index.ConstraintType.EQUAL, "Hi Universe");
        Constraint<Integer> r1c2 = new Constraint<Integer>(ints, Index.ConstraintType.LESS_OR_EQUAL, 5);
        rules.add(new RuleDefinition("R1", r1c1, r1c2));
        Constraint<String> r2c1 = new Constraint<String>(strings, Index.ConstraintType.EQUAL, "Hello World");
        Constraint<Integer> r2c2 = new Constraint<Integer>(ints, Index.ConstraintType.GREATER_THAN, 5);
        rules.add(new RuleDefinition("R2", r2c1, r2c2));
        return rules;
    }

    private static class RuleDefinition {
        private final String ruleName;
        private final Constraint[] constraints;

        private RuleDefinition(String ruleName, Constraint ... constraints) {
            this.ruleName = ruleName;
            this.constraints = constraints;
        }
    }

    private static class Constraint<T> {
        private final DataStore<T> dataStore;
        private final Index.ConstraintType operator;
        private final T value;

        private Constraint(DataStore<T> dataStore, Index.ConstraintType operator, T value) {
            this.dataStore = dataStore;
            this.operator = operator;
            this.value = value;
        }
    }
}

