/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.model.Index;
import org.drools.model.functions.Block5;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Predicate3;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.domain.Cheese;
import org.drools.ruleunits.dsl.domain.Person;

public class MultiJoinUnit
implements RuleUnitDefinition {
    private final DataStore<String> strings;
    private final DataStore<Integer> ints;
    private final DataStore<Person> persons;
    private final DataStore<Cheese> cheeses;
    private final List<String> results = new ArrayList<String>();

    public MultiJoinUnit() {
        this((DataStore<String>)DataSource.createStore(), (DataStore<Integer>)DataSource.createStore(), (DataStore<Person>)DataSource.createStore(), (DataStore<Cheese>)DataSource.createStore());
    }

    public MultiJoinUnit(DataStore<String> strings, DataStore<Integer> ints, DataStore<Person> persons, DataStore<Cheese> cheeses) {
        this.strings = strings;
        this.ints = ints;
        this.persons = persons;
        this.cheeses = cheeses;
    }

    public DataStore<String> getStrings() {
        return this.strings;
    }

    public DataStore<Integer> getInts() {
        return this.ints;
    }

    public DataStore<Person> getPersons() {
        return this.persons;
    }

    public DataStore<Cheese> getCheeses() {
        return this.cheeses;
    }

    public List<String> getResults() {
        return this.results;
    }

    public void defineRules(RulesFactory rulesFactory) {
        rulesFactory.rule("Complex multiple joins").on(this.strings).filter("length", (Function1 & Serializable)s -> s.length(), Index.ConstraintType.GREATER_THAN, (Object)5).join((Function1 & Serializable)rule -> rule.on(this.ints).filter(Index.ConstraintType.GREATER_THAN, (Object)5)).filter(Index.ConstraintType.EQUAL, String::length).join((Function1 & Serializable)rule -> rule.on(this.persons).filter("age", Person::getAge, Index.ConstraintType.GREATER_THAN, "name", (Function1 & Serializable)p -> p.getName().length())).filter((Predicate3 & Serializable)(s, i, p) -> p.getAge() == (i + s.length()) * 2 + 4).filter("age", Person::getAge, Index.ConstraintType.EQUAL, (Function2 & Serializable)(s, i) -> i + s.length() + 26).on(this.cheeses).filter("price", Cheese::getPrice, Index.ConstraintType.LESS_THAN, (Function3 & Serializable)(s, i, p) -> p.getName().length() + i).execute(this.results, (Block5 & Serializable)(r, s, i, p, c) -> r.add("Found " + p.getName() + " who eats " + c.getName()));
    }
}

