/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.drools.model.Condition;
import org.drools.model.DSL;
import org.drools.model.DeclarationSource;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Function1;
import org.drools.model.impl.RuleBuilder;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.dsl.RuleFactory;
import org.drools.ruleunits.dsl.RuleUnitDefinition;
import org.drools.ruleunits.dsl.RulesFactory;
import org.drools.ruleunits.dsl.SyntheticRuleUnit;
import org.drools.ruleunits.dsl.accumulate.AccumulatePattern1;
import org.drools.ruleunits.dsl.accumulate.Accumulator1;
import org.drools.ruleunits.dsl.accumulate.GroupByPattern1;
import org.drools.ruleunits.dsl.patterns.CombinedPatternDef;
import org.drools.ruleunits.dsl.patterns.ExistentialPatternDef;
import org.drools.ruleunits.dsl.patterns.InternalPatternDef;
import org.drools.ruleunits.dsl.patterns.Pattern1DefImpl;
import org.drools.ruleunits.dsl.patterns.Pattern2Def;
import org.drools.ruleunits.dsl.patterns.Pattern2DefImpl;
import org.drools.ruleunits.dsl.patterns.PatternDef;
import org.drools.ruleunits.dsl.util.DataSourceDefinition;
import org.drools.ruleunits.impl.datasources.ConsequenceDataStore;
import org.drools.ruleunits.impl.datasources.ConsequenceDataStoreImpl;
import org.kie.api.runtime.rule.RuleContext;

public class RuleDefinition
implements RuleFactory {
    private final String name;
    private final RuleUnitDefinition unit;
    private final RulesFactory.UnitGlobals globals;
    private final List<InternalPatternDef> patterns = new ArrayList<InternalPatternDef>();
    private RuleItemBuilder consequence;
    private boolean registerNewPattern = true;

    public RuleDefinition(String name, RuleUnitDefinition unit, RulesFactory.UnitGlobals globals) {
        this.name = name;
        this.globals = globals;
        this.unit = unit;
    }

    public void addPattern(InternalPatternDef pattern) {
        this.patterns.add(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <B> InternalPatternDef internalCreatePattern(B builder, Function1<B, PatternDef> patternBuilder) {
        this.registerNewPattern = false;
        try {
            InternalPatternDef created = (InternalPatternDef)patternBuilder.apply(builder);
            InternalPatternDef internalPatternDef = builder instanceof InternalPatternDef ? created.subPatternFrom((InternalPatternDef)builder) : created;
            return internalPatternDef;
        }
        finally {
            this.registerNewPattern = true;
        }
    }

    public <A> Pattern1DefImpl<A> on(DataSource<A> dataSource) {
        DataSourceFieldDefinition dataSourceField = (DataSourceFieldDefinition)this.findUnitField(dataSource);
        Pattern1DefImpl pattern1 = new Pattern1DefImpl(this, DSL.declarationOf(dataSourceField.getDataSourceClass(), (DeclarationSource)DSL.entryPoint((String)this.asGlobal(() -> dataSourceField, dataSource).getName())));
        if (this.registerNewPattern) {
            this.addPattern(pattern1);
        }
        return pattern1;
    }

    @Override
    public RuleFactory not(Function1<RuleFactory, PatternDef> patternBuilder) {
        this.addPattern(new ExistentialPatternDef(Condition.Type.NOT, this.internalCreatePattern(this, patternBuilder)));
        return this;
    }

    @Override
    public RuleFactory exists(Function1<RuleFactory, PatternDef> patternBuilder) {
        this.addPattern(new ExistentialPatternDef(Condition.Type.EXISTS, this.internalCreatePattern(this, patternBuilder)));
        return this;
    }

    public <A, B> Pattern1DefImpl<B> accumulate(Function1<RuleFactory, PatternDef> patternBuilder, Accumulator1<A, B> acc) {
        Pattern1DefImpl accPattern = this.asAccumulatePattern(this.internalCreatePattern(this, patternBuilder), acc);
        this.addPattern(accPattern);
        return accPattern;
    }

    private Pattern1DefImpl asAccumulatePattern(InternalPatternDef patternDef, Accumulator1 acc) {
        if (patternDef instanceof Pattern1DefImpl) {
            return new AccumulatePattern1(this, patternDef, acc);
        }
        if (patternDef instanceof Pattern2DefImpl) {
            Pattern2DefImpl pattern = (Pattern2DefImpl)patternDef;
            return new AccumulatePattern1(this, new CombinedPatternDef(Condition.Type.AND, pattern.getPatternA(), pattern.getPatternB()), acc);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <A, K, V> Pattern2Def<K, V> groupBy(Function1<RuleFactory, PatternDef> patternBuilder, Function1<A, K> groupingFunction, Accumulator1<A, V> acc) {
        GroupByPattern1<A, K, V> groupByPattern = new GroupByPattern1<A, K, V>(this, this.internalCreatePattern(this, patternBuilder), groupingFunction, acc);
        this.addPattern(groupByPattern);
        return groupByPattern;
    }

    public void setConsequence(RuleItemBuilder consequence) {
        this.consequence = consequence;
    }

    @Override
    public <T> void execute(T globalObject, Block1<T> block) {
        this.consequence = DSL.on((Variable)this.asGlobal(globalObject)).execute(block);
    }

    @Override
    public <T> void executeOnDataStore(DataStore<T> dataStore, Block1<ConsequenceDataStore<T>> block) {
        this.consequence = DSL.on((Variable)this.asGlobal(dataStore)).execute((Block2 & Serializable)(drools, ds) -> block.execute((Object)new ConsequenceDataStoreImpl((RuleContext)drools, (DataStore)ds)));
    }

    public <T> Global asGlobal(T globalObject) {
        return this.asGlobal(() -> this.findUnitField(globalObject), globalObject);
    }

    public <T> Global asGlobal(Supplier<FieldDefinition> globalField, T globalObject) {
        return this.globals.asGlobal(globalField, globalObject);
    }

    public Rule toRule() {
        RuleBuilder ruleBuilder = PatternDSL.rule((String)this.unit.getClass().getCanonicalName(), (String)this.name).unit(this.unit.getClass());
        ArrayList<Object> items = new ArrayList<Object>();
        for (InternalPatternDef pattern : this.patterns) {
            items.add(pattern.toExecModelItem());
        }
        if (this.consequence != null) {
            items.add(this.consequence);
        }
        return ruleBuilder.build(items.toArray(new RuleItemBuilder[items.size()]));
    }

    private FieldDefinition findUnitField(Object object) {
        Objects.requireNonNull(object);
        if (this.unit instanceof SyntheticRuleUnit) {
            return this.findSyntheticUnitField(object, (SyntheticRuleUnit)this.unit);
        }
        for (Field field : this.unit.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                if (object != field.get(this.unit)) continue;
                return new ReflectiveFieldDefinition(field);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Unknown unit field for object: " + object);
    }

    private FieldDefinition findSyntheticUnitField(Object object, SyntheticRuleUnit syntheticRuleUnit) {
        for (Map.Entry<String, DataSourceDefinition> entry : syntheticRuleUnit.getDataSourceDefinitions().entrySet()) {
            if (object != entry.getValue().getDataSource()) continue;
            return new SyntheticDataSourceFieldDefinition(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : syntheticRuleUnit.getGlobals().entrySet()) {
            if (object != entry.getValue()) continue;
            return new SyntheticGlobalFieldDefinition(entry.getKey());
        }
        throw new IllegalArgumentException("Unknown unit field for object: " + object);
    }

    public static interface FieldDefinition {
        public Object get(RuleUnitData var1);
    }

    public static interface DataSourceFieldDefinition
    extends FieldDefinition {
        public <A> Class<A> getDataSourceClass();
    }

    static class ReflectiveFieldDefinition
    implements DataSourceFieldDefinition {
        private final Field field;

        ReflectiveFieldDefinition(Field field) {
            this.field = field;
        }

        @Override
        public Object get(RuleUnitData unit) {
            try {
                return this.field.get(unit);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <A> Class<A> getDataSourceClass() {
            Type dsType = this.field.getGenericType();
            if (dsType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)dsType).getActualTypeArguments()[0];
            }
            throw new IllegalArgumentException("Unknown DataSource type");
        }
    }

    static class SyntheticDataSourceFieldDefinition
    implements DataSourceFieldDefinition {
        private final String name;
        private final DataSourceDefinition dataSourceDefinition;

        SyntheticDataSourceFieldDefinition(String name, DataSourceDefinition dataSourceDefinition) {
            this.name = name;
            this.dataSourceDefinition = dataSourceDefinition;
        }

        @Override
        public Object get(RuleUnitData unit) {
            return ((SyntheticRuleUnit)unit).getDataSourceDefinitions().get(this.name).getDataSource();
        }

        @Override
        public <A> Class<A> getDataSourceClass() {
            return this.dataSourceDefinition.getDataClass();
        }
    }

    static class SyntheticGlobalFieldDefinition
    implements FieldDefinition {
        private final String name;

        SyntheticGlobalFieldDefinition(String name) {
            this.name = name;
        }

        @Override
        public Object get(RuleUnitData unit) {
            return ((SyntheticRuleUnit)unit).getGlobals().get(this.name);
        }
    }
}

