/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.impl.LocationUnit;
import org.drools.ruleunits.impl.domain.Location;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;
import org.kie.api.runtime.rule.Variable;

public class QueryTest {
    @Test
    public void testQuery() {
        LocationUnit locationUnit = new LocationUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)locationUnit);){
            locationUnit.getLocations().add((Object)new Location("office", "house"));
            locationUnit.getLocations().add((Object)new Location("kitchen", "house"));
            locationUnit.getLocations().add((Object)new Location("knife", "kitchen"));
            locationUnit.getLocations().add((Object)new Location("cheese", "kitchen"));
            locationUnit.getLocations().add((Object)new Location("desk", "office"));
            locationUnit.getLocations().add((Object)new Location("chair", "office"));
            locationUnit.getLocations().add((Object)new Location("computer", "desk"));
            locationUnit.getLocations().add((Object)new Location("drawer", "desk"));
            locationUnit.getGo().set((Object)"go1");
            unitInstance.fire();
            QueryResults results = unitInstance.executeQuery("getLocations", new Object[]{Variable.v});
            results.size();
            for (QueryResultsRow row : results) {
                Assertions.assertThat((String)row.get("$x").toString()).isIn(new Object[]{"office in house", "desk in office", "desk in house", "computer in desk", "computer in office", "computer in house", "kitchen in house", "cheese in kitchen", "cheese in house", "chair in office", "chair in house", "knife in kitchen", "knife in house", "drawer in desk", "drawer in office", "drawer in house"});
            }
        }
    }
}

