/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.ClockType;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.HelloWorldUnit;
import org.drools.ruleunits.impl.TimerUnit;
import org.drools.ruleunits.impl.listener.TestAgendaEventListener;
import org.drools.ruleunits.impl.listener.TestRuleEventListener;
import org.drools.ruleunits.impl.listener.TestRuleRuntimeEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;

class RuleConfigTest {
    RuleConfigTest() {
    }

    @Test
    void addEventListeners() {
        TestAgendaEventListener testAgendaEventListener = new TestAgendaEventListener();
        TestRuleRuntimeEventListener testRuleRuntimeEventListener = new TestRuleRuntimeEventListener();
        TestRuleEventListener testRuleEventListener = new TestRuleEventListener();
        RuleConfig ruleConfig = RuleUnitProvider.get().newRuleConfig();
        ruleConfig.getAgendaEventListeners().add(testAgendaEventListener);
        ruleConfig.getRuleRuntimeListeners().add(testRuleRuntimeEventListener);
        ruleConfig.getRuleEventListeners().add(testRuleEventListener);
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit, ruleConfig);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
            Assertions.assertThat(testAgendaEventListener.getResults()).containsExactly((Object[])new String[]{"matchCreated : HelloWorld", "beforeMatchFired : HelloWorld", "afterMatchFired : HelloWorld"});
            Assertions.assertThat(testRuleRuntimeEventListener.getResults()).containsExactly((Object[])new String[]{"objectInserted : Hello World"});
            Assertions.assertThat(testRuleEventListener.getResults()).containsExactly((Object[])new String[]{"onBeforeMatchFire : HelloWorld", "onAfterMatchFire : HelloWorld"});
        }
    }

    @Test
    void clockType() {
        TimerUnit unit = new TimerUnit();
        unit.getStrings().add((Object)"Hello Timer");
        RuleConfig ruleConfig = RuleUnitProvider.get().newRuleConfig();
        ruleConfig.setClockType(ClockType.PSEUDO);
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit, ruleConfig);){
            SessionClock clock = unitInstance.getClock();
            Assertions.assertThat((Object)clock).isInstanceOf(SessionPseudoClock.class);
            SessionPseudoClock pseudoClock = (SessionPseudoClock)clock;
            Assertions.assertThat((int)unitInstance.fire()).isZero();
            Assertions.assertThat(unit.getResults()).isEmpty();
            pseudoClock.advanceTime(40L, TimeUnit.MINUTES);
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }
}

