/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.AgendaGroupUnit;
import org.drools.ruleunits.impl.HelloWorldUnit;
import org.drools.ruleunits.impl.LogicalAddByElementTestUnit;
import org.drools.ruleunits.impl.LogicalAddTestUnit;
import org.drools.ruleunits.impl.MultipleDataSourceUnit;
import org.drools.ruleunits.impl.NotTestUnit;
import org.drools.ruleunits.impl.RuleNameUnit;
import org.drools.ruleunits.impl.UpdateNoDSTestUnit;
import org.drools.ruleunits.impl.UpdateTestUnit;
import org.drools.ruleunits.impl.WronglyTypedUnit;
import org.drools.ruleunits.impl.domain.Measurement;
import org.drools.ruleunits.impl.domain.Person;
import org.drools.ruleunits.impl.domain.Sensor;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.kie.api.builder.CompilationErrorsException;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.rule.AgendaFilter;

public class RuleUnitProviderImplTest {
    @Test
    public void helloWorldGenerated() {
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void notWithAndWithoutSingleQuote() {
        NotTestUnit unit = new NotTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        }
    }

    @Test
    public void logicalAdd() {
        LogicalAddTestUnit unit = new LogicalAddTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            DataHandle dh = unit.getStrings().add((Object)"abc");
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"exists"});
            unit.getResults().clear();
            unit.getStrings().remove(dh);
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"not exists"});
        }
    }

    @Test
    public void logicalAddByElement() {
        LogicalAddByElementTestUnit unit = new LogicalAddByElementTestUnit();
        final ArrayList eventsRecorded = new ArrayList();
        RuleConfig ruleConfig = RuleUnitProvider.get().newRuleConfig();
        ruleConfig.getRuleRuntimeListeners().add(new RuleRuntimeEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                String byRuleName = Optional.ofNullable(event.getRule()).map(rule -> " by " + rule.getName()).orElse("");
                eventsRecorded.add(event.getObject() + " inserted" + byRuleName);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                String byRuleName = Optional.ofNullable(event.getRule()).map(rule -> " by " + rule.getName()).orElse("");
                eventsRecorded.add(event.getOldObject() + " deleted" + byRuleName);
            }
        });
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit, ruleConfig);){
            DataHandle handleToStringWithLength3 = unit.getStrings().add((Object)"abc");
            unit.getStrings().add((Object)"len4");
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(4);
            Assertions.assertThat(eventsRecorded).containsExactly((Object[])new String[]{"abc inserted", "len4 inserted", "3 inserted by R1", "4 inserted by R1"});
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"3 exists", "4 exists"});
            eventsRecorded.clear();
            unit.getResults().clear();
            unit.getStrings().remove(handleToStringWithLength3);
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(0);
            Assertions.assertThat(eventsRecorded).doesNotContain((Object[])new String[]{"4 deleted"});
            Assertions.assertThat(eventsRecorded).containsExactly((Object[])new String[]{"abc deleted", "3 deleted"});
        }
    }

    @Test
    public void update() {
        UpdateTestUnit unit = new UpdateTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            unit.getPersons().add((Object)new Person("Mario", 17));
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"ok"});
        }
    }

    @Test
    public void updateNoDS() {
        UpdateNoDSTestUnit unit = new UpdateNoDSTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            unit.getPersons().add((Object)new Person("Mario", 17));
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"ok"});
        }
    }

    @Test
    public void wrongType() {
        try {
            RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)new WronglyTypedUnit());
            Assertions.fail((String)"Compilation should fail");
        }
        catch (CompilationErrorsException e) {
            Assertions.assertThat((boolean)e.getErrorMessages().stream().map(Objects::toString).anyMatch(s -> s.contains("The method add(Integer) in the type DataStore<Integer> is not applicable for the arguments (String)"))).isTrue();
        }
    }

    @DisabledIfSystemProperty(named="drools.drl.antlr4.parser.enabled", matches="true")
    @Test
    public void agendaGroup() {
        try {
            RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)new AgendaGroupUnit());
            Assertions.fail((String)"Compilation should fail");
        }
        catch (CompilationErrorsException e) {
            Assertions.assertThat((boolean)e.getErrorMessages().stream().map(Objects::toString).anyMatch(s -> s.contains("Rule RuleInGroup belongs to unit AgendaGroupUnit and cannot have an agenda-group or a ruleflow-group"))).isTrue();
        }
    }

    @Test
    public void fireWithAgendaFilter() {
        RuleNameUnit unit = new RuleNameUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire((AgendaFilter)new RuleNameStartsWithAgendaFilter("GoodBye"))).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"GoodByeWorld"});
        }
    }

    @Test
    public void multipleOOPathLines() {
        MultipleDataSourceUnit unit = new MultipleDataSourceUnit();
        unit.getMeasurements().add((Object)new Measurement("color", "red"));
        unit.getSensors().add((Object)new Sensor("color"));
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getControlSet()).containsExactly((Object[])new String[]{"red"});
        }
    }
}

