/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.impl.InterpretedRuleUnit;

public class InMemoryRuleUnitInstanceFactory {
    private static final Map<Class, ClassLoader> kieModuleClassLoaders = new HashMap<Class, ClassLoader>();

    public static <T extends RuleUnitData> RuleUnitInstance<T> generateAndInstance(T ruleUnit, String ... drls) {
        ClassLoader kieModuleClassLoader = kieModuleClassLoaders.computeIfAbsent(ruleUnit.getClass(), c -> InterpretedRuleUnit.createRuleUnitKieProject(c, drls).getClassLoader());
        return InMemoryRuleUnitInstanceFactory.loadRuleUnits(kieModuleClassLoader).get(ruleUnit.getClass().getCanonicalName()).createInstance(ruleUnit);
    }

    private static Map<String, RuleUnit> loadRuleUnits(ClassLoader kieModuleClassLoader) {
        HashMap<String, RuleUnit> map = new HashMap<String, RuleUnit>();
        ServiceLoader<RuleUnit> loader = ServiceLoader.load(RuleUnit.class, kieModuleClassLoader);
        for (RuleUnit impl : loader) {
            map.put(impl.id(), impl);
        }
        return map;
    }
}

