/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.impl.FieldDataStore;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.FactHandle;

public class SingletonDataStoreTest {
    @Test
    public void testCreate() {
        Probe probe = new Probe();
        FieldDataStore integers = new FieldDataStore();
        integers.subscribe(probe);
        org.junit.jupiter.api.Assertions.assertNull((Object)probe.handle);
        org.junit.jupiter.api.Assertions.assertNull(probe.value);
    }

    @Test
    public void testAdd() {
        Probe probe = new Probe();
        FieldDataStore integers = new FieldDataStore();
        integers.subscribe(probe);
        integers.set((Object)1);
        integers.set((Object)2);
        integers.set((Object)3);
        Assertions.assertThat((Object)probe.handle).isNotNull();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (Integer)((Integer)probe.value));
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(1, 2, 3), probe.seen);
    }

    @Test
    public void testRemove() {
        Probe probe = new Probe();
        FieldDataStore integers = new FieldDataStore();
        integers.subscribe(probe);
        integers.set((Object)1);
        integers.set((Object)2);
        integers.set((Object)3);
        integers.clear();
        org.junit.jupiter.api.Assertions.assertNull((Object)probe.handle);
        org.junit.jupiter.api.Assertions.assertNull(probe.value);
    }

    private static class Probe<T>
    implements DataProcessor<T> {
        DataHandle handle;
        T value;
        List<T> seen = new ArrayList<T>();

        private Probe() {
        }

        public FactHandle insert(DataHandle handle, T object) {
            this.handle = handle;
            this.value = object;
            this.seen.add(object);
            return null;
        }

        public void update(DataHandle handle, T object) {
            org.junit.jupiter.api.Assertions.assertSame((Object)handle, (Object)this.handle);
            if (object != this.value) {
                this.value = object;
                this.seen.add(object);
            }
        }

        public void delete(DataHandle handle) {
            org.junit.jupiter.api.Assertions.assertSame((Object)handle, (Object)this.handle);
            this.handle = null;
            this.value = null;
        }
    }
}

