/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.RuleBase;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.model.codegen.execmodel.CanonicalModelKieProject;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.impl.InterpretedRuleUnitInstance;
import org.drools.ruleunits.impl.factory.AbstractRuleUnit;
import org.drools.ruleunits.impl.sessions.RuleUnitExecutorImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;

public class InterpretedRuleUnit<T extends RuleUnitData>
extends AbstractRuleUnit<T> {
    private final boolean useExecModel;

    public static <T extends RuleUnitData> RuleUnit<T> of(Class<T> type, boolean useExecModel) {
        return new InterpretedRuleUnit<T>(type.getCanonicalName(), useExecModel);
    }

    public static <T extends RuleUnitData> RuleUnitInstance<T> instance(T ruleUnit, boolean useExecModel) {
        return InterpretedRuleUnit.of(ruleUnit.getClass(), useExecModel).createInstance(ruleUnit);
    }

    private InterpretedRuleUnit(String id, boolean useExecModel) {
        super(id);
        this.useExecModel = useExecModel;
    }

    public RuleUnitInstance<T> internalCreateInstance(T data) {
        RuleBase ruleBase = this.createRuleBase(data);
        RuleUnitExecutorImpl reteEvaluator = new RuleUnitExecutorImpl(ruleBase);
        return new InterpretedRuleUnitInstance<T>(this, data, (ReteEvaluator)reteEvaluator);
    }

    private RuleBase createRuleBase(T data) {
        InternalKieModule kieModule = InterpretedRuleUnit.createRuleUnitKieModule(data.getClass(), this.useExecModel, new String[0]);
        KieModuleKieProject kieProject = InterpretedRuleUnit.createRuleUnitKieProject(kieModule, this.useExecModel);
        BuildContext buildContext = new BuildContext();
        InternalKnowledgeBase kBase = kieModule.createKieBase((KieBaseModelImpl)KieBaseModelImpl.defaultKieBaseModel(), (KieProject)kieProject, buildContext, null);
        if (kBase == null) {
            throw new RuntimeException("Error while creating KieBase" + buildContext.getMessages().filterMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        return kBase;
    }

    private static KieModuleKieProject createRuleUnitKieProject(InternalKieModule kieModule, boolean useExecModel) {
        return useExecModel ? new CanonicalModelKieProject(kieModule, kieModule.getModuleClassLoader()) : new KieModuleKieProject(kieModule, kieModule.getModuleClassLoader());
    }

    private static InternalKieModule createRuleUnitKieModule(Class<?> unitClass, boolean useExecModel, String ... drls) {
        if (drls == null || drls.length == 0) {
            drls = new String[]{InterpretedRuleUnit.unitClassToDrlPath(unitClass)};
        } else {
            for (int i = 0; i < drls.length; ++i) {
                drls[i] = InterpretedRuleUnit.unitClassToDrlPath(unitClass, drls[i]);
            }
        }
        KieServices ks = KieServices.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (String drl : drls) {
            kfs.write(ks.getResources().newClassPathResource(drl));
        }
        return (InternalKieModule)ks.newKieBuilder(kfs).getKieModule(useExecModel ? ExecutableModelProject.class : DrlProject.class);
    }

    private static String unitClassToDrlPath(Class<?> unitClass) {
        return String.format("%s.drl", unitClass.getCanonicalName().replace('.', '/'));
    }

    private static String unitClassToDrlPath(Class<?> unitClass, String drl) {
        String unitClassName = unitClass.getCanonicalName();
        String unitPackage = unitClassName.substring(0, unitClassName.lastIndexOf(46));
        return unitPackage.replace('.', '/') + "/" + drl + ".drl";
    }

    public static KieModuleKieProject createRuleUnitKieProject(Class<?> unitClass, String ... drls) {
        InternalKieModule kieModule = InterpretedRuleUnit.createRuleUnitKieModule(unitClass, true, drls);
        return InterpretedRuleUnit.createRuleUnitKieProject(kieModule, true);
    }
}

