/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.lang.reflect.Type;
import org.drools.ruleunits.api.DataSource;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.kie.internal.ruleunit.RuleUnitVariable;

public final class SimpleRuleUnitVariable
implements RuleUnitVariable {
    private final String name;
    private final Type type;
    private final Class<?> dataSourceParameterType;
    private final Class<?> boxedVarType;
    private final String getter;
    private final String setter;

    public SimpleRuleUnitVariable(String name, Type type, Class<?> dataSourceParameterType, boolean writable) {
        this(name, type, dataSourceParameterType, writable ? "set" + StringUtils.ucFirst((String)name) : null);
    }

    public SimpleRuleUnitVariable(String name, Type type, Class<?> dataSourceParameterType, String setter) {
        this.name = name;
        this.getter = "get" + StringUtils.ucFirst((String)name);
        this.setter = setter;
        this.type = type;
        this.dataSourceParameterType = dataSourceParameterType;
        this.boxedVarType = type instanceof Class ? org.drools.wiring.api.util.ClassUtils.convertFromPrimitiveType((Class)((Class)type)) : ClassUtils.rawType((Type)type);
    }

    public SimpleRuleUnitVariable(String name, Class<?> type) {
        this(name, type, null, true);
    }

    public boolean isDataSource() {
        return DataSource.class.isAssignableFrom(this.boxedVarType) && this.dataSourceParameterType != null;
    }

    public String getName() {
        return this.name;
    }

    public String getter() {
        return this.getter;
    }

    public String setter() {
        return this.setter;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getDataSourceParameterType() {
        return this.dataSourceParameterType;
    }

    public Class<?> getBoxedVarType() {
        return this.boxedVarType;
    }
}

