/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.impl.HelloWorld;
import org.drools.ruleunits.impl.InterpretedRuleUnit;
import org.drools.ruleunits.impl.LogicalAddTestUnit;
import org.drools.ruleunits.impl.NotTestUnit;
import org.drools.ruleunits.impl.Person;
import org.drools.ruleunits.impl.UpdateTestUnit;
import org.drools.ruleunits.impl.WronglyTypedUnit;
import org.junit.jupiter.api.Test;
import org.kie.api.builder.CompilationErrorsException;

public class InterpretedRuleUnitTest {
    @Test
    public void testHelloWorldInterpreted() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance<HelloWorld> unitInstance = InterpretedRuleUnit.instance(unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void testHelloWorldCompiled() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void testHelloWorldGenerated() {
        HelloWorld unit = new HelloWorld();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void testNotWithAndWithoutSingleQuote() {
        NotTestUnit unit = new NotTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        }
    }

    @Test
    public void testLogicalAdd() {
        LogicalAddTestUnit unit = new LogicalAddTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            DataHandle dh = unit.getStrings().add((Object)"abc");
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"exists"});
            unit.getResults().clear();
            unit.getStrings().remove(dh);
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"not exists"});
        }
    }

    @Test
    public void testUpdate() {
        UpdateTestUnit unit = new UpdateTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            unit.getPersons().add((Object)new Person("Mario", 17));
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"ok"});
        }
    }

    @Test
    public void testWrongType() {
        try {
            RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)new WronglyTypedUnit());
            Assertions.fail((String)"Compilation should fail");
        }
        catch (CompilationErrorsException e) {
            Assertions.assertThat((boolean)e.getErrorMessages().stream().map(Objects::toString).anyMatch(s -> s.contains("The method add(Integer) in the type DataStore<Integer> is not applicable for the arguments (String)"))).isTrue();
        }
    }
}

