/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.ruleunits.api.DataHandle;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.AgendaGroupUnit;
import org.drools.ruleunits.impl.HelloWorldUnit;
import org.drools.ruleunits.impl.LogicalAddTestUnit;
import org.drools.ruleunits.impl.NotTestUnit;
import org.drools.ruleunits.impl.RuleNameUnit;
import org.drools.ruleunits.impl.UpdateTestUnit;
import org.drools.ruleunits.impl.WronglyTypedUnit;
import org.drools.ruleunits.impl.domain.Person;
import org.drools.ruleunits.impl.listener.TestAgendaEventListener;
import org.drools.ruleunits.impl.listener.TestRuleEventListener;
import org.drools.ruleunits.impl.listener.TestRuleRuntimeEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.builder.CompilationErrorsException;
import org.kie.api.runtime.rule.AgendaFilter;

public class RuleUnitProviderImplTest {
    @Test
    public void helloWorldGenerated() {
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void notWithAndWithoutSingleQuote() {
        NotTestUnit unit = new NotTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
        }
    }

    @Test
    public void logicalAdd() {
        LogicalAddTestUnit unit = new LogicalAddTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            DataHandle dh = unit.getStrings().add((Object)"abc");
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"exists"});
            unit.getResults().clear();
            unit.getStrings().remove(dh);
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"not exists"});
        }
    }

    @Test
    public void update() {
        UpdateTestUnit unit = new UpdateTestUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            unit.getPersons().add((Object)new Person("Mario", 17));
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(2);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"ok"});
        }
    }

    @Test
    public void wrongType() {
        try {
            RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)new WronglyTypedUnit());
            Assertions.fail((String)"Compilation should fail");
        }
        catch (CompilationErrorsException e) {
            Assertions.assertThat((boolean)e.getErrorMessages().stream().map(Objects::toString).anyMatch(s -> s.contains("The method add(Integer) in the type DataStore<Integer> is not applicable for the arguments (String)"))).isTrue();
        }
    }

    @Test
    public void agendaGroup() {
        try {
            RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)new AgendaGroupUnit());
            Assertions.fail((String)"Compilation should fail");
        }
        catch (CompilationErrorsException e) {
            Assertions.assertThat((boolean)e.getErrorMessages().stream().map(Objects::toString).anyMatch(s -> s.contains("Rule RuleInGroup belongs to unit AgendaGroupUnit and cannot have an agenda-group or a ruleflow-group"))).isTrue();
        }
    }

    @Test
    public void addEventListeners() {
        TestAgendaEventListener testAgendaEventListener = new TestAgendaEventListener();
        TestRuleRuntimeEventListener testRuleRuntimeEventListener = new TestRuleRuntimeEventListener();
        TestRuleEventListener testRuleEventListener = new TestRuleEventListener();
        RuleConfig ruleConfig = RuleUnitProvider.get().newRuleConfig();
        ruleConfig.getAgendaEventListeners().add(testAgendaEventListener);
        ruleConfig.getRuleRuntimeListeners().add(testRuleRuntimeEventListener);
        ruleConfig.getRuleEventListeners().add(testRuleEventListener);
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit, ruleConfig);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
            Assertions.assertThat(testAgendaEventListener.getResults()).containsExactly((Object[])new String[]{"matchCreated : HelloWorld", "beforeMatchFired : HelloWorld", "afterMatchFired : HelloWorld"});
            Assertions.assertThat(testRuleRuntimeEventListener.getResults()).containsExactly((Object[])new String[]{"objectInserted : Hello World"});
            Assertions.assertThat(testRuleEventListener.getResults()).containsExactly((Object[])new String[]{"onBeforeMatchFire : HelloWorld", "onAfterMatchFire : HelloWorld"});
        }
    }

    @Test
    public void fireWithAgendaFilter() {
        RuleNameUnit unit = new RuleNameUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            Assertions.assertThat((int)unitInstance.fire((AgendaFilter)new RuleNameStartsWithAgendaFilter("GoodBye"))).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"GoodByeWorld"});
        }
    }
}

