/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import org.assertj.core.api.Assertions;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.HelloWorldUnit;
import org.drools.ruleunits.impl.InterpretedRuleUnit;
import org.drools.ruleunits.impl.RuleNameUnit;
import org.drools.ruleunits.impl.listener.TestAgendaEventListener;
import org.drools.ruleunits.impl.listener.TestRuleEventListener;
import org.drools.ruleunits.impl.listener.TestRuleRuntimeEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.AgendaFilter;

public class InterpretedRuleUnitTest {
    @Test
    public void helloWorldInterpreted() {
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance<HelloWorldUnit> unitInstance = InterpretedRuleUnit.instance(unit);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
        }
    }

    @Test
    public void addEventListeners() {
        TestAgendaEventListener testAgendaEventListener = new TestAgendaEventListener();
        TestRuleRuntimeEventListener testRuleRuntimeEventListener = new TestRuleRuntimeEventListener();
        TestRuleEventListener testRuleEventListener = new TestRuleEventListener();
        RuleConfig ruleConfig = RuleUnitProvider.get().newRuleConfig();
        ruleConfig.getAgendaEventListeners().add(testAgendaEventListener);
        ruleConfig.getRuleRuntimeListeners().add(testRuleRuntimeEventListener);
        ruleConfig.getRuleEventListeners().add(testRuleEventListener);
        HelloWorldUnit unit = new HelloWorldUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance<HelloWorldUnit> unitInstance = InterpretedRuleUnit.instance(unit, ruleConfig);){
            Assertions.assertThat((int)unitInstance.fire()).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"it worked!"});
            Assertions.assertThat(testAgendaEventListener.getResults()).containsExactly((Object[])new String[]{"matchCreated : HelloWorld", "beforeMatchFired : HelloWorld", "afterMatchFired : HelloWorld"});
            Assertions.assertThat(testRuleRuntimeEventListener.getResults()).containsExactly((Object[])new String[]{"objectInserted : Hello World"});
            Assertions.assertThat(testRuleEventListener.getResults()).containsExactly((Object[])new String[]{"onBeforeMatchFire : HelloWorld", "onAfterMatchFire : HelloWorld"});
        }
    }

    @Test
    public void fireWithAgendaFilter() {
        RuleNameUnit unit = new RuleNameUnit();
        unit.getStrings().add((Object)"Hello World");
        try (RuleUnitInstance<RuleNameUnit> unitInstance = InterpretedRuleUnit.instance(unit);){
            Assertions.assertThat((int)unitInstance.fire((AgendaFilter)new RuleNameStartsWithAgendaFilter("GoodBye"))).isEqualTo(1);
            Assertions.assertThat(unit.getResults()).containsExactly((Object[])new String[]{"GoodByeWorld"});
        }
    }
}

