/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.impl.AbstractRuleUnitInstance;
import org.drools.ruleunits.impl.StockTickUnit;
import org.drools.ruleunits.impl.domain.StockTick;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

public class CepTest {
    @Test
    public void cep_pseudoClock() {
        StockTickUnit unit = new StockTickUnit();
        try (RuleUnitInstance unitInstance = RuleUnitProvider.get().createRuleUnitInstance((RuleUnitData)unit);){
            unit.getStockTicks().append((Object)new StockTick("DROO"));
            SessionPseudoClock sessionClock = (SessionPseudoClock)unitInstance.getClock();
            sessionClock.advanceTime(6L, TimeUnit.SECONDS);
            unit.getStockTicks().append((Object)new StockTick("ACME"));
            unitInstance.fire();
            Assertions.assertThat(unit.getResults()).hasSize(1);
            Assertions.assertThat((String)unit.getResults().get(0).getCompany()).isEqualTo("ACME");
            Collection<FactHandle> factHandles = this.getFactHandlesInEntryPoint((RuleUnitInstance<StockTickUnit>)unitInstance, "stockTicks");
            Assertions.assertThat(factHandles).hasSize(2);
            sessionClock.advanceTime(5L, TimeUnit.SECONDS);
            unitInstance.fire();
            factHandles = this.getFactHandlesInEntryPoint((RuleUnitInstance<StockTickUnit>)unitInstance, "stockTicks");
            Assertions.assertThat(factHandles).hasSize(1);
            Assertions.assertThat((String)((StockTick)((InternalFactHandle)factHandles.iterator().next()).getObject()).getCompany()).isEqualTo("ACME");
        }
    }

    private Collection<FactHandle> getFactHandlesInEntryPoint(RuleUnitInstance<StockTickUnit> unitInstance, String entryPointName) {
        ReteEvaluator evaluator = (ReteEvaluator)((AbstractRuleUnitInstance)unitInstance).getEvaluator();
        WorkingMemoryEntryPoint entryPoint = evaluator.getEntryPoint(entryPointName);
        return entryPoint.getFactHandles();
    }
}

