/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.util.ArrayList;
import java.util.List;
import org.drools.container.spring.MockAgendaEventListener;
import org.drools.container.spring.MockProcessEventListener;
import org.drools.container.spring.MockWorkingMemoryEventListener;
import org.drools.container.spring.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.event.rule.DebugRuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsListenersTest {
    static ClassPathXmlApplicationContext context = null;
    List<Person> list = new ArrayList<Person>();
    static int counterFromListener = 0;

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/drools/container/spring/listeners.xml");
    }

    @Before
    public void clearGlobalList() {
        this.list.clear();
        counterFromListener = 0;
    }

    public static void incrementValueFromListener() {
        ++counterFromListener;
    }

    public void testStatefulAgendaEventListener() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)KieSession2.getAgendaEventListeners().size());
        Assert.assertTrue((boolean)(KieSession2.getAgendaEventListeners().toArray()[0] instanceof MockAgendaEventListener));
    }

    @Test
    public void testStatefulProcessEventListener() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)KieSession2.getProcessEventListeners().size());
        Assert.assertTrue((boolean)(KieSession2.getProcessEventListeners().toArray()[0] instanceof MockProcessEventListener));
    }

    @Test
    public void testStatefulWMEventListener() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulSession");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        Assert.assertTrue((boolean)(KieSession2.getRuleRuntimeEventListeners().toArray()[0] instanceof MockWorkingMemoryEventListener));
        KieSession2.setGlobal("list", this.list);
        KieSession2.insert((Object)new Person());
        KieSession2.fireAllRules();
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessAgendaEventListener() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getAgendaEventListeners().size());
        Assert.assertTrue((boolean)(StatelessKieSession2.getAgendaEventListeners().toArray()[0] instanceof MockAgendaEventListener));
    }

    @Test
    public void testStatelessProcessEventListener() throws Exception {
        StatelessKieSession kstateless = (StatelessKieSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)kstateless.getProcessEventListeners().size());
        Assert.assertTrue((boolean)(kstateless.getProcessEventListeners().toArray()[0] instanceof MockProcessEventListener));
    }

    @Test
    public void testStatelessWMEventListener() throws Exception {
        StatelessKieSession kstateless = (StatelessKieSession)context.getBean("statelessSession");
        Assert.assertEquals((long)1L, (long)kstateless.getRuleRuntimeEventListeners().size());
        Assert.assertTrue((boolean)(kstateless.getRuleRuntimeEventListeners().toArray()[0] instanceof MockWorkingMemoryEventListener));
        kstateless.setGlobal("list", this.list);
        kstateless.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithNestedBean() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulWithNestedBean");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        KieSession2.setGlobal("list", this.list);
        KieSession2.insert((Object)new Person());
        KieSession2.fireAllRules();
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithRef() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulWithRef");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        KieSession2.setGlobal("list", this.list);
        KieSession2.insert((Object)new Person());
        KieSession2.fireAllRules();
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatefulWithDefault() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulWithDefault");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        Assert.assertTrue((boolean)(KieSession2.getRuleRuntimeEventListeners().iterator().next() instanceof DebugRuleRuntimeEventListener));
    }

    @Test
    public void testStatefulWithLegacyDebugListener() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulWithDebugListener");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        Assert.assertTrue((boolean)(KieSession2.getRuleRuntimeEventListeners().iterator().next() instanceof DebugRuleRuntimeEventListener));
    }

    @Test
    public void testStatefulWithGroupedListeners() throws Exception {
        KieSession KieSession2 = (KieSession)context.getBean("statefulWithGroupedListeners");
        Assert.assertEquals((long)1L, (long)KieSession2.getRuleRuntimeEventListeners().size());
        KieSession2.setGlobal("list", this.list);
        KieSession2.insert((Object)new Person());
        KieSession2.fireAllRules();
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithNestedBean() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithNestedBean");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getRuleRuntimeEventListeners().size());
        StatelessKieSession2.setGlobal("list", this.list);
        StatelessKieSession2.execute((Object)new Person());
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithRef() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithRef");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getRuleRuntimeEventListeners().size());
        StatelessKieSession2.setGlobal("list", this.list);
        StatelessKieSession2.execute((Object)new Person());
        Assert.assertEquals((long)1L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithMultipleSameType() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithMultipleSameType");
        Assert.assertEquals((long)2L, (long)StatelessKieSession2.getRuleRuntimeEventListeners().size());
        StatelessKieSession2.setGlobal("list", this.list);
        StatelessKieSession2.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testStatelessWithDefault() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithDefault");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getRuleRuntimeEventListeners().size());
        Assert.assertTrue((boolean)(StatelessKieSession2.getRuleRuntimeEventListeners().toArray()[0] instanceof DebugRuleRuntimeEventListener));
    }

    @Test
    public void testStatelessWithGroupedListeners() throws Exception {
        StatelessKieSession StatelessKieSession2 = (StatelessKieSession)context.getBean("statelessWithGroupedListeners");
        Assert.assertEquals((long)1L, (long)StatelessKieSession2.getRuleRuntimeEventListeners().size());
        StatelessKieSession2.setGlobal("list", this.list);
        StatelessKieSession2.execute((Object)new Person());
        Assert.assertEquals((long)2L, (long)counterFromListener);
    }

    @Test
    public void testEventListenersBean() throws Exception {
        Object debugListeners = context.getBean("debugListeners");
        Assert.assertTrue((boolean)(debugListeners instanceof List));
        Assert.assertEquals((long)3L, (long)((List)debugListeners).size());
    }
}

