/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring;

import java.util.ArrayList;
import java.util.Map;
import org.drools.container.spring.Person;
import org.drools.container.spring.beans.DroolsResourceAdapter;
import org.drools.core.ClockType;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.io.impl.UrlResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.grid.GridNode;
import org.jbpm.process.instance.impl.humantask.HumanTaskHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringDroolsTest {
    @Test
    public void testNoConnection() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        GridNode node1 = (GridNode)context.getBean("node1");
        Assert.assertNotNull((Object)node1);
        GridNode node2 = (GridNode)context.getBean("node2");
        Assert.assertNotNull((Object)node2);
    }

    @Test
    public void testEncoding() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/resourceWithEncoding.xml");
        KieBase kbase = (KieBase)context.getBean("kbase");
        Assert.assertNotNull((Object)kbase);
        for (KiePackage pkg : kbase.getKiePackages()) {
            Assert.assertEquals((Object)"sample ac\u00e7\u00e9nt\u00e8d rule", (Object)((Rule)pkg.getRules().iterator().next()).getName());
        }
    }

    @Test
    public void testNoNodeKSessions() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/no-node-beans.xml");
        ArrayList list = new ArrayList();
        StatelessKieSession kstateless = (StatelessKieSession)context.getBean("ksession1");
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        KieSession kstateful = (KieSession)context.getBean("ksession2");
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSimpleKSessions() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        ArrayList list = new ArrayList();
        StatelessKieSession kstateless = (StatelessKieSession)context.getBean("ksession1");
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)2L, (long)list.size());
        list = new ArrayList();
        KieSession kstateful = (KieSession)context.getBean("ksession2");
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNode() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        GridNode node = (GridNode)context.getBean("node1");
        ArrayList list = new ArrayList();
        StatelessKieSession kstateless = (StatelessKieSession)node.get("stateless1", StatelessKieSession.class);
        Assert.assertNotNull((String)"can't obtain session named: stateless1", (Object)kstateless);
        kstateless.setGlobal("list", list);
        kstateless.execute((Object)new Person("Darth", "Cheddar", 50));
        Assert.assertEquals((long)2L, (long)list.size());
        list = new ArrayList();
        KieSession kstateful = (KieSession)node.get("ksession2", KieSession.class);
        kstateful.setGlobal("list", list);
        kstateful.insert((Object)new Person("Darth", "Cheddar", 50));
        kstateful.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testConfiguration() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/session-conf-beans.xml");
        KnowledgeBaseImpl kbase1 = (KnowledgeBaseImpl)context.getBean("kbase1");
        RuleBaseConfiguration rconf = kbase1.getConfiguration();
        Assert.assertTrue((boolean)rconf.isAdvancedProcessRuleIntegration());
        Assert.assertFalse((boolean)rconf.isMultithreadEvaluation());
        Assert.assertEquals((Object)EventProcessingOption.STREAM, (Object)rconf.getEventProcessingMode());
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)rconf.getAssertBehaviour());
        Assert.assertEquals((Object)"org.drools.container.spring.MockConsequenceExceptionHandler", (Object)rconf.getConsequenceExceptionHandler());
        KnowledgeBaseImpl kbase2 = (KnowledgeBaseImpl)context.getBean("kbase2");
        rconf = kbase2.getConfiguration();
        Assert.assertFalse((boolean)rconf.isAdvancedProcessRuleIntegration());
        Assert.assertFalse((boolean)rconf.isMultithreadEvaluation());
        Assert.assertEquals((long)3L, (long)rconf.getMaxThreads());
        Assert.assertEquals((Object)EventProcessingOption.CLOUD, (Object)rconf.getEventProcessingMode());
        Assert.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)rconf.getAssertBehaviour());
        StatefulKnowledgeSessionImpl ksession1 = (StatefulKnowledgeSessionImpl)context.getBean("ksession1");
        SessionConfiguration sconf = ksession1.getSessionConfiguration();
        Assert.assertTrue((boolean)sconf.isKeepReference());
        Assert.assertEquals((Object)ClockType.REALTIME_CLOCK, (Object)sconf.getClockType());
        Map wih = sconf.getWorkItemHandlers();
        Assert.assertEquals((long)4L, (long)wih.size());
        Assert.assertTrue((boolean)wih.containsKey("wih1"));
        Assert.assertTrue((boolean)wih.containsKey("wih2"));
        Assert.assertTrue((boolean)wih.containsKey("Human Task"));
        Assert.assertTrue((boolean)wih.containsKey("MyWork"));
        Assert.assertNotSame(wih.get("wih1"), wih.get("wih2"));
        Assert.assertEquals(HumanTaskHandler.class, ((WorkItemHandler)wih.get("wih1")).getClass());
        Assert.assertEquals(HumanTaskHandler.class, ((WorkItemHandler)wih.get("wih2")).getClass());
        StatefulKnowledgeSessionImpl ksession2 = (StatefulKnowledgeSessionImpl)context.getBean("ksession2");
        sconf = ksession2.getSessionConfiguration();
        Assert.assertFalse((boolean)sconf.isKeepReference());
        Assert.assertEquals((Object)ClockType.PSEUDO_CLOCK, (Object)sconf.getClockType());
    }

    @Test
    public void testResourceAuthenication() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        DroolsResourceAdapter resourceAdapter = (DroolsResourceAdapter)context.getBean("secureResource");
        Assert.assertNotNull((Object)resourceAdapter);
        Resource resource = resourceAdapter.getDroolsResource();
        Assert.assertTrue((boolean)(resource instanceof UrlResource));
        UrlResource ur = (UrlResource)resource;
        Assert.assertEquals((Object)"enabled", (Object)ur.getBasicAuthentication());
        Assert.assertEquals((Object)"someUser", (Object)ur.getUsername());
        Assert.assertEquals((Object)"somePassword", (Object)ur.getPassword());
        resourceAdapter = (DroolsResourceAdapter)context.getBean("insecureResource");
        Assert.assertNotNull((Object)resourceAdapter);
        resource = resourceAdapter.getDroolsResource();
        Assert.assertTrue((boolean)(resource instanceof UrlResource));
        ur = (UrlResource)resource;
        Assert.assertEquals((Object)"disabled", (Object)ur.getBasicAuthentication());
        Assert.assertEquals((Object)"", (Object)ur.getUsername());
        Assert.assertEquals((Object)"", (Object)ur.getPassword());
    }

    @Test
    public void testResourceNameAndDescription() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/drools/container/spring/beans.xml");
        DroolsResourceAdapter resource = (DroolsResourceAdapter)context.getBean("secureResource");
        Assert.assertNotNull((Object)resource);
        InternalResource secureResource = (InternalResource)resource.getDroolsResource();
        Assert.assertEquals((Object)"/someDRLResource.drl", (Object)secureResource.getSourcePath());
        Assert.assertNull((Object)secureResource.getDescription());
        resource = (DroolsResourceAdapter)context.getBean("resourceWithNameAndDescription");
        Assert.assertNotNull((Object)resource);
        InternalResource resourceWithNameAndDescription = (InternalResource)resource.getDroolsResource();
        Assert.assertEquals((Object)"A Name", (Object)resourceWithNameAndDescription.getSourcePath());
        Assert.assertEquals((Object)"A Description", (Object)resourceWithNameAndDescription.getDescription());
    }
}

