/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.core.type.DateFormats;
import org.drools.impl.adapters.EnvironmentAdapter;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.ProcessInstanceResolverStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NamedBean;
import org.springframework.orm.jpa.JpaTransactionManager;

public class EnvironmentDefBeanFactory
implements FactoryBean<Environment>,
InitializingBean,
BeanNameAware,
NamedBean,
DisposableBean {
    private String name;
    private String beanName;
    private Environment environment;
    private EntityManagerFactory entityManagerFactory;
    private JpaTransactionManager transactionManager;
    private Globals globals;
    private Calendars calendars;
    private DateFormats dateFormats;
    private ObjectMarshallingStrategyAcceptor identityPlaceholderResolverStrategyAcceptor;
    private ObjectMarshallingStrategyAcceptor serializablePlaceholderResolverStrategyAcceptor;
    private EntityManager appScopedEntityManager;
    private EntityManager cmdScopedEntityManager;
    private Environment jpaPlaceHolderResolverStrategyEnv;
    private List<String> objectMarshallersOrder = new ArrayList<String>();
    private List<ObjectMarshallingStrategy> customMarshallingStrategies = new ArrayList<ObjectMarshallingStrategy>();

    public List<String> getObjectMarshallersOrder() {
        return this.objectMarshallersOrder;
    }

    public void setObjectMarshallersOrder(List<String> objectMarshallersOrder) {
        this.objectMarshallersOrder = objectMarshallersOrder;
    }

    public List<ObjectMarshallingStrategy> getCustomMarshallingStrategies() {
        return this.customMarshallingStrategies;
    }

    public void setCustomMarshallingStrategies(List<ObjectMarshallingStrategy> customMarshallingStrategies) {
        this.customMarshallingStrategies = customMarshallingStrategies;
    }

    public Calendars getCalendars() {
        return this.calendars;
    }

    public void setCalendars(Calendars calendars) {
        this.calendars = calendars;
    }

    public DateFormats getDateFormats() {
        return this.dateFormats;
    }

    public void setDateFormats(DateFormats dateFormats) {
        this.dateFormats = dateFormats;
    }

    public Environment getJpaPlaceHolderResolverStrategyEnv() {
        return this.jpaPlaceHolderResolverStrategyEnv;
    }

    public void setJpaPlaceHolderResolverStrategyEnv(Environment jpaPlaceHolderResolverStrategyEnv) {
        this.jpaPlaceHolderResolverStrategyEnv = jpaPlaceHolderResolverStrategyEnv;
    }

    public EntityManager getAppScopedEntityManager() {
        return this.appScopedEntityManager;
    }

    public void setAppScopedEntityManager(EntityManager appScopedEntityManager) {
        this.appScopedEntityManager = appScopedEntityManager;
    }

    public EntityManager getCmdScopedEntityManager() {
        return this.cmdScopedEntityManager;
    }

    public void setCmdScopedEntityManager(EntityManager cmdScopedEntityManager) {
        this.cmdScopedEntityManager = cmdScopedEntityManager;
    }

    public ObjectMarshallingStrategyAcceptor getIdentityPlaceholderResolverStrategyAcceptor() {
        return this.identityPlaceholderResolverStrategyAcceptor;
    }

    public void setIdentityPlaceholderResolverStrategyAcceptor(ObjectMarshallingStrategyAcceptor identityPlaceholderResolverStrategyAcceptor) {
        this.identityPlaceholderResolverStrategyAcceptor = identityPlaceholderResolverStrategyAcceptor;
    }

    public ObjectMarshallingStrategyAcceptor getSerializablePlaceholderResolverStrategyAcceptor() {
        return this.serializablePlaceholderResolverStrategyAcceptor;
    }

    public void setSerializablePlaceholderResolverStrategyAcceptor(ObjectMarshallingStrategyAcceptor serializablePlaceholderResolverStrategyAcceptor) {
        this.serializablePlaceholderResolverStrategyAcceptor = serializablePlaceholderResolverStrategyAcceptor;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void setGlobals(Globals globals) {
        this.globals = globals;
    }

    public JpaTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(JpaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void destroy() throws Exception {
    }

    public Environment getObject() throws Exception {
        return this.environment;
    }

    public Class<Environment> getObjectType() {
        return Environment.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        this.environment = new EnvironmentAdapter(EnvironmentFactory.newEnvironment());
        if (this.entityManagerFactory != null) {
            this.environment.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.entityManagerFactory);
        }
        if (this.transactionManager != null) {
            this.environment.set("org.kie.transaction.TransactionManager", (Object)this.transactionManager);
        }
        if (this.globals != null) {
            this.environment.set("org.kie.Globals", (Object)this.globals);
        }
        if (this.dateFormats != null) {
            this.environment.set("org.kie.build.DateFormats", (Object)this.dateFormats);
        }
        if (this.calendars != null) {
            this.environment.set("org.kie.api.time.Calendars", (Object)this.calendars);
        }
        if (this.objectMarshallersOrder != null && this.objectMarshallersOrder.size() > 0) {
            List<ObjectMarshallingStrategy> strategies = this.getStrategies();
            this.environment.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)strategies.toArray(new ObjectMarshallingStrategy[0]));
        }
        if (this.appScopedEntityManager != null) {
            this.environment.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)this.appScopedEntityManager);
        }
        if (this.cmdScopedEntityManager != null) {
            this.environment.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)this.cmdScopedEntityManager);
        }
    }

    private List<ObjectMarshallingStrategy> getStrategies() {
        ArrayList<ObjectMarshallingStrategy> strategies = new ArrayList<ObjectMarshallingStrategy>();
        int customMarshaller = 0;
        for (String marshaller : this.objectMarshallersOrder) {
            if ("serializable-placeholder-resolver-strategy".equalsIgnoreCase(marshaller)) {
                if (this.serializablePlaceholderResolverStrategyAcceptor == null) {
                    this.serializablePlaceholderResolverStrategyAcceptor = ClassObjectMarshallingStrategyAcceptor.DEFAULT;
                }
                strategies.add((ObjectMarshallingStrategy)new SerializablePlaceholderResolverStrategy(this.serializablePlaceholderResolverStrategyAcceptor));
                continue;
            }
            if ("identity-placeholder-resolver-strategy".equalsIgnoreCase(marshaller)) {
                if (this.identityPlaceholderResolverStrategyAcceptor == null) {
                    this.identityPlaceholderResolverStrategyAcceptor = ClassObjectMarshallingStrategyAcceptor.DEFAULT;
                }
                strategies.add((ObjectMarshallingStrategy)new IdentityPlaceholderResolverStrategy(this.identityPlaceholderResolverStrategyAcceptor));
                continue;
            }
            if ("process-instance-resolver-strategy".equalsIgnoreCase(marshaller)) {
                strategies.add((ObjectMarshallingStrategy)new ProcessInstanceResolverStrategy());
                continue;
            }
            if ("jpa-placeholder-resolver-strategy".equalsIgnoreCase(marshaller)) {
                if (this.jpaPlaceHolderResolverStrategyEnv != null) {
                    strategies.add((ObjectMarshallingStrategy)new JPAPlaceholderResolverStrategy(this.jpaPlaceHolderResolverStrategyEnv));
                    continue;
                }
                strategies.add((ObjectMarshallingStrategy)new JPAPlaceholderResolverStrategy(this.environment));
                continue;
            }
            if (!"custom-marshalling-strategy".equalsIgnoreCase(marshaller)) continue;
            strategies.add(this.customMarshallingStrategies.get(customMarshaller));
            ++customMarshaller;
        }
        return strategies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }
}

