/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.beans.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.session.JpaManager;
import org.drools.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DroolsSpringJpaManager
implements JpaManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Environment env;
    private EntityManagerFactory emf;
    private EntityManager appScopedEntityManager;
    private boolean internalAppScopedEntityManager;

    public DroolsSpringJpaManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("drools.persistence.jpa.EntityManagerFactory");
        this.getApplicationScopedEntityManager();
    }

    public EntityManager getApplicationScopedEntityManager() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("drools.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.emf);
                if (emHolder == null) {
                    this.appScopedEntityManager = this.emf.createEntityManager();
                    emHolder = new EntityManagerHolder(this.appScopedEntityManager);
                    TransactionSynchronizationManager.bindResource((Object)this.emf, (Object)emHolder);
                    this.internalAppScopedEntityManager = true;
                } else {
                    this.appScopedEntityManager = emHolder.getEntityManager();
                }
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", (Object)emHolder.getEntityManager());
            }
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.appScopedEntityManager.joinTransaction();
        }
        return this.appScopedEntityManager;
    }

    public EntityManager getCommandScopedEntityManager() {
        return (EntityManager)this.env.get("drools.persistence.jpa.CmdScopedEntityManager");
    }

    public void beginCommandScopedEntityManager() {
        if (this.getCommandScopedEntityManager() == null || !this.getCommandScopedEntityManager().isOpen()) {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)"cmdEM");
            EntityManager em = null;
            if (emHolder == null) {
                em = this.emf.createEntityManager();
                emHolder = new EntityManagerHolder(em);
                TransactionSynchronizationManager.bindResource((Object)"cmdEM", (Object)emHolder);
            } else {
                em = emHolder.getEntityManager();
            }
            this.env.set("drools.persistence.jpa.CmdScopedEntityManager", (Object)em);
        }
        this.getCommandScopedEntityManager().joinTransaction();
        this.appScopedEntityManager.joinTransaction();
    }

    public void endCommandScopedEntityManager() {
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM")) {
            TransactionSynchronizationManager.unbindResource((Object)"cmdEM");
            if (this.getCommandScopedEntityManager() != null) {
                this.getCommandScopedEntityManager().close();
            }
        }
    }

    public void dispose() {
        this.logger.trace("Disposing DroolsSpringJpaManager");
        if (this.internalAppScopedEntityManager) {
            TransactionSynchronizationManager.unbindResource((Object)this.emf);
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
                this.internalAppScopedEntityManager = false;
                this.env.set("drools.persistence.jpa.AppScopedEntityManager", null);
            }
            this.endCommandScopedEntityManager();
        }
    }
}

